/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.waiters;

import java.util.List;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.waiters.CompositeAcceptor;
import software.amazon.awssdk.core.waiters.PollingStrategy;
import software.amazon.awssdk.core.waiters.PollingStrategyContext;
import software.amazon.awssdk.core.waiters.SdkFunction;
import software.amazon.awssdk.core.waiters.WaiterExecutionBuilder;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.core.waiters.WaiterTimedOutException;
import software.amazon.awssdk.core.waiters.WaiterUnrecoverableException;
import software.amazon.awssdk.utils.Validate;

@SdkProtectedApi
public class WaiterExecution<InputT, OutputT, ErrorT extends RuntimeException> {
    private final SdkFunction<InputT, OutputT> sdkFunction;
    private final InputT request;
    private final CompositeAcceptor<OutputT, ErrorT> acceptor;
    private final PollingStrategy pollingStrategy;

    public WaiterExecution(WaiterExecutionBuilder<InputT, OutputT, ErrorT> waiterExecutionBuilder) {
        this.sdkFunction = (SdkFunction)Validate.paramNotNull(waiterExecutionBuilder.getSdkFunction(), (String)"sdkFunction");
        this.request = Validate.paramNotNull(waiterExecutionBuilder.getRequest(), (String)"request");
        this.acceptor = new CompositeAcceptor((List)Validate.paramNotNull(waiterExecutionBuilder.getAcceptorsList(), (String)"acceptors"));
        this.pollingStrategy = (PollingStrategy)Validate.paramNotNull((Object)waiterExecutionBuilder.getPollingStrategy(), (String)"pollingStrategy");
    }

    public boolean pollResource() throws WaiterTimedOutException, WaiterUnrecoverableException {
        int retriesAttempted = 0;
        block5: while (true) {
            switch (this.getCurrentState()) {
                case SUCCESS: {
                    return true;
                }
                case FAILURE: {
                    throw new WaiterUnrecoverableException("Resource never entered the desired state as it failed.");
                }
                case RETRY: {
                    PollingStrategyContext pollingStrategyContext = new PollingStrategyContext(this.request, retriesAttempted);
                    if (this.pollingStrategy.getRetryStrategy().shouldRetry(pollingStrategyContext)) {
                        this.safeCustomDelay(pollingStrategyContext);
                        ++retriesAttempted;
                        continue block5;
                    }
                    throw new WaiterTimedOutException("Reached maximum attempts without transitioning to the desired state");
                }
            }
        }
    }

    private WaiterState getCurrentState() {
        try {
            return this.acceptor.accepts(this.sdkFunction.apply(this.request));
        }
        catch (RuntimeException amazonServiceException) {
            return this.acceptor.accepts(amazonServiceException);
        }
    }

    private void safeCustomDelay(PollingStrategyContext pollingStrategyContext) {
        try {
            this.pollingStrategy.getDelayStrategy().delayBeforeNextRetry(pollingStrategyContext);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

