/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.waiters;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.waiters.PollingStrategy;
import software.amazon.awssdk.core.waiters.SdkFunction;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterExecution;

@SdkProtectedApi
public class WaiterExecutionBuilder<InputT, OutputT, ErrorT extends RuntimeException> {
    private SdkFunction<InputT, OutputT> sdkFunction;
    private InputT request;
    private PollingStrategy pollingStrategy;
    private List<WaiterAcceptor<OutputT, ErrorT>> acceptors = new ArrayList<WaiterAcceptor<OutputT, ErrorT>>();

    public WaiterExecutionBuilder<InputT, OutputT, ErrorT> withSdkFunction(SdkFunction sdkFunction) {
        this.sdkFunction = sdkFunction;
        return this;
    }

    public WaiterExecutionBuilder<InputT, OutputT, ErrorT> withRequest(InputT request) {
        this.request = request;
        return this;
    }

    public WaiterExecutionBuilder<InputT, OutputT, ErrorT> withPollingStrategy(PollingStrategy pollingStrategy) {
        this.pollingStrategy = pollingStrategy;
        return this;
    }

    public WaiterExecutionBuilder<InputT, OutputT, ErrorT> withAcceptors(List<WaiterAcceptor<OutputT, ErrorT>> acceptors) {
        this.acceptors = acceptors;
        return this;
    }

    public InputT getRequest() {
        return this.request;
    }

    public List<WaiterAcceptor<OutputT, ErrorT>> getAcceptorsList() {
        return this.acceptors;
    }

    public SdkFunction<InputT, OutputT> getSdkFunction() {
        return this.sdkFunction;
    }

    public PollingStrategy getPollingStrategy() {
        return this.pollingStrategy;
    }

    public WaiterExecution<InputT, OutputT, ErrorT> build() {
        return new WaiterExecution(this);
    }
}

