/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.waiters;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.waiters.PollingStrategy;
import software.amazon.awssdk.core.waiters.SdkFunction;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterBuilder;
import software.amazon.awssdk.core.waiters.WaiterExecution;
import software.amazon.awssdk.core.waiters.WaiterExecutionBuilder;
import software.amazon.awssdk.core.waiters.WaiterHandler;
import software.amazon.awssdk.core.waiters.WaiterParameters;
import software.amazon.awssdk.core.waiters.WaiterTimedOutException;
import software.amazon.awssdk.core.waiters.WaiterUnrecoverableException;
import software.amazon.awssdk.utils.Validate;

@SdkProtectedApi
public class WaiterImpl<InputT, OutputT, ErrorT extends RuntimeException>
implements Waiter<InputT> {
    private final SdkFunction<InputT, OutputT> sdkFunction;
    private final List<WaiterAcceptor<OutputT, ErrorT>> acceptors;
    private final PollingStrategy defaultPollingStrategy;
    private final ExecutorService executorService;

    @SdkProtectedApi
    public WaiterImpl(WaiterBuilder<InputT, OutputT, ErrorT> waiterBuilder) {
        this.sdkFunction = (SdkFunction)Validate.paramNotNull(waiterBuilder.getSdkFunction(), (String)"sdkFunction");
        this.acceptors = (List)Validate.paramNotNull(waiterBuilder.getAcceptor(), (String)"acceptors");
        this.defaultPollingStrategy = (PollingStrategy)Validate.paramNotNull((Object)waiterBuilder.getDefaultPollingStrategy(), (String)"defaultPollingStrategy");
        this.executorService = (ExecutorService)Validate.paramNotNull((Object)waiterBuilder.getExecutorService(), (String)"executorService");
    }

    @Override
    public void run(WaiterParameters<InputT> waiterParameters) throws WaiterTimedOutException, WaiterUnrecoverableException {
        Validate.paramNotNull(waiterParameters, (String)"waiterParameters");
        Object request = Validate.paramNotNull(waiterParameters.getRequest(), (String)"request");
        WaiterExecution waiterExecution = new WaiterExecutionBuilder().withRequest(request).withPollingStrategy(waiterParameters.getPollingStrategy() != null ? waiterParameters.getPollingStrategy() : this.defaultPollingStrategy).withAcceptors(this.acceptors).withSdkFunction(this.sdkFunction).build();
        waiterExecution.pollResource();
    }

    @Override
    public Future<Void> runAsync(WaiterParameters<InputT> waiterParameters, WaiterHandler callback) throws WaiterTimedOutException, WaiterUnrecoverableException {
        return this.executorService.submit(() -> {
            try {
                this.run(waiterParameters);
                callback.onWaitSuccess(waiterParameters.getRequest());
            }
            catch (Exception ex) {
                callback.onWaitFailure(ex);
                throw ex;
            }
            return null;
        });
    }
}

