/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.rules.ExternalResource;
import software.amazon.awssdk.utils.SystemSetting;

public class EnvironmentVariableHelper
extends ExternalResource {
    private final Map<String, String> originalEnvironmentVariables = new HashMap<String, String>(System.getenv());
    private final Map<String, String> modifiableMap = Optional.ofNullable(this.processEnv()).orElse(this.envMap());
    private volatile boolean mutated = false;

    public void remove(SystemSetting setting) {
        this.remove(setting.environmentVariable());
    }

    public void remove(String key) {
        this.mutated = true;
        this.modifiableMap.remove(key);
    }

    public void set(SystemSetting setting, String value) {
        this.set(setting.environmentVariable(), value);
    }

    public void set(String key, String value) {
        this.mutated = true;
        this.modifiableMap.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.mutated) {
            EnvironmentVariableHelper environmentVariableHelper = this;
            synchronized (environmentVariableHelper) {
                if (this.mutated) {
                    this.modifiableMap.clear();
                    this.modifiableMap.putAll(this.originalEnvironmentVariables);
                    this.mutated = false;
                }
            }
        }
    }

    protected void after() {
        this.reset();
    }

    private PrivilegedExceptionAction<Void> setAccessible(Field f) {
        return () -> {
            f.setAccessible(true);
            return null;
        };
    }

    public static void run(Consumer<EnvironmentVariableHelper> helperConsumer) {
        EnvironmentVariableHelper helper = new EnvironmentVariableHelper();
        try {
            helperConsumer.accept(helper);
        }
        finally {
            helper.reset();
        }
    }

    private Map<String, String> envMap() {
        return this.getField(System.getenv().getClass(), System.getenv(), "m");
    }

    private Map<String, String> processEnv() {
        try {
            Class<?> processEnvironment = Class.forName("java.lang.ProcessEnvironment");
            return this.getField(processEnvironment, null, "theCaseInsensitiveEnvironment");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Map<String, String> getField(Class<?> processEnvironment, Object obj, String fieldName) {
        try {
            Field declaredField = processEnvironment.getDeclaredField(fieldName);
            AccessController.doPrivileged(this.setAccessible(declaredField));
            return (Map)declaredField.get(obj);
        }
        catch (IllegalAccessException | NoSuchFieldException | PrivilegedActionException e) {
            return null;
        }
    }
}

