/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.Before;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface LogCaptor
extends SdkAutoCloseable {
    public List<LoggingEvent> loggedEvents();

    public void clear();

    public static class DefaultLogCaptor
    extends AppenderSkeleton
    implements LogCaptor {
        private final List<LoggingEvent> loggedEvents = new ArrayList<LoggingEvent>();
        private final Level originalLoggingLevel = Logger.getRootLogger().getLevel();
        private final Level levelToCapture;

        public DefaultLogCaptor(Level levelToCapture) {
            this.levelToCapture = levelToCapture;
            this.setupLogging();
        }

        @Override
        public List<LoggingEvent> loggedEvents() {
            return new ArrayList<LoggingEvent>(this.loggedEvents);
        }

        @Override
        public void clear() {
            this.loggedEvents.clear();
        }

        protected void setupLogging() {
            this.loggedEvents.clear();
            Logger.getRootLogger().addAppender((Appender)this);
            Logger.getRootLogger().setLevel(this.levelToCapture);
        }

        protected void stopLogging() {
            Logger.getRootLogger().removeAppender((Appender)this);
            Logger.getRootLogger().setLevel(this.originalLoggingLevel);
        }

        protected void append(LoggingEvent loggingEvent) {
            this.loggedEvents.add(loggingEvent);
        }

        public boolean requiresLayout() {
            return false;
        }

        public void close() {
            this.stopLogging();
        }
    }

    public static class LogCaptorTestBase
    extends DefaultLogCaptor {
        public LogCaptorTestBase() {
            super(Level.ALL);
        }

        @Override
        @Before
        public void setupLogging() {
            super.setupLogging();
        }

        @Override
        @After
        public void stopLogging() {
            super.stopLogging();
        }
    }
}

