/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils.retry;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContextException;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.util.AnnotationUtils;
import org.opentest4j.TestAbortedException;
import software.amazon.awssdk.testutils.retry.RetryableTest;

public class RetryableTestExtension
implements TestTemplateInvocationContextProvider,
TestExecutionExceptionHandler {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{RetryableTestExtension.class});

    public boolean supportsTestTemplate(ExtensionContext extensionContext) {
        Method testMethod = extensionContext.getRequiredTestMethod();
        return AnnotationUtils.isAnnotated((AnnotatedElement)testMethod, RetryableTest.class);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        RetryExecutor executor = this.retryExecutor(context);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(executor, 16), false);
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        if (!this.isRetryableException(context, throwable)) {
            throw throwable;
        }
        RetryExecutor retryExecutor = this.retryExecutor(context);
        retryExecutor.exceptionOccurred(throwable);
    }

    private RetryExecutor retryExecutor(ExtensionContext context) {
        Method method = context.getRequiredTestMethod();
        ExtensionContext templateContext = (ExtensionContext)context.getParent().orElseThrow(() -> new IllegalStateException("Extension context \"" + context + "\" should have a parent context."));
        int maxRetries = this.maxRetries(context);
        return (RetryExecutor)templateContext.getStore(NAMESPACE).getOrComputeIfAbsent((Object)method.toString(), __ -> new RetryExecutor(maxRetries), RetryExecutor.class);
    }

    private boolean isRetryableException(ExtensionContext context, Throwable throwable) {
        return this.retryableException(context).isAssignableFrom(throwable.getClass()) || throwable instanceof TestAbortedException;
    }

    private int maxRetries(ExtensionContext context) {
        return this.retrieveAnnotation(context).maxRetries();
    }

    private Class<? extends Throwable> retryableException(ExtensionContext context) {
        return this.retrieveAnnotation(context).retryableException();
    }

    private RetryableTest retrieveAnnotation(ExtensionContext context) {
        return (RetryableTest)AnnotationUtils.findAnnotation((AnnotatedElement)context.getRequiredTestMethod(), RetryableTest.class).orElseThrow(() -> new ExtensionContextException("@RetryableTest Annotation not found on method"));
    }

    private static final class RetryExecutor
    implements Iterator<RetryableTestsTemplateInvocationContext> {
        private final int maxRetries;
        private int totalAttempts;
        private List<Throwable> throwables = new ArrayList<Throwable>();

        RetryExecutor(int maxRetries) {
            this.maxRetries = maxRetries;
        }

        private void exceptionOccurred(Throwable throwable) {
            this.throwables.add(throwable);
            if (this.throwables.size() == this.maxRetries) {
                throw new AssertionError("All attempts failed. Last exception: ", throwable);
            }
            throw new TestAbortedException(String.format("Attempt %s failed of the retryable exception, going to retry the test", this.totalAttempts), throwable);
        }

        @Override
        public boolean hasNext() {
            boolean previousFailed;
            if (this.totalAttempts == 0) {
                return true;
            }
            boolean bl = previousFailed = this.totalAttempts == this.throwables.size();
            return previousFailed && this.totalAttempts <= this.maxRetries - 1;
        }

        @Override
        public RetryableTestsTemplateInvocationContext next() {
            ++this.totalAttempts;
            return new RetryableTestsTemplateInvocationContext(this.totalAttempts, this.maxRetries);
        }
    }

    private static final class RetryableTestsTemplateInvocationContext
    implements TestTemplateInvocationContext {
        private int maxRetries;
        private int numAttempt;

        RetryableTestsTemplateInvocationContext(int numAttempt, int maxRetries) {
            this.numAttempt = numAttempt;
            this.maxRetries = maxRetries;
        }
    }
}

