/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import software.amazon.awssdk.utils.IoUtils;

public final class SdkVersionUtils {
    private SdkVersionUtils() {
    }

    public static String getSdkPreviousReleaseVersion(Path pomFile) throws IOException {
        Optional<String> versionString = Files.readAllLines(pomFile).stream().filter(l -> l.contains("<awsjavasdk.previous-previous.version>")).findFirst();
        if (!versionString.isPresent()) {
            throw new AssertionError((Object)"No version is found");
        }
        String string = versionString.get().trim();
        String substring = string.substring(38, string.indexOf(47) - 1);
        return substring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkVersionAvailability(String version, String ... artifactIds) throws IOException {
        for (String artifactId : artifactIds) {
            URLConnection connection = null;
            try {
                URI uri = URI.create(String.format("https://repo.maven.apache.org/maven2/software/amazon/awssdk/%s/%s", artifactId, version));
                connection = (HttpURLConnection)uri.toURL().openConnection(Proxy.NO_PROXY);
                connection.connect();
                int responseCode = ((HttpURLConnection)connection).getResponseCode();
                if (responseCode != 404) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                IoUtils.closeQuietly((AutoCloseable)connection.getInputStream(), null);
                IoUtils.closeQuietly((AutoCloseable)((HttpURLConnection)connection).getErrorStream(), null);
            }
        }
        return true;
    }
}

