/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

public final class Waiter<T> {
    private static final Logger log = Logger.loggerFor(Waiter.class);
    private final Supplier<T> thingToTry;
    private Predicate<T> whenToStop = t -> true;
    private Predicate<T> whenToFail = t -> false;
    private Set<Class<? extends Throwable>> whatExceptionsToStopOn = Collections.emptySet();
    private Set<Class<? extends Throwable>> whatExceptionsToIgnore = Collections.emptySet();

    private Waiter(Supplier<T> thingToTry) {
        Validate.paramNotNull(thingToTry, (String)"thingToTry");
        this.thingToTry = thingToTry;
    }

    public static <T> Waiter<T> run(Supplier<T> thingToTry) {
        return new Waiter<T>(thingToTry);
    }

    public Waiter<T> until(Predicate<T> whenToStop) {
        this.whenToStop = whenToStop;
        return this;
    }

    public Waiter<T> failOn(Predicate<T> whenToFail) {
        this.whenToFail = whenToFail;
        return this;
    }

    @SafeVarargs
    public final Waiter<T> untilException(Class<? extends Throwable> ... whenToStopOnException) {
        this.whatExceptionsToStopOn = new HashSet<Class<? extends Throwable>>(Arrays.asList(whenToStopOnException));
        return this;
    }

    @SafeVarargs
    public final Waiter<T> ignoringException(Class<? extends Throwable> ... whatToIgnore) {
        this.whatExceptionsToIgnore = new HashSet<Class<? extends Throwable>>(Arrays.asList(whatToIgnore));
        return this;
    }

    public boolean orReturnFalse() {
        try {
            this.orFail();
            return true;
        }
        catch (AssertionError e) {
            return false;
        }
    }

    public T orFail() {
        return this.orFailAfter(Duration.ofMinutes(1L));
    }

    public T orFailAfter(Duration howLongToTry) {
        Validate.paramNotNull((Object)howLongToTry, (String)"howLongToTry");
        Instant start = Instant.now();
        int attempt = 0;
        while (Duration.between(start, Instant.now()).compareTo(howLongToTry) < 0) {
            ++attempt;
            try {
                Object result;
                if (attempt > 1) {
                    this.wait(attempt);
                }
                if (this.whenToStop.test(result = this.thingToTry.get())) {
                    log.debug(() -> "Got expected response: " + result);
                    return result;
                }
                if (this.whenToFail.test(result)) {
                    throw new AssertionError((Object)("Received a response that matched the failOn predicate: " + result));
                }
                int unsuccessfulAttempt = attempt;
                log.info(() -> "Attempt " + unsuccessfulAttempt + " failed predicate.");
            }
            catch (RuntimeException e) {
                Throwable t;
                Throwable throwable = t = e instanceof CompletionException ? e.getCause() : e;
                if (this.whatExceptionsToStopOn.contains(t.getClass())) {
                    log.info(() -> "Got expected exception: " + t.getClass().getSimpleName());
                    return null;
                }
                if (this.whatExceptionsToIgnore.contains(t.getClass())) {
                    int unsuccessfulAttempt = attempt;
                    log.info(() -> "Attempt " + unsuccessfulAttempt + " failed with an expected exception (" + t.getClass() + ")");
                    continue;
                }
                throw e;
            }
        }
        throw new AssertionError((Object)("Condition was not met after " + attempt + " attempts (" + Duration.between(start, Instant.now()).getSeconds() + " seconds)"));
    }

    private void wait(int attempt) {
        int howLongToWaitMs = 250 << Math.min(attempt - 1, 4);
        try {
            Thread.sleep(howLongToWaitMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AssertionError((Object)e);
        }
    }
}

