/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyzeDocumentResponse extends TextractResponse implements
        ToCopyableBuilder<AnalyzeDocumentResponse.Builder, AnalyzeDocumentResponse> {
    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField
            .<DocumentMetadata> builder(MarshallingType.SDK_POJO).memberName("DocumentMetadata")
            .getter(getter(AnalyzeDocumentResponse::documentMetadata)).setter(setter(Builder::documentMetadata))
            .constructor(DocumentMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()).build();

    private static final SdkField<List<Block>> BLOCKS_FIELD = SdkField
            .<List<Block>> builder(MarshallingType.LIST)
            .memberName("Blocks")
            .getter(getter(AnalyzeDocumentResponse::blocks))
            .setter(setter(Builder::blocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Block> builder(MarshallingType.SDK_POJO)
                                            .constructor(Block::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<HumanLoopActivationOutput> HUMAN_LOOP_ACTIVATION_OUTPUT_FIELD = SdkField
            .<HumanLoopActivationOutput> builder(MarshallingType.SDK_POJO).memberName("HumanLoopActivationOutput")
            .getter(getter(AnalyzeDocumentResponse::humanLoopActivationOutput))
            .setter(setter(Builder::humanLoopActivationOutput)).constructor(HumanLoopActivationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationOutput").build())
            .build();

    private static final SdkField<String> ANALYZE_DOCUMENT_MODEL_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AnalyzeDocumentModelVersion")
            .getter(getter(AnalyzeDocumentResponse::analyzeDocumentModelVersion))
            .setter(setter(Builder::analyzeDocumentModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzeDocumentModelVersion")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_METADATA_FIELD,
            BLOCKS_FIELD, HUMAN_LOOP_ACTIVATION_OUTPUT_FIELD, ANALYZE_DOCUMENT_MODEL_VERSION_FIELD));

    private final DocumentMetadata documentMetadata;

    private final List<Block> blocks;

    private final HumanLoopActivationOutput humanLoopActivationOutput;

    private final String analyzeDocumentModelVersion;

    private AnalyzeDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.documentMetadata = builder.documentMetadata;
        this.blocks = builder.blocks;
        this.humanLoopActivationOutput = builder.humanLoopActivationOutput;
        this.analyzeDocumentModelVersion = builder.analyzeDocumentModelVersion;
    }

    /**
     * <p>
     * Metadata about the analyzed document. An example is the number of pages.
     * </p>
     * 
     * @return Metadata about the analyzed document. An example is the number of pages.
     */
    public final DocumentMetadata documentMetadata() {
        return documentMetadata;
    }

    /**
     * Returns true if the Blocks property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBlocks() {
        return blocks != null && !(blocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The items that are detected and analyzed by <code>AnalyzeDocument</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBlocks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The items that are detected and analyzed by <code>AnalyzeDocument</code>.
     */
    public final List<Block> blocks() {
        return blocks;
    }

    /**
     * <p>
     * Shows the results of the human in the loop evaluation.
     * </p>
     * 
     * @return Shows the results of the human in the loop evaluation.
     */
    public final HumanLoopActivationOutput humanLoopActivationOutput() {
        return humanLoopActivationOutput;
    }

    /**
     * <p>
     * The version of the model used to analyze the document.
     * </p>
     * 
     * @return The version of the model used to analyze the document.
     */
    public final String analyzeDocumentModelVersion() {
        return analyzeDocumentModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlocks() ? blocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopActivationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(analyzeDocumentModelVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzeDocumentResponse)) {
            return false;
        }
        AnalyzeDocumentResponse other = (AnalyzeDocumentResponse) obj;
        return Objects.equals(documentMetadata(), other.documentMetadata()) && hasBlocks() == other.hasBlocks()
                && Objects.equals(blocks(), other.blocks())
                && Objects.equals(humanLoopActivationOutput(), other.humanLoopActivationOutput())
                && Objects.equals(analyzeDocumentModelVersion(), other.analyzeDocumentModelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyzeDocumentResponse").add("DocumentMetadata", documentMetadata())
                .add("Blocks", hasBlocks() ? blocks() : null).add("HumanLoopActivationOutput", humanLoopActivationOutput())
                .add("AnalyzeDocumentModelVersion", analyzeDocumentModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentMetadata":
            return Optional.ofNullable(clazz.cast(documentMetadata()));
        case "Blocks":
            return Optional.ofNullable(clazz.cast(blocks()));
        case "HumanLoopActivationOutput":
            return Optional.ofNullable(clazz.cast(humanLoopActivationOutput()));
        case "AnalyzeDocumentModelVersion":
            return Optional.ofNullable(clazz.cast(analyzeDocumentModelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzeDocumentResponse, T> g) {
        return obj -> g.apply((AnalyzeDocumentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TextractResponse.Builder, SdkPojo, CopyableBuilder<Builder, AnalyzeDocumentResponse> {
        /**
         * <p>
         * Metadata about the analyzed document. An example is the number of pages.
         * </p>
         * 
         * @param documentMetadata
         *        Metadata about the analyzed document. An example is the number of pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentMetadata(DocumentMetadata documentMetadata);

        /**
         * <p>
         * Metadata about the analyzed document. An example is the number of pages.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentMetadata.Builder} avoiding the need to
         * create one manually via {@link DocumentMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #documentMetadata(DocumentMetadata)}.
         * 
         * @param documentMetadata
         *        a consumer that will call methods on {@link DocumentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentMetadata(DocumentMetadata)
         */
        default Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return documentMetadata(DocumentMetadata.builder().applyMutation(documentMetadata).build());
        }

        /**
         * <p>
         * The items that are detected and analyzed by <code>AnalyzeDocument</code>.
         * </p>
         * 
         * @param blocks
         *        The items that are detected and analyzed by <code>AnalyzeDocument</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocks(Collection<Block> blocks);

        /**
         * <p>
         * The items that are detected and analyzed by <code>AnalyzeDocument</code>.
         * </p>
         * 
         * @param blocks
         *        The items that are detected and analyzed by <code>AnalyzeDocument</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocks(Block... blocks);

        /**
         * <p>
         * The items that are detected and analyzed by <code>AnalyzeDocument</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Block>.Builder} avoiding the need to create
         * one manually via {@link List<Block>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Block>.Builder#build()} is called immediately and its result
         * is passed to {@link #blocks(List<Block>)}.
         * 
         * @param blocks
         *        a consumer that will call methods on {@link List<Block>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blocks(List<Block>)
         */
        Builder blocks(Consumer<Block.Builder>... blocks);

        /**
         * <p>
         * Shows the results of the human in the loop evaluation.
         * </p>
         * 
         * @param humanLoopActivationOutput
         *        Shows the results of the human in the loop evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopActivationOutput(HumanLoopActivationOutput humanLoopActivationOutput);

        /**
         * <p>
         * Shows the results of the human in the loop evaluation.
         * </p>
         * This is a convenience that creates an instance of the {@link HumanLoopActivationOutput.Builder} avoiding the
         * need to create one manually via {@link HumanLoopActivationOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link HumanLoopActivationOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #humanLoopActivationOutput(HumanLoopActivationOutput)}.
         * 
         * @param humanLoopActivationOutput
         *        a consumer that will call methods on {@link HumanLoopActivationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopActivationOutput(HumanLoopActivationOutput)
         */
        default Builder humanLoopActivationOutput(Consumer<HumanLoopActivationOutput.Builder> humanLoopActivationOutput) {
            return humanLoopActivationOutput(HumanLoopActivationOutput.builder().applyMutation(humanLoopActivationOutput).build());
        }

        /**
         * <p>
         * The version of the model used to analyze the document.
         * </p>
         * 
         * @param analyzeDocumentModelVersion
         *        The version of the model used to analyze the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzeDocumentModelVersion(String analyzeDocumentModelVersion);
    }

    static final class BuilderImpl extends TextractResponse.BuilderImpl implements Builder {
        private DocumentMetadata documentMetadata;

        private List<Block> blocks = DefaultSdkAutoConstructList.getInstance();

        private HumanLoopActivationOutput humanLoopActivationOutput;

        private String analyzeDocumentModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzeDocumentResponse model) {
            super(model);
            documentMetadata(model.documentMetadata);
            blocks(model.blocks);
            humanLoopActivationOutput(model.humanLoopActivationOutput);
            analyzeDocumentModelVersion(model.analyzeDocumentModelVersion);
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return documentMetadata != null ? documentMetadata.toBuilder() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        public final List<Block.Builder> getBlocks() {
            List<Block.Builder> result = BlockListCopier.copyToBuilder(this.blocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder blocks(Collection<Block> blocks) {
            this.blocks = BlockListCopier.copy(blocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Block... blocks) {
            blocks(Arrays.asList(blocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Consumer<Block.Builder>... blocks) {
            blocks(Stream.of(blocks).map(c -> Block.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlocks(Collection<Block.BuilderImpl> blocks) {
            this.blocks = BlockListCopier.copyFromBuilder(blocks);
        }

        public final HumanLoopActivationOutput.Builder getHumanLoopActivationOutput() {
            return humanLoopActivationOutput != null ? humanLoopActivationOutput.toBuilder() : null;
        }

        @Override
        public final Builder humanLoopActivationOutput(HumanLoopActivationOutput humanLoopActivationOutput) {
            this.humanLoopActivationOutput = humanLoopActivationOutput;
            return this;
        }

        public final void setHumanLoopActivationOutput(HumanLoopActivationOutput.BuilderImpl humanLoopActivationOutput) {
            this.humanLoopActivationOutput = humanLoopActivationOutput != null ? humanLoopActivationOutput.build() : null;
        }

        public final String getAnalyzeDocumentModelVersion() {
            return analyzeDocumentModelVersion;
        }

        @Override
        public final Builder analyzeDocumentModelVersion(String analyzeDocumentModelVersion) {
            this.analyzeDocumentModelVersion = analyzeDocumentModelVersion;
            return this;
        }

        public final void setAnalyzeDocumentModelVersion(String analyzeDocumentModelVersion) {
            this.analyzeDocumentModelVersion = analyzeDocumentModelVersion;
        }

        @Override
        public AnalyzeDocumentResponse build() {
            return new AnalyzeDocumentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
