/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the input document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentMetadata.Builder, DocumentMetadata> {
    private static final SdkField<Integer> PAGES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Pages")
            .getter(getter(DocumentMetadata::pages)).setter(setter(Builder::pages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pages").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer pages;

    private DocumentMetadata(BuilderImpl builder) {
        this.pages = builder.pages;
    }

    /**
     * <p>
     * The number of pages that are detected in the document.
     * </p>
     * 
     * @return The number of pages that are detected in the document.
     */
    public final Integer pages() {
        return pages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pages());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadata)) {
            return false;
        }
        DocumentMetadata other = (DocumentMetadata) obj;
        return Objects.equals(pages(), other.pages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentMetadata").add("Pages", pages()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Pages":
            return Optional.ofNullable(clazz.cast(pages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentMetadata, T> g) {
        return obj -> g.apply((DocumentMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentMetadata> {
        /**
         * <p>
         * The number of pages that are detected in the document.
         * </p>
         * 
         * @param pages
         *        The number of pages that are detected in the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pages(Integer pages);
    }

    static final class BuilderImpl implements Builder {
        private Integer pages;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentMetadata model) {
            pages(model.pages);
        }

        public final Integer getPages() {
            return pages;
        }

        @Override
        public final Builder pages(Integer pages) {
            this.pages = pages;
            return this;
        }

        public final void setPages(Integer pages) {
            this.pages = pages;
        }

        @Override
        public DocumentMetadata build() {
            return new DocumentMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
