/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectDocumentTextRequest extends TextractRequest implements
        ToCopyableBuilder<DetectDocumentTextRequest.Builder, DetectDocumentTextRequest> {
    private static final SdkField<Document> DOCUMENT_FIELD = SdkField.<Document> builder(MarshallingType.SDK_POJO)
            .memberName("Document").getter(getter(DetectDocumentTextRequest::document)).setter(setter(Builder::document))
            .constructor(Document::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Document").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD));

    private final Document document;

    private DetectDocumentTextRequest(BuilderImpl builder) {
        super(builder);
        this.document = builder.document;
    }

    /**
     * <p>
     * The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon Textract
     * operations, you can't pass image bytes. The document must be an image in JPEG or PNG format.
     * </p>
     * <p>
     * If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that are
     * passed using the <code>Bytes</code> field.
     * </p>
     * 
     * @return The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon
     *         Textract operations, you can't pass image bytes. The document must be an image in JPEG or PNG format.</p>
     *         <p>
     *         If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that
     *         are passed using the <code>Bytes</code> field.
     */
    public final Document document() {
        return document;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(document());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectDocumentTextRequest)) {
            return false;
        }
        DetectDocumentTextRequest other = (DetectDocumentTextRequest) obj;
        return Objects.equals(document(), other.document());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectDocumentTextRequest").add("Document", document()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Document":
            return Optional.ofNullable(clazz.cast(document()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectDocumentTextRequest, T> g) {
        return obj -> g.apply((DetectDocumentTextRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TextractRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetectDocumentTextRequest> {
        /**
         * <p>
         * The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon
         * Textract operations, you can't pass image bytes. The document must be an image in JPEG or PNG format.
         * </p>
         * <p>
         * If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that are
         * passed using the <code>Bytes</code> field.
         * </p>
         * 
         * @param document
         *        The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call
         *        Amazon Textract operations, you can't pass image bytes. The document must be an image in JPEG or PNG
         *        format.</p>
         *        <p>
         *        If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes
         *        that are passed using the <code>Bytes</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(Document document);

        /**
         * <p>
         * The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon
         * Textract operations, you can't pass image bytes. The document must be an image in JPEG or PNG format.
         * </p>
         * <p>
         * If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that are
         * passed using the <code>Bytes</code> field.
         * </p>
         * This is a convenience that creates an instance of the {@link Document.Builder} avoiding the need to create
         * one manually via {@link Document#builder()}.
         *
         * When the {@link Consumer} completes, {@link Document.Builder#build()} is called immediately and its result is
         * passed to {@link #document(Document)}.
         * 
         * @param document
         *        a consumer that will call methods on {@link Document.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #document(Document)
         */
        default Builder document(Consumer<Document.Builder> document) {
            return document(Document.builder().applyMutation(document).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TextractRequest.BuilderImpl implements Builder {
        private Document document;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectDocumentTextRequest model) {
            super(model);
            document(model.document);
        }

        public final Document.Builder getDocument() {
            return document != null ? document.toBuilder() : null;
        }

        public final void setDocument(Document.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        @Transient
        public final Builder document(Document document) {
            this.document = document;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectDocumentTextRequest build() {
            return new DetectDocumentTextRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
