/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A grouping of tables which contain LineItems, with each table identified by the table's
 * <code>LineItemGroupIndex</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineItemGroup implements SdkPojo, Serializable, ToCopyableBuilder<LineItemGroup.Builder, LineItemGroup> {
    private static final SdkField<Integer> LINE_ITEM_GROUP_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LineItemGroupIndex").getter(getter(LineItemGroup::lineItemGroupIndex))
            .setter(setter(Builder::lineItemGroupIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItemGroupIndex").build())
            .build();

    private static final SdkField<List<LineItemFields>> LINE_ITEMS_FIELD = SdkField
            .<List<LineItemFields>> builder(MarshallingType.LIST)
            .memberName("LineItems")
            .getter(getter(LineItemGroup::lineItems))
            .setter(setter(Builder::lineItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LineItemFields> builder(MarshallingType.SDK_POJO)
                                            .constructor(LineItemFields::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_ITEM_GROUP_INDEX_FIELD,
            LINE_ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer lineItemGroupIndex;

    private final List<LineItemFields> lineItems;

    private LineItemGroup(BuilderImpl builder) {
        this.lineItemGroupIndex = builder.lineItemGroupIndex;
        this.lineItems = builder.lineItems;
    }

    /**
     * <p>
     * The number used to identify a specific table in a document. The first table encountered will have a
     * LineItemGroupIndex of 1, the second 2, etc.
     * </p>
     * 
     * @return The number used to identify a specific table in a document. The first table encountered will have a
     *         LineItemGroupIndex of 1, the second 2, etc.
     */
    public final Integer lineItemGroupIndex() {
        return lineItemGroupIndex;
    }

    /**
     * For responses, this returns true if the service returned a value for the LineItems property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLineItems() {
        return lineItems != null && !(lineItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The breakdown of information on a particular line of a table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLineItems} method.
     * </p>
     * 
     * @return The breakdown of information on a particular line of a table.
     */
    public final List<LineItemFields> lineItems() {
        return lineItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lineItemGroupIndex());
        hashCode = 31 * hashCode + Objects.hashCode(hasLineItems() ? lineItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItemGroup)) {
            return false;
        }
        LineItemGroup other = (LineItemGroup) obj;
        return Objects.equals(lineItemGroupIndex(), other.lineItemGroupIndex()) && hasLineItems() == other.hasLineItems()
                && Objects.equals(lineItems(), other.lineItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineItemGroup").add("LineItemGroupIndex", lineItemGroupIndex())
                .add("LineItems", hasLineItems() ? lineItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LineItemGroupIndex":
            return Optional.ofNullable(clazz.cast(lineItemGroupIndex()));
        case "LineItems":
            return Optional.ofNullable(clazz.cast(lineItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LineItemGroup, T> g) {
        return obj -> g.apply((LineItemGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineItemGroup> {
        /**
         * <p>
         * The number used to identify a specific table in a document. The first table encountered will have a
         * LineItemGroupIndex of 1, the second 2, etc.
         * </p>
         * 
         * @param lineItemGroupIndex
         *        The number used to identify a specific table in a document. The first table encountered will have a
         *        LineItemGroupIndex of 1, the second 2, etc.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItemGroupIndex(Integer lineItemGroupIndex);

        /**
         * <p>
         * The breakdown of information on a particular line of a table.
         * </p>
         * 
         * @param lineItems
         *        The breakdown of information on a particular line of a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItems(Collection<LineItemFields> lineItems);

        /**
         * <p>
         * The breakdown of information on a particular line of a table.
         * </p>
         * 
         * @param lineItems
         *        The breakdown of information on a particular line of a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItems(LineItemFields... lineItems);

        /**
         * <p>
         * The breakdown of information on a particular line of a table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LineItemFields>.Builder} avoiding the need
         * to create one manually via {@link List<LineItemFields>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LineItemFields>.Builder#build()} is called immediately and
         * its result is passed to {@link #lineItems(List<LineItemFields>)}.
         * 
         * @param lineItems
         *        a consumer that will call methods on {@link List<LineItemFields>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineItems(List<LineItemFields>)
         */
        Builder lineItems(Consumer<LineItemFields.Builder>... lineItems);
    }

    static final class BuilderImpl implements Builder {
        private Integer lineItemGroupIndex;

        private List<LineItemFields> lineItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LineItemGroup model) {
            lineItemGroupIndex(model.lineItemGroupIndex);
            lineItems(model.lineItems);
        }

        public final Integer getLineItemGroupIndex() {
            return lineItemGroupIndex;
        }

        public final void setLineItemGroupIndex(Integer lineItemGroupIndex) {
            this.lineItemGroupIndex = lineItemGroupIndex;
        }

        @Override
        @Transient
        public final Builder lineItemGroupIndex(Integer lineItemGroupIndex) {
            this.lineItemGroupIndex = lineItemGroupIndex;
            return this;
        }

        public final List<LineItemFields.Builder> getLineItems() {
            List<LineItemFields.Builder> result = LineItemListCopier.copyToBuilder(this.lineItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineItems(Collection<LineItemFields.BuilderImpl> lineItems) {
            this.lineItems = LineItemListCopier.copyFromBuilder(lineItems);
        }

        @Override
        @Transient
        public final Builder lineItems(Collection<LineItemFields> lineItems) {
            this.lineItems = LineItemListCopier.copy(lineItems);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lineItems(LineItemFields... lineItems) {
            lineItems(Arrays.asList(lineItems));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lineItems(Consumer<LineItemFields.Builder>... lineItems) {
            lineItems(Stream.of(lineItems).map(c -> LineItemFields.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public LineItemGroup build() {
            return new LineItemGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
