/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure containing both the normalized type of the extracted information and the text associated with it. These are
 * extracted as Type and Value respectively.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityDocumentField implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityDocumentField.Builder, IdentityDocumentField> {
    private static final SdkField<AnalyzeIDDetections> TYPE_FIELD = SdkField
            .<AnalyzeIDDetections> builder(MarshallingType.SDK_POJO).memberName("Type")
            .getter(getter(IdentityDocumentField::type)).setter(setter(Builder::type)).constructor(AnalyzeIDDetections::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<AnalyzeIDDetections> VALUE_DETECTION_FIELD = SdkField
            .<AnalyzeIDDetections> builder(MarshallingType.SDK_POJO).memberName("ValueDetection")
            .getter(getter(IdentityDocumentField::valueDetection)).setter(setter(Builder::valueDetection))
            .constructor(AnalyzeIDDetections::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueDetection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            VALUE_DETECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AnalyzeIDDetections type;

    private final AnalyzeIDDetections valueDetection;

    private IdentityDocumentField(BuilderImpl builder) {
        this.type = builder.type;
        this.valueDetection = builder.valueDetection;
    }

    /**
     * Returns the value of the Type property for this object.
     * 
     * @return The value of the Type property for this object.
     */
    public final AnalyzeIDDetections type() {
        return type;
    }

    /**
     * Returns the value of the ValueDetection property for this object.
     * 
     * @return The value of the ValueDetection property for this object.
     */
    public final AnalyzeIDDetections valueDetection() {
        return valueDetection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(valueDetection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityDocumentField)) {
            return false;
        }
        IdentityDocumentField other = (IdentityDocumentField) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(valueDetection(), other.valueDetection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityDocumentField").add("Type", type()).add("ValueDetection", valueDetection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "ValueDetection":
            return Optional.ofNullable(clazz.cast(valueDetection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityDocumentField, T> g) {
        return obj -> g.apply((IdentityDocumentField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityDocumentField> {
        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(AnalyzeIDDetections type);

        /**
         * Sets the value of the Type property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AnalyzeIDDetections.Builder} avoiding the
         * need to create one manually via {@link AnalyzeIDDetections#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalyzeIDDetections.Builder#build()} is called immediately and
         * its result is passed to {@link #type(AnalyzeIDDetections)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link AnalyzeIDDetections.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(AnalyzeIDDetections)
         */
        default Builder type(Consumer<AnalyzeIDDetections.Builder> type) {
            return type(AnalyzeIDDetections.builder().applyMutation(type).build());
        }

        /**
         * Sets the value of the ValueDetection property for this object.
         *
         * @param valueDetection
         *        The new value for the ValueDetection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueDetection(AnalyzeIDDetections valueDetection);

        /**
         * Sets the value of the ValueDetection property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AnalyzeIDDetections.Builder} avoiding the
         * need to create one manually via {@link AnalyzeIDDetections#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalyzeIDDetections.Builder#build()} is called immediately and
         * its result is passed to {@link #valueDetection(AnalyzeIDDetections)}.
         * 
         * @param valueDetection
         *        a consumer that will call methods on {@link AnalyzeIDDetections.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueDetection(AnalyzeIDDetections)
         */
        default Builder valueDetection(Consumer<AnalyzeIDDetections.Builder> valueDetection) {
            return valueDetection(AnalyzeIDDetections.builder().applyMutation(valueDetection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AnalyzeIDDetections type;

        private AnalyzeIDDetections valueDetection;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityDocumentField model) {
            type(model.type);
            valueDetection(model.valueDetection);
        }

        public final AnalyzeIDDetections.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(AnalyzeIDDetections.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(AnalyzeIDDetections type) {
            this.type = type;
            return this;
        }

        public final AnalyzeIDDetections.Builder getValueDetection() {
            return valueDetection != null ? valueDetection.toBuilder() : null;
        }

        public final void setValueDetection(AnalyzeIDDetections.BuilderImpl valueDetection) {
            this.valueDetection = valueDetection != null ? valueDetection.build() : null;
        }

        @Override
        public final Builder valueDetection(AnalyzeIDDetections valueDetection) {
            this.valueDetection = valueDetection;
            return this;
        }

        @Override
        public IdentityDocumentField build() {
            return new IdentityDocumentField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
