/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.IdentityDocumentField;
import software.amazon.awssdk.services.textract.model.IdentityDocumentFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentityDocument> {
    private static final SdkField<Integer> DOCUMENT_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DocumentIndex").getter(IdentityDocument.getter(IdentityDocument::documentIndex)).setter(IdentityDocument.setter(Builder::documentIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentIndex").build()}).build();
    private static final SdkField<List<IdentityDocumentField>> IDENTITY_DOCUMENT_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IdentityDocumentFields").getter(IdentityDocument.getter(IdentityDocument::identityDocumentFields)).setter(IdentityDocument.setter(Builder::identityDocumentFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityDocumentFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdentityDocumentField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_INDEX_FIELD, IDENTITY_DOCUMENT_FIELDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer documentIndex;
    private final List<IdentityDocumentField> identityDocumentFields;

    private IdentityDocument(BuilderImpl builder) {
        this.documentIndex = builder.documentIndex;
        this.identityDocumentFields = builder.identityDocumentFields;
    }

    public final Integer documentIndex() {
        return this.documentIndex;
    }

    public final boolean hasIdentityDocumentFields() {
        return this.identityDocumentFields != null && !(this.identityDocumentFields instanceof SdkAutoConstructList);
    }

    public final List<IdentityDocumentField> identityDocumentFields() {
        return this.identityDocumentFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentityDocumentFields() ? this.identityDocumentFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityDocument)) {
            return false;
        }
        IdentityDocument other = (IdentityDocument)obj;
        return Objects.equals(this.documentIndex(), other.documentIndex()) && this.hasIdentityDocumentFields() == other.hasIdentityDocumentFields() && Objects.equals(this.identityDocumentFields(), other.identityDocumentFields());
    }

    public final String toString() {
        return ToString.builder((String)"IdentityDocument").add("DocumentIndex", (Object)this.documentIndex()).add("IdentityDocumentFields", this.hasIdentityDocumentFields() ? this.identityDocumentFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentIndex": {
                return Optional.ofNullable(clazz.cast(this.documentIndex()));
            }
            case "IdentityDocumentFields": {
                return Optional.ofNullable(clazz.cast(this.identityDocumentFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityDocument, T> g) {
        return obj -> g.apply((IdentityDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer documentIndex;
        private List<IdentityDocumentField> identityDocumentFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityDocument model) {
            this.documentIndex(model.documentIndex);
            this.identityDocumentFields(model.identityDocumentFields);
        }

        public final Integer getDocumentIndex() {
            return this.documentIndex;
        }

        public final void setDocumentIndex(Integer documentIndex) {
            this.documentIndex = documentIndex;
        }

        @Override
        public final Builder documentIndex(Integer documentIndex) {
            this.documentIndex = documentIndex;
            return this;
        }

        public final List<IdentityDocumentField.Builder> getIdentityDocumentFields() {
            List<IdentityDocumentField.Builder> result = IdentityDocumentFieldListCopier.copyToBuilder(this.identityDocumentFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentityDocumentFields(Collection<IdentityDocumentField.BuilderImpl> identityDocumentFields) {
            this.identityDocumentFields = IdentityDocumentFieldListCopier.copyFromBuilder(identityDocumentFields);
        }

        @Override
        public final Builder identityDocumentFields(Collection<IdentityDocumentField> identityDocumentFields) {
            this.identityDocumentFields = IdentityDocumentFieldListCopier.copy(identityDocumentFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityDocumentFields(IdentityDocumentField ... identityDocumentFields) {
            this.identityDocumentFields(Arrays.asList(identityDocumentFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityDocumentFields(Consumer<IdentityDocumentField.Builder> ... identityDocumentFields) {
            this.identityDocumentFields(Stream.of(identityDocumentFields).map(c -> (IdentityDocumentField)((IdentityDocumentField.Builder)IdentityDocumentField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IdentityDocument build() {
            return new IdentityDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentityDocument> {
        public Builder documentIndex(Integer var1);

        public Builder identityDocumentFields(Collection<IdentityDocumentField> var1);

        public Builder identityDocumentFields(IdentityDocumentField ... var1);

        public Builder identityDocumentFields(Consumer<IdentityDocumentField.Builder> ... var1);
    }
}

