/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to contain the information detected by an AnalyzeID operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyzeIDDetections implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyzeIDDetections.Builder, AnalyzeIDDetections> {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(AnalyzeIDDetections::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<NormalizedValue> NORMALIZED_VALUE_FIELD = SdkField
            .<NormalizedValue> builder(MarshallingType.SDK_POJO).memberName("NormalizedValue")
            .getter(getter(AnalyzeIDDetections::normalizedValue)).setter(setter(Builder::normalizedValue))
            .constructor(NormalizedValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NormalizedValue").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(AnalyzeIDDetections::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD,
            NORMALIZED_VALUE_FIELD, CONFIDENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String text;

    private final NormalizedValue normalizedValue;

    private final Float confidence;

    private AnalyzeIDDetections(BuilderImpl builder) {
        this.text = builder.text;
        this.normalizedValue = builder.normalizedValue;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * Text of either the normalized field or value associated with it.
     * </p>
     * 
     * @return Text of either the normalized field or value associated with it.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * Only returned for dates, returns the type of value detected and the date written in a more machine readable way.
     * </p>
     * 
     * @return Only returned for dates, returns the type of value detected and the date written in a more machine
     *         readable way.
     */
    public final NormalizedValue normalizedValue() {
        return normalizedValue;
    }

    /**
     * <p>
     * The confidence score of the detected text.
     * </p>
     * 
     * @return The confidence score of the detected text.
     */
    public final Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(normalizedValue());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzeIDDetections)) {
            return false;
        }
        AnalyzeIDDetections other = (AnalyzeIDDetections) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(normalizedValue(), other.normalizedValue())
                && Objects.equals(confidence(), other.confidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyzeIDDetections").add("Text", text()).add("NormalizedValue", normalizedValue())
                .add("Confidence", confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "NormalizedValue":
            return Optional.ofNullable(clazz.cast(normalizedValue()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzeIDDetections, T> g) {
        return obj -> g.apply((AnalyzeIDDetections) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyzeIDDetections> {
        /**
         * <p>
         * Text of either the normalized field or value associated with it.
         * </p>
         * 
         * @param text
         *        Text of either the normalized field or value associated with it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * Only returned for dates, returns the type of value detected and the date written in a more machine readable
         * way.
         * </p>
         * 
         * @param normalizedValue
         *        Only returned for dates, returns the type of value detected and the date written in a more machine
         *        readable way.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder normalizedValue(NormalizedValue normalizedValue);

        /**
         * <p>
         * Only returned for dates, returns the type of value detected and the date written in a more machine readable
         * way.
         * </p>
         * This is a convenience method that creates an instance of the {@link NormalizedValue.Builder} avoiding the
         * need to create one manually via {@link NormalizedValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link NormalizedValue.Builder#build()} is called immediately and its
         * result is passed to {@link #normalizedValue(NormalizedValue)}.
         * 
         * @param normalizedValue
         *        a consumer that will call methods on {@link NormalizedValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #normalizedValue(NormalizedValue)
         */
        default Builder normalizedValue(Consumer<NormalizedValue.Builder> normalizedValue) {
            return normalizedValue(NormalizedValue.builder().applyMutation(normalizedValue).build());
        }

        /**
         * <p>
         * The confidence score of the detected text.
         * </p>
         * 
         * @param confidence
         *        The confidence score of the detected text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    static final class BuilderImpl implements Builder {
        private String text;

        private NormalizedValue normalizedValue;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzeIDDetections model) {
            text(model.text);
            normalizedValue(model.normalizedValue);
            confidence(model.confidence);
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final NormalizedValue.Builder getNormalizedValue() {
            return normalizedValue != null ? normalizedValue.toBuilder() : null;
        }

        public final void setNormalizedValue(NormalizedValue.BuilderImpl normalizedValue) {
            this.normalizedValue = normalizedValue != null ? normalizedValue.build() : null;
        }

        @Override
        public final Builder normalizedValue(NormalizedValue normalizedValue) {
            this.normalizedValue = normalizedValue;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public AnalyzeIDDetections build() {
            return new AnalyzeIDDetections(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
