/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Breakdown of detected information, seperated into the catagories Type, LabelDetection, and ValueDetection
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExpenseField implements SdkPojo, Serializable, ToCopyableBuilder<ExpenseField.Builder, ExpenseField> {
    private static final SdkField<ExpenseType> TYPE_FIELD = SdkField.<ExpenseType> builder(MarshallingType.SDK_POJO)
            .memberName("Type").getter(getter(ExpenseField::type)).setter(setter(Builder::type))
            .constructor(ExpenseType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<ExpenseDetection> LABEL_DETECTION_FIELD = SdkField
            .<ExpenseDetection> builder(MarshallingType.SDK_POJO).memberName("LabelDetection")
            .getter(getter(ExpenseField::labelDetection)).setter(setter(Builder::labelDetection))
            .constructor(ExpenseDetection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelDetection").build()).build();

    private static final SdkField<ExpenseDetection> VALUE_DETECTION_FIELD = SdkField
            .<ExpenseDetection> builder(MarshallingType.SDK_POJO).memberName("ValueDetection")
            .getter(getter(ExpenseField::valueDetection)).setter(setter(Builder::valueDetection))
            .constructor(ExpenseDetection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueDetection").build()).build();

    private static final SdkField<Integer> PAGE_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageNumber").getter(getter(ExpenseField::pageNumber)).setter(setter(Builder::pageNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            LABEL_DETECTION_FIELD, VALUE_DETECTION_FIELD, PAGE_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final ExpenseType type;

    private final ExpenseDetection labelDetection;

    private final ExpenseDetection valueDetection;

    private final Integer pageNumber;

    private ExpenseField(BuilderImpl builder) {
        this.type = builder.type;
        this.labelDetection = builder.labelDetection;
        this.valueDetection = builder.valueDetection;
        this.pageNumber = builder.pageNumber;
    }

    /**
     * <p>
     * The implied label of a detected element. Present alongside LabelDetection for explicit elements.
     * </p>
     * 
     * @return The implied label of a detected element. Present alongside LabelDetection for explicit elements.
     */
    public final ExpenseType type() {
        return type;
    }

    /**
     * <p>
     * The explicitly stated label of a detected element.
     * </p>
     * 
     * @return The explicitly stated label of a detected element.
     */
    public final ExpenseDetection labelDetection() {
        return labelDetection;
    }

    /**
     * <p>
     * The value of a detected element. Present in explicit and implicit elements.
     * </p>
     * 
     * @return The value of a detected element. Present in explicit and implicit elements.
     */
    public final ExpenseDetection valueDetection() {
        return valueDetection;
    }

    /**
     * <p>
     * The page number the value was detected on.
     * </p>
     * 
     * @return The page number the value was detected on.
     */
    public final Integer pageNumber() {
        return pageNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(labelDetection());
        hashCode = 31 * hashCode + Objects.hashCode(valueDetection());
        hashCode = 31 * hashCode + Objects.hashCode(pageNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpenseField)) {
            return false;
        }
        ExpenseField other = (ExpenseField) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(labelDetection(), other.labelDetection())
                && Objects.equals(valueDetection(), other.valueDetection()) && Objects.equals(pageNumber(), other.pageNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExpenseField").add("Type", type()).add("LabelDetection", labelDetection())
                .add("ValueDetection", valueDetection()).add("PageNumber", pageNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "LabelDetection":
            return Optional.ofNullable(clazz.cast(labelDetection()));
        case "ValueDetection":
            return Optional.ofNullable(clazz.cast(valueDetection()));
        case "PageNumber":
            return Optional.ofNullable(clazz.cast(pageNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExpenseField, T> g) {
        return obj -> g.apply((ExpenseField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExpenseField> {
        /**
         * <p>
         * The implied label of a detected element. Present alongside LabelDetection for explicit elements.
         * </p>
         * 
         * @param type
         *        The implied label of a detected element. Present alongside LabelDetection for explicit elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(ExpenseType type);

        /**
         * <p>
         * The implied label of a detected element. Present alongside LabelDetection for explicit elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpenseType.Builder} avoiding the need to
         * create one manually via {@link ExpenseType#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExpenseType.Builder#build()} is called immediately and its result
         * is passed to {@link #type(ExpenseType)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link ExpenseType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(ExpenseType)
         */
        default Builder type(Consumer<ExpenseType.Builder> type) {
            return type(ExpenseType.builder().applyMutation(type).build());
        }

        /**
         * <p>
         * The explicitly stated label of a detected element.
         * </p>
         * 
         * @param labelDetection
         *        The explicitly stated label of a detected element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelDetection(ExpenseDetection labelDetection);

        /**
         * <p>
         * The explicitly stated label of a detected element.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpenseDetection.Builder} avoiding the
         * need to create one manually via {@link ExpenseDetection#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExpenseDetection.Builder#build()} is called immediately and its
         * result is passed to {@link #labelDetection(ExpenseDetection)}.
         * 
         * @param labelDetection
         *        a consumer that will call methods on {@link ExpenseDetection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelDetection(ExpenseDetection)
         */
        default Builder labelDetection(Consumer<ExpenseDetection.Builder> labelDetection) {
            return labelDetection(ExpenseDetection.builder().applyMutation(labelDetection).build());
        }

        /**
         * <p>
         * The value of a detected element. Present in explicit and implicit elements.
         * </p>
         * 
         * @param valueDetection
         *        The value of a detected element. Present in explicit and implicit elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueDetection(ExpenseDetection valueDetection);

        /**
         * <p>
         * The value of a detected element. Present in explicit and implicit elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpenseDetection.Builder} avoiding the
         * need to create one manually via {@link ExpenseDetection#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExpenseDetection.Builder#build()} is called immediately and its
         * result is passed to {@link #valueDetection(ExpenseDetection)}.
         * 
         * @param valueDetection
         *        a consumer that will call methods on {@link ExpenseDetection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueDetection(ExpenseDetection)
         */
        default Builder valueDetection(Consumer<ExpenseDetection.Builder> valueDetection) {
            return valueDetection(ExpenseDetection.builder().applyMutation(valueDetection).build());
        }

        /**
         * <p>
         * The page number the value was detected on.
         * </p>
         * 
         * @param pageNumber
         *        The page number the value was detected on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageNumber(Integer pageNumber);
    }

    static final class BuilderImpl implements Builder {
        private ExpenseType type;

        private ExpenseDetection labelDetection;

        private ExpenseDetection valueDetection;

        private Integer pageNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpenseField model) {
            type(model.type);
            labelDetection(model.labelDetection);
            valueDetection(model.valueDetection);
            pageNumber(model.pageNumber);
        }

        public final ExpenseType.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(ExpenseType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(ExpenseType type) {
            this.type = type;
            return this;
        }

        public final ExpenseDetection.Builder getLabelDetection() {
            return labelDetection != null ? labelDetection.toBuilder() : null;
        }

        public final void setLabelDetection(ExpenseDetection.BuilderImpl labelDetection) {
            this.labelDetection = labelDetection != null ? labelDetection.build() : null;
        }

        @Override
        public final Builder labelDetection(ExpenseDetection labelDetection) {
            this.labelDetection = labelDetection;
            return this;
        }

        public final ExpenseDetection.Builder getValueDetection() {
            return valueDetection != null ? valueDetection.toBuilder() : null;
        }

        public final void setValueDetection(ExpenseDetection.BuilderImpl valueDetection) {
            this.valueDetection = valueDetection != null ? valueDetection.build() : null;
        }

        @Override
        public final Builder valueDetection(ExpenseDetection valueDetection) {
            this.valueDetection = valueDetection;
            return this;
        }

        public final Integer getPageNumber() {
            return pageNumber;
        }

        public final void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        @Override
        public final Builder pageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        @Override
        public ExpenseField build() {
            return new ExpenseField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
