/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyzeDocumentRequest extends TextractRequest implements
        ToCopyableBuilder<AnalyzeDocumentRequest.Builder, AnalyzeDocumentRequest> {
    private static final SdkField<Document> DOCUMENT_FIELD = SdkField.<Document> builder(MarshallingType.SDK_POJO)
            .memberName("Document").getter(getter(AnalyzeDocumentRequest::document)).setter(setter(Builder::document))
            .constructor(Document::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Document").build()).build();

    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FeatureTypes")
            .getter(getter(AnalyzeDocumentRequest::featureTypesAsStrings))
            .setter(setter(Builder::featureTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<HumanLoopConfig> HUMAN_LOOP_CONFIG_FIELD = SdkField
            .<HumanLoopConfig> builder(MarshallingType.SDK_POJO).memberName("HumanLoopConfig")
            .getter(getter(AnalyzeDocumentRequest::humanLoopConfig)).setter(setter(Builder::humanLoopConfig))
            .constructor(HumanLoopConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopConfig").build()).build();

    private static final SdkField<QueriesConfig> QUERIES_CONFIG_FIELD = SdkField
            .<QueriesConfig> builder(MarshallingType.SDK_POJO).memberName("QueriesConfig")
            .getter(getter(AnalyzeDocumentRequest::queriesConfig)).setter(setter(Builder::queriesConfig))
            .constructor(QueriesConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueriesConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD,
            FEATURE_TYPES_FIELD, HUMAN_LOOP_CONFIG_FIELD, QUERIES_CONFIG_FIELD));

    private final Document document;

    private final List<String> featureTypes;

    private final HumanLoopConfig humanLoopConfig;

    private final QueriesConfig queriesConfig;

    private AnalyzeDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.document = builder.document;
        this.featureTypes = builder.featureTypes;
        this.humanLoopConfig = builder.humanLoopConfig;
        this.queriesConfig = builder.queriesConfig;
    }

    /**
     * <p>
     * The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon Textract
     * operations, you can't pass image bytes. The document must be an image in JPEG, PNG, PDF, or TIFF format.
     * </p>
     * <p>
     * If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that are
     * passed using the <code>Bytes</code> field.
     * </p>
     * 
     * @return The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon
     *         Textract operations, you can't pass image bytes. The document must be an image in JPEG, PNG, PDF, or TIFF
     *         format.</p>
     *         <p>
     *         If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that
     *         are passed using the <code>Bytes</code> field.
     */
    public final Document document() {
        return document;
    }

    /**
     * <p>
     * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables that
     * are detected in the input document. Add FORMS to return detected form data. To perform both types of analysis,
     * add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are included in
     * the response (including text that isn't related to the value of <code>FeatureTypes</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatureTypes} method.
     * </p>
     * 
     * @return A list of the types of analysis to perform. Add TABLES to the list to return information about the tables
     *         that are detected in the input document. Add FORMS to return detected form data. To perform both types of
     *         analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document
     *         are included in the response (including text that isn't related to the value of <code>FeatureTypes</code>
     *         ).
     */
    public final List<FeatureType> featureTypes() {
        return FeatureTypesCopier.copyStringToEnum(featureTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the FeatureTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFeatureTypes() {
        return featureTypes != null && !(featureTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables that
     * are detected in the input document. Add FORMS to return detected form data. To perform both types of analysis,
     * add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are included in
     * the response (including text that isn't related to the value of <code>FeatureTypes</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatureTypes} method.
     * </p>
     * 
     * @return A list of the types of analysis to perform. Add TABLES to the list to return information about the tables
     *         that are detected in the input document. Add FORMS to return detected form data. To perform both types of
     *         analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document
     *         are included in the response (including text that isn't related to the value of <code>FeatureTypes</code>
     *         ).
     */
    public final List<String> featureTypesAsStrings() {
        return featureTypes;
    }

    /**
     * <p>
     * Sets the configuration for the human in the loop workflow for analyzing documents.
     * </p>
     * 
     * @return Sets the configuration for the human in the loop workflow for analyzing documents.
     */
    public final HumanLoopConfig humanLoopConfig() {
        return humanLoopConfig;
    }

    /**
     * <p>
     * Contains Queries and the alias for those Queries, as determined by the input.
     * </p>
     * 
     * @return Contains Queries and the alias for those Queries, as determined by the input.
     */
    public final QueriesConfig queriesConfig() {
        return queriesConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatureTypes() ? featureTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopConfig());
        hashCode = 31 * hashCode + Objects.hashCode(queriesConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzeDocumentRequest)) {
            return false;
        }
        AnalyzeDocumentRequest other = (AnalyzeDocumentRequest) obj;
        return Objects.equals(document(), other.document()) && hasFeatureTypes() == other.hasFeatureTypes()
                && Objects.equals(featureTypesAsStrings(), other.featureTypesAsStrings())
                && Objects.equals(humanLoopConfig(), other.humanLoopConfig())
                && Objects.equals(queriesConfig(), other.queriesConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyzeDocumentRequest").add("Document", document())
                .add("FeatureTypes", hasFeatureTypes() ? featureTypesAsStrings() : null)
                .add("HumanLoopConfig", humanLoopConfig()).add("QueriesConfig", queriesConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Document":
            return Optional.ofNullable(clazz.cast(document()));
        case "FeatureTypes":
            return Optional.ofNullable(clazz.cast(featureTypesAsStrings()));
        case "HumanLoopConfig":
            return Optional.ofNullable(clazz.cast(humanLoopConfig()));
        case "QueriesConfig":
            return Optional.ofNullable(clazz.cast(queriesConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzeDocumentRequest, T> g) {
        return obj -> g.apply((AnalyzeDocumentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TextractRequest.Builder, SdkPojo, CopyableBuilder<Builder, AnalyzeDocumentRequest> {
        /**
         * <p>
         * The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon
         * Textract operations, you can't pass image bytes. The document must be an image in JPEG, PNG, PDF, or TIFF
         * format.
         * </p>
         * <p>
         * If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that are
         * passed using the <code>Bytes</code> field.
         * </p>
         * 
         * @param document
         *        The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call
         *        Amazon Textract operations, you can't pass image bytes. The document must be an image in JPEG, PNG,
         *        PDF, or TIFF format.</p>
         *        <p>
         *        If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes
         *        that are passed using the <code>Bytes</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(Document document);

        /**
         * <p>
         * The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon
         * Textract operations, you can't pass image bytes. The document must be an image in JPEG, PNG, PDF, or TIFF
         * format.
         * </p>
         * <p>
         * If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that are
         * passed using the <code>Bytes</code> field.
         * </p>
         * This is a convenience method that creates an instance of the {@link Document.Builder} avoiding the need to
         * create one manually via {@link Document#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Document.Builder#build()} is called immediately and its result is
         * passed to {@link #document(Document)}.
         * 
         * @param document
         *        a consumer that will call methods on {@link Document.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #document(Document)
         */
        default Builder document(Consumer<Document.Builder> document) {
            return document(Document.builder().applyMutation(document).build());
        }

        /**
         * <p>
         * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables
         * that are detected in the input document. Add FORMS to return detected form data. To perform both types of
         * analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are
         * included in the response (including text that isn't related to the value of <code>FeatureTypes</code>).
         * </p>
         * 
         * @param featureTypes
         *        A list of the types of analysis to perform. Add TABLES to the list to return information about the
         *        tables that are detected in the input document. Add FORMS to return detected form data. To perform
         *        both types of analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words
         *        detected in the document are included in the response (including text that isn't related to the value
         *        of <code>FeatureTypes</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypesWithStrings(Collection<String> featureTypes);

        /**
         * <p>
         * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables
         * that are detected in the input document. Add FORMS to return detected form data. To perform both types of
         * analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are
         * included in the response (including text that isn't related to the value of <code>FeatureTypes</code>).
         * </p>
         * 
         * @param featureTypes
         *        A list of the types of analysis to perform. Add TABLES to the list to return information about the
         *        tables that are detected in the input document. Add FORMS to return detected form data. To perform
         *        both types of analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words
         *        detected in the document are included in the response (including text that isn't related to the value
         *        of <code>FeatureTypes</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypesWithStrings(String... featureTypes);

        /**
         * <p>
         * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables
         * that are detected in the input document. Add FORMS to return detected form data. To perform both types of
         * analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are
         * included in the response (including text that isn't related to the value of <code>FeatureTypes</code>).
         * </p>
         * 
         * @param featureTypes
         *        A list of the types of analysis to perform. Add TABLES to the list to return information about the
         *        tables that are detected in the input document. Add FORMS to return detected form data. To perform
         *        both types of analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words
         *        detected in the document are included in the response (including text that isn't related to the value
         *        of <code>FeatureTypes</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypes(Collection<FeatureType> featureTypes);

        /**
         * <p>
         * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables
         * that are detected in the input document. Add FORMS to return detected form data. To perform both types of
         * analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are
         * included in the response (including text that isn't related to the value of <code>FeatureTypes</code>).
         * </p>
         * 
         * @param featureTypes
         *        A list of the types of analysis to perform. Add TABLES to the list to return information about the
         *        tables that are detected in the input document. Add FORMS to return detected form data. To perform
         *        both types of analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words
         *        detected in the document are included in the response (including text that isn't related to the value
         *        of <code>FeatureTypes</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypes(FeatureType... featureTypes);

        /**
         * <p>
         * Sets the configuration for the human in the loop workflow for analyzing documents.
         * </p>
         * 
         * @param humanLoopConfig
         *        Sets the configuration for the human in the loop workflow for analyzing documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopConfig(HumanLoopConfig humanLoopConfig);

        /**
         * <p>
         * Sets the configuration for the human in the loop workflow for analyzing documents.
         * </p>
         * This is a convenience method that creates an instance of the {@link HumanLoopConfig.Builder} avoiding the
         * need to create one manually via {@link HumanLoopConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HumanLoopConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #humanLoopConfig(HumanLoopConfig)}.
         * 
         * @param humanLoopConfig
         *        a consumer that will call methods on {@link HumanLoopConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopConfig(HumanLoopConfig)
         */
        default Builder humanLoopConfig(Consumer<HumanLoopConfig.Builder> humanLoopConfig) {
            return humanLoopConfig(HumanLoopConfig.builder().applyMutation(humanLoopConfig).build());
        }

        /**
         * <p>
         * Contains Queries and the alias for those Queries, as determined by the input.
         * </p>
         * 
         * @param queriesConfig
         *        Contains Queries and the alias for those Queries, as determined by the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queriesConfig(QueriesConfig queriesConfig);

        /**
         * <p>
         * Contains Queries and the alias for those Queries, as determined by the input.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueriesConfig.Builder} avoiding the need
         * to create one manually via {@link QueriesConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueriesConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #queriesConfig(QueriesConfig)}.
         * 
         * @param queriesConfig
         *        a consumer that will call methods on {@link QueriesConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queriesConfig(QueriesConfig)
         */
        default Builder queriesConfig(Consumer<QueriesConfig.Builder> queriesConfig) {
            return queriesConfig(QueriesConfig.builder().applyMutation(queriesConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TextractRequest.BuilderImpl implements Builder {
        private Document document;

        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();

        private HumanLoopConfig humanLoopConfig;

        private QueriesConfig queriesConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzeDocumentRequest model) {
            super(model);
            document(model.document);
            featureTypesWithStrings(model.featureTypes);
            humanLoopConfig(model.humanLoopConfig);
            queriesConfig(model.queriesConfig);
        }

        public final Document.Builder getDocument() {
            return document != null ? document.toBuilder() : null;
        }

        public final void setDocument(Document.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public final Builder document(Document document) {
            this.document = document;
            return this;
        }

        public final Collection<String> getFeatureTypes() {
            if (featureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return featureTypes;
        }

        public final void setFeatureTypes(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
        }

        @Override
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypesWithStrings(String... featureTypes) {
            featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public final Builder featureTypes(Collection<FeatureType> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypes(FeatureType... featureTypes) {
            featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        public final HumanLoopConfig.Builder getHumanLoopConfig() {
            return humanLoopConfig != null ? humanLoopConfig.toBuilder() : null;
        }

        public final void setHumanLoopConfig(HumanLoopConfig.BuilderImpl humanLoopConfig) {
            this.humanLoopConfig = humanLoopConfig != null ? humanLoopConfig.build() : null;
        }

        @Override
        public final Builder humanLoopConfig(HumanLoopConfig humanLoopConfig) {
            this.humanLoopConfig = humanLoopConfig;
            return this;
        }

        public final QueriesConfig.Builder getQueriesConfig() {
            return queriesConfig != null ? queriesConfig.toBuilder() : null;
        }

        public final void setQueriesConfig(QueriesConfig.BuilderImpl queriesConfig) {
            this.queriesConfig = queriesConfig != null ? queriesConfig.build() : null;
        }

        @Override
        public final Builder queriesConfig(QueriesConfig queriesConfig) {
            this.queriesConfig = queriesConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AnalyzeDocumentRequest build() {
            return new AnalyzeDocumentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
