/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure holding all the information returned by AnalyzeExpense
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExpenseDocument implements SdkPojo, Serializable, ToCopyableBuilder<ExpenseDocument.Builder, ExpenseDocument> {
    private static final SdkField<Integer> EXPENSE_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExpenseIndex").getter(getter(ExpenseDocument::expenseIndex)).setter(setter(Builder::expenseIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpenseIndex").build()).build();

    private static final SdkField<List<ExpenseField>> SUMMARY_FIELDS_FIELD = SdkField
            .<List<ExpenseField>> builder(MarshallingType.LIST)
            .memberName("SummaryFields")
            .getter(getter(ExpenseDocument::summaryFields))
            .setter(setter(Builder::summaryFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpenseField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpenseField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LineItemGroup>> LINE_ITEM_GROUPS_FIELD = SdkField
            .<List<LineItemGroup>> builder(MarshallingType.LIST)
            .memberName("LineItemGroups")
            .getter(getter(ExpenseDocument::lineItemGroups))
            .setter(setter(Builder::lineItemGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItemGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LineItemGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(LineItemGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPENSE_INDEX_FIELD,
            SUMMARY_FIELDS_FIELD, LINE_ITEM_GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer expenseIndex;

    private final List<ExpenseField> summaryFields;

    private final List<LineItemGroup> lineItemGroups;

    private ExpenseDocument(BuilderImpl builder) {
        this.expenseIndex = builder.expenseIndex;
        this.summaryFields = builder.summaryFields;
        this.lineItemGroups = builder.lineItemGroups;
    }

    /**
     * <p>
     * Denotes which invoice or receipt in the document the information is coming from. First document will be 1, the
     * second 2, and so on.
     * </p>
     * 
     * @return Denotes which invoice or receipt in the document the information is coming from. First document will be
     *         1, the second 2, and so on.
     */
    public final Integer expenseIndex() {
        return expenseIndex;
    }

    /**
     * For responses, this returns true if the service returned a value for the SummaryFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSummaryFields() {
        return summaryFields != null && !(summaryFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any information found outside of a table by Amazon Textract.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSummaryFields} method.
     * </p>
     * 
     * @return Any information found outside of a table by Amazon Textract.
     */
    public final List<ExpenseField> summaryFields() {
        return summaryFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the LineItemGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLineItemGroups() {
        return lineItemGroups != null && !(lineItemGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information detected on each table of a document, seperated into <code>LineItems</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLineItemGroups} method.
     * </p>
     * 
     * @return Information detected on each table of a document, seperated into <code>LineItems</code>.
     */
    public final List<LineItemGroup> lineItemGroups() {
        return lineItemGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expenseIndex());
        hashCode = 31 * hashCode + Objects.hashCode(hasSummaryFields() ? summaryFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLineItemGroups() ? lineItemGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpenseDocument)) {
            return false;
        }
        ExpenseDocument other = (ExpenseDocument) obj;
        return Objects.equals(expenseIndex(), other.expenseIndex()) && hasSummaryFields() == other.hasSummaryFields()
                && Objects.equals(summaryFields(), other.summaryFields()) && hasLineItemGroups() == other.hasLineItemGroups()
                && Objects.equals(lineItemGroups(), other.lineItemGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExpenseDocument").add("ExpenseIndex", expenseIndex())
                .add("SummaryFields", hasSummaryFields() ? summaryFields() : null)
                .add("LineItemGroups", hasLineItemGroups() ? lineItemGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExpenseIndex":
            return Optional.ofNullable(clazz.cast(expenseIndex()));
        case "SummaryFields":
            return Optional.ofNullable(clazz.cast(summaryFields()));
        case "LineItemGroups":
            return Optional.ofNullable(clazz.cast(lineItemGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExpenseDocument, T> g) {
        return obj -> g.apply((ExpenseDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExpenseDocument> {
        /**
         * <p>
         * Denotes which invoice or receipt in the document the information is coming from. First document will be 1,
         * the second 2, and so on.
         * </p>
         * 
         * @param expenseIndex
         *        Denotes which invoice or receipt in the document the information is coming from. First document will
         *        be 1, the second 2, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expenseIndex(Integer expenseIndex);

        /**
         * <p>
         * Any information found outside of a table by Amazon Textract.
         * </p>
         * 
         * @param summaryFields
         *        Any information found outside of a table by Amazon Textract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryFields(Collection<ExpenseField> summaryFields);

        /**
         * <p>
         * Any information found outside of a table by Amazon Textract.
         * </p>
         * 
         * @param summaryFields
         *        Any information found outside of a table by Amazon Textract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryFields(ExpenseField... summaryFields);

        /**
         * <p>
         * Any information found outside of a table by Amazon Textract.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.ExpenseField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.textract.model.ExpenseField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.ExpenseField.Builder#build()} is called immediately and
         * its result is passed to {@link #summaryFields(List<ExpenseField>)}.
         * 
         * @param summaryFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.ExpenseField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaryFields(java.util.Collection<ExpenseField>)
         */
        Builder summaryFields(Consumer<ExpenseField.Builder>... summaryFields);

        /**
         * <p>
         * Information detected on each table of a document, seperated into <code>LineItems</code>.
         * </p>
         * 
         * @param lineItemGroups
         *        Information detected on each table of a document, seperated into <code>LineItems</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItemGroups(Collection<LineItemGroup> lineItemGroups);

        /**
         * <p>
         * Information detected on each table of a document, seperated into <code>LineItems</code>.
         * </p>
         * 
         * @param lineItemGroups
         *        Information detected on each table of a document, seperated into <code>LineItems</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItemGroups(LineItemGroup... lineItemGroups);

        /**
         * <p>
         * Information detected on each table of a document, seperated into <code>LineItems</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.LineItemGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.textract.model.LineItemGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.LineItemGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #lineItemGroups(List<LineItemGroup>)}.
         * 
         * @param lineItemGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.LineItemGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineItemGroups(java.util.Collection<LineItemGroup>)
         */
        Builder lineItemGroups(Consumer<LineItemGroup.Builder>... lineItemGroups);
    }

    static final class BuilderImpl implements Builder {
        private Integer expenseIndex;

        private List<ExpenseField> summaryFields = DefaultSdkAutoConstructList.getInstance();

        private List<LineItemGroup> lineItemGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExpenseDocument model) {
            expenseIndex(model.expenseIndex);
            summaryFields(model.summaryFields);
            lineItemGroups(model.lineItemGroups);
        }

        public final Integer getExpenseIndex() {
            return expenseIndex;
        }

        public final void setExpenseIndex(Integer expenseIndex) {
            this.expenseIndex = expenseIndex;
        }

        @Override
        public final Builder expenseIndex(Integer expenseIndex) {
            this.expenseIndex = expenseIndex;
            return this;
        }

        public final List<ExpenseField.Builder> getSummaryFields() {
            List<ExpenseField.Builder> result = ExpenseFieldListCopier.copyToBuilder(this.summaryFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaryFields(Collection<ExpenseField.BuilderImpl> summaryFields) {
            this.summaryFields = ExpenseFieldListCopier.copyFromBuilder(summaryFields);
        }

        @Override
        public final Builder summaryFields(Collection<ExpenseField> summaryFields) {
            this.summaryFields = ExpenseFieldListCopier.copy(summaryFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryFields(ExpenseField... summaryFields) {
            summaryFields(Arrays.asList(summaryFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryFields(Consumer<ExpenseField.Builder>... summaryFields) {
            summaryFields(Stream.of(summaryFields).map(c -> ExpenseField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<LineItemGroup.Builder> getLineItemGroups() {
            List<LineItemGroup.Builder> result = LineItemGroupListCopier.copyToBuilder(this.lineItemGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineItemGroups(Collection<LineItemGroup.BuilderImpl> lineItemGroups) {
            this.lineItemGroups = LineItemGroupListCopier.copyFromBuilder(lineItemGroups);
        }

        @Override
        public final Builder lineItemGroups(Collection<LineItemGroup> lineItemGroups) {
            this.lineItemGroups = LineItemGroupListCopier.copy(lineItemGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItemGroups(LineItemGroup... lineItemGroups) {
            lineItemGroups(Arrays.asList(lineItemGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItemGroups(Consumer<LineItemGroup.Builder>... lineItemGroups) {
            lineItemGroups(Stream.of(lineItemGroups).map(c -> LineItemGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExpenseDocument build() {
            return new ExpenseDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
