/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.textract.model.AnalyzeDocumentRequest;
import software.amazon.awssdk.services.textract.model.AnalyzeDocumentResponse;
import software.amazon.awssdk.services.textract.model.AnalyzeExpenseRequest;
import software.amazon.awssdk.services.textract.model.AnalyzeExpenseResponse;
import software.amazon.awssdk.services.textract.model.AnalyzeIdRequest;
import software.amazon.awssdk.services.textract.model.AnalyzeIdResponse;
import software.amazon.awssdk.services.textract.model.CreateAdapterRequest;
import software.amazon.awssdk.services.textract.model.CreateAdapterResponse;
import software.amazon.awssdk.services.textract.model.CreateAdapterVersionRequest;
import software.amazon.awssdk.services.textract.model.CreateAdapterVersionResponse;
import software.amazon.awssdk.services.textract.model.DeleteAdapterRequest;
import software.amazon.awssdk.services.textract.model.DeleteAdapterResponse;
import software.amazon.awssdk.services.textract.model.DeleteAdapterVersionRequest;
import software.amazon.awssdk.services.textract.model.DeleteAdapterVersionResponse;
import software.amazon.awssdk.services.textract.model.DetectDocumentTextRequest;
import software.amazon.awssdk.services.textract.model.DetectDocumentTextResponse;
import software.amazon.awssdk.services.textract.model.GetAdapterRequest;
import software.amazon.awssdk.services.textract.model.GetAdapterResponse;
import software.amazon.awssdk.services.textract.model.GetAdapterVersionRequest;
import software.amazon.awssdk.services.textract.model.GetAdapterVersionResponse;
import software.amazon.awssdk.services.textract.model.GetDocumentAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetDocumentAnalysisResponse;
import software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionRequest;
import software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse;
import software.amazon.awssdk.services.textract.model.GetExpenseAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetExpenseAnalysisResponse;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisResponse;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryRequest;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryResponse;
import software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest;
import software.amazon.awssdk.services.textract.model.ListAdapterVersionsResponse;
import software.amazon.awssdk.services.textract.model.ListAdaptersRequest;
import software.amazon.awssdk.services.textract.model.ListAdaptersResponse;
import software.amazon.awssdk.services.textract.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.textract.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartDocumentAnalysisResponse;
import software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionRequest;
import software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionResponse;
import software.amazon.awssdk.services.textract.model.StartExpenseAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartExpenseAnalysisResponse;
import software.amazon.awssdk.services.textract.model.StartLendingAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartLendingAnalysisResponse;
import software.amazon.awssdk.services.textract.model.TagResourceRequest;
import software.amazon.awssdk.services.textract.model.TagResourceResponse;
import software.amazon.awssdk.services.textract.model.UntagResourceRequest;
import software.amazon.awssdk.services.textract.model.UntagResourceResponse;
import software.amazon.awssdk.services.textract.model.UpdateAdapterRequest;
import software.amazon.awssdk.services.textract.model.UpdateAdapterResponse;
import software.amazon.awssdk.services.textract.paginators.ListAdapterVersionsPublisher;
import software.amazon.awssdk.services.textract.paginators.ListAdaptersPublisher;

/**
 * Service client for accessing Amazon Textract asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Amazon Textract detects and analyzes text in documents and converts it into machine-readable text. This is the API
 * reference documentation for Amazon Textract.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface TextractAsyncClient extends AwsClient {
    String SERVICE_NAME = "textract";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "textract";

    /**
     * <p>
     * Analyzes an input document for relationships between detected items.
     * </p>
     * <p>
     * The types of information returned are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Form data (key-value pairs). The related information is returned in two <a>Block</a> objects, each of type
     * <code>KEY_VALUE_SET</code>: a KEY <code>Block</code> object and a VALUE <code>Block</code> object. For example,
     * <i>Name: Ana Silva Carolina</i> contains a key and value. <i>Name:</i> is the key. <i>Ana Silva Carolina</i> is
     * the value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Table and table cell data. A TABLE <code>Block</code> object contains information about a detected table. A CELL
     * <code>Block</code> object is returned for each cell in a table.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lines and words of text. A LINE <code>Block</code> object contains one or more WORD <code>Block</code> objects.
     * All lines and words that are detected in the document are returned (including text that doesn't have a
     * relationship with the value of <code>FeatureTypes</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * Signatures. A SIGNATURE <code>Block</code> object contains the location information of a signature in a document.
     * If used in conjunction with forms or tables, a signature can be given a Key-Value pairing or be detected in the
     * cell of a table.
     * </p>
     * </li>
     * <li>
     * <p>
     * Query. A QUERY Block object contains the query text, alias and link to the associated Query results block object.
     * </p>
     * </li>
     * <li>
     * <p>
     * Query Result. A QUERY_RESULT Block object contains the answer to the query and an ID that connects it to the
     * query asked. This Block also contains a confidence score.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Selection elements such as check boxes and option buttons (radio buttons) can be detected in form data and in
     * tables. A SELECTION_ELEMENT <code>Block</code> object contains information about a selection element, including
     * the selection status.
     * </p>
     * <p>
     * You can choose which type of analysis to perform by specifying the <code>FeatureTypes</code> list.
     * </p>
     * <p>
     * The output is returned in a list of <code>Block</code> objects.
     * </p>
     * <p>
     * <code>AnalyzeDocument</code> is a synchronous operation. To analyze documents asynchronously, use
     * <a>StartDocumentAnalysis</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html">Document Text Analysis</a>.
     * </p>
     *
     * @param analyzeDocumentRequest
     * @return A Java Future containing the result of the AnalyzeDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>HumanLoopQuotaExceededException Indicates you have exceeded the maximum number of active human in the
     *         loop workflows available</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.AnalyzeDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AnalyzeDocumentResponse> analyzeDocument(AnalyzeDocumentRequest analyzeDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Analyzes an input document for relationships between detected items.
     * </p>
     * <p>
     * The types of information returned are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Form data (key-value pairs). The related information is returned in two <a>Block</a> objects, each of type
     * <code>KEY_VALUE_SET</code>: a KEY <code>Block</code> object and a VALUE <code>Block</code> object. For example,
     * <i>Name: Ana Silva Carolina</i> contains a key and value. <i>Name:</i> is the key. <i>Ana Silva Carolina</i> is
     * the value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Table and table cell data. A TABLE <code>Block</code> object contains information about a detected table. A CELL
     * <code>Block</code> object is returned for each cell in a table.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lines and words of text. A LINE <code>Block</code> object contains one or more WORD <code>Block</code> objects.
     * All lines and words that are detected in the document are returned (including text that doesn't have a
     * relationship with the value of <code>FeatureTypes</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * Signatures. A SIGNATURE <code>Block</code> object contains the location information of a signature in a document.
     * If used in conjunction with forms or tables, a signature can be given a Key-Value pairing or be detected in the
     * cell of a table.
     * </p>
     * </li>
     * <li>
     * <p>
     * Query. A QUERY Block object contains the query text, alias and link to the associated Query results block object.
     * </p>
     * </li>
     * <li>
     * <p>
     * Query Result. A QUERY_RESULT Block object contains the answer to the query and an ID that connects it to the
     * query asked. This Block also contains a confidence score.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Selection elements such as check boxes and option buttons (radio buttons) can be detected in form data and in
     * tables. A SELECTION_ELEMENT <code>Block</code> object contains information about a selection element, including
     * the selection status.
     * </p>
     * <p>
     * You can choose which type of analysis to perform by specifying the <code>FeatureTypes</code> list.
     * </p>
     * <p>
     * The output is returned in a list of <code>Block</code> objects.
     * </p>
     * <p>
     * <code>AnalyzeDocument</code> is a synchronous operation. To analyze documents asynchronously, use
     * <a>StartDocumentAnalysis</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html">Document Text Analysis</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AnalyzeDocumentRequest.Builder} avoiding the need
     * to create one manually via {@link AnalyzeDocumentRequest#builder()}
     * </p>
     *
     * @param analyzeDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.AnalyzeDocumentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AnalyzeDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>HumanLoopQuotaExceededException Indicates you have exceeded the maximum number of active human in the
     *         loop workflows available</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.AnalyzeDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AnalyzeDocumentResponse> analyzeDocument(
            Consumer<AnalyzeDocumentRequest.Builder> analyzeDocumentRequest) {
        return analyzeDocument(AnalyzeDocumentRequest.builder().applyMutation(analyzeDocumentRequest).build());
    }

    /**
     * <p>
     * <code>AnalyzeExpense</code> synchronously analyzes an input document for financially related relationships
     * between text.
     * </p>
     * <p>
     * Information is returned as <code>ExpenseDocuments</code> and seperated as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LineItemGroups</code>- A data set containing <code>LineItems</code> which store information about the lines
     * of text, such as an item purchased and its price on a receipt.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SummaryFields</code>- Contains all other information a receipt, such as header information or the vendors
     * name.
     * </p>
     * </li>
     * </ul>
     *
     * @param analyzeExpenseRequest
     * @return A Java Future containing the result of the AnalyzeExpense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.AnalyzeExpense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeExpense" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AnalyzeExpenseResponse> analyzeExpense(AnalyzeExpenseRequest analyzeExpenseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>AnalyzeExpense</code> synchronously analyzes an input document for financially related relationships
     * between text.
     * </p>
     * <p>
     * Information is returned as <code>ExpenseDocuments</code> and seperated as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LineItemGroups</code>- A data set containing <code>LineItems</code> which store information about the lines
     * of text, such as an item purchased and its price on a receipt.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SummaryFields</code>- Contains all other information a receipt, such as header information or the vendors
     * name.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AnalyzeExpenseRequest.Builder} avoiding the need to
     * create one manually via {@link AnalyzeExpenseRequest#builder()}
     * </p>
     *
     * @param analyzeExpenseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.AnalyzeExpenseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AnalyzeExpense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.AnalyzeExpense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeExpense" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AnalyzeExpenseResponse> analyzeExpense(Consumer<AnalyzeExpenseRequest.Builder> analyzeExpenseRequest) {
        return analyzeExpense(AnalyzeExpenseRequest.builder().applyMutation(analyzeExpenseRequest).build());
    }

    /**
     * <p>
     * Analyzes identity documents for relevant information. This information is extracted and returned as
     * <code>IdentityDocumentFields</code>, which records both the normalized field and value of the extracted text.
     * Unlike other Amazon Textract operations, <code>AnalyzeID</code> doesn't return any Geometry data.
     * </p>
     *
     * @param analyzeIdRequest
     * @return A Java Future containing the result of the AnalyzeID operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.AnalyzeID
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeID" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AnalyzeIdResponse> analyzeID(AnalyzeIdRequest analyzeIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Analyzes identity documents for relevant information. This information is extracted and returned as
     * <code>IdentityDocumentFields</code>, which records both the normalized field and value of the extracted text.
     * Unlike other Amazon Textract operations, <code>AnalyzeID</code> doesn't return any Geometry data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AnalyzeIdRequest.Builder} avoiding the need to
     * create one manually via {@link AnalyzeIdRequest#builder()}
     * </p>
     *
     * @param analyzeIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.AnalyzeIdRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AnalyzeID operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.AnalyzeID
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeID" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AnalyzeIdResponse> analyzeID(Consumer<AnalyzeIdRequest.Builder> analyzeIdRequest) {
        return analyzeID(AnalyzeIdRequest.builder().applyMutation(analyzeIdRequest).build());
    }

    /**
     * <p>
     * Creates an adapter, which can be fine-tuned for enhanced performance on user provided documents. Takes an
     * AdapterName and FeatureType. Currently the only supported feature type is <code>QUERIES</code>. You can also
     * provide a Description, Tags, and a ClientRequestToken. You can choose whether or not the adapter should be
     * AutoUpdated with the AutoUpdate argument. By default, AutoUpdate is set to DISABLED.
     * </p>
     *
     * @param createAdapterRequest
     * @return A Java Future containing the result of the CreateAdapter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>LimitExceededException An Amazon Textract service limit was exceeded. For example, if you start too
     *         many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>,
     *         for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Textract service limit.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ServiceQuotaExceededException Returned when a request cannot be completed as it would exceed a
     *         maximum service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.CreateAdapter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/CreateAdapter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAdapterResponse> createAdapter(CreateAdapterRequest createAdapterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an adapter, which can be fine-tuned for enhanced performance on user provided documents. Takes an
     * AdapterName and FeatureType. Currently the only supported feature type is <code>QUERIES</code>. You can also
     * provide a Description, Tags, and a ClientRequestToken. You can choose whether or not the adapter should be
     * AutoUpdated with the AutoUpdate argument. By default, AutoUpdate is set to DISABLED.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAdapterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAdapterRequest#builder()}
     * </p>
     *
     * @param createAdapterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.CreateAdapterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAdapter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>LimitExceededException An Amazon Textract service limit was exceeded. For example, if you start too
     *         many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>,
     *         for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Textract service limit.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ServiceQuotaExceededException Returned when a request cannot be completed as it would exceed a
     *         maximum service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.CreateAdapter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/CreateAdapter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAdapterResponse> createAdapter(Consumer<CreateAdapterRequest.Builder> createAdapterRequest) {
        return createAdapter(CreateAdapterRequest.builder().applyMutation(createAdapterRequest).build());
    }

    /**
     * <p>
     * Creates a new version of an adapter. Operates on a provided AdapterId and a specified dataset provided via the
     * DatasetConfig argument. Requires that you specify an Amazon S3 bucket with the OutputConfig argument. You can
     * provide an optional KMSKeyId, an optional ClientRequestToken, and optional tags.
     * </p>
     *
     * @param createAdapterVersionRequest
     * @return A Java Future containing the result of the CreateAdapterVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>LimitExceededException An Amazon Textract service limit was exceeded. For example, if you start too
     *         many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>,
     *         for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Textract service limit.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ServiceQuotaExceededException Returned when a request cannot be completed as it would exceed a
     *         maximum service quota.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.CreateAdapterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/CreateAdapterVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAdapterVersionResponse> createAdapterVersion(
            CreateAdapterVersionRequest createAdapterVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of an adapter. Operates on a provided AdapterId and a specified dataset provided via the
     * DatasetConfig argument. Requires that you specify an Amazon S3 bucket with the OutputConfig argument. You can
     * provide an optional KMSKeyId, an optional ClientRequestToken, and optional tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAdapterVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAdapterVersionRequest#builder()}
     * </p>
     *
     * @param createAdapterVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.CreateAdapterVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAdapterVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>LimitExceededException An Amazon Textract service limit was exceeded. For example, if you start too
     *         many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>,
     *         for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Textract service limit.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ServiceQuotaExceededException Returned when a request cannot be completed as it would exceed a
     *         maximum service quota.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.CreateAdapterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/CreateAdapterVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAdapterVersionResponse> createAdapterVersion(
            Consumer<CreateAdapterVersionRequest.Builder> createAdapterVersionRequest) {
        return createAdapterVersion(CreateAdapterVersionRequest.builder().applyMutation(createAdapterVersionRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Textract adapter. Takes an AdapterId and deletes the adapter specified by the ID.
     * </p>
     *
     * @param deleteAdapterRequest
     * @return A Java Future containing the result of the DeleteAdapter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.DeleteAdapter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/DeleteAdapter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAdapterResponse> deleteAdapter(DeleteAdapterRequest deleteAdapterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Textract adapter. Takes an AdapterId and deletes the adapter specified by the ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAdapterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAdapterRequest#builder()}
     * </p>
     *
     * @param deleteAdapterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.DeleteAdapterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAdapter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.DeleteAdapter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/DeleteAdapter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAdapterResponse> deleteAdapter(Consumer<DeleteAdapterRequest.Builder> deleteAdapterRequest) {
        return deleteAdapter(DeleteAdapterRequest.builder().applyMutation(deleteAdapterRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Textract adapter version. Requires that you specify both an AdapterId and a AdapterVersion.
     * Deletes the adapter version specified by the AdapterId and the AdapterVersion.
     * </p>
     *
     * @param deleteAdapterVersionRequest
     * @return A Java Future containing the result of the DeleteAdapterVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.DeleteAdapterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/DeleteAdapterVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAdapterVersionResponse> deleteAdapterVersion(
            DeleteAdapterVersionRequest deleteAdapterVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Textract adapter version. Requires that you specify both an AdapterId and a AdapterVersion.
     * Deletes the adapter version specified by the AdapterId and the AdapterVersion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAdapterVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAdapterVersionRequest#builder()}
     * </p>
     *
     * @param deleteAdapterVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.DeleteAdapterVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAdapterVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.DeleteAdapterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/DeleteAdapterVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAdapterVersionResponse> deleteAdapterVersion(
            Consumer<DeleteAdapterVersionRequest.Builder> deleteAdapterVersionRequest) {
        return deleteAdapterVersion(DeleteAdapterVersionRequest.builder().applyMutation(deleteAdapterVersionRequest).build());
    }

    /**
     * <p>
     * Detects text in the input document. Amazon Textract can detect lines of text and the words that make up a line of
     * text. The input document must be in one of the following image formats: JPEG, PNG, PDF, or TIFF.
     * <code>DetectDocumentText</code> returns the detected text in an array of <a>Block</a> objects.
     * </p>
     * <p>
     * Each document page has as an associated <code>Block</code> of type PAGE. Each PAGE <code>Block</code> object is
     * the parent of LINE <code>Block</code> objects that represent the lines of detected text on a page. A LINE
     * <code>Block</code> object is a parent for each word that makes up the line. Words are represented by
     * <code>Block</code> objects of type WORD.
     * </p>
     * <p>
     * <code>DetectDocumentText</code> is a synchronous operation. To analyze documents asynchronously, use
     * <a>StartDocumentTextDetection</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html">Document Text Detection</a>.
     * </p>
     *
     * @param detectDocumentTextRequest
     * @return A Java Future containing the result of the DetectDocumentText operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.DetectDocumentText
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/DetectDocumentText" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetectDocumentTextResponse> detectDocumentText(DetectDocumentTextRequest detectDocumentTextRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects text in the input document. Amazon Textract can detect lines of text and the words that make up a line of
     * text. The input document must be in one of the following image formats: JPEG, PNG, PDF, or TIFF.
     * <code>DetectDocumentText</code> returns the detected text in an array of <a>Block</a> objects.
     * </p>
     * <p>
     * Each document page has as an associated <code>Block</code> of type PAGE. Each PAGE <code>Block</code> object is
     * the parent of LINE <code>Block</code> objects that represent the lines of detected text on a page. A LINE
     * <code>Block</code> object is a parent for each word that makes up the line. Words are represented by
     * <code>Block</code> objects of type WORD.
     * </p>
     * <p>
     * <code>DetectDocumentText</code> is a synchronous operation. To analyze documents asynchronously, use
     * <a>StartDocumentTextDetection</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html">Document Text Detection</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectDocumentTextRequest.Builder} avoiding the
     * need to create one manually via {@link DetectDocumentTextRequest#builder()}
     * </p>
     *
     * @param detectDocumentTextRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.DetectDocumentTextRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DetectDocumentText operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.DetectDocumentText
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/DetectDocumentText" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DetectDocumentTextResponse> detectDocumentText(
            Consumer<DetectDocumentTextRequest.Builder> detectDocumentTextRequest) {
        return detectDocumentText(DetectDocumentTextRequest.builder().applyMutation(detectDocumentTextRequest).build());
    }

    /**
     * <p>
     * Gets configuration information for an adapter specified by an AdapterId, returning information on AdapterName,
     * Description, CreationTime, AutoUpdate status, and FeatureTypes.
     * </p>
     *
     * @param getAdapterRequest
     * @return A Java Future containing the result of the GetAdapter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.GetAdapter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetAdapter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAdapterResponse> getAdapter(GetAdapterRequest getAdapterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets configuration information for an adapter specified by an AdapterId, returning information on AdapterName,
     * Description, CreationTime, AutoUpdate status, and FeatureTypes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAdapterRequest.Builder} avoiding the need to
     * create one manually via {@link GetAdapterRequest#builder()}
     * </p>
     *
     * @param getAdapterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.GetAdapterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAdapter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.GetAdapter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetAdapter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAdapterResponse> getAdapter(Consumer<GetAdapterRequest.Builder> getAdapterRequest) {
        return getAdapter(GetAdapterRequest.builder().applyMutation(getAdapterRequest).build());
    }

    /**
     * <p>
     * Gets configuration information for the specified adapter version, including: AdapterId, AdapterVersion,
     * FeatureTypes, Status, StatusMessage, DatasetConfig, KMSKeyId, OutputConfig, Tags and EvaluationMetrics.
     * </p>
     *
     * @param getAdapterVersionRequest
     * @return A Java Future containing the result of the GetAdapterVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.GetAdapterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetAdapterVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAdapterVersionResponse> getAdapterVersion(GetAdapterVersionRequest getAdapterVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets configuration information for the specified adapter version, including: AdapterId, AdapterVersion,
     * FeatureTypes, Status, StatusMessage, DatasetConfig, KMSKeyId, OutputConfig, Tags and EvaluationMetrics.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAdapterVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetAdapterVersionRequest#builder()}
     * </p>
     *
     * @param getAdapterVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.GetAdapterVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAdapterVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.GetAdapterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetAdapterVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAdapterVersionResponse> getAdapterVersion(
            Consumer<GetAdapterVersionRequest.Builder> getAdapterVersionRequest) {
        return getAdapterVersion(GetAdapterVersionRequest.builder().applyMutation(getAdapterVersionRequest).build());
    }

    /**
     * <p>
     * Gets the results for an Amazon Textract asynchronous operation that analyzes text in a document.
     * </p>
     * <p>
     * You start asynchronous text analysis by calling <a>StartDocumentAnalysis</a>, which returns a job identifier (
     * <code>JobId</code>). When the text analysis operation finishes, Amazon Textract publishes a completion status to
     * the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to
     * <code>StartDocumentAnalysis</code>. To get the results of the text-detection operation, first check that the
     * status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call
     * <code>GetDocumentAnalysis</code>, and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartDocumentAnalysis</code>.
     * </p>
     * <p>
     * <code>GetDocumentAnalysis</code> returns an array of <a>Block</a> objects. The following types of information are
     * returned:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Form data (key-value pairs). The related information is returned in two <a>Block</a> objects, each of type
     * <code>KEY_VALUE_SET</code>: a KEY <code>Block</code> object and a VALUE <code>Block</code> object. For example,
     * <i>Name: Ana Silva Carolina</i> contains a key and value. <i>Name:</i> is the key. <i>Ana Silva Carolina</i> is
     * the value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Table and table cell data. A TABLE <code>Block</code> object contains information about a detected table. A CELL
     * <code>Block</code> object is returned for each cell in a table.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lines and words of text. A LINE <code>Block</code> object contains one or more WORD <code>Block</code> objects.
     * All lines and words that are detected in the document are returned (including text that doesn't have a
     * relationship with the value of the <code>StartDocumentAnalysis</code> <code>FeatureTypes</code> input parameter).
     * </p>
     * </li>
     * <li>
     * <p>
     * Query. A QUERY Block object contains the query text, alias and link to the associated Query results block object.
     * </p>
     * </li>
     * <li>
     * <p>
     * Query Results. A QUERY_RESULT Block object contains the answer to the query and an ID that connects it to the
     * query asked. This Block also contains a confidence score.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * While processing a document with queries, look out for <code>INVALID_REQUEST_PARAMETERS</code> output. This
     * indicates that either the per page query limit has been exceeded or that the operation is trying to query a page
     * in the document which doesn’t exist.
     * </p>
     * </note>
     * <p>
     * Selection elements such as check boxes and option buttons (radio buttons) can be detected in form data and in
     * tables. A SELECTION_ELEMENT <code>Block</code> object contains information about a selection element, including
     * the selection status.
     * </p>
     * <p>
     * Use the <code>MaxResults</code> parameter to limit the number of blocks that are returned. If there are more
     * results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response
     * contains a pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetDocumentAnalysis</code>, and populate the <code>NextToken</code> request parameter with the token value
     * that's returned from the previous call to <code>GetDocumentAnalysis</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html">Document Text Analysis</a>.
     * </p>
     *
     * @param getDocumentAnalysisRequest
     * @return A Java Future containing the result of the GetDocumentAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InvalidJobIdException An invalid job identifier was passed to an asynchronous analysis operation.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.GetDocumentAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetDocumentAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDocumentAnalysisResponse> getDocumentAnalysis(
            GetDocumentAnalysisRequest getDocumentAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the results for an Amazon Textract asynchronous operation that analyzes text in a document.
     * </p>
     * <p>
     * You start asynchronous text analysis by calling <a>StartDocumentAnalysis</a>, which returns a job identifier (
     * <code>JobId</code>). When the text analysis operation finishes, Amazon Textract publishes a completion status to
     * the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to
     * <code>StartDocumentAnalysis</code>. To get the results of the text-detection operation, first check that the
     * status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call
     * <code>GetDocumentAnalysis</code>, and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartDocumentAnalysis</code>.
     * </p>
     * <p>
     * <code>GetDocumentAnalysis</code> returns an array of <a>Block</a> objects. The following types of information are
     * returned:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Form data (key-value pairs). The related information is returned in two <a>Block</a> objects, each of type
     * <code>KEY_VALUE_SET</code>: a KEY <code>Block</code> object and a VALUE <code>Block</code> object. For example,
     * <i>Name: Ana Silva Carolina</i> contains a key and value. <i>Name:</i> is the key. <i>Ana Silva Carolina</i> is
     * the value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Table and table cell data. A TABLE <code>Block</code> object contains information about a detected table. A CELL
     * <code>Block</code> object is returned for each cell in a table.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lines and words of text. A LINE <code>Block</code> object contains one or more WORD <code>Block</code> objects.
     * All lines and words that are detected in the document are returned (including text that doesn't have a
     * relationship with the value of the <code>StartDocumentAnalysis</code> <code>FeatureTypes</code> input parameter).
     * </p>
     * </li>
     * <li>
     * <p>
     * Query. A QUERY Block object contains the query text, alias and link to the associated Query results block object.
     * </p>
     * </li>
     * <li>
     * <p>
     * Query Results. A QUERY_RESULT Block object contains the answer to the query and an ID that connects it to the
     * query asked. This Block also contains a confidence score.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * While processing a document with queries, look out for <code>INVALID_REQUEST_PARAMETERS</code> output. This
     * indicates that either the per page query limit has been exceeded or that the operation is trying to query a page
     * in the document which doesn’t exist.
     * </p>
     * </note>
     * <p>
     * Selection elements such as check boxes and option buttons (radio buttons) can be detected in form data and in
     * tables. A SELECTION_ELEMENT <code>Block</code> object contains information about a selection element, including
     * the selection status.
     * </p>
     * <p>
     * Use the <code>MaxResults</code> parameter to limit the number of blocks that are returned. If there are more
     * results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response
     * contains a pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetDocumentAnalysis</code>, and populate the <code>NextToken</code> request parameter with the token value
     * that's returned from the previous call to <code>GetDocumentAnalysis</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html">Document Text Analysis</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentAnalysisRequest.Builder} avoiding the
     * need to create one manually via {@link GetDocumentAnalysisRequest#builder()}
     * </p>
     *
     * @param getDocumentAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.GetDocumentAnalysisRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDocumentAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InvalidJobIdException An invalid job identifier was passed to an asynchronous analysis operation.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.GetDocumentAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetDocumentAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDocumentAnalysisResponse> getDocumentAnalysis(
            Consumer<GetDocumentAnalysisRequest.Builder> getDocumentAnalysisRequest) {
        return getDocumentAnalysis(GetDocumentAnalysisRequest.builder().applyMutation(getDocumentAnalysisRequest).build());
    }

    /**
     * <p>
     * Gets the results for an Amazon Textract asynchronous operation that detects text in a document. Amazon Textract
     * can detect lines of text and the words that make up a line of text.
     * </p>
     * <p>
     * You start asynchronous text detection by calling <a>StartDocumentTextDetection</a>, which returns a job
     * identifier (<code>JobId</code>). When the text detection operation finishes, Amazon Textract publishes a
     * completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial
     * call to <code>StartDocumentTextDetection</code>. To get the results of the text-detection operation, first check
     * that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call
     * <code>GetDocumentTextDetection</code>, and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartDocumentTextDetection</code>.
     * </p>
     * <p>
     * <code>GetDocumentTextDetection</code> returns an array of <a>Block</a> objects.
     * </p>
     * <p>
     * Each document page has as an associated <code>Block</code> of type PAGE. Each PAGE <code>Block</code> object is
     * the parent of LINE <code>Block</code> objects that represent the lines of detected text on a page. A LINE
     * <code>Block</code> object is a parent for each word that makes up the line. Words are represented by
     * <code>Block</code> objects of type WORD.
     * </p>
     * <p>
     * Use the MaxResults parameter to limit the number of blocks that are returned. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetDocumentTextDetection</code>, and populate the <code>NextToken</code> request parameter with the token
     * value that's returned from the previous call to <code>GetDocumentTextDetection</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html">Document Text Detection</a>.
     * </p>
     *
     * @param getDocumentTextDetectionRequest
     * @return A Java Future containing the result of the GetDocumentTextDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InvalidJobIdException An invalid job identifier was passed to an asynchronous analysis operation.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.GetDocumentTextDetection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetDocumentTextDetection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDocumentTextDetectionResponse> getDocumentTextDetection(
            GetDocumentTextDetectionRequest getDocumentTextDetectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the results for an Amazon Textract asynchronous operation that detects text in a document. Amazon Textract
     * can detect lines of text and the words that make up a line of text.
     * </p>
     * <p>
     * You start asynchronous text detection by calling <a>StartDocumentTextDetection</a>, which returns a job
     * identifier (<code>JobId</code>). When the text detection operation finishes, Amazon Textract publishes a
     * completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial
     * call to <code>StartDocumentTextDetection</code>. To get the results of the text-detection operation, first check
     * that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call
     * <code>GetDocumentTextDetection</code>, and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartDocumentTextDetection</code>.
     * </p>
     * <p>
     * <code>GetDocumentTextDetection</code> returns an array of <a>Block</a> objects.
     * </p>
     * <p>
     * Each document page has as an associated <code>Block</code> of type PAGE. Each PAGE <code>Block</code> object is
     * the parent of LINE <code>Block</code> objects that represent the lines of detected text on a page. A LINE
     * <code>Block</code> object is a parent for each word that makes up the line. Words are represented by
     * <code>Block</code> objects of type WORD.
     * </p>
     * <p>
     * Use the MaxResults parameter to limit the number of blocks that are returned. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetDocumentTextDetection</code>, and populate the <code>NextToken</code> request parameter with the token
     * value that's returned from the previous call to <code>GetDocumentTextDetection</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html">Document Text Detection</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentTextDetectionRequest.Builder} avoiding
     * the need to create one manually via {@link GetDocumentTextDetectionRequest#builder()}
     * </p>
     *
     * @param getDocumentTextDetectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDocumentTextDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InvalidJobIdException An invalid job identifier was passed to an asynchronous analysis operation.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.GetDocumentTextDetection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetDocumentTextDetection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDocumentTextDetectionResponse> getDocumentTextDetection(
            Consumer<GetDocumentTextDetectionRequest.Builder> getDocumentTextDetectionRequest) {
        return getDocumentTextDetection(GetDocumentTextDetectionRequest.builder().applyMutation(getDocumentTextDetectionRequest)
                .build());
    }

    /**
     * <p>
     * Gets the results for an Amazon Textract asynchronous operation that analyzes invoices and receipts. Amazon
     * Textract finds contact information, items purchased, and vendor name, from input invoices and receipts.
     * </p>
     * <p>
     * You start asynchronous invoice/receipt analysis by calling <a>StartExpenseAnalysis</a>, which returns a job
     * identifier (<code>JobId</code>). Upon completion of the invoice/receipt analysis, Amazon Textract publishes the
     * completion status to the Amazon Simple Notification Service (Amazon SNS) topic. This topic must be registered in
     * the initial call to <code>StartExpenseAnalysis</code>. To get the results of the invoice/receipt analysis
     * operation, first ensure that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so,
     * call <code>GetExpenseAnalysis</code>, and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartExpenseAnalysis</code>.
     * </p>
     * <p>
     * Use the MaxResults parameter to limit the number of blocks that are returned. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetExpenseAnalysis</code>, and populate the <code>NextToken</code> request parameter with the token value
     * that's returned from the previous call to <code>GetExpenseAnalysis</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/invoices-receipts.html">Analyzing Invoices and Receipts</a>.
     * </p>
     *
     * @param getExpenseAnalysisRequest
     * @return A Java Future containing the result of the GetExpenseAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InvalidJobIdException An invalid job identifier was passed to an asynchronous analysis operation.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.GetExpenseAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetExpenseAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetExpenseAnalysisResponse> getExpenseAnalysis(GetExpenseAnalysisRequest getExpenseAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the results for an Amazon Textract asynchronous operation that analyzes invoices and receipts. Amazon
     * Textract finds contact information, items purchased, and vendor name, from input invoices and receipts.
     * </p>
     * <p>
     * You start asynchronous invoice/receipt analysis by calling <a>StartExpenseAnalysis</a>, which returns a job
     * identifier (<code>JobId</code>). Upon completion of the invoice/receipt analysis, Amazon Textract publishes the
     * completion status to the Amazon Simple Notification Service (Amazon SNS) topic. This topic must be registered in
     * the initial call to <code>StartExpenseAnalysis</code>. To get the results of the invoice/receipt analysis
     * operation, first ensure that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so,
     * call <code>GetExpenseAnalysis</code>, and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartExpenseAnalysis</code>.
     * </p>
     * <p>
     * Use the MaxResults parameter to limit the number of blocks that are returned. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetExpenseAnalysis</code>, and populate the <code>NextToken</code> request parameter with the token value
     * that's returned from the previous call to <code>GetExpenseAnalysis</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/invoices-receipts.html">Analyzing Invoices and Receipts</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExpenseAnalysisRequest.Builder} avoiding the
     * need to create one manually via {@link GetExpenseAnalysisRequest#builder()}
     * </p>
     *
     * @param getExpenseAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.GetExpenseAnalysisRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetExpenseAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InvalidJobIdException An invalid job identifier was passed to an asynchronous analysis operation.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.GetExpenseAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetExpenseAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetExpenseAnalysisResponse> getExpenseAnalysis(
            Consumer<GetExpenseAnalysisRequest.Builder> getExpenseAnalysisRequest) {
        return getExpenseAnalysis(GetExpenseAnalysisRequest.builder().applyMutation(getExpenseAnalysisRequest).build());
    }

    /**
     * <p>
     * Gets the results for an Amazon Textract asynchronous operation that analyzes text in a lending document.
     * </p>
     * <p>
     * You start asynchronous text analysis by calling <code>StartLendingAnalysis</code>, which returns a job identifier
     * (<code>JobId</code>). When the text analysis operation finishes, Amazon Textract publishes a completion status to
     * the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to
     * <code>StartLendingAnalysis</code>.
     * </p>
     * <p>
     * To get the results of the text analysis operation, first check that the status value published to the Amazon SNS
     * topic is SUCCEEDED. If so, call GetLendingAnalysis, and pass the job identifier (<code>JobId</code>) from the
     * initial call to <code>StartLendingAnalysis</code>.
     * </p>
     *
     * @param getLendingAnalysisRequest
     * @return A Java Future containing the result of the GetLendingAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InvalidJobIdException An invalid job identifier was passed to an asynchronous analysis operation.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.GetLendingAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetLendingAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLendingAnalysisResponse> getLendingAnalysis(GetLendingAnalysisRequest getLendingAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the results for an Amazon Textract asynchronous operation that analyzes text in a lending document.
     * </p>
     * <p>
     * You start asynchronous text analysis by calling <code>StartLendingAnalysis</code>, which returns a job identifier
     * (<code>JobId</code>). When the text analysis operation finishes, Amazon Textract publishes a completion status to
     * the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to
     * <code>StartLendingAnalysis</code>.
     * </p>
     * <p>
     * To get the results of the text analysis operation, first check that the status value published to the Amazon SNS
     * topic is SUCCEEDED. If so, call GetLendingAnalysis, and pass the job identifier (<code>JobId</code>) from the
     * initial call to <code>StartLendingAnalysis</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLendingAnalysisRequest.Builder} avoiding the
     * need to create one manually via {@link GetLendingAnalysisRequest#builder()}
     * </p>
     *
     * @param getLendingAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.GetLendingAnalysisRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLendingAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InvalidJobIdException An invalid job identifier was passed to an asynchronous analysis operation.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.GetLendingAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetLendingAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLendingAnalysisResponse> getLendingAnalysis(
            Consumer<GetLendingAnalysisRequest.Builder> getLendingAnalysisRequest) {
        return getLendingAnalysis(GetLendingAnalysisRequest.builder().applyMutation(getLendingAnalysisRequest).build());
    }

    /**
     * <p>
     * Gets summarized results for the <code>StartLendingAnalysis</code> operation, which analyzes text in a lending
     * document. The returned summary consists of information about documents grouped together by a common document
     * type. Information like detected signatures, page numbers, and split documents is returned with respect to the
     * type of grouped document.
     * </p>
     * <p>
     * You start asynchronous text analysis by calling <code>StartLendingAnalysis</code>, which returns a job identifier
     * (<code>JobId</code>). When the text analysis operation finishes, Amazon Textract publishes a completion status to
     * the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to
     * <code>StartLendingAnalysis</code>.
     * </p>
     * <p>
     * To get the results of the text analysis operation, first check that the status value published to the Amazon SNS
     * topic is SUCCEEDED. If so, call <code>GetLendingAnalysisSummary</code>, and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartLendingAnalysis</code>.
     * </p>
     *
     * @param getLendingAnalysisSummaryRequest
     * @return A Java Future containing the result of the GetLendingAnalysisSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InvalidJobIdException An invalid job identifier was passed to an asynchronous analysis operation.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.GetLendingAnalysisSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetLendingAnalysisSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLendingAnalysisSummaryResponse> getLendingAnalysisSummary(
            GetLendingAnalysisSummaryRequest getLendingAnalysisSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summarized results for the <code>StartLendingAnalysis</code> operation, which analyzes text in a lending
     * document. The returned summary consists of information about documents grouped together by a common document
     * type. Information like detected signatures, page numbers, and split documents is returned with respect to the
     * type of grouped document.
     * </p>
     * <p>
     * You start asynchronous text analysis by calling <code>StartLendingAnalysis</code>, which returns a job identifier
     * (<code>JobId</code>). When the text analysis operation finishes, Amazon Textract publishes a completion status to
     * the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to
     * <code>StartLendingAnalysis</code>.
     * </p>
     * <p>
     * To get the results of the text analysis operation, first check that the status value published to the Amazon SNS
     * topic is SUCCEEDED. If so, call <code>GetLendingAnalysisSummary</code>, and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartLendingAnalysis</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLendingAnalysisSummaryRequest.Builder} avoiding
     * the need to create one manually via {@link GetLendingAnalysisSummaryRequest#builder()}
     * </p>
     *
     * @param getLendingAnalysisSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetLendingAnalysisSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InvalidJobIdException An invalid job identifier was passed to an asynchronous analysis operation.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.GetLendingAnalysisSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetLendingAnalysisSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLendingAnalysisSummaryResponse> getLendingAnalysisSummary(
            Consumer<GetLendingAnalysisSummaryRequest.Builder> getLendingAnalysisSummaryRequest) {
        return getLendingAnalysisSummary(GetLendingAnalysisSummaryRequest.builder()
                .applyMutation(getLendingAnalysisSummaryRequest).build());
    }

    /**
     * <p>
     * List all version of an adapter that meet the specified filtration criteria.
     * </p>
     *
     * @param listAdapterVersionsRequest
     * @return A Java Future containing the result of the ListAdapterVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.ListAdapterVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/ListAdapterVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAdapterVersionsResponse> listAdapterVersions(
            ListAdapterVersionsRequest listAdapterVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all version of an adapter that meet the specified filtration criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAdapterVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAdapterVersionsRequest#builder()}
     * </p>
     *
     * @param listAdapterVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAdapterVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.ListAdapterVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/ListAdapterVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAdapterVersionsResponse> listAdapterVersions(
            Consumer<ListAdapterVersionsRequest.Builder> listAdapterVersionsRequest) {
        return listAdapterVersions(ListAdapterVersionsRequest.builder().applyMutation(listAdapterVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAdapterVersions(software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.textract.paginators.ListAdapterVersionsPublisher publisher = client.listAdapterVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.textract.paginators.ListAdapterVersionsPublisher publisher = client.listAdapterVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.textract.model.ListAdapterVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.textract.model.ListAdapterVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAdapterVersions(software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAdapterVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.ListAdapterVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/ListAdapterVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAdapterVersionsPublisher listAdapterVersionsPaginator(ListAdapterVersionsRequest listAdapterVersionsRequest) {
        return new ListAdapterVersionsPublisher(this, listAdapterVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAdapterVersions(software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.textract.paginators.ListAdapterVersionsPublisher publisher = client.listAdapterVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.textract.paginators.ListAdapterVersionsPublisher publisher = client.listAdapterVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.textract.model.ListAdapterVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.textract.model.ListAdapterVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAdapterVersions(software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAdapterVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAdapterVersionsRequest#builder()}
     * </p>
     *
     * @param listAdapterVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.ListAdapterVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/ListAdapterVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAdapterVersionsPublisher listAdapterVersionsPaginator(
            Consumer<ListAdapterVersionsRequest.Builder> listAdapterVersionsRequest) {
        return listAdapterVersionsPaginator(ListAdapterVersionsRequest.builder().applyMutation(listAdapterVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all adapters that match the specified filtration criteria.
     * </p>
     *
     * @param listAdaptersRequest
     * @return A Java Future containing the result of the ListAdapters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.ListAdapters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/ListAdapters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAdaptersResponse> listAdapters(ListAdaptersRequest listAdaptersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all adapters that match the specified filtration criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAdaptersRequest.Builder} avoiding the need to
     * create one manually via {@link ListAdaptersRequest#builder()}
     * </p>
     *
     * @param listAdaptersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.ListAdaptersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAdapters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.ListAdapters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/ListAdapters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAdaptersResponse> listAdapters(Consumer<ListAdaptersRequest.Builder> listAdaptersRequest) {
        return listAdapters(ListAdaptersRequest.builder().applyMutation(listAdaptersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAdapters(software.amazon.awssdk.services.textract.model.ListAdaptersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.textract.paginators.ListAdaptersPublisher publisher = client.listAdaptersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.textract.paginators.ListAdaptersPublisher publisher = client.listAdaptersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.textract.model.ListAdaptersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.textract.model.ListAdaptersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAdapters(software.amazon.awssdk.services.textract.model.ListAdaptersRequest)} operation.</b>
     * </p>
     *
     * @param listAdaptersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.ListAdapters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/ListAdapters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAdaptersPublisher listAdaptersPaginator(ListAdaptersRequest listAdaptersRequest) {
        return new ListAdaptersPublisher(this, listAdaptersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAdapters(software.amazon.awssdk.services.textract.model.ListAdaptersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.textract.paginators.ListAdaptersPublisher publisher = client.listAdaptersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.textract.paginators.ListAdaptersPublisher publisher = client.listAdaptersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.textract.model.ListAdaptersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.textract.model.ListAdaptersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAdapters(software.amazon.awssdk.services.textract.model.ListAdaptersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAdaptersRequest.Builder} avoiding the need to
     * create one manually via {@link ListAdaptersRequest#builder()}
     * </p>
     *
     * @param listAdaptersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.ListAdaptersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.ListAdapters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/ListAdapters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAdaptersPublisher listAdaptersPaginator(Consumer<ListAdaptersRequest.Builder> listAdaptersRequest) {
        return listAdaptersPaginator(ListAdaptersRequest.builder().applyMutation(listAdaptersRequest).build());
    }

    /**
     * <p>
     * Lists all tags for an Amazon Textract resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags for an Amazon Textract resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts the asynchronous analysis of an input document for relationships between detected items such as key-value
     * pairs, tables, and selection elements.
     * </p>
     * <p>
     * <code>StartDocumentAnalysis</code> can analyze text in documents that are in JPEG, PNG, TIFF, and PDF format. The
     * documents are stored in an Amazon S3 bucket. Use <a>DocumentLocation</a> to specify the bucket name and file name
     * of the document.
     * </p>
     * <p>
     * <code>StartDocumentAnalysis</code> returns a job identifier (<code>JobId</code>) that you use to get the results
     * of the operation. When text analysis is finished, Amazon Textract publishes a completion status to the Amazon
     * Simple Notification Service (Amazon SNS) topic that you specify in <code>NotificationChannel</code>. To get the
     * results of the text analysis operation, first check that the status value published to the Amazon SNS topic is
     * <code>SUCCEEDED</code>. If so, call <a>GetDocumentAnalysis</a>, and pass the job identifier (<code>JobId</code>)
     * from the initial call to <code>StartDocumentAnalysis</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html">Document Text Analysis</a>.
     * </p>
     *
     * @param startDocumentAnalysisRequest
     * @return A Java Future containing the result of the StartDocumentAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>LimitExceededException An Amazon Textract service limit was exceeded. For example, if you start too
     *         many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>,
     *         for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Textract service limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.StartDocumentAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartDocumentAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDocumentAnalysisResponse> startDocumentAnalysis(
            StartDocumentAnalysisRequest startDocumentAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the asynchronous analysis of an input document for relationships between detected items such as key-value
     * pairs, tables, and selection elements.
     * </p>
     * <p>
     * <code>StartDocumentAnalysis</code> can analyze text in documents that are in JPEG, PNG, TIFF, and PDF format. The
     * documents are stored in an Amazon S3 bucket. Use <a>DocumentLocation</a> to specify the bucket name and file name
     * of the document.
     * </p>
     * <p>
     * <code>StartDocumentAnalysis</code> returns a job identifier (<code>JobId</code>) that you use to get the results
     * of the operation. When text analysis is finished, Amazon Textract publishes a completion status to the Amazon
     * Simple Notification Service (Amazon SNS) topic that you specify in <code>NotificationChannel</code>. To get the
     * results of the text analysis operation, first check that the status value published to the Amazon SNS topic is
     * <code>SUCCEEDED</code>. If so, call <a>GetDocumentAnalysis</a>, and pass the job identifier (<code>JobId</code>)
     * from the initial call to <code>StartDocumentAnalysis</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html">Document Text Analysis</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDocumentAnalysisRequest.Builder} avoiding the
     * need to create one manually via {@link StartDocumentAnalysisRequest#builder()}
     * </p>
     *
     * @param startDocumentAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartDocumentAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>LimitExceededException An Amazon Textract service limit was exceeded. For example, if you start too
     *         many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>,
     *         for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Textract service limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.StartDocumentAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartDocumentAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDocumentAnalysisResponse> startDocumentAnalysis(
            Consumer<StartDocumentAnalysisRequest.Builder> startDocumentAnalysisRequest) {
        return startDocumentAnalysis(StartDocumentAnalysisRequest.builder().applyMutation(startDocumentAnalysisRequest).build());
    }

    /**
     * <p>
     * Starts the asynchronous detection of text in a document. Amazon Textract can detect lines of text and the words
     * that make up a line of text.
     * </p>
     * <p>
     * <code>StartDocumentTextDetection</code> can analyze text in documents that are in JPEG, PNG, TIFF, and PDF
     * format. The documents are stored in an Amazon S3 bucket. Use <a>DocumentLocation</a> to specify the bucket name
     * and file name of the document.
     * </p>
     * <p>
     * <code>StartTextDetection</code> returns a job identifier (<code>JobId</code>) that you use to get the results of
     * the operation. When text detection is finished, Amazon Textract publishes a completion status to the Amazon
     * Simple Notification Service (Amazon SNS) topic that you specify in <code>NotificationChannel</code>. To get the
     * results of the text detection operation, first check that the status value published to the Amazon SNS topic is
     * <code>SUCCEEDED</code>. If so, call <a>GetDocumentTextDetection</a>, and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartDocumentTextDetection</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html">Document Text Detection</a>.
     * </p>
     *
     * @param startDocumentTextDetectionRequest
     * @return A Java Future containing the result of the StartDocumentTextDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>LimitExceededException An Amazon Textract service limit was exceeded. For example, if you start too
     *         many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>,
     *         for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Textract service limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.StartDocumentTextDetection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartDocumentTextDetection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDocumentTextDetectionResponse> startDocumentTextDetection(
            StartDocumentTextDetectionRequest startDocumentTextDetectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the asynchronous detection of text in a document. Amazon Textract can detect lines of text and the words
     * that make up a line of text.
     * </p>
     * <p>
     * <code>StartDocumentTextDetection</code> can analyze text in documents that are in JPEG, PNG, TIFF, and PDF
     * format. The documents are stored in an Amazon S3 bucket. Use <a>DocumentLocation</a> to specify the bucket name
     * and file name of the document.
     * </p>
     * <p>
     * <code>StartTextDetection</code> returns a job identifier (<code>JobId</code>) that you use to get the results of
     * the operation. When text detection is finished, Amazon Textract publishes a completion status to the Amazon
     * Simple Notification Service (Amazon SNS) topic that you specify in <code>NotificationChannel</code>. To get the
     * results of the text detection operation, first check that the status value published to the Amazon SNS topic is
     * <code>SUCCEEDED</code>. If so, call <a>GetDocumentTextDetection</a>, and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartDocumentTextDetection</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html">Document Text Detection</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDocumentTextDetectionRequest.Builder} avoiding
     * the need to create one manually via {@link StartDocumentTextDetectionRequest#builder()}
     * </p>
     *
     * @param startDocumentTextDetectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartDocumentTextDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>LimitExceededException An Amazon Textract service limit was exceeded. For example, if you start too
     *         many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>,
     *         for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Textract service limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.StartDocumentTextDetection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartDocumentTextDetection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDocumentTextDetectionResponse> startDocumentTextDetection(
            Consumer<StartDocumentTextDetectionRequest.Builder> startDocumentTextDetectionRequest) {
        return startDocumentTextDetection(StartDocumentTextDetectionRequest.builder()
                .applyMutation(startDocumentTextDetectionRequest).build());
    }

    /**
     * <p>
     * Starts the asynchronous analysis of invoices or receipts for data like contact information, items purchased, and
     * vendor names.
     * </p>
     * <p>
     * <code>StartExpenseAnalysis</code> can analyze text in documents that are in JPEG, PNG, and PDF format. The
     * documents must be stored in an Amazon S3 bucket. Use the <a>DocumentLocation</a> parameter to specify the name of
     * your S3 bucket and the name of the document in that bucket.
     * </p>
     * <p>
     * <code>StartExpenseAnalysis</code> returns a job identifier (<code>JobId</code>) that you will provide to
     * <code>GetExpenseAnalysis</code> to retrieve the results of the operation. When the analysis of the input
     * invoices/receipts is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification
     * Service (Amazon SNS) topic that you provide to the <code>NotificationChannel</code>. To obtain the results of the
     * invoice and receipt analysis operation, ensure that the status value published to the Amazon SNS topic is
     * <code>SUCCEEDED</code>. If so, call <a>GetExpenseAnalysis</a>, and pass the job identifier (<code>JobId</code>)
     * that was returned by your call to <code>StartExpenseAnalysis</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/invoice-receipts.html">Analyzing Invoices and Receipts</a>.
     * </p>
     *
     * @param startExpenseAnalysisRequest
     * @return A Java Future containing the result of the StartExpenseAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>LimitExceededException An Amazon Textract service limit was exceeded. For example, if you start too
     *         many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>,
     *         for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Textract service limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.StartExpenseAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartExpenseAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartExpenseAnalysisResponse> startExpenseAnalysis(
            StartExpenseAnalysisRequest startExpenseAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the asynchronous analysis of invoices or receipts for data like contact information, items purchased, and
     * vendor names.
     * </p>
     * <p>
     * <code>StartExpenseAnalysis</code> can analyze text in documents that are in JPEG, PNG, and PDF format. The
     * documents must be stored in an Amazon S3 bucket. Use the <a>DocumentLocation</a> parameter to specify the name of
     * your S3 bucket and the name of the document in that bucket.
     * </p>
     * <p>
     * <code>StartExpenseAnalysis</code> returns a job identifier (<code>JobId</code>) that you will provide to
     * <code>GetExpenseAnalysis</code> to retrieve the results of the operation. When the analysis of the input
     * invoices/receipts is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification
     * Service (Amazon SNS) topic that you provide to the <code>NotificationChannel</code>. To obtain the results of the
     * invoice and receipt analysis operation, ensure that the status value published to the Amazon SNS topic is
     * <code>SUCCEEDED</code>. If so, call <a>GetExpenseAnalysis</a>, and pass the job identifier (<code>JobId</code>)
     * that was returned by your call to <code>StartExpenseAnalysis</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/invoice-receipts.html">Analyzing Invoices and Receipts</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartExpenseAnalysisRequest.Builder} avoiding the
     * need to create one manually via {@link StartExpenseAnalysisRequest#builder()}
     * </p>
     *
     * @param startExpenseAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.StartExpenseAnalysisRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartExpenseAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>LimitExceededException An Amazon Textract service limit was exceeded. For example, if you start too
     *         many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>,
     *         for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Textract service limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.StartExpenseAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartExpenseAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartExpenseAnalysisResponse> startExpenseAnalysis(
            Consumer<StartExpenseAnalysisRequest.Builder> startExpenseAnalysisRequest) {
        return startExpenseAnalysis(StartExpenseAnalysisRequest.builder().applyMutation(startExpenseAnalysisRequest).build());
    }

    /**
     * <p>
     * Starts the classification and analysis of an input document. <code>StartLendingAnalysis</code> initiates the
     * classification and analysis of a packet of lending documents. <code>StartLendingAnalysis</code> operates on a
     * document file located in an Amazon S3 bucket.
     * </p>
     * <p>
     * <code>StartLendingAnalysis</code> can analyze text in documents that are in one of the following formats: JPEG,
     * PNG, TIFF, PDF. Use <code>DocumentLocation</code> to specify the bucket name and the file name of the document.
     * </p>
     * <p>
     * <code>StartLendingAnalysis</code> returns a job identifier (<code>JobId</code>) that you use to get the results
     * of the operation. When the text analysis is finished, Amazon Textract publishes a completion status to the Amazon
     * Simple Notification Service (Amazon SNS) topic that you specify in <code>NotificationChannel</code>. To get the
     * results of the text analysis operation, first check that the status value published to the Amazon SNS topic is
     * SUCCEEDED. If the status is SUCCEEDED you can call either <code>GetLendingAnalysis</code> or
     * <code>GetLendingAnalysisSummary</code> and provide the <code>JobId</code> to obtain the results of the analysis.
     * </p>
     * <p>
     * If using <code>OutputConfig</code> to specify an Amazon S3 bucket, the output will be contained within the
     * specified prefix in a directory labeled with the job-id. In the directory there are 3 sub-directories:
     * </p>
     * <ul>
     * <li>
     * <p>
     * detailedResponse (contains the GetLendingAnalysis response)
     * </p>
     * </li>
     * <li>
     * <p>
     * summaryResponse (for the GetLendingAnalysisSummary response)
     * </p>
     * </li>
     * <li>
     * <p>
     * splitDocuments (documents split across logical boundaries)
     * </p>
     * </li>
     * </ul>
     *
     * @param startLendingAnalysisRequest
     * @return A Java Future containing the result of the StartLendingAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>LimitExceededException An Amazon Textract service limit was exceeded. For example, if you start too
     *         many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>,
     *         for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Textract service limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.StartLendingAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartLendingAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartLendingAnalysisResponse> startLendingAnalysis(
            StartLendingAnalysisRequest startLendingAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the classification and analysis of an input document. <code>StartLendingAnalysis</code> initiates the
     * classification and analysis of a packet of lending documents. <code>StartLendingAnalysis</code> operates on a
     * document file located in an Amazon S3 bucket.
     * </p>
     * <p>
     * <code>StartLendingAnalysis</code> can analyze text in documents that are in one of the following formats: JPEG,
     * PNG, TIFF, PDF. Use <code>DocumentLocation</code> to specify the bucket name and the file name of the document.
     * </p>
     * <p>
     * <code>StartLendingAnalysis</code> returns a job identifier (<code>JobId</code>) that you use to get the results
     * of the operation. When the text analysis is finished, Amazon Textract publishes a completion status to the Amazon
     * Simple Notification Service (Amazon SNS) topic that you specify in <code>NotificationChannel</code>. To get the
     * results of the text analysis operation, first check that the status value published to the Amazon SNS topic is
     * SUCCEEDED. If the status is SUCCEEDED you can call either <code>GetLendingAnalysis</code> or
     * <code>GetLendingAnalysisSummary</code> and provide the <code>JobId</code> to obtain the results of the analysis.
     * </p>
     * <p>
     * If using <code>OutputConfig</code> to specify an Amazon S3 bucket, the output will be contained within the
     * specified prefix in a directory labeled with the job-id. In the directory there are 3 sub-directories:
     * </p>
     * <ul>
     * <li>
     * <p>
     * detailedResponse (contains the GetLendingAnalysis response)
     * </p>
     * </li>
     * <li>
     * <p>
     * summaryResponse (for the GetLendingAnalysisSummary response)
     * </p>
     * </li>
     * <li>
     * <p>
     * splitDocuments (documents split across logical boundaries)
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartLendingAnalysisRequest.Builder} avoiding the
     * need to create one manually via {@link StartLendingAnalysisRequest#builder()}
     * </p>
     *
     * @param startLendingAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.StartLendingAnalysisRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartLendingAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Textract is unable to access the S3 object that's specified in the
     *         request. for more information, <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon
     *         S3</a> For troubleshooting information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
     *         </li>
     *         <li>InvalidKmsKeyException Indicates you do not have decrypt permissions with the KMS key entered, or the
     *         KMS key was entered incorrectly.</li>
     *         <li>UnsupportedDocumentException The format of the input document isn't supported. Documents for
     *         operations can be in PNG, JPEG, PDF, or TIFF format.</li>
     *         <li>DocumentTooLargeException The document can't be processed because it's too large. The maximum
     *         document size for synchronous operations 10 MB. The maximum document size for asynchronous operations is
     *         500 MB for PDF files.</li>
     *         <li>BadDocumentException Amazon Textract isn't able to read the document. For more information on the
     *         document limits in Amazon Textract, see <a>limits</a>.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>LimitExceededException An Amazon Textract service limit was exceeded. For example, if you start too
     *         many asynchronous jobs concurrently, calls to start operations (<code>StartDocumentTextDetection</code>,
     *         for example) raise a LimitExceededException exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Textract service limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.StartLendingAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartLendingAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartLendingAnalysisResponse> startLendingAnalysis(
            Consumer<StartLendingAnalysisRequest.Builder> startLendingAnalysisRequest) {
        return startLendingAnalysis(StartLendingAnalysisRequest.builder().applyMutation(startLendingAnalysisRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>ServiceQuotaExceededException Returned when a request cannot be completed as it would exceed a
     *         maximum service quota.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>ServiceQuotaExceededException Returned when a request cannot be completed as it would exceed a
     *         maximum service quota.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes any tags with the specified keys from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes any tags with the specified keys from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update the configuration for an adapter. FeatureTypes configurations cannot be updated. At least one new
     * parameter must be specified as an argument.
     * </p>
     *
     * @param updateAdapterRequest
     * @return A Java Future containing the result of the UpdateAdapter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.UpdateAdapter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/UpdateAdapter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAdapterResponse> updateAdapter(UpdateAdapterRequest updateAdapterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the configuration for an adapter. FeatureTypes configurations cannot be updated. At least one new
     * parameter must be specified as an argument.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAdapterRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAdapterRequest#builder()}
     * </p>
     *
     * @param updateAdapterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.textract.model.UpdateAdapterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateAdapter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An input parameter violated a constraint. For example, in synchronous
     *         operations, an <code>InvalidParameterException</code> exception occurs when neither of the
     *         <code>S3Object</code> or <code>Bytes</code> values are supplied in the <code>Document</code> request
     *         parameter. Validate your parameter before calling the API operation again.</li>
     *         <li>AccessDeniedException You aren't authorized to perform the action. Use the Amazon Resource Name (ARN)
     *         of an authorized user or IAM role to perform the operation.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Textract.</li>
     *         <li>InternalServerErrorException Amazon Textract experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Textract is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ValidationException Indicates that a request was not valid. Check request for proper formatting.</li>
     *         <li>ResourceNotFoundException Returned when an operation tried to access a nonexistent resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TextractException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TextractAsyncClient.UpdateAdapter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/UpdateAdapter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAdapterResponse> updateAdapter(Consumer<UpdateAdapterRequest.Builder> updateAdapterRequest) {
        return updateAdapter(UpdateAdapterRequest.builder().applyMutation(updateAdapterRequest).build());
    }

    @Override
    default TextractServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link TextractAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TextractAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TextractAsyncClient}.
     */
    static TextractAsyncClientBuilder builder() {
        return new DefaultTextractAsyncClientBuilder();
    }
}
