/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAdapterVersionsResponse extends TextractResponse implements
        ToCopyableBuilder<ListAdapterVersionsResponse.Builder, ListAdapterVersionsResponse> {
    private static final SdkField<List<AdapterVersionOverview>> ADAPTER_VERSIONS_FIELD = SdkField
            .<List<AdapterVersionOverview>> builder(MarshallingType.LIST)
            .memberName("AdapterVersions")
            .getter(getter(ListAdapterVersionsResponse::adapterVersions))
            .setter(setter(Builder::adapterVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdapterVersionOverview> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdapterVersionOverview::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAdapterVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AdapterVersionOverview> adapterVersions;

    private final String nextToken;

    private ListAdapterVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.adapterVersions = builder.adapterVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdapterVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdapterVersions() {
        return adapterVersions != null && !(adapterVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Adapter versions that match the filtering criteria specified when calling ListAdapters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdapterVersions} method.
     * </p>
     * 
     * @return Adapter versions that match the filtering criteria specified when calling ListAdapters.
     */
    public final List<AdapterVersionOverview> adapterVersions() {
        return adapterVersions;
    }

    /**
     * <p>
     * Identifies the next page of results to return when listing adapter versions.
     * </p>
     * 
     * @return Identifies the next page of results to return when listing adapter versions.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAdapterVersions() ? adapterVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAdapterVersionsResponse)) {
            return false;
        }
        ListAdapterVersionsResponse other = (ListAdapterVersionsResponse) obj;
        return hasAdapterVersions() == other.hasAdapterVersions() && Objects.equals(adapterVersions(), other.adapterVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAdapterVersionsResponse")
                .add("AdapterVersions", hasAdapterVersions() ? adapterVersions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdapterVersions":
            return Optional.ofNullable(clazz.cast(adapterVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAdapterVersionsResponse, T> g) {
        return obj -> g.apply((ListAdapterVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TextractResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAdapterVersionsResponse> {
        /**
         * <p>
         * Adapter versions that match the filtering criteria specified when calling ListAdapters.
         * </p>
         * 
         * @param adapterVersions
         *        Adapter versions that match the filtering criteria specified when calling ListAdapters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adapterVersions(Collection<AdapterVersionOverview> adapterVersions);

        /**
         * <p>
         * Adapter versions that match the filtering criteria specified when calling ListAdapters.
         * </p>
         * 
         * @param adapterVersions
         *        Adapter versions that match the filtering criteria specified when calling ListAdapters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adapterVersions(AdapterVersionOverview... adapterVersions);

        /**
         * <p>
         * Adapter versions that match the filtering criteria specified when calling ListAdapters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.AdapterVersionOverview.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.textract.model.AdapterVersionOverview#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.AdapterVersionOverview.Builder#build()} is called
         * immediately and its result is passed to {@link #adapterVersions(List<AdapterVersionOverview>)}.
         * 
         * @param adapterVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.AdapterVersionOverview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adapterVersions(java.util.Collection<AdapterVersionOverview>)
         */
        Builder adapterVersions(Consumer<AdapterVersionOverview.Builder>... adapterVersions);

        /**
         * <p>
         * Identifies the next page of results to return when listing adapter versions.
         * </p>
         * 
         * @param nextToken
         *        Identifies the next page of results to return when listing adapter versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends TextractResponse.BuilderImpl implements Builder {
        private List<AdapterVersionOverview> adapterVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAdapterVersionsResponse model) {
            super(model);
            adapterVersions(model.adapterVersions);
            nextToken(model.nextToken);
        }

        public final List<AdapterVersionOverview.Builder> getAdapterVersions() {
            List<AdapterVersionOverview.Builder> result = AdapterVersionListCopier.copyToBuilder(this.adapterVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdapterVersions(Collection<AdapterVersionOverview.BuilderImpl> adapterVersions) {
            this.adapterVersions = AdapterVersionListCopier.copyFromBuilder(adapterVersions);
        }

        @Override
        public final Builder adapterVersions(Collection<AdapterVersionOverview> adapterVersions) {
            this.adapterVersions = AdapterVersionListCopier.copy(adapterVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adapterVersions(AdapterVersionOverview... adapterVersions) {
            adapterVersions(Arrays.asList(adapterVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adapterVersions(Consumer<AdapterVersionOverview.Builder>... adapterVersions) {
            adapterVersions(Stream.of(adapterVersions).map(c -> AdapterVersionOverview.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAdapterVersionsResponse build() {
            return new ListAdapterVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
