/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about documents grouped by the same document type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentGroup implements SdkPojo, Serializable, ToCopyableBuilder<DocumentGroup.Builder, DocumentGroup> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DocumentGroup::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<SplitDocument>> SPLIT_DOCUMENTS_FIELD = SdkField
            .<List<SplitDocument>> builder(MarshallingType.LIST)
            .memberName("SplitDocuments")
            .getter(getter(DocumentGroup::splitDocuments))
            .setter(setter(Builder::splitDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitDocuments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SplitDocument> builder(MarshallingType.SDK_POJO)
                                            .constructor(SplitDocument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DetectedSignature>> DETECTED_SIGNATURES_FIELD = SdkField
            .<List<DetectedSignature>> builder(MarshallingType.LIST)
            .memberName("DetectedSignatures")
            .getter(getter(DocumentGroup::detectedSignatures))
            .setter(setter(Builder::detectedSignatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectedSignatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetectedSignature> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetectedSignature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UndetectedSignature>> UNDETECTED_SIGNATURES_FIELD = SdkField
            .<List<UndetectedSignature>> builder(MarshallingType.LIST)
            .memberName("UndetectedSignatures")
            .getter(getter(DocumentGroup::undetectedSignatures))
            .setter(setter(Builder::undetectedSignatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UndetectedSignatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UndetectedSignature> builder(MarshallingType.SDK_POJO)
                                            .constructor(UndetectedSignature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            SPLIT_DOCUMENTS_FIELD, DETECTED_SIGNATURES_FIELD, UNDETECTED_SIGNATURES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final List<SplitDocument> splitDocuments;

    private final List<DetectedSignature> detectedSignatures;

    private final List<UndetectedSignature> undetectedSignatures;

    private DocumentGroup(BuilderImpl builder) {
        this.type = builder.type;
        this.splitDocuments = builder.splitDocuments;
        this.detectedSignatures = builder.detectedSignatures;
        this.undetectedSignatures = builder.undetectedSignatures;
    }

    /**
     * <p>
     * The type of document that Amazon Textract has detected. See <a
     * href="https://docs.aws.amazon.com/textract/latest/dg/lending-response-objects.html">Analyze Lending Response
     * Objects</a> for a list of all types returned by Textract.
     * </p>
     * 
     * @return The type of document that Amazon Textract has detected. See <a
     *         href="https://docs.aws.amazon.com/textract/latest/dg/lending-response-objects.html">Analyze Lending
     *         Response Objects</a> for a list of all types returned by Textract.
     */
    public final String type() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the SplitDocuments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSplitDocuments() {
        return splitDocuments != null && !(splitDocuments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains information about the pages of a document, defined by logical boundary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSplitDocuments} method.
     * </p>
     * 
     * @return An array that contains information about the pages of a document, defined by logical boundary.
     */
    public final List<SplitDocument> splitDocuments() {
        return splitDocuments;
    }

    /**
     * For responses, this returns true if the service returned a value for the DetectedSignatures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDetectedSignatures() {
        return detectedSignatures != null && !(detectedSignatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the detected signatures found in a document group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetectedSignatures} method.
     * </p>
     * 
     * @return A list of the detected signatures found in a document group.
     */
    public final List<DetectedSignature> detectedSignatures() {
        return detectedSignatures;
    }

    /**
     * For responses, this returns true if the service returned a value for the UndetectedSignatures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUndetectedSignatures() {
        return undetectedSignatures != null && !(undetectedSignatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of any expected signatures not found in a document group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUndetectedSignatures} method.
     * </p>
     * 
     * @return A list of any expected signatures not found in a document group.
     */
    public final List<UndetectedSignature> undetectedSignatures() {
        return undetectedSignatures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(hasSplitDocuments() ? splitDocuments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDetectedSignatures() ? detectedSignatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUndetectedSignatures() ? undetectedSignatures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentGroup)) {
            return false;
        }
        DocumentGroup other = (DocumentGroup) obj;
        return Objects.equals(type(), other.type()) && hasSplitDocuments() == other.hasSplitDocuments()
                && Objects.equals(splitDocuments(), other.splitDocuments())
                && hasDetectedSignatures() == other.hasDetectedSignatures()
                && Objects.equals(detectedSignatures(), other.detectedSignatures())
                && hasUndetectedSignatures() == other.hasUndetectedSignatures()
                && Objects.equals(undetectedSignatures(), other.undetectedSignatures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentGroup").add("Type", type())
                .add("SplitDocuments", hasSplitDocuments() ? splitDocuments() : null)
                .add("DetectedSignatures", hasDetectedSignatures() ? detectedSignatures() : null)
                .add("UndetectedSignatures", hasUndetectedSignatures() ? undetectedSignatures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "SplitDocuments":
            return Optional.ofNullable(clazz.cast(splitDocuments()));
        case "DetectedSignatures":
            return Optional.ofNullable(clazz.cast(detectedSignatures()));
        case "UndetectedSignatures":
            return Optional.ofNullable(clazz.cast(undetectedSignatures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentGroup, T> g) {
        return obj -> g.apply((DocumentGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentGroup> {
        /**
         * <p>
         * The type of document that Amazon Textract has detected. See <a
         * href="https://docs.aws.amazon.com/textract/latest/dg/lending-response-objects.html">Analyze Lending Response
         * Objects</a> for a list of all types returned by Textract.
         * </p>
         * 
         * @param type
         *        The type of document that Amazon Textract has detected. See <a
         *        href="https://docs.aws.amazon.com/textract/latest/dg/lending-response-objects.html">Analyze Lending
         *        Response Objects</a> for a list of all types returned by Textract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * An array that contains information about the pages of a document, defined by logical boundary.
         * </p>
         * 
         * @param splitDocuments
         *        An array that contains information about the pages of a document, defined by logical boundary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splitDocuments(Collection<SplitDocument> splitDocuments);

        /**
         * <p>
         * An array that contains information about the pages of a document, defined by logical boundary.
         * </p>
         * 
         * @param splitDocuments
         *        An array that contains information about the pages of a document, defined by logical boundary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splitDocuments(SplitDocument... splitDocuments);

        /**
         * <p>
         * An array that contains information about the pages of a document, defined by logical boundary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.SplitDocument.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.textract.model.SplitDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.SplitDocument.Builder#build()} is called immediately
         * and its result is passed to {@link #splitDocuments(List<SplitDocument>)}.
         * 
         * @param splitDocuments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.SplitDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #splitDocuments(java.util.Collection<SplitDocument>)
         */
        Builder splitDocuments(Consumer<SplitDocument.Builder>... splitDocuments);

        /**
         * <p>
         * A list of the detected signatures found in a document group.
         * </p>
         * 
         * @param detectedSignatures
         *        A list of the detected signatures found in a document group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectedSignatures(Collection<DetectedSignature> detectedSignatures);

        /**
         * <p>
         * A list of the detected signatures found in a document group.
         * </p>
         * 
         * @param detectedSignatures
         *        A list of the detected signatures found in a document group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectedSignatures(DetectedSignature... detectedSignatures);

        /**
         * <p>
         * A list of the detected signatures found in a document group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.DetectedSignature.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.textract.model.DetectedSignature#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.DetectedSignature.Builder#build()} is called
         * immediately and its result is passed to {@link #detectedSignatures(List<DetectedSignature>)}.
         * 
         * @param detectedSignatures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.DetectedSignature.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectedSignatures(java.util.Collection<DetectedSignature>)
         */
        Builder detectedSignatures(Consumer<DetectedSignature.Builder>... detectedSignatures);

        /**
         * <p>
         * A list of any expected signatures not found in a document group.
         * </p>
         * 
         * @param undetectedSignatures
         *        A list of any expected signatures not found in a document group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder undetectedSignatures(Collection<UndetectedSignature> undetectedSignatures);

        /**
         * <p>
         * A list of any expected signatures not found in a document group.
         * </p>
         * 
         * @param undetectedSignatures
         *        A list of any expected signatures not found in a document group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder undetectedSignatures(UndetectedSignature... undetectedSignatures);

        /**
         * <p>
         * A list of any expected signatures not found in a document group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.UndetectedSignature.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.textract.model.UndetectedSignature#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.UndetectedSignature.Builder#build()} is called
         * immediately and its result is passed to {@link #undetectedSignatures(List<UndetectedSignature>)}.
         * 
         * @param undetectedSignatures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.UndetectedSignature.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #undetectedSignatures(java.util.Collection<UndetectedSignature>)
         */
        Builder undetectedSignatures(Consumer<UndetectedSignature.Builder>... undetectedSignatures);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private List<SplitDocument> splitDocuments = DefaultSdkAutoConstructList.getInstance();

        private List<DetectedSignature> detectedSignatures = DefaultSdkAutoConstructList.getInstance();

        private List<UndetectedSignature> undetectedSignatures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentGroup model) {
            type(model.type);
            splitDocuments(model.splitDocuments);
            detectedSignatures(model.detectedSignatures);
            undetectedSignatures(model.undetectedSignatures);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final List<SplitDocument.Builder> getSplitDocuments() {
            List<SplitDocument.Builder> result = SplitDocumentListCopier.copyToBuilder(this.splitDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSplitDocuments(Collection<SplitDocument.BuilderImpl> splitDocuments) {
            this.splitDocuments = SplitDocumentListCopier.copyFromBuilder(splitDocuments);
        }

        @Override
        public final Builder splitDocuments(Collection<SplitDocument> splitDocuments) {
            this.splitDocuments = SplitDocumentListCopier.copy(splitDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder splitDocuments(SplitDocument... splitDocuments) {
            splitDocuments(Arrays.asList(splitDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder splitDocuments(Consumer<SplitDocument.Builder>... splitDocuments) {
            splitDocuments(Stream.of(splitDocuments).map(c -> SplitDocument.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DetectedSignature.Builder> getDetectedSignatures() {
            List<DetectedSignature.Builder> result = DetectedSignatureListCopier.copyToBuilder(this.detectedSignatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetectedSignatures(Collection<DetectedSignature.BuilderImpl> detectedSignatures) {
            this.detectedSignatures = DetectedSignatureListCopier.copyFromBuilder(detectedSignatures);
        }

        @Override
        public final Builder detectedSignatures(Collection<DetectedSignature> detectedSignatures) {
            this.detectedSignatures = DetectedSignatureListCopier.copy(detectedSignatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectedSignatures(DetectedSignature... detectedSignatures) {
            detectedSignatures(Arrays.asList(detectedSignatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectedSignatures(Consumer<DetectedSignature.Builder>... detectedSignatures) {
            detectedSignatures(Stream.of(detectedSignatures).map(c -> DetectedSignature.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UndetectedSignature.Builder> getUndetectedSignatures() {
            List<UndetectedSignature.Builder> result = UndetectedSignatureListCopier.copyToBuilder(this.undetectedSignatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUndetectedSignatures(Collection<UndetectedSignature.BuilderImpl> undetectedSignatures) {
            this.undetectedSignatures = UndetectedSignatureListCopier.copyFromBuilder(undetectedSignatures);
        }

        @Override
        public final Builder undetectedSignatures(Collection<UndetectedSignature> undetectedSignatures) {
            this.undetectedSignatures = UndetectedSignatureListCopier.copy(undetectedSignatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder undetectedSignatures(UndetectedSignature... undetectedSignatures) {
            undetectedSignatures(Arrays.asList(undetectedSignatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder undetectedSignatures(Consumer<UndetectedSignature.Builder>... undetectedSignatures) {
            undetectedSignatures(Stream.of(undetectedSignatures).map(c -> UndetectedSignature.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DocumentGroup build() {
            return new DocumentGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
