/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The dataset configuration options for a given version of an adapter. Can include an Amazon S3 bucket if specified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdapterVersionDatasetConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AdapterVersionDatasetConfig.Builder, AdapterVersionDatasetConfig> {
    private static final SdkField<S3Object> MANIFEST_S3_OBJECT_FIELD = SdkField.<S3Object> builder(MarshallingType.SDK_POJO)
            .memberName("ManifestS3Object").getter(getter(AdapterVersionDatasetConfig::manifestS3Object))
            .setter(setter(Builder::manifestS3Object)).constructor(S3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestS3Object").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_S3_OBJECT_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Object manifestS3Object;

    private AdapterVersionDatasetConfig(BuilderImpl builder) {
        this.manifestS3Object = builder.manifestS3Object;
    }

    /**
     * Returns the value of the ManifestS3Object property for this object.
     * 
     * @return The value of the ManifestS3Object property for this object.
     */
    public final S3Object manifestS3Object() {
        return manifestS3Object;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestS3Object());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdapterVersionDatasetConfig)) {
            return false;
        }
        AdapterVersionDatasetConfig other = (AdapterVersionDatasetConfig) obj;
        return Objects.equals(manifestS3Object(), other.manifestS3Object());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdapterVersionDatasetConfig").add("ManifestS3Object", manifestS3Object()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestS3Object":
            return Optional.ofNullable(clazz.cast(manifestS3Object()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdapterVersionDatasetConfig, T> g) {
        return obj -> g.apply((AdapterVersionDatasetConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdapterVersionDatasetConfig> {
        /**
         * Sets the value of the ManifestS3Object property for this object.
         *
         * @param manifestS3Object
         *        The new value for the ManifestS3Object property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestS3Object(S3Object manifestS3Object);

        /**
         * Sets the value of the ManifestS3Object property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3Object.Builder} avoiding the need to
         * create one manually via {@link S3Object#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Object.Builder#build()} is called immediately and its result is
         * passed to {@link #manifestS3Object(S3Object)}.
         * 
         * @param manifestS3Object
         *        a consumer that will call methods on {@link S3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifestS3Object(S3Object)
         */
        default Builder manifestS3Object(Consumer<S3Object.Builder> manifestS3Object) {
            return manifestS3Object(S3Object.builder().applyMutation(manifestS3Object).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Object manifestS3Object;

        private BuilderImpl() {
        }

        private BuilderImpl(AdapterVersionDatasetConfig model) {
            manifestS3Object(model.manifestS3Object);
        }

        public final S3Object.Builder getManifestS3Object() {
            return manifestS3Object != null ? manifestS3Object.toBuilder() : null;
        }

        public final void setManifestS3Object(S3Object.BuilderImpl manifestS3Object) {
            this.manifestS3Object = manifestS3Object != null ? manifestS3Object.build() : null;
        }

        @Override
        public final Builder manifestS3Object(S3Object manifestS3Object) {
            this.manifestS3Object = manifestS3Object;
            return this;
        }

        @Override
        public AdapterVersionDatasetConfig build() {
            return new AdapterVersionDatasetConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
