/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAdapterRequest extends TextractRequest implements
        ToCopyableBuilder<CreateAdapterRequest.Builder, CreateAdapterRequest> {
    private static final SdkField<String> ADAPTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdapterName").getter(getter(CreateAdapterRequest::adapterName)).setter(setter(Builder::adapterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterName").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateAdapterRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateAdapterRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FeatureTypes")
            .getter(getter(CreateAdapterRequest::featureTypesAsStrings))
            .setter(setter(Builder::featureTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUTO_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoUpdate").getter(getter(CreateAdapterRequest::autoUpdateAsString))
            .setter(setter(Builder::autoUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpdate").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateAdapterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_NAME_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, DESCRIPTION_FIELD, FEATURE_TYPES_FIELD, AUTO_UPDATE_FIELD, TAGS_FIELD));

    private final String adapterName;

    private final String clientRequestToken;

    private final String description;

    private final List<String> featureTypes;

    private final String autoUpdate;

    private final Map<String, String> tags;

    private CreateAdapterRequest(BuilderImpl builder) {
        super(builder);
        this.adapterName = builder.adapterName;
        this.clientRequestToken = builder.clientRequestToken;
        this.description = builder.description;
        this.featureTypes = builder.featureTypes;
        this.autoUpdate = builder.autoUpdate;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name to be assigned to the adapter being created.
     * </p>
     * 
     * @return The name to be assigned to the adapter being created.
     */
    public final String adapterName() {
        return adapterName;
    }

    /**
     * <p>
     * Idempotent token is used to recognize the request. If the same token is used with multiple CreateAdapter
     * requests, the same session is returned. This token is employed to avoid unintentionally creating the same session
     * multiple times.
     * </p>
     * 
     * @return Idempotent token is used to recognize the request. If the same token is used with multiple CreateAdapter
     *         requests, the same session is returned. This token is employed to avoid unintentionally creating the same
     *         session multiple times.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The description to be assigned to the adapter being created.
     * </p>
     * 
     * @return The description to be assigned to the adapter being created.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of feature that the adapter is being trained on. Currrenly, supported feature types are:
     * <code>QUERIES</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatureTypes} method.
     * </p>
     * 
     * @return The type of feature that the adapter is being trained on. Currrenly, supported feature types are:
     *         <code>QUERIES</code>
     */
    public final List<FeatureType> featureTypes() {
        return FeatureTypesCopier.copyStringToEnum(featureTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the FeatureTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFeatureTypes() {
        return featureTypes != null && !(featureTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of feature that the adapter is being trained on. Currrenly, supported feature types are:
     * <code>QUERIES</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatureTypes} method.
     * </p>
     * 
     * @return The type of feature that the adapter is being trained on. Currrenly, supported feature types are:
     *         <code>QUERIES</code>
     */
    public final List<String> featureTypesAsStrings() {
        return featureTypes;
    }

    /**
     * <p>
     * Controls whether or not the adapter should automatically update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoUpdate} will
     * return {@link AutoUpdate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoUpdateAsString}.
     * </p>
     * 
     * @return Controls whether or not the adapter should automatically update.
     * @see AutoUpdate
     */
    public final AutoUpdate autoUpdate() {
        return AutoUpdate.fromValue(autoUpdate);
    }

    /**
     * <p>
     * Controls whether or not the adapter should automatically update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoUpdate} will
     * return {@link AutoUpdate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoUpdateAsString}.
     * </p>
     * 
     * @return Controls whether or not the adapter should automatically update.
     * @see AutoUpdate
     */
    public final String autoUpdateAsString() {
        return autoUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags to be added to the adapter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to be added to the adapter.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adapterName());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatureTypes() ? featureTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoUpdateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAdapterRequest)) {
            return false;
        }
        CreateAdapterRequest other = (CreateAdapterRequest) obj;
        return Objects.equals(adapterName(), other.adapterName())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(description(), other.description()) && hasFeatureTypes() == other.hasFeatureTypes()
                && Objects.equals(featureTypesAsStrings(), other.featureTypesAsStrings())
                && Objects.equals(autoUpdateAsString(), other.autoUpdateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAdapterRequest").add("AdapterName", adapterName())
                .add("ClientRequestToken", clientRequestToken()).add("Description", description())
                .add("FeatureTypes", hasFeatureTypes() ? featureTypesAsStrings() : null).add("AutoUpdate", autoUpdateAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdapterName":
            return Optional.ofNullable(clazz.cast(adapterName()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "FeatureTypes":
            return Optional.ofNullable(clazz.cast(featureTypesAsStrings()));
        case "AutoUpdate":
            return Optional.ofNullable(clazz.cast(autoUpdateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAdapterRequest, T> g) {
        return obj -> g.apply((CreateAdapterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TextractRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAdapterRequest> {
        /**
         * <p>
         * The name to be assigned to the adapter being created.
         * </p>
         * 
         * @param adapterName
         *        The name to be assigned to the adapter being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adapterName(String adapterName);

        /**
         * <p>
         * Idempotent token is used to recognize the request. If the same token is used with multiple CreateAdapter
         * requests, the same session is returned. This token is employed to avoid unintentionally creating the same
         * session multiple times.
         * </p>
         * 
         * @param clientRequestToken
         *        Idempotent token is used to recognize the request. If the same token is used with multiple
         *        CreateAdapter requests, the same session is returned. This token is employed to avoid unintentionally
         *        creating the same session multiple times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The description to be assigned to the adapter being created.
         * </p>
         * 
         * @param description
         *        The description to be assigned to the adapter being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of feature that the adapter is being trained on. Currrenly, supported feature types are:
         * <code>QUERIES</code>
         * </p>
         * 
         * @param featureTypes
         *        The type of feature that the adapter is being trained on. Currrenly, supported feature types are:
         *        <code>QUERIES</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypesWithStrings(Collection<String> featureTypes);

        /**
         * <p>
         * The type of feature that the adapter is being trained on. Currrenly, supported feature types are:
         * <code>QUERIES</code>
         * </p>
         * 
         * @param featureTypes
         *        The type of feature that the adapter is being trained on. Currrenly, supported feature types are:
         *        <code>QUERIES</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypesWithStrings(String... featureTypes);

        /**
         * <p>
         * The type of feature that the adapter is being trained on. Currrenly, supported feature types are:
         * <code>QUERIES</code>
         * </p>
         * 
         * @param featureTypes
         *        The type of feature that the adapter is being trained on. Currrenly, supported feature types are:
         *        <code>QUERIES</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypes(Collection<FeatureType> featureTypes);

        /**
         * <p>
         * The type of feature that the adapter is being trained on. Currrenly, supported feature types are:
         * <code>QUERIES</code>
         * </p>
         * 
         * @param featureTypes
         *        The type of feature that the adapter is being trained on. Currrenly, supported feature types are:
         *        <code>QUERIES</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypes(FeatureType... featureTypes);

        /**
         * <p>
         * Controls whether or not the adapter should automatically update.
         * </p>
         * 
         * @param autoUpdate
         *        Controls whether or not the adapter should automatically update.
         * @see AutoUpdate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoUpdate
         */
        Builder autoUpdate(String autoUpdate);

        /**
         * <p>
         * Controls whether or not the adapter should automatically update.
         * </p>
         * 
         * @param autoUpdate
         *        Controls whether or not the adapter should automatically update.
         * @see AutoUpdate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoUpdate
         */
        Builder autoUpdate(AutoUpdate autoUpdate);

        /**
         * <p>
         * A list of tags to be added to the adapter.
         * </p>
         * 
         * @param tags
         *        A list of tags to be added to the adapter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TextractRequest.BuilderImpl implements Builder {
        private String adapterName;

        private String clientRequestToken;

        private String description;

        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();

        private String autoUpdate;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAdapterRequest model) {
            super(model);
            adapterName(model.adapterName);
            clientRequestToken(model.clientRequestToken);
            description(model.description);
            featureTypesWithStrings(model.featureTypes);
            autoUpdate(model.autoUpdate);
            tags(model.tags);
        }

        public final String getAdapterName() {
            return adapterName;
        }

        public final void setAdapterName(String adapterName) {
            this.adapterName = adapterName;
        }

        @Override
        public final Builder adapterName(String adapterName) {
            this.adapterName = adapterName;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getFeatureTypes() {
            if (featureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return featureTypes;
        }

        public final void setFeatureTypes(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
        }

        @Override
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypesWithStrings(String... featureTypes) {
            featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public final Builder featureTypes(Collection<FeatureType> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypes(FeatureType... featureTypes) {
            featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        public final String getAutoUpdate() {
            return autoUpdate;
        }

        public final void setAutoUpdate(String autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(String autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        @Override
        public final Builder autoUpdate(AutoUpdate autoUpdate) {
            this.autoUpdate(autoUpdate == null ? null : autoUpdate.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAdapterRequest build() {
            return new CreateAdapterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
