/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about adapters used when analyzing a document, with each adapter specified using an AdapterId
 * and version
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdaptersConfig implements SdkPojo, Serializable, ToCopyableBuilder<AdaptersConfig.Builder, AdaptersConfig> {
    private static final SdkField<List<Adapter>> ADAPTERS_FIELD = SdkField
            .<List<Adapter>> builder(MarshallingType.LIST)
            .memberName("Adapters")
            .getter(getter(AdaptersConfig::adapters))
            .setter(setter(Builder::adapters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Adapters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Adapter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Adapter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Adapter> adapters;

    private AdaptersConfig(BuilderImpl builder) {
        this.adapters = builder.adapters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Adapters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAdapters() {
        return adapters != null && !(adapters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of adapters to be used when analyzing the specified document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdapters} method.
     * </p>
     * 
     * @return A list of adapters to be used when analyzing the specified document.
     */
    public final List<Adapter> adapters() {
        return adapters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdapters() ? adapters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdaptersConfig)) {
            return false;
        }
        AdaptersConfig other = (AdaptersConfig) obj;
        return hasAdapters() == other.hasAdapters() && Objects.equals(adapters(), other.adapters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdaptersConfig").add("Adapters", hasAdapters() ? adapters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Adapters":
            return Optional.ofNullable(clazz.cast(adapters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Adapters", ADAPTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdaptersConfig, T> g) {
        return obj -> g.apply((AdaptersConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdaptersConfig> {
        /**
         * <p>
         * A list of adapters to be used when analyzing the specified document.
         * </p>
         * 
         * @param adapters
         *        A list of adapters to be used when analyzing the specified document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adapters(Collection<Adapter> adapters);

        /**
         * <p>
         * A list of adapters to be used when analyzing the specified document.
         * </p>
         * 
         * @param adapters
         *        A list of adapters to be used when analyzing the specified document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adapters(Adapter... adapters);

        /**
         * <p>
         * A list of adapters to be used when analyzing the specified document.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.Adapter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.textract.model.Adapter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.Adapter.Builder#build()} is called immediately and its
         * result is passed to {@link #adapters(List<Adapter>)}.
         * 
         * @param adapters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.Adapter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adapters(java.util.Collection<Adapter>)
         */
        Builder adapters(Consumer<Adapter.Builder>... adapters);
    }

    static final class BuilderImpl implements Builder {
        private List<Adapter> adapters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdaptersConfig model) {
            adapters(model.adapters);
        }

        public final List<Adapter.Builder> getAdapters() {
            List<Adapter.Builder> result = AdaptersCopier.copyToBuilder(this.adapters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdapters(Collection<Adapter.BuilderImpl> adapters) {
            this.adapters = AdaptersCopier.copyFromBuilder(adapters);
        }

        @Override
        public final Builder adapters(Collection<Adapter> adapters) {
            this.adapters = AdaptersCopier.copy(adapters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adapters(Adapter... adapters) {
            adapters(Arrays.asList(adapters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adapters(Consumer<Adapter.Builder>... adapters) {
            adapters(Stream.of(adapters).map(c -> Adapter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AdaptersConfig build() {
            return new AdaptersConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
