/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAdapterVersionResponse extends TextractResponse implements
        ToCopyableBuilder<CreateAdapterVersionResponse.Builder, CreateAdapterVersionResponse> {
    private static final SdkField<String> ADAPTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdapterId").getter(getter(CreateAdapterVersionResponse::adapterId)).setter(setter(Builder::adapterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterId").build()).build();

    private static final SdkField<String> ADAPTER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdapterVersion").getter(getter(CreateAdapterVersionResponse::adapterVersion))
            .setter(setter(Builder::adapterVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_ID_FIELD,
            ADAPTER_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String adapterId;

    private final String adapterVersion;

    private CreateAdapterVersionResponse(BuilderImpl builder) {
        super(builder);
        this.adapterId = builder.adapterId;
        this.adapterVersion = builder.adapterVersion;
    }

    /**
     * <p>
     * A string containing the unique ID for the adapter that has received a new version.
     * </p>
     * 
     * @return A string containing the unique ID for the adapter that has received a new version.
     */
    public final String adapterId() {
        return adapterId;
    }

    /**
     * <p>
     * A string describing the new version of the adapter.
     * </p>
     * 
     * @return A string describing the new version of the adapter.
     */
    public final String adapterVersion() {
        return adapterVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adapterId());
        hashCode = 31 * hashCode + Objects.hashCode(adapterVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAdapterVersionResponse)) {
            return false;
        }
        CreateAdapterVersionResponse other = (CreateAdapterVersionResponse) obj;
        return Objects.equals(adapterId(), other.adapterId()) && Objects.equals(adapterVersion(), other.adapterVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAdapterVersionResponse").add("AdapterId", adapterId())
                .add("AdapterVersion", adapterVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdapterId":
            return Optional.ofNullable(clazz.cast(adapterId()));
        case "AdapterVersion":
            return Optional.ofNullable(clazz.cast(adapterVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdapterId", ADAPTER_ID_FIELD);
        map.put("AdapterVersion", ADAPTER_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAdapterVersionResponse, T> g) {
        return obj -> g.apply((CreateAdapterVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TextractResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAdapterVersionResponse> {
        /**
         * <p>
         * A string containing the unique ID for the adapter that has received a new version.
         * </p>
         * 
         * @param adapterId
         *        A string containing the unique ID for the adapter that has received a new version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adapterId(String adapterId);

        /**
         * <p>
         * A string describing the new version of the adapter.
         * </p>
         * 
         * @param adapterVersion
         *        A string describing the new version of the adapter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adapterVersion(String adapterVersion);
    }

    static final class BuilderImpl extends TextractResponse.BuilderImpl implements Builder {
        private String adapterId;

        private String adapterVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAdapterVersionResponse model) {
            super(model);
            adapterId(model.adapterId);
            adapterVersion(model.adapterVersion);
        }

        public final String getAdapterId() {
            return adapterId;
        }

        public final void setAdapterId(String adapterId) {
            this.adapterId = adapterId;
        }

        @Override
        public final Builder adapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public final String getAdapterVersion() {
            return adapterVersion;
        }

        public final void setAdapterVersion(String adapterVersion) {
            this.adapterVersion = adapterVersion;
        }

        @Override
        public final Builder adapterVersion(String adapterVersion) {
            this.adapterVersion = adapterVersion;
            return this;
        }

        @Override
        public CreateAdapterVersionResponse build() {
            return new CreateAdapterVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
