/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectDocumentTextResponse extends TextractResponse implements
        ToCopyableBuilder<DetectDocumentTextResponse.Builder, DetectDocumentTextResponse> {
    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField
            .<DocumentMetadata> builder(MarshallingType.SDK_POJO).memberName("DocumentMetadata")
            .getter(getter(DetectDocumentTextResponse::documentMetadata)).setter(setter(Builder::documentMetadata))
            .constructor(DocumentMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()).build();

    private static final SdkField<List<Block>> BLOCKS_FIELD = SdkField
            .<List<Block>> builder(MarshallingType.LIST)
            .memberName("Blocks")
            .getter(getter(DetectDocumentTextResponse::blocks))
            .setter(setter(Builder::blocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Block> builder(MarshallingType.SDK_POJO)
                                            .constructor(Block::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DETECT_DOCUMENT_TEXT_MODEL_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DetectDocumentTextModelVersion")
            .getter(getter(DetectDocumentTextResponse::detectDocumentTextModelVersion))
            .setter(setter(Builder::detectDocumentTextModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectDocumentTextModelVersion")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_METADATA_FIELD,
            BLOCKS_FIELD, DETECT_DOCUMENT_TEXT_MODEL_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DocumentMetadata documentMetadata;

    private final List<Block> blocks;

    private final String detectDocumentTextModelVersion;

    private DetectDocumentTextResponse(BuilderImpl builder) {
        super(builder);
        this.documentMetadata = builder.documentMetadata;
        this.blocks = builder.blocks;
        this.detectDocumentTextModelVersion = builder.detectDocumentTextModelVersion;
    }

    /**
     * <p>
     * Metadata about the document. It contains the number of pages that are detected in the document.
     * </p>
     * 
     * @return Metadata about the document. It contains the number of pages that are detected in the document.
     */
    public final DocumentMetadata documentMetadata() {
        return documentMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the Blocks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBlocks() {
        return blocks != null && !(blocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Block</code> objects that contain the text that's detected in the document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlocks} method.
     * </p>
     * 
     * @return An array of <code>Block</code> objects that contain the text that's detected in the document.
     */
    public final List<Block> blocks() {
        return blocks;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String detectDocumentTextModelVersion() {
        return detectDocumentTextModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlocks() ? blocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(detectDocumentTextModelVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectDocumentTextResponse)) {
            return false;
        }
        DetectDocumentTextResponse other = (DetectDocumentTextResponse) obj;
        return Objects.equals(documentMetadata(), other.documentMetadata()) && hasBlocks() == other.hasBlocks()
                && Objects.equals(blocks(), other.blocks())
                && Objects.equals(detectDocumentTextModelVersion(), other.detectDocumentTextModelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectDocumentTextResponse").add("DocumentMetadata", documentMetadata())
                .add("Blocks", hasBlocks() ? blocks() : null)
                .add("DetectDocumentTextModelVersion", detectDocumentTextModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentMetadata":
            return Optional.ofNullable(clazz.cast(documentMetadata()));
        case "Blocks":
            return Optional.ofNullable(clazz.cast(blocks()));
        case "DetectDocumentTextModelVersion":
            return Optional.ofNullable(clazz.cast(detectDocumentTextModelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DocumentMetadata", DOCUMENT_METADATA_FIELD);
        map.put("Blocks", BLOCKS_FIELD);
        map.put("DetectDocumentTextModelVersion", DETECT_DOCUMENT_TEXT_MODEL_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectDocumentTextResponse, T> g) {
        return obj -> g.apply((DetectDocumentTextResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TextractResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetectDocumentTextResponse> {
        /**
         * <p>
         * Metadata about the document. It contains the number of pages that are detected in the document.
         * </p>
         * 
         * @param documentMetadata
         *        Metadata about the document. It contains the number of pages that are detected in the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentMetadata(DocumentMetadata documentMetadata);

        /**
         * <p>
         * Metadata about the document. It contains the number of pages that are detected in the document.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentMetadata.Builder} avoiding the
         * need to create one manually via {@link DocumentMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #documentMetadata(DocumentMetadata)}.
         * 
         * @param documentMetadata
         *        a consumer that will call methods on {@link DocumentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentMetadata(DocumentMetadata)
         */
        default Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return documentMetadata(DocumentMetadata.builder().applyMutation(documentMetadata).build());
        }

        /**
         * <p>
         * An array of <code>Block</code> objects that contain the text that's detected in the document.
         * </p>
         * 
         * @param blocks
         *        An array of <code>Block</code> objects that contain the text that's detected in the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocks(Collection<Block> blocks);

        /**
         * <p>
         * An array of <code>Block</code> objects that contain the text that's detected in the document.
         * </p>
         * 
         * @param blocks
         *        An array of <code>Block</code> objects that contain the text that's detected in the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocks(Block... blocks);

        /**
         * <p>
         * An array of <code>Block</code> objects that contain the text that's detected in the document.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.Block.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.textract.model.Block#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.Block.Builder#build()} is called immediately and its
         * result is passed to {@link #blocks(List<Block>)}.
         * 
         * @param blocks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.Block.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blocks(java.util.Collection<Block>)
         */
        Builder blocks(Consumer<Block.Builder>... blocks);

        /**
         * <p/>
         * 
         * @param detectDocumentTextModelVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectDocumentTextModelVersion(String detectDocumentTextModelVersion);
    }

    static final class BuilderImpl extends TextractResponse.BuilderImpl implements Builder {
        private DocumentMetadata documentMetadata;

        private List<Block> blocks = DefaultSdkAutoConstructList.getInstance();

        private String detectDocumentTextModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectDocumentTextResponse model) {
            super(model);
            documentMetadata(model.documentMetadata);
            blocks(model.blocks);
            detectDocumentTextModelVersion(model.detectDocumentTextModelVersion);
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return documentMetadata != null ? documentMetadata.toBuilder() : null;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final List<Block.Builder> getBlocks() {
            List<Block.Builder> result = BlockListCopier.copyToBuilder(this.blocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlocks(Collection<Block.BuilderImpl> blocks) {
            this.blocks = BlockListCopier.copyFromBuilder(blocks);
        }

        @Override
        public final Builder blocks(Collection<Block> blocks) {
            this.blocks = BlockListCopier.copy(blocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Block... blocks) {
            blocks(Arrays.asList(blocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Consumer<Block.Builder>... blocks) {
            blocks(Stream.of(blocks).map(c -> Block.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDetectDocumentTextModelVersion() {
            return detectDocumentTextModelVersion;
        }

        public final void setDetectDocumentTextModelVersion(String detectDocumentTextModelVersion) {
            this.detectDocumentTextModelVersion = detectDocumentTextModelVersion;
        }

        @Override
        public final Builder detectDocumentTextModelVersion(String detectDocumentTextModelVersion) {
            this.detectDocumentTextModelVersion = detectDocumentTextModelVersion;
            return this;
        }

        @Override
        public DetectDocumentTextResponse build() {
            return new DetectDocumentTextResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
