/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The evaluation metrics (F1 score, Precision, and Recall) for an adapter version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationMetric.Builder, EvaluationMetric> {
    private static final SdkField<Float> F1_SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("F1Score")
            .getter(getter(EvaluationMetric::f1Score)).setter(setter(Builder::f1Score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("F1Score").build()).build();

    private static final SdkField<Float> PRECISION_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Precision").getter(getter(EvaluationMetric::precision)).setter(setter(Builder::precision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Precision").build()).build();

    private static final SdkField<Float> RECALL_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Recall")
            .getter(getter(EvaluationMetric::recall)).setter(setter(Builder::recall))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recall").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(F1_SCORE_FIELD,
            PRECISION_FIELD, RECALL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Float f1Score;

    private final Float precision;

    private final Float recall;

    private EvaluationMetric(BuilderImpl builder) {
        this.f1Score = builder.f1Score;
        this.precision = builder.precision;
        this.recall = builder.recall;
    }

    /**
     * <p>
     * The F1 score for an adapter version.
     * </p>
     * 
     * @return The F1 score for an adapter version.
     */
    public final Float f1Score() {
        return f1Score;
    }

    /**
     * <p>
     * The Precision score for an adapter version.
     * </p>
     * 
     * @return The Precision score for an adapter version.
     */
    public final Float precision() {
        return precision;
    }

    /**
     * <p>
     * The Recall score for an adapter version.
     * </p>
     * 
     * @return The Recall score for an adapter version.
     */
    public final Float recall() {
        return recall;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(f1Score());
        hashCode = 31 * hashCode + Objects.hashCode(precision());
        hashCode = 31 * hashCode + Objects.hashCode(recall());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationMetric)) {
            return false;
        }
        EvaluationMetric other = (EvaluationMetric) obj;
        return Objects.equals(f1Score(), other.f1Score()) && Objects.equals(precision(), other.precision())
                && Objects.equals(recall(), other.recall());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationMetric").add("F1Score", f1Score()).add("Precision", precision())
                .add("Recall", recall()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "F1Score":
            return Optional.ofNullable(clazz.cast(f1Score()));
        case "Precision":
            return Optional.ofNullable(clazz.cast(precision()));
        case "Recall":
            return Optional.ofNullable(clazz.cast(recall()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("F1Score", F1_SCORE_FIELD);
        map.put("Precision", PRECISION_FIELD);
        map.put("Recall", RECALL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationMetric, T> g) {
        return obj -> g.apply((EvaluationMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationMetric> {
        /**
         * <p>
         * The F1 score for an adapter version.
         * </p>
         * 
         * @param f1Score
         *        The F1 score for an adapter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder f1Score(Float f1Score);

        /**
         * <p>
         * The Precision score for an adapter version.
         * </p>
         * 
         * @param precision
         *        The Precision score for an adapter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precision(Float precision);

        /**
         * <p>
         * The Recall score for an adapter version.
         * </p>
         * 
         * @param recall
         *        The Recall score for an adapter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recall(Float recall);
    }

    static final class BuilderImpl implements Builder {
        private Float f1Score;

        private Float precision;

        private Float recall;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationMetric model) {
            f1Score(model.f1Score);
            precision(model.precision);
            recall(model.recall);
        }

        public final Float getF1Score() {
            return f1Score;
        }

        public final void setF1Score(Float f1Score) {
            this.f1Score = f1Score;
        }

        @Override
        public final Builder f1Score(Float f1Score) {
            this.f1Score = f1Score;
            return this;
        }

        public final Float getPrecision() {
            return precision;
        }

        public final void setPrecision(Float precision) {
            this.precision = precision;
        }

        @Override
        public final Builder precision(Float precision) {
            this.precision = precision;
            return this;
        }

        public final Float getRecall() {
            return recall;
        }

        public final void setRecall(Float recall) {
            this.recall = recall;
        }

        @Override
        public final Builder recall(Float recall) {
            this.recall = recall;
            return this;
        }

        @Override
        public EvaluationMetric build() {
            return new EvaluationMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
