/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that holds information about the different lines found in a document's tables.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineItemFields implements SdkPojo, Serializable, ToCopyableBuilder<LineItemFields.Builder, LineItemFields> {
    private static final SdkField<List<ExpenseField>> LINE_ITEM_EXPENSE_FIELDS_FIELD = SdkField
            .<List<ExpenseField>> builder(MarshallingType.LIST)
            .memberName("LineItemExpenseFields")
            .getter(getter(LineItemFields::lineItemExpenseFields))
            .setter(setter(Builder::lineItemExpenseFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItemExpenseFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpenseField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpenseField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LINE_ITEM_EXPENSE_FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ExpenseField> lineItemExpenseFields;

    private LineItemFields(BuilderImpl builder) {
        this.lineItemExpenseFields = builder.lineItemExpenseFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the LineItemExpenseFields property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLineItemExpenseFields() {
        return lineItemExpenseFields != null && !(lineItemExpenseFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * ExpenseFields used to show information from detected lines on a table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLineItemExpenseFields} method.
     * </p>
     * 
     * @return ExpenseFields used to show information from detected lines on a table.
     */
    public final List<ExpenseField> lineItemExpenseFields() {
        return lineItemExpenseFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLineItemExpenseFields() ? lineItemExpenseFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItemFields)) {
            return false;
        }
        LineItemFields other = (LineItemFields) obj;
        return hasLineItemExpenseFields() == other.hasLineItemExpenseFields()
                && Objects.equals(lineItemExpenseFields(), other.lineItemExpenseFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineItemFields")
                .add("LineItemExpenseFields", hasLineItemExpenseFields() ? lineItemExpenseFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LineItemExpenseFields":
            return Optional.ofNullable(clazz.cast(lineItemExpenseFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LineItemExpenseFields", LINE_ITEM_EXPENSE_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineItemFields, T> g) {
        return obj -> g.apply((LineItemFields) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineItemFields> {
        /**
         * <p>
         * ExpenseFields used to show information from detected lines on a table.
         * </p>
         * 
         * @param lineItemExpenseFields
         *        ExpenseFields used to show information from detected lines on a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItemExpenseFields(Collection<ExpenseField> lineItemExpenseFields);

        /**
         * <p>
         * ExpenseFields used to show information from detected lines on a table.
         * </p>
         * 
         * @param lineItemExpenseFields
         *        ExpenseFields used to show information from detected lines on a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItemExpenseFields(ExpenseField... lineItemExpenseFields);

        /**
         * <p>
         * ExpenseFields used to show information from detected lines on a table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.ExpenseField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.textract.model.ExpenseField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.ExpenseField.Builder#build()} is called immediately and
         * its result is passed to {@link #lineItemExpenseFields(List<ExpenseField>)}.
         * 
         * @param lineItemExpenseFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.ExpenseField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineItemExpenseFields(java.util.Collection<ExpenseField>)
         */
        Builder lineItemExpenseFields(Consumer<ExpenseField.Builder>... lineItemExpenseFields);
    }

    static final class BuilderImpl implements Builder {
        private List<ExpenseField> lineItemExpenseFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LineItemFields model) {
            lineItemExpenseFields(model.lineItemExpenseFields);
        }

        public final List<ExpenseField.Builder> getLineItemExpenseFields() {
            List<ExpenseField.Builder> result = ExpenseFieldListCopier.copyToBuilder(this.lineItemExpenseFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineItemExpenseFields(Collection<ExpenseField.BuilderImpl> lineItemExpenseFields) {
            this.lineItemExpenseFields = ExpenseFieldListCopier.copyFromBuilder(lineItemExpenseFields);
        }

        @Override
        public final Builder lineItemExpenseFields(Collection<ExpenseField> lineItemExpenseFields) {
            this.lineItemExpenseFields = ExpenseFieldListCopier.copy(lineItemExpenseFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItemExpenseFields(ExpenseField... lineItemExpenseFields) {
            lineItemExpenseFields(Arrays.asList(lineItemExpenseFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItemExpenseFields(Consumer<ExpenseField.Builder>... lineItemExpenseFields) {
            lineItemExpenseFields(Stream.of(lineItemExpenseFields).map(c -> ExpenseField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public LineItemFields build() {
            return new LineItemFields(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
