/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDbInstanceRequest extends TimestreamInfluxDbRequest implements
        ToCopyableBuilder<UpdateDbInstanceRequest.Builder, UpdateDbInstanceRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateDbInstanceRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<LogDeliveryConfiguration> LOG_DELIVERY_CONFIGURATION_FIELD = SdkField
            .<LogDeliveryConfiguration> builder(MarshallingType.SDK_POJO).memberName("logDeliveryConfiguration")
            .getter(getter(UpdateDbInstanceRequest::logDeliveryConfiguration)).setter(setter(Builder::logDeliveryConfiguration))
            .constructor(LogDeliveryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDeliveryConfiguration").build())
            .build();

    private static final SdkField<String> DB_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("dbParameterGroupIdentifier")
            .getter(getter(UpdateDbInstanceRequest::dbParameterGroupIdentifier))
            .setter(setter(Builder::dbParameterGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbParameterGroupIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            LOG_DELIVERY_CONFIGURATION_FIELD, DB_PARAMETER_GROUP_IDENTIFIER_FIELD));

    private final String identifier;

    private final LogDeliveryConfiguration logDeliveryConfiguration;

    private final String dbParameterGroupIdentifier;

    private UpdateDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.logDeliveryConfiguration = builder.logDeliveryConfiguration;
        this.dbParameterGroupIdentifier = builder.dbParameterGroupIdentifier;
    }

    /**
     * <p>
     * The id of the DB instance.
     * </p>
     * 
     * @return The id of the DB instance.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
     * </p>
     * 
     * @return Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
     */
    public final LogDeliveryConfiguration logDeliveryConfiguration() {
        return logDeliveryConfiguration;
    }

    /**
     * <p>
     * The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the database is
     * configured. For example, DB parameter groups can specify the limit for query concurrency.
     * </p>
     * 
     * @return The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the
     *         database is configured. For example, DB parameter groups can specify the limit for query concurrency.
     */
    public final String dbParameterGroupIdentifier() {
        return dbParameterGroupIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(logDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDbInstanceRequest)) {
            return false;
        }
        UpdateDbInstanceRequest other = (UpdateDbInstanceRequest) obj;
        return Objects.equals(identifier(), other.identifier())
                && Objects.equals(logDeliveryConfiguration(), other.logDeliveryConfiguration())
                && Objects.equals(dbParameterGroupIdentifier(), other.dbParameterGroupIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDbInstanceRequest").add("Identifier", identifier())
                .add("LogDeliveryConfiguration", logDeliveryConfiguration())
                .add("DbParameterGroupIdentifier", dbParameterGroupIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "logDeliveryConfiguration":
            return Optional.ofNullable(clazz.cast(logDeliveryConfiguration()));
        case "dbParameterGroupIdentifier":
            return Optional.ofNullable(clazz.cast(dbParameterGroupIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDbInstanceRequest, T> g) {
        return obj -> g.apply((UpdateDbInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamInfluxDbRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDbInstanceRequest> {
        /**
         * <p>
         * The id of the DB instance.
         * </p>
         * 
         * @param identifier
         *        The id of the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
         * </p>
         * 
         * @param logDeliveryConfiguration
         *        Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration);

        /**
         * <p>
         * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogDeliveryConfiguration.Builder}
         * avoiding the need to create one manually via {@link LogDeliveryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogDeliveryConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #logDeliveryConfiguration(LogDeliveryConfiguration)}.
         * 
         * @param logDeliveryConfiguration
         *        a consumer that will call methods on {@link LogDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryConfiguration(LogDeliveryConfiguration)
         */
        default Builder logDeliveryConfiguration(Consumer<LogDeliveryConfiguration.Builder> logDeliveryConfiguration) {
            return logDeliveryConfiguration(LogDeliveryConfiguration.builder().applyMutation(logDeliveryConfiguration).build());
        }

        /**
         * <p>
         * The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the database
         * is configured. For example, DB parameter groups can specify the limit for query concurrency.
         * </p>
         * 
         * @param dbParameterGroupIdentifier
         *        The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the
         *        database is configured. For example, DB parameter groups can specify the limit for query concurrency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TimestreamInfluxDbRequest.BuilderImpl implements Builder {
        private String identifier;

        private LogDeliveryConfiguration logDeliveryConfiguration;

        private String dbParameterGroupIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDbInstanceRequest model) {
            super(model);
            identifier(model.identifier);
            logDeliveryConfiguration(model.logDeliveryConfiguration);
            dbParameterGroupIdentifier(model.dbParameterGroupIdentifier);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final LogDeliveryConfiguration.Builder getLogDeliveryConfiguration() {
            return logDeliveryConfiguration != null ? logDeliveryConfiguration.toBuilder() : null;
        }

        public final void setLogDeliveryConfiguration(LogDeliveryConfiguration.BuilderImpl logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration != null ? logDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration;
            return this;
        }

        public final String getDbParameterGroupIdentifier() {
            return dbParameterGroupIdentifier;
        }

        public final void setDbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
        }

        @Override
        public final Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDbInstanceRequest build() {
            return new UpdateDbInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
