/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDbInstanceResponse extends TimestreamInfluxDbResponse implements
        ToCopyableBuilder<GetDbInstanceResponse.Builder, GetDbInstanceResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetDbInstanceResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetDbInstanceResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetDbInstanceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetDbInstanceResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(GetDbInstanceResponse::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<String> DB_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbInstanceType").getter(getter(GetDbInstanceResponse::dbInstanceTypeAsString))
            .setter(setter(Builder::dbInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbInstanceType").build()).build();

    private static final SdkField<String> DB_STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbStorageType").getter(getter(GetDbInstanceResponse::dbStorageTypeAsString))
            .setter(setter(Builder::dbStorageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbStorageType").build()).build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("allocatedStorage").getter(getter(GetDbInstanceResponse::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocatedStorage").build()).build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentType").getter(getter(GetDbInstanceResponse::deploymentTypeAsString))
            .setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()).build();

    private static final SdkField<List<String>> VPC_SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpcSubnetIds")
            .getter(getter(GetDbInstanceResponse::vpcSubnetIds))
            .setter(setter(Builder::vpcSubnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publiclyAccessible").getter(getter(GetDbInstanceResponse::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build())
            .build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpcSecurityGroupIds")
            .getter(getter(GetDbInstanceResponse::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DB_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("dbParameterGroupIdentifier")
            .getter(getter(GetDbInstanceResponse::dbParameterGroupIdentifier))
            .setter(setter(Builder::dbParameterGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbParameterGroupIdentifier").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(GetDbInstanceResponse::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> SECONDARY_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secondaryAvailabilityZone").getter(getter(GetDbInstanceResponse::secondaryAvailabilityZone))
            .setter(setter(Builder::secondaryAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryAvailabilityZone").build())
            .build();

    private static final SdkField<LogDeliveryConfiguration> LOG_DELIVERY_CONFIGURATION_FIELD = SdkField
            .<LogDeliveryConfiguration> builder(MarshallingType.SDK_POJO).memberName("logDeliveryConfiguration")
            .getter(getter(GetDbInstanceResponse::logDeliveryConfiguration)).setter(setter(Builder::logDeliveryConfiguration))
            .constructor(LogDeliveryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDeliveryConfiguration").build())
            .build();

    private static final SdkField<String> INFLUX_AUTH_PARAMETERS_SECRET_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("influxAuthParametersSecretArn")
            .getter(getter(GetDbInstanceResponse::influxAuthParametersSecretArn))
            .setter(setter(Builder::influxAuthParametersSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("influxAuthParametersSecretArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ARN_FIELD, STATUS_FIELD, ENDPOINT_FIELD, DB_INSTANCE_TYPE_FIELD, DB_STORAGE_TYPE_FIELD, ALLOCATED_STORAGE_FIELD,
            DEPLOYMENT_TYPE_FIELD, VPC_SUBNET_IDS_FIELD, PUBLICLY_ACCESSIBLE_FIELD, VPC_SECURITY_GROUP_IDS_FIELD,
            DB_PARAMETER_GROUP_IDENTIFIER_FIELD, AVAILABILITY_ZONE_FIELD, SECONDARY_AVAILABILITY_ZONE_FIELD,
            LOG_DELIVERY_CONFIGURATION_FIELD, INFLUX_AUTH_PARAMETERS_SECRET_ARN_FIELD));

    private final String id;

    private final String name;

    private final String arn;

    private final String status;

    private final String endpoint;

    private final String dbInstanceType;

    private final String dbStorageType;

    private final Integer allocatedStorage;

    private final String deploymentType;

    private final List<String> vpcSubnetIds;

    private final Boolean publiclyAccessible;

    private final List<String> vpcSecurityGroupIds;

    private final String dbParameterGroupIdentifier;

    private final String availabilityZone;

    private final String secondaryAvailabilityZone;

    private final LogDeliveryConfiguration logDeliveryConfiguration;

    private final String influxAuthParametersSecretArn;

    private GetDbInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.status = builder.status;
        this.endpoint = builder.endpoint;
        this.dbInstanceType = builder.dbInstanceType;
        this.dbStorageType = builder.dbStorageType;
        this.allocatedStorage = builder.allocatedStorage;
        this.deploymentType = builder.deploymentType;
        this.vpcSubnetIds = builder.vpcSubnetIds;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.dbParameterGroupIdentifier = builder.dbParameterGroupIdentifier;
        this.availabilityZone = builder.availabilityZone;
        this.secondaryAvailabilityZone = builder.secondaryAvailabilityZone;
        this.logDeliveryConfiguration = builder.logDeliveryConfiguration;
        this.influxAuthParametersSecretArn = builder.influxAuthParametersSecretArn;
    }

    /**
     * <p>
     * A service-generated unique identifier.
     * </p>
     * 
     * @return A service-generated unique identifier.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The customer-supplied name that uniquely identifies the DB instance when interacting with the Amazon Timestream
     * for InfluxDB API and CLI commands.
     * </p>
     * 
     * @return The customer-supplied name that uniquely identifies the DB instance when interacting with the Amazon
     *         Timestream for InfluxDB API and CLI commands.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the DB instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the DB instance.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the DB instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the DB instance.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the DB instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the DB instance.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
     * </p>
     * 
     * @return The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The Timestream for InfluxDB instance type that InfluxDB runs on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbInstanceType}
     * will return {@link DbInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dbInstanceTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB instance type that InfluxDB runs on.
     * @see DbInstanceType
     */
    public final DbInstanceType dbInstanceType() {
        return DbInstanceType.fromValue(dbInstanceType);
    }

    /**
     * <p>
     * The Timestream for InfluxDB instance type that InfluxDB runs on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbInstanceType}
     * will return {@link DbInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dbInstanceTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB instance type that InfluxDB runs on.
     * @see DbInstanceType
     */
    public final String dbInstanceTypeAsString() {
        return dbInstanceType;
    }

    /**
     * <p>
     * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbStorageType}
     * will return {@link DbStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dbStorageTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
     * @see DbStorageType
     */
    public final DbStorageType dbStorageType() {
        return DbStorageType.fromValue(dbStorageType);
    }

    /**
     * <p>
     * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbStorageType}
     * will return {@link DbStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dbStorageTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
     * @see DbStorageType
     */
    public final String dbStorageTypeAsString() {
        return dbStorageType;
    }

    /**
     * <p>
     * The amount of storage allocated for your DB storage type (in gibibytes).
     * </p>
     * 
     * @return The amount of storage allocated for your DB storage type (in gibibytes).
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or with a MultiAZ Standby for High
     * availability.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or with a MultiAZ Standby for High
     *         availability.
     * @see DeploymentType
     */
    public final DeploymentType deploymentType() {
        return DeploymentType.fromValue(deploymentType);
    }

    /**
     * <p>
     * Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or with a MultiAZ Standby for High
     * availability.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or with a MultiAZ Standby for High
     *         availability.
     * @see DeploymentType
     */
    public final String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSubnetIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSubnetIds() {
        return vpcSubnetIds != null && !(vpcSubnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC subnet IDs associated with the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSubnetIds} method.
     * </p>
     * 
     * @return A list of VPC subnet IDs associated with the DB instance.
     */
    public final List<String> vpcSubnetIds() {
        return vpcSubnetIds;
    }

    /**
     * <p>
     * Indicates if the DB instance has a public IP to facilitate access.
     * </p>
     * 
     * @return Indicates if the DB instance has a public IP to facilitate access.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC security group IDs associated with the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of VPC security group IDs associated with the DB instance.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The id of the DB parameter group assigned to your DB instance.
     * </p>
     * 
     * @return The id of the DB parameter group assigned to your DB instance.
     */
    public final String dbParameterGroupIdentifier() {
        return dbParameterGroupIdentifier;
    }

    /**
     * <p>
     * The Availability Zone in which the DB instance resides.
     * </p>
     * 
     * @return The Availability Zone in which the DB instance resides.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The Availability Zone in which the standby instance is located when deploying with a MultiAZ standby instance.
     * </p>
     * 
     * @return The Availability Zone in which the standby instance is located when deploying with a MultiAZ standby
     *         instance.
     */
    public final String secondaryAvailabilityZone() {
        return secondaryAvailabilityZone;
    }

    /**
     * <p>
     * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
     * </p>
     * 
     * @return Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
     */
    public final LogDeliveryConfiguration logDeliveryConfiguration() {
        return logDeliveryConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Secrets Manager secret containing the initial InfluxDB authorization
     * parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization values:
     * organization, bucket, username, and password.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Secrets Manager secret containing the initial InfluxDB
     *         authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB
     *         authorization values: organization, bucket, username, and password.
     */
    public final String influxAuthParametersSecretArn() {
        return influxAuthParametersSecretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dbStorageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSubnetIds() ? vpcSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(logDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(influxAuthParametersSecretArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDbInstanceResponse)) {
            return false;
        }
        GetDbInstanceResponse other = (GetDbInstanceResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(dbInstanceTypeAsString(), other.dbInstanceTypeAsString())
                && Objects.equals(dbStorageTypeAsString(), other.dbStorageTypeAsString())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && hasVpcSubnetIds() == other.hasVpcSubnetIds() && Objects.equals(vpcSubnetIds(), other.vpcSubnetIds())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(dbParameterGroupIdentifier(), other.dbParameterGroupIdentifier())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(secondaryAvailabilityZone(), other.secondaryAvailabilityZone())
                && Objects.equals(logDeliveryConfiguration(), other.logDeliveryConfiguration())
                && Objects.equals(influxAuthParametersSecretArn(), other.influxAuthParametersSecretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDbInstanceResponse").add("Id", id()).add("Name", name()).add("Arn", arn())
                .add("Status", statusAsString()).add("Endpoint", endpoint()).add("DbInstanceType", dbInstanceTypeAsString())
                .add("DbStorageType", dbStorageTypeAsString()).add("AllocatedStorage", allocatedStorage())
                .add("DeploymentType", deploymentTypeAsString()).add("VpcSubnetIds", hasVpcSubnetIds() ? vpcSubnetIds() : null)
                .add("PubliclyAccessible", publiclyAccessible())
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("DbParameterGroupIdentifier", dbParameterGroupIdentifier()).add("AvailabilityZone", availabilityZone())
                .add("SecondaryAvailabilityZone", secondaryAvailabilityZone())
                .add("LogDeliveryConfiguration", logDeliveryConfiguration())
                .add("InfluxAuthParametersSecretArn", influxAuthParametersSecretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "dbInstanceType":
            return Optional.ofNullable(clazz.cast(dbInstanceTypeAsString()));
        case "dbStorageType":
            return Optional.ofNullable(clazz.cast(dbStorageTypeAsString()));
        case "allocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "deploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "vpcSubnetIds":
            return Optional.ofNullable(clazz.cast(vpcSubnetIds()));
        case "publiclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "vpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "dbParameterGroupIdentifier":
            return Optional.ofNullable(clazz.cast(dbParameterGroupIdentifier()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "secondaryAvailabilityZone":
            return Optional.ofNullable(clazz.cast(secondaryAvailabilityZone()));
        case "logDeliveryConfiguration":
            return Optional.ofNullable(clazz.cast(logDeliveryConfiguration()));
        case "influxAuthParametersSecretArn":
            return Optional.ofNullable(clazz.cast(influxAuthParametersSecretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDbInstanceResponse, T> g) {
        return obj -> g.apply((GetDbInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamInfluxDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDbInstanceResponse> {
        /**
         * <p>
         * A service-generated unique identifier.
         * </p>
         * 
         * @param id
         *        A service-generated unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The customer-supplied name that uniquely identifies the DB instance when interacting with the Amazon
         * Timestream for InfluxDB API and CLI commands.
         * </p>
         * 
         * @param name
         *        The customer-supplied name that uniquely identifies the DB instance when interacting with the Amazon
         *        Timestream for InfluxDB API and CLI commands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the DB instance.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the DB instance.
         * </p>
         * 
         * @param status
         *        The status of the DB instance.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the DB instance.
         * </p>
         * 
         * @param status
         *        The status of the DB instance.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
         * </p>
         * 
         * @param endpoint
         *        The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The Timestream for InfluxDB instance type that InfluxDB runs on.
         * </p>
         * 
         * @param dbInstanceType
         *        The Timestream for InfluxDB instance type that InfluxDB runs on.
         * @see DbInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbInstanceType
         */
        Builder dbInstanceType(String dbInstanceType);

        /**
         * <p>
         * The Timestream for InfluxDB instance type that InfluxDB runs on.
         * </p>
         * 
         * @param dbInstanceType
         *        The Timestream for InfluxDB instance type that InfluxDB runs on.
         * @see DbInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbInstanceType
         */
        Builder dbInstanceType(DbInstanceType dbInstanceType);

        /**
         * <p>
         * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
         * </p>
         * 
         * @param dbStorageType
         *        The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
         * @see DbStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbStorageType
         */
        Builder dbStorageType(String dbStorageType);

        /**
         * <p>
         * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
         * </p>
         * 
         * @param dbStorageType
         *        The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
         * @see DbStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbStorageType
         */
        Builder dbStorageType(DbStorageType dbStorageType);

        /**
         * <p>
         * The amount of storage allocated for your DB storage type (in gibibytes).
         * </p>
         * 
         * @param allocatedStorage
         *        The amount of storage allocated for your DB storage type (in gibibytes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or with a MultiAZ Standby for High
         * availability.
         * </p>
         * 
         * @param deploymentType
         *        Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or with a MultiAZ Standby for
         *        High availability.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or with a MultiAZ Standby for High
         * availability.
         * </p>
         * 
         * @param deploymentType
         *        Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or with a MultiAZ Standby for
         *        High availability.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(DeploymentType deploymentType);

        /**
         * <p>
         * A list of VPC subnet IDs associated with the DB instance.
         * </p>
         * 
         * @param vpcSubnetIds
         *        A list of VPC subnet IDs associated with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSubnetIds(Collection<String> vpcSubnetIds);

        /**
         * <p>
         * A list of VPC subnet IDs associated with the DB instance.
         * </p>
         * 
         * @param vpcSubnetIds
         *        A list of VPC subnet IDs associated with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSubnetIds(String... vpcSubnetIds);

        /**
         * <p>
         * Indicates if the DB instance has a public IP to facilitate access.
         * </p>
         * 
         * @param publiclyAccessible
         *        Indicates if the DB instance has a public IP to facilitate access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * A list of VPC security group IDs associated with the DB instance.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security group IDs associated with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of VPC security group IDs associated with the DB instance.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security group IDs associated with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The id of the DB parameter group assigned to your DB instance.
         * </p>
         * 
         * @param dbParameterGroupIdentifier
         *        The id of the DB parameter group assigned to your DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier);

        /**
         * <p>
         * The Availability Zone in which the DB instance resides.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the DB instance resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The Availability Zone in which the standby instance is located when deploying with a MultiAZ standby
         * instance.
         * </p>
         * 
         * @param secondaryAvailabilityZone
         *        The Availability Zone in which the standby instance is located when deploying with a MultiAZ standby
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryAvailabilityZone(String secondaryAvailabilityZone);

        /**
         * <p>
         * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
         * </p>
         * 
         * @param logDeliveryConfiguration
         *        Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration);

        /**
         * <p>
         * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogDeliveryConfiguration.Builder}
         * avoiding the need to create one manually via {@link LogDeliveryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogDeliveryConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #logDeliveryConfiguration(LogDeliveryConfiguration)}.
         * 
         * @param logDeliveryConfiguration
         *        a consumer that will call methods on {@link LogDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryConfiguration(LogDeliveryConfiguration)
         */
        default Builder logDeliveryConfiguration(Consumer<LogDeliveryConfiguration.Builder> logDeliveryConfiguration) {
            return logDeliveryConfiguration(LogDeliveryConfiguration.builder().applyMutation(logDeliveryConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Secrets Manager secret containing the initial InfluxDB
         * authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization
         * values: organization, bucket, username, and password.
         * </p>
         * 
         * @param influxAuthParametersSecretArn
         *        The Amazon Resource Name (ARN) of the AWS Secrets Manager secret containing the initial InfluxDB
         *        authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB
         *        authorization values: organization, bucket, username, and password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder influxAuthParametersSecretArn(String influxAuthParametersSecretArn);
    }

    static final class BuilderImpl extends TimestreamInfluxDbResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String arn;

        private String status;

        private String endpoint;

        private String dbInstanceType;

        private String dbStorageType;

        private Integer allocatedStorage;

        private String deploymentType;

        private List<String> vpcSubnetIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean publiclyAccessible;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String dbParameterGroupIdentifier;

        private String availabilityZone;

        private String secondaryAvailabilityZone;

        private LogDeliveryConfiguration logDeliveryConfiguration;

        private String influxAuthParametersSecretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDbInstanceResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            arn(model.arn);
            status(model.status);
            endpoint(model.endpoint);
            dbInstanceType(model.dbInstanceType);
            dbStorageType(model.dbStorageType);
            allocatedStorage(model.allocatedStorage);
            deploymentType(model.deploymentType);
            vpcSubnetIds(model.vpcSubnetIds);
            publiclyAccessible(model.publiclyAccessible);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            dbParameterGroupIdentifier(model.dbParameterGroupIdentifier);
            availabilityZone(model.availabilityZone);
            secondaryAvailabilityZone(model.secondaryAvailabilityZone);
            logDeliveryConfiguration(model.logDeliveryConfiguration);
            influxAuthParametersSecretArn(model.influxAuthParametersSecretArn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getDbInstanceType() {
            return dbInstanceType;
        }

        public final void setDbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
        }

        @Override
        public final Builder dbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
            return this;
        }

        @Override
        public final Builder dbInstanceType(DbInstanceType dbInstanceType) {
            this.dbInstanceType(dbInstanceType == null ? null : dbInstanceType.toString());
            return this;
        }

        public final String getDbStorageType() {
            return dbStorageType;
        }

        public final void setDbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
        }

        @Override
        public final Builder dbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
            return this;
        }

        @Override
        public final Builder dbStorageType(DbStorageType dbStorageType) {
            this.dbStorageType(dbStorageType == null ? null : dbStorageType.toString());
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final Collection<String> getVpcSubnetIds() {
            if (vpcSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSubnetIds;
        }

        public final void setVpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = VpcSubnetIdListCopier.copy(vpcSubnetIds);
        }

        @Override
        public final Builder vpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = VpcSubnetIdListCopier.copy(vpcSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSubnetIds(String... vpcSubnetIds) {
            vpcSubnetIds(Arrays.asList(vpcSubnetIds));
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getDbParameterGroupIdentifier() {
            return dbParameterGroupIdentifier;
        }

        public final void setDbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
        }

        @Override
        public final Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getSecondaryAvailabilityZone() {
            return secondaryAvailabilityZone;
        }

        public final void setSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
        }

        @Override
        public final Builder secondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
            return this;
        }

        public final LogDeliveryConfiguration.Builder getLogDeliveryConfiguration() {
            return logDeliveryConfiguration != null ? logDeliveryConfiguration.toBuilder() : null;
        }

        public final void setLogDeliveryConfiguration(LogDeliveryConfiguration.BuilderImpl logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration != null ? logDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration;
            return this;
        }

        public final String getInfluxAuthParametersSecretArn() {
            return influxAuthParametersSecretArn;
        }

        public final void setInfluxAuthParametersSecretArn(String influxAuthParametersSecretArn) {
            this.influxAuthParametersSecretArn = influxAuthParametersSecretArn;
        }

        @Override
        public final Builder influxAuthParametersSecretArn(String influxAuthParametersSecretArn) {
            this.influxAuthParametersSecretArn = influxAuthParametersSecretArn;
            return this;
        }

        @Override
        public GetDbInstanceResponse build() {
            return new GetDbInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
