/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InfluxDBv2Parameters implements SdkPojo, Serializable,
        ToCopyableBuilder<InfluxDBv2Parameters.Builder, InfluxDBv2Parameters> {
    private static final SdkField<Boolean> FLUX_LOG_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("fluxLogEnabled").getter(getter(InfluxDBv2Parameters::fluxLogEnabled))
            .setter(setter(Builder::fluxLogEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fluxLogEnabled").build()).build();

    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logLevel").getter(getter(InfluxDBv2Parameters::logLevelAsString)).setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()).build();

    private static final SdkField<Boolean> NO_TASKS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("noTasks").getter(getter(InfluxDBv2Parameters::noTasks)).setter(setter(Builder::noTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noTasks").build()).build();

    private static final SdkField<Integer> QUERY_CONCURRENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("queryConcurrency").getter(getter(InfluxDBv2Parameters::queryConcurrency))
            .setter(setter(Builder::queryConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryConcurrency").build()).build();

    private static final SdkField<Integer> QUERY_QUEUE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("queryQueueSize").getter(getter(InfluxDBv2Parameters::queryQueueSize))
            .setter(setter(Builder::queryQueueSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryQueueSize").build()).build();

    private static final SdkField<String> TRACING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tracingType").getter(getter(InfluxDBv2Parameters::tracingTypeAsString))
            .setter(setter(Builder::tracingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracingType").build()).build();

    private static final SdkField<Boolean> METRICS_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("metricsDisabled").getter(getter(InfluxDBv2Parameters::metricsDisabled))
            .setter(setter(Builder::metricsDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsDisabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLUX_LOG_ENABLED_FIELD,
            LOG_LEVEL_FIELD, NO_TASKS_FIELD, QUERY_CONCURRENCY_FIELD, QUERY_QUEUE_SIZE_FIELD, TRACING_TYPE_FIELD,
            METRICS_DISABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean fluxLogEnabled;

    private final String logLevel;

    private final Boolean noTasks;

    private final Integer queryConcurrency;

    private final Integer queryQueueSize;

    private final String tracingType;

    private final Boolean metricsDisabled;

    private InfluxDBv2Parameters(BuilderImpl builder) {
        this.fluxLogEnabled = builder.fluxLogEnabled;
        this.logLevel = builder.logLevel;
        this.noTasks = builder.noTasks;
        this.queryConcurrency = builder.queryConcurrency;
        this.queryQueueSize = builder.queryQueueSize;
        this.tracingType = builder.tracingType;
        this.metricsDisabled = builder.metricsDisabled;
    }

    /**
     * <p>
     * Include option to show detailed logs for Flux queries.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return Include option to show detailed logs for Flux queries.</p>
     *         <p>
     *         Default: false
     */
    public final Boolean fluxLogEnabled() {
        return fluxLogEnabled;
    }

    /**
     * <p>
     * Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level specified.
     * </p>
     * <p>
     * Default: info
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level
     *         specified.</p>
     *         <p>
     *         Default: info
     * @see LogLevel
     */
    public final LogLevel logLevel() {
        return LogLevel.fromValue(logLevel);
    }

    /**
     * <p>
     * Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level specified.
     * </p>
     * <p>
     * Default: info
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level
     *         specified.</p>
     *         <p>
     *         Default: info
     * @see LogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    /**
     * <p>
     * Disable the task scheduler. If problematic tasks prevent InfluxDB from starting, use this option to start
     * InfluxDB without scheduling or executing tasks.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return Disable the task scheduler. If problematic tasks prevent InfluxDB from starting, use this option to start
     *         InfluxDB without scheduling or executing tasks.</p>
     *         <p>
     *         Default: false
     */
    public final Boolean noTasks() {
        return noTasks;
    }

    /**
     * <p>
     * Number of queries allowed to execute concurrently. Setting to 0 allows an unlimited number of concurrent queries.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return Number of queries allowed to execute concurrently. Setting to 0 allows an unlimited number of concurrent
     *         queries.</p>
     *         <p>
     *         Default: 0
     */
    public final Integer queryConcurrency() {
        return queryConcurrency;
    }

    /**
     * <p>
     * Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are rejected.
     * Setting to 0 allows an unlimited number of queries in the queue.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are
     *         rejected. Setting to 0 allows an unlimited number of queries in the queue.</p>
     *         <p>
     *         Default: 0
     */
    public final Integer queryQueueSize() {
        return queryQueueSize;
    }

    /**
     * <p>
     * Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tracingType} will
     * return {@link TracingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tracingTypeAsString}.
     * </p>
     * 
     * @return Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
     * @see TracingType
     */
    public final TracingType tracingType() {
        return TracingType.fromValue(tracingType);
    }

    /**
     * <p>
     * Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tracingType} will
     * return {@link TracingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tracingTypeAsString}.
     * </p>
     * 
     * @return Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
     * @see TracingType
     */
    public final String tracingTypeAsString() {
        return tracingType;
    }

    /**
     * <p>
     * Disable the HTTP /metrics endpoint which exposes <a
     * href="https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/">internal InfluxDB metrics</a>.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return Disable the HTTP /metrics endpoint which exposes <a
     *         href="https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/">internal InfluxDB
     *         metrics</a>.</p>
     *         <p>
     *         Default: false
     */
    public final Boolean metricsDisabled() {
        return metricsDisabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fluxLogEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(noTasks());
        hashCode = 31 * hashCode + Objects.hashCode(queryConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(queryQueueSize());
        hashCode = 31 * hashCode + Objects.hashCode(tracingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricsDisabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InfluxDBv2Parameters)) {
            return false;
        }
        InfluxDBv2Parameters other = (InfluxDBv2Parameters) obj;
        return Objects.equals(fluxLogEnabled(), other.fluxLogEnabled())
                && Objects.equals(logLevelAsString(), other.logLevelAsString()) && Objects.equals(noTasks(), other.noTasks())
                && Objects.equals(queryConcurrency(), other.queryConcurrency())
                && Objects.equals(queryQueueSize(), other.queryQueueSize())
                && Objects.equals(tracingTypeAsString(), other.tracingTypeAsString())
                && Objects.equals(metricsDisabled(), other.metricsDisabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InfluxDBv2Parameters").add("FluxLogEnabled", fluxLogEnabled())
                .add("LogLevel", logLevelAsString()).add("NoTasks", noTasks()).add("QueryConcurrency", queryConcurrency())
                .add("QueryQueueSize", queryQueueSize()).add("TracingType", tracingTypeAsString())
                .add("MetricsDisabled", metricsDisabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fluxLogEnabled":
            return Optional.ofNullable(clazz.cast(fluxLogEnabled()));
        case "logLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        case "noTasks":
            return Optional.ofNullable(clazz.cast(noTasks()));
        case "queryConcurrency":
            return Optional.ofNullable(clazz.cast(queryConcurrency()));
        case "queryQueueSize":
            return Optional.ofNullable(clazz.cast(queryQueueSize()));
        case "tracingType":
            return Optional.ofNullable(clazz.cast(tracingTypeAsString()));
        case "metricsDisabled":
            return Optional.ofNullable(clazz.cast(metricsDisabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InfluxDBv2Parameters, T> g) {
        return obj -> g.apply((InfluxDBv2Parameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InfluxDBv2Parameters> {
        /**
         * <p>
         * Include option to show detailed logs for Flux queries.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param fluxLogEnabled
         *        Include option to show detailed logs for Flux queries.</p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fluxLogEnabled(Boolean fluxLogEnabled);

        /**
         * <p>
         * Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level
         * specified.
         * </p>
         * <p>
         * Default: info
         * </p>
         * 
         * @param logLevel
         *        Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level
         *        specified.</p>
         *        <p>
         *        Default: info
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * <p>
         * Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level
         * specified.
         * </p>
         * <p>
         * Default: info
         * </p>
         * 
         * @param logLevel
         *        Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level
         *        specified.</p>
         *        <p>
         *        Default: info
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(LogLevel logLevel);

        /**
         * <p>
         * Disable the task scheduler. If problematic tasks prevent InfluxDB from starting, use this option to start
         * InfluxDB without scheduling or executing tasks.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param noTasks
         *        Disable the task scheduler. If problematic tasks prevent InfluxDB from starting, use this option to
         *        start InfluxDB without scheduling or executing tasks.</p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noTasks(Boolean noTasks);

        /**
         * <p>
         * Number of queries allowed to execute concurrently. Setting to 0 allows an unlimited number of concurrent
         * queries.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param queryConcurrency
         *        Number of queries allowed to execute concurrently. Setting to 0 allows an unlimited number of
         *        concurrent queries.</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryConcurrency(Integer queryConcurrency);

        /**
         * <p>
         * Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are rejected.
         * Setting to 0 allows an unlimited number of queries in the queue.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param queryQueueSize
         *        Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are
         *        rejected. Setting to 0 allows an unlimited number of queries in the queue.</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryQueueSize(Integer queryQueueSize);

        /**
         * <p>
         * Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
         * </p>
         * 
         * @param tracingType
         *        Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
         * @see TracingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TracingType
         */
        Builder tracingType(String tracingType);

        /**
         * <p>
         * Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
         * </p>
         * 
         * @param tracingType
         *        Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
         * @see TracingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TracingType
         */
        Builder tracingType(TracingType tracingType);

        /**
         * <p>
         * Disable the HTTP /metrics endpoint which exposes <a
         * href="https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/">internal InfluxDB metrics</a>.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param metricsDisabled
         *        Disable the HTTP /metrics endpoint which exposes <a
         *        href="https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/">internal InfluxDB
         *        metrics</a>.</p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsDisabled(Boolean metricsDisabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean fluxLogEnabled;

        private String logLevel;

        private Boolean noTasks;

        private Integer queryConcurrency;

        private Integer queryQueueSize;

        private String tracingType;

        private Boolean metricsDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(InfluxDBv2Parameters model) {
            fluxLogEnabled(model.fluxLogEnabled);
            logLevel(model.logLevel);
            noTasks(model.noTasks);
            queryConcurrency(model.queryConcurrency);
            queryQueueSize(model.queryQueueSize);
            tracingType(model.tracingType);
            metricsDisabled(model.metricsDisabled);
        }

        public final Boolean getFluxLogEnabled() {
            return fluxLogEnabled;
        }

        public final void setFluxLogEnabled(Boolean fluxLogEnabled) {
            this.fluxLogEnabled = fluxLogEnabled;
        }

        @Override
        public final Builder fluxLogEnabled(Boolean fluxLogEnabled) {
            this.fluxLogEnabled = fluxLogEnabled;
            return this;
        }

        public final String getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final Boolean getNoTasks() {
            return noTasks;
        }

        public final void setNoTasks(Boolean noTasks) {
            this.noTasks = noTasks;
        }

        @Override
        public final Builder noTasks(Boolean noTasks) {
            this.noTasks = noTasks;
            return this;
        }

        public final Integer getQueryConcurrency() {
            return queryConcurrency;
        }

        public final void setQueryConcurrency(Integer queryConcurrency) {
            this.queryConcurrency = queryConcurrency;
        }

        @Override
        public final Builder queryConcurrency(Integer queryConcurrency) {
            this.queryConcurrency = queryConcurrency;
            return this;
        }

        public final Integer getQueryQueueSize() {
            return queryQueueSize;
        }

        public final void setQueryQueueSize(Integer queryQueueSize) {
            this.queryQueueSize = queryQueueSize;
        }

        @Override
        public final Builder queryQueueSize(Integer queryQueueSize) {
            this.queryQueueSize = queryQueueSize;
            return this;
        }

        public final String getTracingType() {
            return tracingType;
        }

        public final void setTracingType(String tracingType) {
            this.tracingType = tracingType;
        }

        @Override
        public final Builder tracingType(String tracingType) {
            this.tracingType = tracingType;
            return this;
        }

        @Override
        public final Builder tracingType(TracingType tracingType) {
            this.tracingType(tracingType == null ? null : tracingType.toString());
            return this;
        }

        public final Boolean getMetricsDisabled() {
            return metricsDisabled;
        }

        public final void setMetricsDisabled(Boolean metricsDisabled) {
            this.metricsDisabled = metricsDisabled;
        }

        @Override
        public final Builder metricsDisabled(Boolean metricsDisabled) {
            this.metricsDisabled = metricsDisabled;
            return this;
        }

        @Override
        public InfluxDBv2Parameters build() {
            return new InfluxDBv2Parameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
