/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDbInstanceRequest extends TimestreamInfluxDbRequest implements
        ToCopyableBuilder<CreateDbInstanceRequest.Builder, CreateDbInstanceRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateDbInstanceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("username").getter(getter(CreateDbInstanceRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("password").getter(getter(CreateDbInstanceRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("password").build()).build();

    private static final SdkField<String> ORGANIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("organization").getter(getter(CreateDbInstanceRequest::organization))
            .setter(setter(Builder::organization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organization").build()).build();

    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("bucket")
            .getter(getter(CreateDbInstanceRequest::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()).build();

    private static final SdkField<String> DB_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbInstanceType").getter(getter(CreateDbInstanceRequest::dbInstanceTypeAsString))
            .setter(setter(Builder::dbInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbInstanceType").build()).build();

    private static final SdkField<List<String>> VPC_SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpcSubnetIds")
            .getter(getter(CreateDbInstanceRequest::vpcSubnetIds))
            .setter(setter(Builder::vpcSubnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpcSecurityGroupIds")
            .getter(getter(CreateDbInstanceRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publiclyAccessible").getter(getter(CreateDbInstanceRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build())
            .build();

    private static final SdkField<String> DB_STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbStorageType").getter(getter(CreateDbInstanceRequest::dbStorageTypeAsString))
            .setter(setter(Builder::dbStorageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbStorageType").build()).build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("allocatedStorage").getter(getter(CreateDbInstanceRequest::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocatedStorage").build()).build();

    private static final SdkField<String> DB_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("dbParameterGroupIdentifier")
            .getter(getter(CreateDbInstanceRequest::dbParameterGroupIdentifier))
            .setter(setter(Builder::dbParameterGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbParameterGroupIdentifier").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentType").getter(getter(CreateDbInstanceRequest::deploymentTypeAsString))
            .setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()).build();

    private static final SdkField<LogDeliveryConfiguration> LOG_DELIVERY_CONFIGURATION_FIELD = SdkField
            .<LogDeliveryConfiguration> builder(MarshallingType.SDK_POJO).memberName("logDeliveryConfiguration")
            .getter(getter(CreateDbInstanceRequest::logDeliveryConfiguration)).setter(setter(Builder::logDeliveryConfiguration))
            .constructor(LogDeliveryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDeliveryConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateDbInstanceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(CreateDbInstanceRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NAME_FIELD, USERNAME_FIELD, PASSWORD_FIELD, ORGANIZATION_FIELD, BUCKET_FIELD,
                    DB_INSTANCE_TYPE_FIELD, VPC_SUBNET_IDS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, PUBLICLY_ACCESSIBLE_FIELD,
                    DB_STORAGE_TYPE_FIELD, ALLOCATED_STORAGE_FIELD, DB_PARAMETER_GROUP_IDENTIFIER_FIELD, DEPLOYMENT_TYPE_FIELD,
                    LOG_DELIVERY_CONFIGURATION_FIELD, TAGS_FIELD, PORT_FIELD));

    private final String name;

    private final String username;

    private final String password;

    private final String organization;

    private final String bucket;

    private final String dbInstanceType;

    private final List<String> vpcSubnetIds;

    private final List<String> vpcSecurityGroupIds;

    private final Boolean publiclyAccessible;

    private final String dbStorageType;

    private final Integer allocatedStorage;

    private final String dbParameterGroupIdentifier;

    private final String deploymentType;

    private final LogDeliveryConfiguration logDeliveryConfiguration;

    private final Map<String, String> tags;

    private final Integer port;

    private CreateDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.username = builder.username;
        this.password = builder.password;
        this.organization = builder.organization;
        this.bucket = builder.bucket;
        this.dbInstanceType = builder.dbInstanceType;
        this.vpcSubnetIds = builder.vpcSubnetIds;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.dbStorageType = builder.dbStorageType;
        this.allocatedStorage = builder.allocatedStorage;
        this.dbParameterGroupIdentifier = builder.dbParameterGroupIdentifier;
        this.deploymentType = builder.deploymentType;
        this.logDeliveryConfiguration = builder.logDeliveryConfiguration;
        this.tags = builder.tags;
        this.port = builder.port;
    }

    /**
     * <p>
     * The name that uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API
     * and CLI commands. This name will also be a prefix included in the endpoint. DB instance names must be unique per
     * customer and per region.
     * </p>
     * 
     * @return The name that uniquely identifies the DB instance when interacting with the Amazon Timestream for
     *         InfluxDB API and CLI commands. This name will also be a prefix included in the endpoint. DB instance
     *         names must be unique per customer and per region.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The username of the initial admin user created in InfluxDB. Must start with a letter and can't end with a hyphen
     * or contain two consecutive hyphens. For example, my-user1. This username will allow you to access the InfluxDB UI
     * to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. These
     * attributes will be stored in a Secret created in Amazon Secrets Manager in your account.
     * </p>
     * 
     * @return The username of the initial admin user created in InfluxDB. Must start with a letter and can't end with a
     *         hyphen or contain two consecutive hyphens. For example, my-user1. This username will allow you to access
     *         the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an
     *         operator token. These attributes will be stored in a Secret created in Amazon Secrets Manager in your
     *         account.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The password of the initial admin user created in InfluxDB. This password will allow you to access the InfluxDB
     * UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. These
     * attributes will be stored in a Secret created in AWS SecretManager in your account.
     * </p>
     * 
     * @return The password of the initial admin user created in InfluxDB. This password will allow you to access the
     *         InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator
     *         token. These attributes will be stored in a Secret created in AWS SecretManager in your account.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * The name of the initial organization for the initial admin user in InfluxDB. An InfluxDB organization is a
     * workspace for a group of users.
     * </p>
     * 
     * @return The name of the initial organization for the initial admin user in InfluxDB. An InfluxDB organization is
     *         a workspace for a group of users.
     */
    public final String organization() {
        return organization;
    }

    /**
     * <p>
     * The name of the initial InfluxDB bucket. All InfluxDB data is stored in a bucket. A bucket combines the concept
     * of a database and a retention period (the duration of time that each data point persists). A bucket belongs to an
     * organization.
     * </p>
     * 
     * @return The name of the initial InfluxDB bucket. All InfluxDB data is stored in a bucket. A bucket combines the
     *         concept of a database and a retention period (the duration of time that each data point persists). A
     *         bucket belongs to an organization.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The Timestream for InfluxDB DB instance type to run InfluxDB on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbInstanceType}
     * will return {@link DbInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dbInstanceTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB DB instance type to run InfluxDB on.
     * @see DbInstanceType
     */
    public final DbInstanceType dbInstanceType() {
        return DbInstanceType.fromValue(dbInstanceType);
    }

    /**
     * <p>
     * The Timestream for InfluxDB DB instance type to run InfluxDB on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbInstanceType}
     * will return {@link DbInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dbInstanceTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB DB instance type to run InfluxDB on.
     * @see DbInstanceType
     */
    public final String dbInstanceTypeAsString() {
        return dbInstanceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSubnetIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSubnetIds() {
        return vpcSubnetIds != null && !(vpcSubnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC subnet IDs to associate with the DB instance. Provide at least two VPC subnet IDs in different
     * availability zones when deploying with a Multi-AZ standby.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSubnetIds} method.
     * </p>
     * 
     * @return A list of VPC subnet IDs to associate with the DB instance. Provide at least two VPC subnet IDs in
     *         different availability zones when deploying with a Multi-AZ standby.
     */
    public final List<String> vpcSubnetIds() {
        return vpcSubnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC security group IDs to associate with the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of VPC security group IDs to associate with the DB instance.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * Configures the DB instance with a public IP to facilitate access.
     * </p>
     * 
     * @return Configures the DB instance with a public IP to facilitate access.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * The Timestream for InfluxDB DB storage type to read and write InfluxDB data.
     * </p>
     * <p>
     * You can choose between 3 different types of provisioned Influx IOPS included storage according to your workloads
     * requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Influx IO Included 3000 IOPS
     * </p>
     * </li>
     * <li>
     * <p>
     * Influx IO Included 12000 IOPS
     * </p>
     * </li>
     * <li>
     * <p>
     * Influx IO Included 16000 IOPS
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbStorageType}
     * will return {@link DbStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dbStorageTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB DB storage type to read and write InfluxDB data.</p>
     *         <p>
     *         You can choose between 3 different types of provisioned Influx IOPS included storage according to your
     *         workloads requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Influx IO Included 3000 IOPS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Influx IO Included 12000 IOPS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Influx IO Included 16000 IOPS
     *         </p>
     *         </li>
     * @see DbStorageType
     */
    public final DbStorageType dbStorageType() {
        return DbStorageType.fromValue(dbStorageType);
    }

    /**
     * <p>
     * The Timestream for InfluxDB DB storage type to read and write InfluxDB data.
     * </p>
     * <p>
     * You can choose between 3 different types of provisioned Influx IOPS included storage according to your workloads
     * requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Influx IO Included 3000 IOPS
     * </p>
     * </li>
     * <li>
     * <p>
     * Influx IO Included 12000 IOPS
     * </p>
     * </li>
     * <li>
     * <p>
     * Influx IO Included 16000 IOPS
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbStorageType}
     * will return {@link DbStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dbStorageTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB DB storage type to read and write InfluxDB data.</p>
     *         <p>
     *         You can choose between 3 different types of provisioned Influx IOPS included storage according to your
     *         workloads requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Influx IO Included 3000 IOPS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Influx IO Included 12000 IOPS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Influx IO Included 16000 IOPS
     *         </p>
     *         </li>
     * @see DbStorageType
     */
    public final String dbStorageTypeAsString() {
        return dbStorageType;
    }

    /**
     * <p>
     * The amount of storage to allocate for your DB storage type in GiB (gibibytes).
     * </p>
     * 
     * @return The amount of storage to allocate for your DB storage type in GiB (gibibytes).
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the database is
     * configured. For example, DB parameter groups can specify the limit for query concurrency.
     * </p>
     * 
     * @return The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the
     *         database is configured. For example, DB parameter groups can specify the limit for query concurrency.
     */
    public final String dbParameterGroupIdentifier() {
        return dbParameterGroupIdentifier;
    }

    /**
     * <p>
     * Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for high
     * availability.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby
     *         for high availability.
     * @see DeploymentType
     */
    public final DeploymentType deploymentType() {
        return DeploymentType.fromValue(deploymentType);
    }

    /**
     * <p>
     * Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for high
     * availability.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby
     *         for high availability.
     * @see DeploymentType
     */
    public final String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * <p>
     * Configuration for sending InfluxDB engine logs to a specified S3 bucket.
     * </p>
     * 
     * @return Configuration for sending InfluxDB engine logs to a specified S3 bucket.
     */
    public final LogDeliveryConfiguration logDeliveryConfiguration() {
        return logDeliveryConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs to associate with the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs to associate with the DB instance.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The port number on which InfluxDB accepts connections.
     * </p>
     * <p>
     * Valid Values: 1024-65535
     * </p>
     * <p>
     * Default: 8086
     * </p>
     * <p>
     * Constraints: The value can't be 2375-2376, 7788-7799, 8090, or 51678-51680
     * </p>
     * 
     * @return The port number on which InfluxDB accepts connections.</p>
     *         <p>
     *         Valid Values: 1024-65535
     *         </p>
     *         <p>
     *         Default: 8086
     *         </p>
     *         <p>
     *         Constraints: The value can't be 2375-2376, 7788-7799, 8090, or 51678-51680
     */
    public final Integer port() {
        return port;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(organization());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSubnetIds() ? vpcSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(dbStorageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(port());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbInstanceRequest)) {
            return false;
        }
        CreateDbInstanceRequest other = (CreateDbInstanceRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(username(), other.username())
                && Objects.equals(password(), other.password()) && Objects.equals(organization(), other.organization())
                && Objects.equals(bucket(), other.bucket())
                && Objects.equals(dbInstanceTypeAsString(), other.dbInstanceTypeAsString())
                && hasVpcSubnetIds() == other.hasVpcSubnetIds() && Objects.equals(vpcSubnetIds(), other.vpcSubnetIds())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(dbStorageTypeAsString(), other.dbStorageTypeAsString())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(dbParameterGroupIdentifier(), other.dbParameterGroupIdentifier())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(logDeliveryConfiguration(), other.logDeliveryConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(port(), other.port());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDbInstanceRequest").add("Name", name())
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Organization", organization()).add("Bucket", bucket()).add("DbInstanceType", dbInstanceTypeAsString())
                .add("VpcSubnetIds", hasVpcSubnetIds() ? vpcSubnetIds() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("PubliclyAccessible", publiclyAccessible()).add("DbStorageType", dbStorageTypeAsString())
                .add("AllocatedStorage", allocatedStorage()).add("DbParameterGroupIdentifier", dbParameterGroupIdentifier())
                .add("DeploymentType", deploymentTypeAsString()).add("LogDeliveryConfiguration", logDeliveryConfiguration())
                .add("Tags", hasTags() ? tags() : null).add("Port", port()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "username":
            return Optional.ofNullable(clazz.cast(username()));
        case "password":
            return Optional.ofNullable(clazz.cast(password()));
        case "organization":
            return Optional.ofNullable(clazz.cast(organization()));
        case "bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "dbInstanceType":
            return Optional.ofNullable(clazz.cast(dbInstanceTypeAsString()));
        case "vpcSubnetIds":
            return Optional.ofNullable(clazz.cast(vpcSubnetIds()));
        case "vpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "publiclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "dbStorageType":
            return Optional.ofNullable(clazz.cast(dbStorageTypeAsString()));
        case "allocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "dbParameterGroupIdentifier":
            return Optional.ofNullable(clazz.cast(dbParameterGroupIdentifier()));
        case "deploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "logDeliveryConfiguration":
            return Optional.ofNullable(clazz.cast(logDeliveryConfiguration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDbInstanceRequest, T> g) {
        return obj -> g.apply((CreateDbInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamInfluxDbRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDbInstanceRequest> {
        /**
         * <p>
         * The name that uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB
         * API and CLI commands. This name will also be a prefix included in the endpoint. DB instance names must be
         * unique per customer and per region.
         * </p>
         * 
         * @param name
         *        The name that uniquely identifies the DB instance when interacting with the Amazon Timestream for
         *        InfluxDB API and CLI commands. This name will also be a prefix included in the endpoint. DB instance
         *        names must be unique per customer and per region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The username of the initial admin user created in InfluxDB. Must start with a letter and can't end with a
         * hyphen or contain two consecutive hyphens. For example, my-user1. This username will allow you to access the
         * InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator
         * token. These attributes will be stored in a Secret created in Amazon Secrets Manager in your account.
         * </p>
         * 
         * @param username
         *        The username of the initial admin user created in InfluxDB. Must start with a letter and can't end
         *        with a hyphen or contain two consecutive hyphens. For example, my-user1. This username will allow you
         *        to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to
         *        create an operator token. These attributes will be stored in a Secret created in Amazon Secrets
         *        Manager in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The password of the initial admin user created in InfluxDB. This password will allow you to access the
         * InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator
         * token. These attributes will be stored in a Secret created in AWS SecretManager in your account.
         * </p>
         * 
         * @param password
         *        The password of the initial admin user created in InfluxDB. This password will allow you to access the
         *        InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an
         *        operator token. These attributes will be stored in a Secret created in AWS SecretManager in your
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The name of the initial organization for the initial admin user in InfluxDB. An InfluxDB organization is a
         * workspace for a group of users.
         * </p>
         * 
         * @param organization
         *        The name of the initial organization for the initial admin user in InfluxDB. An InfluxDB organization
         *        is a workspace for a group of users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organization(String organization);

        /**
         * <p>
         * The name of the initial InfluxDB bucket. All InfluxDB data is stored in a bucket. A bucket combines the
         * concept of a database and a retention period (the duration of time that each data point persists). A bucket
         * belongs to an organization.
         * </p>
         * 
         * @param bucket
         *        The name of the initial InfluxDB bucket. All InfluxDB data is stored in a bucket. A bucket combines
         *        the concept of a database and a retention period (the duration of time that each data point persists).
         *        A bucket belongs to an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The Timestream for InfluxDB DB instance type to run InfluxDB on.
         * </p>
         * 
         * @param dbInstanceType
         *        The Timestream for InfluxDB DB instance type to run InfluxDB on.
         * @see DbInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbInstanceType
         */
        Builder dbInstanceType(String dbInstanceType);

        /**
         * <p>
         * The Timestream for InfluxDB DB instance type to run InfluxDB on.
         * </p>
         * 
         * @param dbInstanceType
         *        The Timestream for InfluxDB DB instance type to run InfluxDB on.
         * @see DbInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbInstanceType
         */
        Builder dbInstanceType(DbInstanceType dbInstanceType);

        /**
         * <p>
         * A list of VPC subnet IDs to associate with the DB instance. Provide at least two VPC subnet IDs in different
         * availability zones when deploying with a Multi-AZ standby.
         * </p>
         * 
         * @param vpcSubnetIds
         *        A list of VPC subnet IDs to associate with the DB instance. Provide at least two VPC subnet IDs in
         *        different availability zones when deploying with a Multi-AZ standby.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSubnetIds(Collection<String> vpcSubnetIds);

        /**
         * <p>
         * A list of VPC subnet IDs to associate with the DB instance. Provide at least two VPC subnet IDs in different
         * availability zones when deploying with a Multi-AZ standby.
         * </p>
         * 
         * @param vpcSubnetIds
         *        A list of VPC subnet IDs to associate with the DB instance. Provide at least two VPC subnet IDs in
         *        different availability zones when deploying with a Multi-AZ standby.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSubnetIds(String... vpcSubnetIds);

        /**
         * <p>
         * A list of VPC security group IDs to associate with the DB instance.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security group IDs to associate with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of VPC security group IDs to associate with the DB instance.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security group IDs to associate with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * Configures the DB instance with a public IP to facilitate access.
         * </p>
         * 
         * @param publiclyAccessible
         *        Configures the DB instance with a public IP to facilitate access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The Timestream for InfluxDB DB storage type to read and write InfluxDB data.
         * </p>
         * <p>
         * You can choose between 3 different types of provisioned Influx IOPS included storage according to your
         * workloads requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Influx IO Included 3000 IOPS
         * </p>
         * </li>
         * <li>
         * <p>
         * Influx IO Included 12000 IOPS
         * </p>
         * </li>
         * <li>
         * <p>
         * Influx IO Included 16000 IOPS
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbStorageType
         *        The Timestream for InfluxDB DB storage type to read and write InfluxDB data.</p>
         *        <p>
         *        You can choose between 3 different types of provisioned Influx IOPS included storage according to your
         *        workloads requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Influx IO Included 3000 IOPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Influx IO Included 12000 IOPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Influx IO Included 16000 IOPS
         *        </p>
         *        </li>
         * @see DbStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbStorageType
         */
        Builder dbStorageType(String dbStorageType);

        /**
         * <p>
         * The Timestream for InfluxDB DB storage type to read and write InfluxDB data.
         * </p>
         * <p>
         * You can choose between 3 different types of provisioned Influx IOPS included storage according to your
         * workloads requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Influx IO Included 3000 IOPS
         * </p>
         * </li>
         * <li>
         * <p>
         * Influx IO Included 12000 IOPS
         * </p>
         * </li>
         * <li>
         * <p>
         * Influx IO Included 16000 IOPS
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbStorageType
         *        The Timestream for InfluxDB DB storage type to read and write InfluxDB data.</p>
         *        <p>
         *        You can choose between 3 different types of provisioned Influx IOPS included storage according to your
         *        workloads requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Influx IO Included 3000 IOPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Influx IO Included 12000 IOPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Influx IO Included 16000 IOPS
         *        </p>
         *        </li>
         * @see DbStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbStorageType
         */
        Builder dbStorageType(DbStorageType dbStorageType);

        /**
         * <p>
         * The amount of storage to allocate for your DB storage type in GiB (gibibytes).
         * </p>
         * 
         * @param allocatedStorage
         *        The amount of storage to allocate for your DB storage type in GiB (gibibytes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the database
         * is configured. For example, DB parameter groups can specify the limit for query concurrency.
         * </p>
         * 
         * @param dbParameterGroupIdentifier
         *        The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the
         *        database is configured. For example, DB parameter groups can specify the limit for query concurrency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier);

        /**
         * <p>
         * Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for
         * high availability.
         * </p>
         * 
         * @param deploymentType
         *        Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby
         *        for high availability.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for
         * high availability.
         * </p>
         * 
         * @param deploymentType
         *        Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby
         *        for high availability.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(DeploymentType deploymentType);

        /**
         * <p>
         * Configuration for sending InfluxDB engine logs to a specified S3 bucket.
         * </p>
         * 
         * @param logDeliveryConfiguration
         *        Configuration for sending InfluxDB engine logs to a specified S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration);

        /**
         * <p>
         * Configuration for sending InfluxDB engine logs to a specified S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogDeliveryConfiguration.Builder}
         * avoiding the need to create one manually via {@link LogDeliveryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogDeliveryConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #logDeliveryConfiguration(LogDeliveryConfiguration)}.
         * 
         * @param logDeliveryConfiguration
         *        a consumer that will call methods on {@link LogDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryConfiguration(LogDeliveryConfiguration)
         */
        default Builder logDeliveryConfiguration(Consumer<LogDeliveryConfiguration.Builder> logDeliveryConfiguration) {
            return logDeliveryConfiguration(LogDeliveryConfiguration.builder().applyMutation(logDeliveryConfiguration).build());
        }

        /**
         * <p>
         * A list of key-value pairs to associate with the DB instance.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to associate with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The port number on which InfluxDB accepts connections.
         * </p>
         * <p>
         * Valid Values: 1024-65535
         * </p>
         * <p>
         * Default: 8086
         * </p>
         * <p>
         * Constraints: The value can't be 2375-2376, 7788-7799, 8090, or 51678-51680
         * </p>
         * 
         * @param port
         *        The port number on which InfluxDB accepts connections.</p>
         *        <p>
         *        Valid Values: 1024-65535
         *        </p>
         *        <p>
         *        Default: 8086
         *        </p>
         *        <p>
         *        Constraints: The value can't be 2375-2376, 7788-7799, 8090, or 51678-51680
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TimestreamInfluxDbRequest.BuilderImpl implements Builder {
        private String name;

        private String username;

        private String password;

        private String organization;

        private String bucket;

        private String dbInstanceType;

        private List<String> vpcSubnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean publiclyAccessible;

        private String dbStorageType;

        private Integer allocatedStorage;

        private String dbParameterGroupIdentifier;

        private String deploymentType;

        private LogDeliveryConfiguration logDeliveryConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Integer port;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbInstanceRequest model) {
            super(model);
            name(model.name);
            username(model.username);
            password(model.password);
            organization(model.organization);
            bucket(model.bucket);
            dbInstanceType(model.dbInstanceType);
            vpcSubnetIds(model.vpcSubnetIds);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            publiclyAccessible(model.publiclyAccessible);
            dbStorageType(model.dbStorageType);
            allocatedStorage(model.allocatedStorage);
            dbParameterGroupIdentifier(model.dbParameterGroupIdentifier);
            deploymentType(model.deploymentType);
            logDeliveryConfiguration(model.logDeliveryConfiguration);
            tags(model.tags);
            port(model.port);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getOrganization() {
            return organization;
        }

        public final void setOrganization(String organization) {
            this.organization = organization;
        }

        @Override
        public final Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getDbInstanceType() {
            return dbInstanceType;
        }

        public final void setDbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
        }

        @Override
        public final Builder dbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
            return this;
        }

        @Override
        public final Builder dbInstanceType(DbInstanceType dbInstanceType) {
            this.dbInstanceType(dbInstanceType == null ? null : dbInstanceType.toString());
            return this;
        }

        public final Collection<String> getVpcSubnetIds() {
            if (vpcSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSubnetIds;
        }

        public final void setVpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = VpcSubnetIdListCopier.copy(vpcSubnetIds);
        }

        @Override
        public final Builder vpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = VpcSubnetIdListCopier.copy(vpcSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSubnetIds(String... vpcSubnetIds) {
            vpcSubnetIds(Arrays.asList(vpcSubnetIds));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getDbStorageType() {
            return dbStorageType;
        }

        public final void setDbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
        }

        @Override
        public final Builder dbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
            return this;
        }

        @Override
        public final Builder dbStorageType(DbStorageType dbStorageType) {
            this.dbStorageType(dbStorageType == null ? null : dbStorageType.toString());
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getDbParameterGroupIdentifier() {
            return dbParameterGroupIdentifier;
        }

        public final void setDbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
        }

        @Override
        public final Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
            return this;
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final LogDeliveryConfiguration.Builder getLogDeliveryConfiguration() {
            return logDeliveryConfiguration != null ? logDeliveryConfiguration.toBuilder() : null;
        }

        public final void setLogDeliveryConfiguration(LogDeliveryConfiguration.BuilderImpl logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration != null ? logDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbInstanceRequest build() {
            return new CreateDbInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
