/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum DbInstanceType {
    DB_INFLUX_MEDIUM("db.influx.medium"),

    DB_INFLUX_LARGE("db.influx.large"),

    DB_INFLUX_XLARGE("db.influx.xlarge"),

    DB_INFLUX_2_XLARGE("db.influx.2xlarge"),

    DB_INFLUX_4_XLARGE("db.influx.4xlarge"),

    DB_INFLUX_8_XLARGE("db.influx.8xlarge"),

    DB_INFLUX_12_XLARGE("db.influx.12xlarge"),

    DB_INFLUX_16_XLARGE("db.influx.16xlarge"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DbInstanceType> VALUE_MAP = EnumUtils.uniqueIndex(DbInstanceType.class,
            DbInstanceType::toString);

    private final String value;

    private DbInstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DbInstanceType corresponding to the value
     */
    public static DbInstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DbInstanceType}s
     */
    public static Set<DbInstanceType> knownValues() {
        Set<DbInstanceType> knownValues = EnumSet.allOf(DbInstanceType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
