/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters that comprise the parameter group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Parameters implements SdkPojo, Serializable, ToCopyableBuilder<Parameters.Builder, Parameters> {
    private static final SdkField<InfluxDBv2Parameters> INFLUX_DB_V2_FIELD = SdkField
            .<InfluxDBv2Parameters> builder(MarshallingType.SDK_POJO).memberName("InfluxDBv2")
            .getter(getter(Parameters::influxDBv2)).setter(setter(Builder::influxDBv2))
            .constructor(InfluxDBv2Parameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfluxDBv2").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFLUX_DB_V2_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InfluxDBv2Parameters influxDBv2;

    private final Type type;

    private Parameters(BuilderImpl builder) {
        this.influxDBv2 = builder.influxDBv2;
        this.type = builder.type;
    }

    /**
     * <p>
     * All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
     * </p>
     * 
     * @return All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
     */
    public final InfluxDBv2Parameters influxDBv2() {
        return influxDBv2;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(influxDBv2());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameters)) {
            return false;
        }
        Parameters other = (Parameters) obj;
        return Objects.equals(influxDBv2(), other.influxDBv2());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Parameters").add("InfluxDBv2", influxDBv2()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InfluxDBv2":
            return Optional.ofNullable(clazz.cast(influxDBv2()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #influxDBv2()} initialized to the given value.
     *
     * <p>
     * All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
     * </p>
     * 
     * @param influxDBv2
     *        All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
     */
    public static Parameters fromInfluxDBv2(InfluxDBv2Parameters influxDBv2) {
        return builder().influxDBv2(influxDBv2).build();
    }

    /**
     * Create an instance of this class with {@link #influxDBv2()} initialized to the given value.
     *
     * <p>
     * All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
     * </p>
     * 
     * @param influxDBv2
     *        All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
     */
    public static Parameters fromInfluxDBv2(Consumer<InfluxDBv2Parameters.Builder> influxDBv2) {
        InfluxDBv2Parameters.Builder builder = InfluxDBv2Parameters.builder();
        influxDBv2.accept(builder);
        return fromInfluxDBv2(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InfluxDBv2", INFLUX_DB_V2_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Parameters, T> g) {
        return obj -> g.apply((Parameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Parameters> {
        /**
         * <p>
         * All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
         * </p>
         * 
         * @param influxDBv2
         *        All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder influxDBv2(InfluxDBv2Parameters influxDBv2);

        /**
         * <p>
         * All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
         * </p>
         * This is a convenience method that creates an instance of the {@link InfluxDBv2Parameters.Builder} avoiding
         * the need to create one manually via {@link InfluxDBv2Parameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InfluxDBv2Parameters.Builder#build()} is called immediately and
         * its result is passed to {@link #influxDBv2(InfluxDBv2Parameters)}.
         * 
         * @param influxDBv2
         *        a consumer that will call methods on {@link InfluxDBv2Parameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #influxDBv2(InfluxDBv2Parameters)
         */
        default Builder influxDBv2(Consumer<InfluxDBv2Parameters.Builder> influxDBv2) {
            return influxDBv2(InfluxDBv2Parameters.builder().applyMutation(influxDBv2).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InfluxDBv2Parameters influxDBv2;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Parameters model) {
            influxDBv2(model.influxDBv2);
        }

        public final InfluxDBv2Parameters.Builder getInfluxDBv2() {
            return influxDBv2 != null ? influxDBv2.toBuilder() : null;
        }

        public final void setInfluxDBv2(InfluxDBv2Parameters.BuilderImpl influxDBv2) {
            Object oldValue = this.influxDBv2;
            this.influxDBv2 = influxDBv2 != null ? influxDBv2.build() : null;
            handleUnionValueChange(Type.INFLUX_DB_V2, oldValue, this.influxDBv2);
        }

        @Override
        public final Builder influxDBv2(InfluxDBv2Parameters influxDBv2) {
            Object oldValue = this.influxDBv2;
            this.influxDBv2 = influxDBv2;
            handleUnionValueChange(Type.INFLUX_DB_V2, oldValue, this.influxDBv2);
            return this;
        }

        @Override
        public Parameters build() {
            return new Parameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Parameters#type()
     */
    public enum Type {
        INFLUX_DB_V2,

        UNKNOWN_TO_SDK_VERSION
    }
}
