/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDbInstanceRequest extends TimestreamInfluxDbRequest implements
        ToCopyableBuilder<UpdateDbInstanceRequest.Builder, UpdateDbInstanceRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateDbInstanceRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<LogDeliveryConfiguration> LOG_DELIVERY_CONFIGURATION_FIELD = SdkField
            .<LogDeliveryConfiguration> builder(MarshallingType.SDK_POJO).memberName("logDeliveryConfiguration")
            .getter(getter(UpdateDbInstanceRequest::logDeliveryConfiguration)).setter(setter(Builder::logDeliveryConfiguration))
            .constructor(LogDeliveryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDeliveryConfiguration").build())
            .build();

    private static final SdkField<String> DB_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("dbParameterGroupIdentifier")
            .getter(getter(UpdateDbInstanceRequest::dbParameterGroupIdentifier))
            .setter(setter(Builder::dbParameterGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbParameterGroupIdentifier").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(UpdateDbInstanceRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> DB_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbInstanceType").getter(getter(UpdateDbInstanceRequest::dbInstanceTypeAsString))
            .setter(setter(Builder::dbInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbInstanceType").build()).build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentType").getter(getter(UpdateDbInstanceRequest::deploymentTypeAsString))
            .setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            LOG_DELIVERY_CONFIGURATION_FIELD, DB_PARAMETER_GROUP_IDENTIFIER_FIELD, PORT_FIELD, DB_INSTANCE_TYPE_FIELD,
            DEPLOYMENT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final LogDeliveryConfiguration logDeliveryConfiguration;

    private final String dbParameterGroupIdentifier;

    private final Integer port;

    private final String dbInstanceType;

    private final String deploymentType;

    private UpdateDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.logDeliveryConfiguration = builder.logDeliveryConfiguration;
        this.dbParameterGroupIdentifier = builder.dbParameterGroupIdentifier;
        this.port = builder.port;
        this.dbInstanceType = builder.dbInstanceType;
        this.deploymentType = builder.deploymentType;
    }

    /**
     * <p>
     * The id of the DB instance.
     * </p>
     * 
     * @return The id of the DB instance.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
     * </p>
     * 
     * @return Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
     */
    public final LogDeliveryConfiguration logDeliveryConfiguration() {
        return logDeliveryConfiguration;
    }

    /**
     * <p>
     * The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the database is
     * configured. For example, DB parameter groups can specify the limit for query concurrency.
     * </p>
     * 
     * @return The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the
     *         database is configured. For example, DB parameter groups can specify the limit for query concurrency.
     */
    public final String dbParameterGroupIdentifier() {
        return dbParameterGroupIdentifier;
    }

    /**
     * <p>
     * The port number on which InfluxDB accepts connections.
     * </p>
     * <p>
     * If you change the Port value, your database restarts immediately.
     * </p>
     * <p>
     * Valid Values: 1024-65535
     * </p>
     * <p>
     * Default: 8086
     * </p>
     * <p>
     * Constraints: The value can't be 2375-2376, 7788-7799, 8090, or 51678-51680
     * </p>
     * 
     * @return The port number on which InfluxDB accepts connections.</p>
     *         <p>
     *         If you change the Port value, your database restarts immediately.
     *         </p>
     *         <p>
     *         Valid Values: 1024-65535
     *         </p>
     *         <p>
     *         Default: 8086
     *         </p>
     *         <p>
     *         Constraints: The value can't be 2375-2376, 7788-7799, 8090, or 51678-51680
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The Timestream for InfluxDB DB instance type to run InfluxDB on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbInstanceType}
     * will return {@link DbInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dbInstanceTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB DB instance type to run InfluxDB on.
     * @see DbInstanceType
     */
    public final DbInstanceType dbInstanceType() {
        return DbInstanceType.fromValue(dbInstanceType);
    }

    /**
     * <p>
     * The Timestream for InfluxDB DB instance type to run InfluxDB on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbInstanceType}
     * will return {@link DbInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dbInstanceTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB DB instance type to run InfluxDB on.
     * @see DbInstanceType
     */
    public final String dbInstanceTypeAsString() {
        return dbInstanceType;
    }

    /**
     * <p>
     * Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for high
     * availability.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby
     *         for high availability.
     * @see DeploymentType
     */
    public final DeploymentType deploymentType() {
        return DeploymentType.fromValue(deploymentType);
    }

    /**
     * <p>
     * Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for high
     * availability.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby
     *         for high availability.
     * @see DeploymentType
     */
    public final String deploymentTypeAsString() {
        return deploymentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(logDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDbInstanceRequest)) {
            return false;
        }
        UpdateDbInstanceRequest other = (UpdateDbInstanceRequest) obj;
        return Objects.equals(identifier(), other.identifier())
                && Objects.equals(logDeliveryConfiguration(), other.logDeliveryConfiguration())
                && Objects.equals(dbParameterGroupIdentifier(), other.dbParameterGroupIdentifier())
                && Objects.equals(port(), other.port())
                && Objects.equals(dbInstanceTypeAsString(), other.dbInstanceTypeAsString())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDbInstanceRequest").add("Identifier", identifier())
                .add("LogDeliveryConfiguration", logDeliveryConfiguration())
                .add("DbParameterGroupIdentifier", dbParameterGroupIdentifier()).add("Port", port())
                .add("DbInstanceType", dbInstanceTypeAsString()).add("DeploymentType", deploymentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "logDeliveryConfiguration":
            return Optional.ofNullable(clazz.cast(logDeliveryConfiguration()));
        case "dbParameterGroupIdentifier":
            return Optional.ofNullable(clazz.cast(dbParameterGroupIdentifier()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "dbInstanceType":
            return Optional.ofNullable(clazz.cast(dbInstanceTypeAsString()));
        case "deploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("logDeliveryConfiguration", LOG_DELIVERY_CONFIGURATION_FIELD);
        map.put("dbParameterGroupIdentifier", DB_PARAMETER_GROUP_IDENTIFIER_FIELD);
        map.put("port", PORT_FIELD);
        map.put("dbInstanceType", DB_INSTANCE_TYPE_FIELD);
        map.put("deploymentType", DEPLOYMENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDbInstanceRequest, T> g) {
        return obj -> g.apply((UpdateDbInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamInfluxDbRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDbInstanceRequest> {
        /**
         * <p>
         * The id of the DB instance.
         * </p>
         * 
         * @param identifier
         *        The id of the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
         * </p>
         * 
         * @param logDeliveryConfiguration
         *        Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration);

        /**
         * <p>
         * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogDeliveryConfiguration.Builder}
         * avoiding the need to create one manually via {@link LogDeliveryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogDeliveryConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #logDeliveryConfiguration(LogDeliveryConfiguration)}.
         * 
         * @param logDeliveryConfiguration
         *        a consumer that will call methods on {@link LogDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryConfiguration(LogDeliveryConfiguration)
         */
        default Builder logDeliveryConfiguration(Consumer<LogDeliveryConfiguration.Builder> logDeliveryConfiguration) {
            return logDeliveryConfiguration(LogDeliveryConfiguration.builder().applyMutation(logDeliveryConfiguration).build());
        }

        /**
         * <p>
         * The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the database
         * is configured. For example, DB parameter groups can specify the limit for query concurrency.
         * </p>
         * 
         * @param dbParameterGroupIdentifier
         *        The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the
         *        database is configured. For example, DB parameter groups can specify the limit for query concurrency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier);

        /**
         * <p>
         * The port number on which InfluxDB accepts connections.
         * </p>
         * <p>
         * If you change the Port value, your database restarts immediately.
         * </p>
         * <p>
         * Valid Values: 1024-65535
         * </p>
         * <p>
         * Default: 8086
         * </p>
         * <p>
         * Constraints: The value can't be 2375-2376, 7788-7799, 8090, or 51678-51680
         * </p>
         * 
         * @param port
         *        The port number on which InfluxDB accepts connections.</p>
         *        <p>
         *        If you change the Port value, your database restarts immediately.
         *        </p>
         *        <p>
         *        Valid Values: 1024-65535
         *        </p>
         *        <p>
         *        Default: 8086
         *        </p>
         *        <p>
         *        Constraints: The value can't be 2375-2376, 7788-7799, 8090, or 51678-51680
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The Timestream for InfluxDB DB instance type to run InfluxDB on.
         * </p>
         * 
         * @param dbInstanceType
         *        The Timestream for InfluxDB DB instance type to run InfluxDB on.
         * @see DbInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbInstanceType
         */
        Builder dbInstanceType(String dbInstanceType);

        /**
         * <p>
         * The Timestream for InfluxDB DB instance type to run InfluxDB on.
         * </p>
         * 
         * @param dbInstanceType
         *        The Timestream for InfluxDB DB instance type to run InfluxDB on.
         * @see DbInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbInstanceType
         */
        Builder dbInstanceType(DbInstanceType dbInstanceType);

        /**
         * <p>
         * Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for
         * high availability.
         * </p>
         * 
         * @param deploymentType
         *        Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby
         *        for high availability.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for
         * high availability.
         * </p>
         * 
         * @param deploymentType
         *        Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby
         *        for high availability.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(DeploymentType deploymentType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TimestreamInfluxDbRequest.BuilderImpl implements Builder {
        private String identifier;

        private LogDeliveryConfiguration logDeliveryConfiguration;

        private String dbParameterGroupIdentifier;

        private Integer port;

        private String dbInstanceType;

        private String deploymentType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDbInstanceRequest model) {
            super(model);
            identifier(model.identifier);
            logDeliveryConfiguration(model.logDeliveryConfiguration);
            dbParameterGroupIdentifier(model.dbParameterGroupIdentifier);
            port(model.port);
            dbInstanceType(model.dbInstanceType);
            deploymentType(model.deploymentType);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final LogDeliveryConfiguration.Builder getLogDeliveryConfiguration() {
            return logDeliveryConfiguration != null ? logDeliveryConfiguration.toBuilder() : null;
        }

        public final void setLogDeliveryConfiguration(LogDeliveryConfiguration.BuilderImpl logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration != null ? logDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration;
            return this;
        }

        public final String getDbParameterGroupIdentifier() {
            return dbParameterGroupIdentifier;
        }

        public final void setDbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
        }

        @Override
        public final Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDbInstanceType() {
            return dbInstanceType;
        }

        public final void setDbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
        }

        @Override
        public final Builder dbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
            return this;
        }

        @Override
        public final Builder dbInstanceType(DbInstanceType dbInstanceType) {
            this.dbInstanceType(dbInstanceType == null ? null : dbInstanceType.toString());
            return this;
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDbInstanceRequest build() {
            return new UpdateDbInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
