/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.TimestreamInfluxDbClient;
import software.amazon.awssdk.services.timestreaminfluxdb.internal.UserAgentUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbClusterSummary;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbClustersRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbClustersResponse;

public class ListDbClustersIterable
implements SdkIterable<ListDbClustersResponse> {
    private final TimestreamInfluxDbClient client;
    private final ListDbClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDbClustersIterable(TimestreamInfluxDbClient client, ListDbClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDbClustersResponseFetcher();
    }

    public Iterator<ListDbClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DbClusterSummary> items() {
        Function<ListDbClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDbClustersResponseFetcher
    implements SyncPageFetcher<ListDbClustersResponse> {
        private ListDbClustersResponseFetcher() {
        }

        public boolean hasNextPage(ListDbClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDbClustersResponse nextPage(ListDbClustersResponse previousPage) {
            if (previousPage == null) {
                return ListDbClustersIterable.this.client.listDbClusters(ListDbClustersIterable.this.firstRequest);
            }
            return ListDbClustersIterable.this.client.listDbClusters((ListDbClustersRequest)((Object)ListDbClustersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

