/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreaminfluxdb.model.Duration;
import software.amazon.awssdk.services.timestreaminfluxdb.model.LogLevel;
import software.amazon.awssdk.services.timestreaminfluxdb.model.TracingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InfluxDBv2Parameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InfluxDBv2Parameters> {
    private static final SdkField<Boolean> FLUX_LOG_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("fluxLogEnabled").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::fluxLogEnabled)).setter(InfluxDBv2Parameters.setter(Builder::fluxLogEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fluxLogEnabled").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logLevel").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::logLevelAsString)).setter(InfluxDBv2Parameters.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()}).build();
    private static final SdkField<Boolean> NO_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("noTasks").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::noTasks)).setter(InfluxDBv2Parameters.setter(Builder::noTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noTasks").build()}).build();
    private static final SdkField<Integer> QUERY_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("queryConcurrency").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::queryConcurrency)).setter(InfluxDBv2Parameters.setter(Builder::queryConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryConcurrency").build()}).build();
    private static final SdkField<Integer> QUERY_QUEUE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("queryQueueSize").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::queryQueueSize)).setter(InfluxDBv2Parameters.setter(Builder::queryQueueSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryQueueSize").build()}).build();
    private static final SdkField<String> TRACING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tracingType").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::tracingTypeAsString)).setter(InfluxDBv2Parameters.setter(Builder::tracingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracingType").build()}).build();
    private static final SdkField<Boolean> METRICS_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("metricsDisabled").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::metricsDisabled)).setter(InfluxDBv2Parameters.setter(Builder::metricsDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsDisabled").build()}).build();
    private static final SdkField<Duration> HTTP_IDLE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("httpIdleTimeout").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::httpIdleTimeout)).setter(InfluxDBv2Parameters.setter(Builder::httpIdleTimeout)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpIdleTimeout").build()}).build();
    private static final SdkField<Duration> HTTP_READ_HEADER_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("httpReadHeaderTimeout").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::httpReadHeaderTimeout)).setter(InfluxDBv2Parameters.setter(Builder::httpReadHeaderTimeout)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpReadHeaderTimeout").build()}).build();
    private static final SdkField<Duration> HTTP_READ_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("httpReadTimeout").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::httpReadTimeout)).setter(InfluxDBv2Parameters.setter(Builder::httpReadTimeout)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpReadTimeout").build()}).build();
    private static final SdkField<Duration> HTTP_WRITE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("httpWriteTimeout").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::httpWriteTimeout)).setter(InfluxDBv2Parameters.setter(Builder::httpWriteTimeout)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpWriteTimeout").build()}).build();
    private static final SdkField<Long> INFLUXQL_MAX_SELECT_BUCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("influxqlMaxSelectBuckets").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::influxqlMaxSelectBuckets)).setter(InfluxDBv2Parameters.setter(Builder::influxqlMaxSelectBuckets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("influxqlMaxSelectBuckets").build()}).build();
    private static final SdkField<Long> INFLUXQL_MAX_SELECT_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("influxqlMaxSelectPoint").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::influxqlMaxSelectPoint)).setter(InfluxDBv2Parameters.setter(Builder::influxqlMaxSelectPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("influxqlMaxSelectPoint").build()}).build();
    private static final SdkField<Long> INFLUXQL_MAX_SELECT_SERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("influxqlMaxSelectSeries").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::influxqlMaxSelectSeries)).setter(InfluxDBv2Parameters.setter(Builder::influxqlMaxSelectSeries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("influxqlMaxSelectSeries").build()}).build();
    private static final SdkField<Boolean> PPROF_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("pprofDisabled").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::pprofDisabled)).setter(InfluxDBv2Parameters.setter(Builder::pprofDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pprofDisabled").build()}).build();
    private static final SdkField<Long> QUERY_INITIAL_MEMORY_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("queryInitialMemoryBytes").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::queryInitialMemoryBytes)).setter(InfluxDBv2Parameters.setter(Builder::queryInitialMemoryBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryInitialMemoryBytes").build()}).build();
    private static final SdkField<Long> QUERY_MAX_MEMORY_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("queryMaxMemoryBytes").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::queryMaxMemoryBytes)).setter(InfluxDBv2Parameters.setter(Builder::queryMaxMemoryBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryMaxMemoryBytes").build()}).build();
    private static final SdkField<Long> QUERY_MEMORY_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("queryMemoryBytes").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::queryMemoryBytes)).setter(InfluxDBv2Parameters.setter(Builder::queryMemoryBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryMemoryBytes").build()}).build();
    private static final SdkField<Integer> SESSION_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("sessionLength").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::sessionLength)).setter(InfluxDBv2Parameters.setter(Builder::sessionLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionLength").build()}).build();
    private static final SdkField<Boolean> SESSION_RENEW_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("sessionRenewDisabled").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::sessionRenewDisabled)).setter(InfluxDBv2Parameters.setter(Builder::sessionRenewDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionRenewDisabled").build()}).build();
    private static final SdkField<Long> STORAGE_CACHE_MAX_MEMORY_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("storageCacheMaxMemorySize").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::storageCacheMaxMemorySize)).setter(InfluxDBv2Parameters.setter(Builder::storageCacheMaxMemorySize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCacheMaxMemorySize").build()}).build();
    private static final SdkField<Long> STORAGE_CACHE_SNAPSHOT_MEMORY_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("storageCacheSnapshotMemorySize").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::storageCacheSnapshotMemorySize)).setter(InfluxDBv2Parameters.setter(Builder::storageCacheSnapshotMemorySize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCacheSnapshotMemorySize").build()}).build();
    private static final SdkField<Duration> STORAGE_CACHE_SNAPSHOT_WRITE_COLD_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageCacheSnapshotWriteColdDuration").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::storageCacheSnapshotWriteColdDuration)).setter(InfluxDBv2Parameters.setter(Builder::storageCacheSnapshotWriteColdDuration)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCacheSnapshotWriteColdDuration").build()}).build();
    private static final SdkField<Duration> STORAGE_COMPACT_FULL_WRITE_COLD_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageCompactFullWriteColdDuration").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::storageCompactFullWriteColdDuration)).setter(InfluxDBv2Parameters.setter(Builder::storageCompactFullWriteColdDuration)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCompactFullWriteColdDuration").build()}).build();
    private static final SdkField<Long> STORAGE_COMPACT_THROUGHPUT_BURST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("storageCompactThroughputBurst").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::storageCompactThroughputBurst)).setter(InfluxDBv2Parameters.setter(Builder::storageCompactThroughputBurst)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCompactThroughputBurst").build()}).build();
    private static final SdkField<Integer> STORAGE_MAX_CONCURRENT_COMPACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageMaxConcurrentCompactions").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::storageMaxConcurrentCompactions)).setter(InfluxDBv2Parameters.setter(Builder::storageMaxConcurrentCompactions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageMaxConcurrentCompactions").build()}).build();
    private static final SdkField<Long> STORAGE_MAX_INDEX_LOG_FILE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("storageMaxIndexLogFileSize").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::storageMaxIndexLogFileSize)).setter(InfluxDBv2Parameters.setter(Builder::storageMaxIndexLogFileSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageMaxIndexLogFileSize").build()}).build();
    private static final SdkField<Boolean> STORAGE_NO_VALIDATE_FIELD_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("storageNoValidateFieldSize").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::storageNoValidateFieldSize)).setter(InfluxDBv2Parameters.setter(Builder::storageNoValidateFieldSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageNoValidateFieldSize").build()}).build();
    private static final SdkField<Duration> STORAGE_RETENTION_CHECK_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageRetentionCheckInterval").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::storageRetentionCheckInterval)).setter(InfluxDBv2Parameters.setter(Builder::storageRetentionCheckInterval)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageRetentionCheckInterval").build()}).build();
    private static final SdkField<Integer> STORAGE_SERIES_FILE_MAX_CONCURRENT_SNAPSHOT_COMPACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageSeriesFileMaxConcurrentSnapshotCompactions").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::storageSeriesFileMaxConcurrentSnapshotCompactions)).setter(InfluxDBv2Parameters.setter(Builder::storageSeriesFileMaxConcurrentSnapshotCompactions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageSeriesFileMaxConcurrentSnapshotCompactions").build()}).build();
    private static final SdkField<Long> STORAGE_SERIES_ID_SET_CACHE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("storageSeriesIdSetCacheSize").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::storageSeriesIdSetCacheSize)).setter(InfluxDBv2Parameters.setter(Builder::storageSeriesIdSetCacheSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageSeriesIdSetCacheSize").build()}).build();
    private static final SdkField<Integer> STORAGE_WAL_MAX_CONCURRENT_WRITES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageWalMaxConcurrentWrites").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::storageWalMaxConcurrentWrites)).setter(InfluxDBv2Parameters.setter(Builder::storageWalMaxConcurrentWrites)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageWalMaxConcurrentWrites").build()}).build();
    private static final SdkField<Duration> STORAGE_WAL_MAX_WRITE_DELAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageWalMaxWriteDelay").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::storageWalMaxWriteDelay)).setter(InfluxDBv2Parameters.setter(Builder::storageWalMaxWriteDelay)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageWalMaxWriteDelay").build()}).build();
    private static final SdkField<Boolean> UI_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("uiDisabled").getter(InfluxDBv2Parameters.getter(InfluxDBv2Parameters::uiDisabled)).setter(InfluxDBv2Parameters.setter(Builder::uiDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uiDisabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLUX_LOG_ENABLED_FIELD, LOG_LEVEL_FIELD, NO_TASKS_FIELD, QUERY_CONCURRENCY_FIELD, QUERY_QUEUE_SIZE_FIELD, TRACING_TYPE_FIELD, METRICS_DISABLED_FIELD, HTTP_IDLE_TIMEOUT_FIELD, HTTP_READ_HEADER_TIMEOUT_FIELD, HTTP_READ_TIMEOUT_FIELD, HTTP_WRITE_TIMEOUT_FIELD, INFLUXQL_MAX_SELECT_BUCKETS_FIELD, INFLUXQL_MAX_SELECT_POINT_FIELD, INFLUXQL_MAX_SELECT_SERIES_FIELD, PPROF_DISABLED_FIELD, QUERY_INITIAL_MEMORY_BYTES_FIELD, QUERY_MAX_MEMORY_BYTES_FIELD, QUERY_MEMORY_BYTES_FIELD, SESSION_LENGTH_FIELD, SESSION_RENEW_DISABLED_FIELD, STORAGE_CACHE_MAX_MEMORY_SIZE_FIELD, STORAGE_CACHE_SNAPSHOT_MEMORY_SIZE_FIELD, STORAGE_CACHE_SNAPSHOT_WRITE_COLD_DURATION_FIELD, STORAGE_COMPACT_FULL_WRITE_COLD_DURATION_FIELD, STORAGE_COMPACT_THROUGHPUT_BURST_FIELD, STORAGE_MAX_CONCURRENT_COMPACTIONS_FIELD, STORAGE_MAX_INDEX_LOG_FILE_SIZE_FIELD, STORAGE_NO_VALIDATE_FIELD_SIZE_FIELD, STORAGE_RETENTION_CHECK_INTERVAL_FIELD, STORAGE_SERIES_FILE_MAX_CONCURRENT_SNAPSHOT_COMPACTIONS_FIELD, STORAGE_SERIES_ID_SET_CACHE_SIZE_FIELD, STORAGE_WAL_MAX_CONCURRENT_WRITES_FIELD, STORAGE_WAL_MAX_WRITE_DELAY_FIELD, UI_DISABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InfluxDBv2Parameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean fluxLogEnabled;
    private final String logLevel;
    private final Boolean noTasks;
    private final Integer queryConcurrency;
    private final Integer queryQueueSize;
    private final String tracingType;
    private final Boolean metricsDisabled;
    private final Duration httpIdleTimeout;
    private final Duration httpReadHeaderTimeout;
    private final Duration httpReadTimeout;
    private final Duration httpWriteTimeout;
    private final Long influxqlMaxSelectBuckets;
    private final Long influxqlMaxSelectPoint;
    private final Long influxqlMaxSelectSeries;
    private final Boolean pprofDisabled;
    private final Long queryInitialMemoryBytes;
    private final Long queryMaxMemoryBytes;
    private final Long queryMemoryBytes;
    private final Integer sessionLength;
    private final Boolean sessionRenewDisabled;
    private final Long storageCacheMaxMemorySize;
    private final Long storageCacheSnapshotMemorySize;
    private final Duration storageCacheSnapshotWriteColdDuration;
    private final Duration storageCompactFullWriteColdDuration;
    private final Long storageCompactThroughputBurst;
    private final Integer storageMaxConcurrentCompactions;
    private final Long storageMaxIndexLogFileSize;
    private final Boolean storageNoValidateFieldSize;
    private final Duration storageRetentionCheckInterval;
    private final Integer storageSeriesFileMaxConcurrentSnapshotCompactions;
    private final Long storageSeriesIdSetCacheSize;
    private final Integer storageWalMaxConcurrentWrites;
    private final Duration storageWalMaxWriteDelay;
    private final Boolean uiDisabled;

    private InfluxDBv2Parameters(BuilderImpl builder) {
        this.fluxLogEnabled = builder.fluxLogEnabled;
        this.logLevel = builder.logLevel;
        this.noTasks = builder.noTasks;
        this.queryConcurrency = builder.queryConcurrency;
        this.queryQueueSize = builder.queryQueueSize;
        this.tracingType = builder.tracingType;
        this.metricsDisabled = builder.metricsDisabled;
        this.httpIdleTimeout = builder.httpIdleTimeout;
        this.httpReadHeaderTimeout = builder.httpReadHeaderTimeout;
        this.httpReadTimeout = builder.httpReadTimeout;
        this.httpWriteTimeout = builder.httpWriteTimeout;
        this.influxqlMaxSelectBuckets = builder.influxqlMaxSelectBuckets;
        this.influxqlMaxSelectPoint = builder.influxqlMaxSelectPoint;
        this.influxqlMaxSelectSeries = builder.influxqlMaxSelectSeries;
        this.pprofDisabled = builder.pprofDisabled;
        this.queryInitialMemoryBytes = builder.queryInitialMemoryBytes;
        this.queryMaxMemoryBytes = builder.queryMaxMemoryBytes;
        this.queryMemoryBytes = builder.queryMemoryBytes;
        this.sessionLength = builder.sessionLength;
        this.sessionRenewDisabled = builder.sessionRenewDisabled;
        this.storageCacheMaxMemorySize = builder.storageCacheMaxMemorySize;
        this.storageCacheSnapshotMemorySize = builder.storageCacheSnapshotMemorySize;
        this.storageCacheSnapshotWriteColdDuration = builder.storageCacheSnapshotWriteColdDuration;
        this.storageCompactFullWriteColdDuration = builder.storageCompactFullWriteColdDuration;
        this.storageCompactThroughputBurst = builder.storageCompactThroughputBurst;
        this.storageMaxConcurrentCompactions = builder.storageMaxConcurrentCompactions;
        this.storageMaxIndexLogFileSize = builder.storageMaxIndexLogFileSize;
        this.storageNoValidateFieldSize = builder.storageNoValidateFieldSize;
        this.storageRetentionCheckInterval = builder.storageRetentionCheckInterval;
        this.storageSeriesFileMaxConcurrentSnapshotCompactions = builder.storageSeriesFileMaxConcurrentSnapshotCompactions;
        this.storageSeriesIdSetCacheSize = builder.storageSeriesIdSetCacheSize;
        this.storageWalMaxConcurrentWrites = builder.storageWalMaxConcurrentWrites;
        this.storageWalMaxWriteDelay = builder.storageWalMaxWriteDelay;
        this.uiDisabled = builder.uiDisabled;
    }

    public final Boolean fluxLogEnabled() {
        return this.fluxLogEnabled;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public final Boolean noTasks() {
        return this.noTasks;
    }

    public final Integer queryConcurrency() {
        return this.queryConcurrency;
    }

    public final Integer queryQueueSize() {
        return this.queryQueueSize;
    }

    public final TracingType tracingType() {
        return TracingType.fromValue(this.tracingType);
    }

    public final String tracingTypeAsString() {
        return this.tracingType;
    }

    public final Boolean metricsDisabled() {
        return this.metricsDisabled;
    }

    public final Duration httpIdleTimeout() {
        return this.httpIdleTimeout;
    }

    public final Duration httpReadHeaderTimeout() {
        return this.httpReadHeaderTimeout;
    }

    public final Duration httpReadTimeout() {
        return this.httpReadTimeout;
    }

    public final Duration httpWriteTimeout() {
        return this.httpWriteTimeout;
    }

    public final Long influxqlMaxSelectBuckets() {
        return this.influxqlMaxSelectBuckets;
    }

    public final Long influxqlMaxSelectPoint() {
        return this.influxqlMaxSelectPoint;
    }

    public final Long influxqlMaxSelectSeries() {
        return this.influxqlMaxSelectSeries;
    }

    public final Boolean pprofDisabled() {
        return this.pprofDisabled;
    }

    public final Long queryInitialMemoryBytes() {
        return this.queryInitialMemoryBytes;
    }

    public final Long queryMaxMemoryBytes() {
        return this.queryMaxMemoryBytes;
    }

    public final Long queryMemoryBytes() {
        return this.queryMemoryBytes;
    }

    public final Integer sessionLength() {
        return this.sessionLength;
    }

    public final Boolean sessionRenewDisabled() {
        return this.sessionRenewDisabled;
    }

    public final Long storageCacheMaxMemorySize() {
        return this.storageCacheMaxMemorySize;
    }

    public final Long storageCacheSnapshotMemorySize() {
        return this.storageCacheSnapshotMemorySize;
    }

    public final Duration storageCacheSnapshotWriteColdDuration() {
        return this.storageCacheSnapshotWriteColdDuration;
    }

    public final Duration storageCompactFullWriteColdDuration() {
        return this.storageCompactFullWriteColdDuration;
    }

    public final Long storageCompactThroughputBurst() {
        return this.storageCompactThroughputBurst;
    }

    public final Integer storageMaxConcurrentCompactions() {
        return this.storageMaxConcurrentCompactions;
    }

    public final Long storageMaxIndexLogFileSize() {
        return this.storageMaxIndexLogFileSize;
    }

    public final Boolean storageNoValidateFieldSize() {
        return this.storageNoValidateFieldSize;
    }

    public final Duration storageRetentionCheckInterval() {
        return this.storageRetentionCheckInterval;
    }

    public final Integer storageSeriesFileMaxConcurrentSnapshotCompactions() {
        return this.storageSeriesFileMaxConcurrentSnapshotCompactions;
    }

    public final Long storageSeriesIdSetCacheSize() {
        return this.storageSeriesIdSetCacheSize;
    }

    public final Integer storageWalMaxConcurrentWrites() {
        return this.storageWalMaxConcurrentWrites;
    }

    public final Duration storageWalMaxWriteDelay() {
        return this.storageWalMaxWriteDelay;
    }

    public final Boolean uiDisabled() {
        return this.uiDisabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fluxLogEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.noTasks());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryQueueSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpIdleTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpReadHeaderTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpReadTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpWriteTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.influxqlMaxSelectBuckets());
        hashCode = 31 * hashCode + Objects.hashCode(this.influxqlMaxSelectPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.influxqlMaxSelectSeries());
        hashCode = 31 * hashCode + Objects.hashCode(this.pprofDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryInitialMemoryBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryMaxMemoryBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryMemoryBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionRenewDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCacheMaxMemorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCacheSnapshotMemorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCacheSnapshotWriteColdDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCompactFullWriteColdDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCompactThroughputBurst());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageMaxConcurrentCompactions());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageMaxIndexLogFileSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageNoValidateFieldSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageRetentionCheckInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageSeriesFileMaxConcurrentSnapshotCompactions());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageSeriesIdSetCacheSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageWalMaxConcurrentWrites());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageWalMaxWriteDelay());
        hashCode = 31 * hashCode + Objects.hashCode(this.uiDisabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InfluxDBv2Parameters)) {
            return false;
        }
        InfluxDBv2Parameters other = (InfluxDBv2Parameters)obj;
        return Objects.equals(this.fluxLogEnabled(), other.fluxLogEnabled()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && Objects.equals(this.noTasks(), other.noTasks()) && Objects.equals(this.queryConcurrency(), other.queryConcurrency()) && Objects.equals(this.queryQueueSize(), other.queryQueueSize()) && Objects.equals(this.tracingTypeAsString(), other.tracingTypeAsString()) && Objects.equals(this.metricsDisabled(), other.metricsDisabled()) && Objects.equals(this.httpIdleTimeout(), other.httpIdleTimeout()) && Objects.equals(this.httpReadHeaderTimeout(), other.httpReadHeaderTimeout()) && Objects.equals(this.httpReadTimeout(), other.httpReadTimeout()) && Objects.equals(this.httpWriteTimeout(), other.httpWriteTimeout()) && Objects.equals(this.influxqlMaxSelectBuckets(), other.influxqlMaxSelectBuckets()) && Objects.equals(this.influxqlMaxSelectPoint(), other.influxqlMaxSelectPoint()) && Objects.equals(this.influxqlMaxSelectSeries(), other.influxqlMaxSelectSeries()) && Objects.equals(this.pprofDisabled(), other.pprofDisabled()) && Objects.equals(this.queryInitialMemoryBytes(), other.queryInitialMemoryBytes()) && Objects.equals(this.queryMaxMemoryBytes(), other.queryMaxMemoryBytes()) && Objects.equals(this.queryMemoryBytes(), other.queryMemoryBytes()) && Objects.equals(this.sessionLength(), other.sessionLength()) && Objects.equals(this.sessionRenewDisabled(), other.sessionRenewDisabled()) && Objects.equals(this.storageCacheMaxMemorySize(), other.storageCacheMaxMemorySize()) && Objects.equals(this.storageCacheSnapshotMemorySize(), other.storageCacheSnapshotMemorySize()) && Objects.equals(this.storageCacheSnapshotWriteColdDuration(), other.storageCacheSnapshotWriteColdDuration()) && Objects.equals(this.storageCompactFullWriteColdDuration(), other.storageCompactFullWriteColdDuration()) && Objects.equals(this.storageCompactThroughputBurst(), other.storageCompactThroughputBurst()) && Objects.equals(this.storageMaxConcurrentCompactions(), other.storageMaxConcurrentCompactions()) && Objects.equals(this.storageMaxIndexLogFileSize(), other.storageMaxIndexLogFileSize()) && Objects.equals(this.storageNoValidateFieldSize(), other.storageNoValidateFieldSize()) && Objects.equals(this.storageRetentionCheckInterval(), other.storageRetentionCheckInterval()) && Objects.equals(this.storageSeriesFileMaxConcurrentSnapshotCompactions(), other.storageSeriesFileMaxConcurrentSnapshotCompactions()) && Objects.equals(this.storageSeriesIdSetCacheSize(), other.storageSeriesIdSetCacheSize()) && Objects.equals(this.storageWalMaxConcurrentWrites(), other.storageWalMaxConcurrentWrites()) && Objects.equals(this.storageWalMaxWriteDelay(), other.storageWalMaxWriteDelay()) && Objects.equals(this.uiDisabled(), other.uiDisabled());
    }

    public final String toString() {
        return ToString.builder((String)"InfluxDBv2Parameters").add("FluxLogEnabled", (Object)this.fluxLogEnabled()).add("LogLevel", (Object)this.logLevelAsString()).add("NoTasks", (Object)this.noTasks()).add("QueryConcurrency", (Object)this.queryConcurrency()).add("QueryQueueSize", (Object)this.queryQueueSize()).add("TracingType", (Object)this.tracingTypeAsString()).add("MetricsDisabled", (Object)this.metricsDisabled()).add("HttpIdleTimeout", (Object)this.httpIdleTimeout()).add("HttpReadHeaderTimeout", (Object)this.httpReadHeaderTimeout()).add("HttpReadTimeout", (Object)this.httpReadTimeout()).add("HttpWriteTimeout", (Object)this.httpWriteTimeout()).add("InfluxqlMaxSelectBuckets", (Object)this.influxqlMaxSelectBuckets()).add("InfluxqlMaxSelectPoint", (Object)this.influxqlMaxSelectPoint()).add("InfluxqlMaxSelectSeries", (Object)this.influxqlMaxSelectSeries()).add("PprofDisabled", (Object)this.pprofDisabled()).add("QueryInitialMemoryBytes", (Object)this.queryInitialMemoryBytes()).add("QueryMaxMemoryBytes", (Object)this.queryMaxMemoryBytes()).add("QueryMemoryBytes", (Object)this.queryMemoryBytes()).add("SessionLength", (Object)this.sessionLength()).add("SessionRenewDisabled", (Object)this.sessionRenewDisabled()).add("StorageCacheMaxMemorySize", (Object)this.storageCacheMaxMemorySize()).add("StorageCacheSnapshotMemorySize", (Object)this.storageCacheSnapshotMemorySize()).add("StorageCacheSnapshotWriteColdDuration", (Object)this.storageCacheSnapshotWriteColdDuration()).add("StorageCompactFullWriteColdDuration", (Object)this.storageCompactFullWriteColdDuration()).add("StorageCompactThroughputBurst", (Object)this.storageCompactThroughputBurst()).add("StorageMaxConcurrentCompactions", (Object)this.storageMaxConcurrentCompactions()).add("StorageMaxIndexLogFileSize", (Object)this.storageMaxIndexLogFileSize()).add("StorageNoValidateFieldSize", (Object)this.storageNoValidateFieldSize()).add("StorageRetentionCheckInterval", (Object)this.storageRetentionCheckInterval()).add("StorageSeriesFileMaxConcurrentSnapshotCompactions", (Object)this.storageSeriesFileMaxConcurrentSnapshotCompactions()).add("StorageSeriesIdSetCacheSize", (Object)this.storageSeriesIdSetCacheSize()).add("StorageWalMaxConcurrentWrites", (Object)this.storageWalMaxConcurrentWrites()).add("StorageWalMaxWriteDelay", (Object)this.storageWalMaxWriteDelay()).add("UiDisabled", (Object)this.uiDisabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fluxLogEnabled": {
                return Optional.ofNullable(clazz.cast(this.fluxLogEnabled()));
            }
            case "logLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "noTasks": {
                return Optional.ofNullable(clazz.cast(this.noTasks()));
            }
            case "queryConcurrency": {
                return Optional.ofNullable(clazz.cast(this.queryConcurrency()));
            }
            case "queryQueueSize": {
                return Optional.ofNullable(clazz.cast(this.queryQueueSize()));
            }
            case "tracingType": {
                return Optional.ofNullable(clazz.cast(this.tracingTypeAsString()));
            }
            case "metricsDisabled": {
                return Optional.ofNullable(clazz.cast(this.metricsDisabled()));
            }
            case "httpIdleTimeout": {
                return Optional.ofNullable(clazz.cast(this.httpIdleTimeout()));
            }
            case "httpReadHeaderTimeout": {
                return Optional.ofNullable(clazz.cast(this.httpReadHeaderTimeout()));
            }
            case "httpReadTimeout": {
                return Optional.ofNullable(clazz.cast(this.httpReadTimeout()));
            }
            case "httpWriteTimeout": {
                return Optional.ofNullable(clazz.cast(this.httpWriteTimeout()));
            }
            case "influxqlMaxSelectBuckets": {
                return Optional.ofNullable(clazz.cast(this.influxqlMaxSelectBuckets()));
            }
            case "influxqlMaxSelectPoint": {
                return Optional.ofNullable(clazz.cast(this.influxqlMaxSelectPoint()));
            }
            case "influxqlMaxSelectSeries": {
                return Optional.ofNullable(clazz.cast(this.influxqlMaxSelectSeries()));
            }
            case "pprofDisabled": {
                return Optional.ofNullable(clazz.cast(this.pprofDisabled()));
            }
            case "queryInitialMemoryBytes": {
                return Optional.ofNullable(clazz.cast(this.queryInitialMemoryBytes()));
            }
            case "queryMaxMemoryBytes": {
                return Optional.ofNullable(clazz.cast(this.queryMaxMemoryBytes()));
            }
            case "queryMemoryBytes": {
                return Optional.ofNullable(clazz.cast(this.queryMemoryBytes()));
            }
            case "sessionLength": {
                return Optional.ofNullable(clazz.cast(this.sessionLength()));
            }
            case "sessionRenewDisabled": {
                return Optional.ofNullable(clazz.cast(this.sessionRenewDisabled()));
            }
            case "storageCacheMaxMemorySize": {
                return Optional.ofNullable(clazz.cast(this.storageCacheMaxMemorySize()));
            }
            case "storageCacheSnapshotMemorySize": {
                return Optional.ofNullable(clazz.cast(this.storageCacheSnapshotMemorySize()));
            }
            case "storageCacheSnapshotWriteColdDuration": {
                return Optional.ofNullable(clazz.cast(this.storageCacheSnapshotWriteColdDuration()));
            }
            case "storageCompactFullWriteColdDuration": {
                return Optional.ofNullable(clazz.cast(this.storageCompactFullWriteColdDuration()));
            }
            case "storageCompactThroughputBurst": {
                return Optional.ofNullable(clazz.cast(this.storageCompactThroughputBurst()));
            }
            case "storageMaxConcurrentCompactions": {
                return Optional.ofNullable(clazz.cast(this.storageMaxConcurrentCompactions()));
            }
            case "storageMaxIndexLogFileSize": {
                return Optional.ofNullable(clazz.cast(this.storageMaxIndexLogFileSize()));
            }
            case "storageNoValidateFieldSize": {
                return Optional.ofNullable(clazz.cast(this.storageNoValidateFieldSize()));
            }
            case "storageRetentionCheckInterval": {
                return Optional.ofNullable(clazz.cast(this.storageRetentionCheckInterval()));
            }
            case "storageSeriesFileMaxConcurrentSnapshotCompactions": {
                return Optional.ofNullable(clazz.cast(this.storageSeriesFileMaxConcurrentSnapshotCompactions()));
            }
            case "storageSeriesIdSetCacheSize": {
                return Optional.ofNullable(clazz.cast(this.storageSeriesIdSetCacheSize()));
            }
            case "storageWalMaxConcurrentWrites": {
                return Optional.ofNullable(clazz.cast(this.storageWalMaxConcurrentWrites()));
            }
            case "storageWalMaxWriteDelay": {
                return Optional.ofNullable(clazz.cast(this.storageWalMaxWriteDelay()));
            }
            case "uiDisabled": {
                return Optional.ofNullable(clazz.cast(this.uiDisabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fluxLogEnabled", FLUX_LOG_ENABLED_FIELD);
        map.put("logLevel", LOG_LEVEL_FIELD);
        map.put("noTasks", NO_TASKS_FIELD);
        map.put("queryConcurrency", QUERY_CONCURRENCY_FIELD);
        map.put("queryQueueSize", QUERY_QUEUE_SIZE_FIELD);
        map.put("tracingType", TRACING_TYPE_FIELD);
        map.put("metricsDisabled", METRICS_DISABLED_FIELD);
        map.put("httpIdleTimeout", HTTP_IDLE_TIMEOUT_FIELD);
        map.put("httpReadHeaderTimeout", HTTP_READ_HEADER_TIMEOUT_FIELD);
        map.put("httpReadTimeout", HTTP_READ_TIMEOUT_FIELD);
        map.put("httpWriteTimeout", HTTP_WRITE_TIMEOUT_FIELD);
        map.put("influxqlMaxSelectBuckets", INFLUXQL_MAX_SELECT_BUCKETS_FIELD);
        map.put("influxqlMaxSelectPoint", INFLUXQL_MAX_SELECT_POINT_FIELD);
        map.put("influxqlMaxSelectSeries", INFLUXQL_MAX_SELECT_SERIES_FIELD);
        map.put("pprofDisabled", PPROF_DISABLED_FIELD);
        map.put("queryInitialMemoryBytes", QUERY_INITIAL_MEMORY_BYTES_FIELD);
        map.put("queryMaxMemoryBytes", QUERY_MAX_MEMORY_BYTES_FIELD);
        map.put("queryMemoryBytes", QUERY_MEMORY_BYTES_FIELD);
        map.put("sessionLength", SESSION_LENGTH_FIELD);
        map.put("sessionRenewDisabled", SESSION_RENEW_DISABLED_FIELD);
        map.put("storageCacheMaxMemorySize", STORAGE_CACHE_MAX_MEMORY_SIZE_FIELD);
        map.put("storageCacheSnapshotMemorySize", STORAGE_CACHE_SNAPSHOT_MEMORY_SIZE_FIELD);
        map.put("storageCacheSnapshotWriteColdDuration", STORAGE_CACHE_SNAPSHOT_WRITE_COLD_DURATION_FIELD);
        map.put("storageCompactFullWriteColdDuration", STORAGE_COMPACT_FULL_WRITE_COLD_DURATION_FIELD);
        map.put("storageCompactThroughputBurst", STORAGE_COMPACT_THROUGHPUT_BURST_FIELD);
        map.put("storageMaxConcurrentCompactions", STORAGE_MAX_CONCURRENT_COMPACTIONS_FIELD);
        map.put("storageMaxIndexLogFileSize", STORAGE_MAX_INDEX_LOG_FILE_SIZE_FIELD);
        map.put("storageNoValidateFieldSize", STORAGE_NO_VALIDATE_FIELD_SIZE_FIELD);
        map.put("storageRetentionCheckInterval", STORAGE_RETENTION_CHECK_INTERVAL_FIELD);
        map.put("storageSeriesFileMaxConcurrentSnapshotCompactions", STORAGE_SERIES_FILE_MAX_CONCURRENT_SNAPSHOT_COMPACTIONS_FIELD);
        map.put("storageSeriesIdSetCacheSize", STORAGE_SERIES_ID_SET_CACHE_SIZE_FIELD);
        map.put("storageWalMaxConcurrentWrites", STORAGE_WAL_MAX_CONCURRENT_WRITES_FIELD);
        map.put("storageWalMaxWriteDelay", STORAGE_WAL_MAX_WRITE_DELAY_FIELD);
        map.put("uiDisabled", UI_DISABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InfluxDBv2Parameters, T> g) {
        return obj -> g.apply((InfluxDBv2Parameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean fluxLogEnabled;
        private String logLevel;
        private Boolean noTasks;
        private Integer queryConcurrency;
        private Integer queryQueueSize;
        private String tracingType;
        private Boolean metricsDisabled;
        private Duration httpIdleTimeout;
        private Duration httpReadHeaderTimeout;
        private Duration httpReadTimeout;
        private Duration httpWriteTimeout;
        private Long influxqlMaxSelectBuckets;
        private Long influxqlMaxSelectPoint;
        private Long influxqlMaxSelectSeries;
        private Boolean pprofDisabled;
        private Long queryInitialMemoryBytes;
        private Long queryMaxMemoryBytes;
        private Long queryMemoryBytes;
        private Integer sessionLength;
        private Boolean sessionRenewDisabled;
        private Long storageCacheMaxMemorySize;
        private Long storageCacheSnapshotMemorySize;
        private Duration storageCacheSnapshotWriteColdDuration;
        private Duration storageCompactFullWriteColdDuration;
        private Long storageCompactThroughputBurst;
        private Integer storageMaxConcurrentCompactions;
        private Long storageMaxIndexLogFileSize;
        private Boolean storageNoValidateFieldSize;
        private Duration storageRetentionCheckInterval;
        private Integer storageSeriesFileMaxConcurrentSnapshotCompactions;
        private Long storageSeriesIdSetCacheSize;
        private Integer storageWalMaxConcurrentWrites;
        private Duration storageWalMaxWriteDelay;
        private Boolean uiDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(InfluxDBv2Parameters model) {
            this.fluxLogEnabled(model.fluxLogEnabled);
            this.logLevel(model.logLevel);
            this.noTasks(model.noTasks);
            this.queryConcurrency(model.queryConcurrency);
            this.queryQueueSize(model.queryQueueSize);
            this.tracingType(model.tracingType);
            this.metricsDisabled(model.metricsDisabled);
            this.httpIdleTimeout(model.httpIdleTimeout);
            this.httpReadHeaderTimeout(model.httpReadHeaderTimeout);
            this.httpReadTimeout(model.httpReadTimeout);
            this.httpWriteTimeout(model.httpWriteTimeout);
            this.influxqlMaxSelectBuckets(model.influxqlMaxSelectBuckets);
            this.influxqlMaxSelectPoint(model.influxqlMaxSelectPoint);
            this.influxqlMaxSelectSeries(model.influxqlMaxSelectSeries);
            this.pprofDisabled(model.pprofDisabled);
            this.queryInitialMemoryBytes(model.queryInitialMemoryBytes);
            this.queryMaxMemoryBytes(model.queryMaxMemoryBytes);
            this.queryMemoryBytes(model.queryMemoryBytes);
            this.sessionLength(model.sessionLength);
            this.sessionRenewDisabled(model.sessionRenewDisabled);
            this.storageCacheMaxMemorySize(model.storageCacheMaxMemorySize);
            this.storageCacheSnapshotMemorySize(model.storageCacheSnapshotMemorySize);
            this.storageCacheSnapshotWriteColdDuration(model.storageCacheSnapshotWriteColdDuration);
            this.storageCompactFullWriteColdDuration(model.storageCompactFullWriteColdDuration);
            this.storageCompactThroughputBurst(model.storageCompactThroughputBurst);
            this.storageMaxConcurrentCompactions(model.storageMaxConcurrentCompactions);
            this.storageMaxIndexLogFileSize(model.storageMaxIndexLogFileSize);
            this.storageNoValidateFieldSize(model.storageNoValidateFieldSize);
            this.storageRetentionCheckInterval(model.storageRetentionCheckInterval);
            this.storageSeriesFileMaxConcurrentSnapshotCompactions(model.storageSeriesFileMaxConcurrentSnapshotCompactions);
            this.storageSeriesIdSetCacheSize(model.storageSeriesIdSetCacheSize);
            this.storageWalMaxConcurrentWrites(model.storageWalMaxConcurrentWrites);
            this.storageWalMaxWriteDelay(model.storageWalMaxWriteDelay);
            this.uiDisabled(model.uiDisabled);
        }

        public final Boolean getFluxLogEnabled() {
            return this.fluxLogEnabled;
        }

        public final void setFluxLogEnabled(Boolean fluxLogEnabled) {
            this.fluxLogEnabled = fluxLogEnabled;
        }

        @Override
        public final Builder fluxLogEnabled(Boolean fluxLogEnabled) {
            this.fluxLogEnabled = fluxLogEnabled;
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final Boolean getNoTasks() {
            return this.noTasks;
        }

        public final void setNoTasks(Boolean noTasks) {
            this.noTasks = noTasks;
        }

        @Override
        public final Builder noTasks(Boolean noTasks) {
            this.noTasks = noTasks;
            return this;
        }

        public final Integer getQueryConcurrency() {
            return this.queryConcurrency;
        }

        public final void setQueryConcurrency(Integer queryConcurrency) {
            this.queryConcurrency = queryConcurrency;
        }

        @Override
        public final Builder queryConcurrency(Integer queryConcurrency) {
            this.queryConcurrency = queryConcurrency;
            return this;
        }

        public final Integer getQueryQueueSize() {
            return this.queryQueueSize;
        }

        public final void setQueryQueueSize(Integer queryQueueSize) {
            this.queryQueueSize = queryQueueSize;
        }

        @Override
        public final Builder queryQueueSize(Integer queryQueueSize) {
            this.queryQueueSize = queryQueueSize;
            return this;
        }

        public final String getTracingType() {
            return this.tracingType;
        }

        public final void setTracingType(String tracingType) {
            this.tracingType = tracingType;
        }

        @Override
        public final Builder tracingType(String tracingType) {
            this.tracingType = tracingType;
            return this;
        }

        @Override
        public final Builder tracingType(TracingType tracingType) {
            this.tracingType(tracingType == null ? null : tracingType.toString());
            return this;
        }

        public final Boolean getMetricsDisabled() {
            return this.metricsDisabled;
        }

        public final void setMetricsDisabled(Boolean metricsDisabled) {
            this.metricsDisabled = metricsDisabled;
        }

        @Override
        public final Builder metricsDisabled(Boolean metricsDisabled) {
            this.metricsDisabled = metricsDisabled;
            return this;
        }

        public final Duration.Builder getHttpIdleTimeout() {
            return this.httpIdleTimeout != null ? this.httpIdleTimeout.toBuilder() : null;
        }

        public final void setHttpIdleTimeout(Duration.BuilderImpl httpIdleTimeout) {
            this.httpIdleTimeout = httpIdleTimeout != null ? httpIdleTimeout.build() : null;
        }

        @Override
        public final Builder httpIdleTimeout(Duration httpIdleTimeout) {
            this.httpIdleTimeout = httpIdleTimeout;
            return this;
        }

        public final Duration.Builder getHttpReadHeaderTimeout() {
            return this.httpReadHeaderTimeout != null ? this.httpReadHeaderTimeout.toBuilder() : null;
        }

        public final void setHttpReadHeaderTimeout(Duration.BuilderImpl httpReadHeaderTimeout) {
            this.httpReadHeaderTimeout = httpReadHeaderTimeout != null ? httpReadHeaderTimeout.build() : null;
        }

        @Override
        public final Builder httpReadHeaderTimeout(Duration httpReadHeaderTimeout) {
            this.httpReadHeaderTimeout = httpReadHeaderTimeout;
            return this;
        }

        public final Duration.Builder getHttpReadTimeout() {
            return this.httpReadTimeout != null ? this.httpReadTimeout.toBuilder() : null;
        }

        public final void setHttpReadTimeout(Duration.BuilderImpl httpReadTimeout) {
            this.httpReadTimeout = httpReadTimeout != null ? httpReadTimeout.build() : null;
        }

        @Override
        public final Builder httpReadTimeout(Duration httpReadTimeout) {
            this.httpReadTimeout = httpReadTimeout;
            return this;
        }

        public final Duration.Builder getHttpWriteTimeout() {
            return this.httpWriteTimeout != null ? this.httpWriteTimeout.toBuilder() : null;
        }

        public final void setHttpWriteTimeout(Duration.BuilderImpl httpWriteTimeout) {
            this.httpWriteTimeout = httpWriteTimeout != null ? httpWriteTimeout.build() : null;
        }

        @Override
        public final Builder httpWriteTimeout(Duration httpWriteTimeout) {
            this.httpWriteTimeout = httpWriteTimeout;
            return this;
        }

        public final Long getInfluxqlMaxSelectBuckets() {
            return this.influxqlMaxSelectBuckets;
        }

        public final void setInfluxqlMaxSelectBuckets(Long influxqlMaxSelectBuckets) {
            this.influxqlMaxSelectBuckets = influxqlMaxSelectBuckets;
        }

        @Override
        public final Builder influxqlMaxSelectBuckets(Long influxqlMaxSelectBuckets) {
            this.influxqlMaxSelectBuckets = influxqlMaxSelectBuckets;
            return this;
        }

        public final Long getInfluxqlMaxSelectPoint() {
            return this.influxqlMaxSelectPoint;
        }

        public final void setInfluxqlMaxSelectPoint(Long influxqlMaxSelectPoint) {
            this.influxqlMaxSelectPoint = influxqlMaxSelectPoint;
        }

        @Override
        public final Builder influxqlMaxSelectPoint(Long influxqlMaxSelectPoint) {
            this.influxqlMaxSelectPoint = influxqlMaxSelectPoint;
            return this;
        }

        public final Long getInfluxqlMaxSelectSeries() {
            return this.influxqlMaxSelectSeries;
        }

        public final void setInfluxqlMaxSelectSeries(Long influxqlMaxSelectSeries) {
            this.influxqlMaxSelectSeries = influxqlMaxSelectSeries;
        }

        @Override
        public final Builder influxqlMaxSelectSeries(Long influxqlMaxSelectSeries) {
            this.influxqlMaxSelectSeries = influxqlMaxSelectSeries;
            return this;
        }

        public final Boolean getPprofDisabled() {
            return this.pprofDisabled;
        }

        public final void setPprofDisabled(Boolean pprofDisabled) {
            this.pprofDisabled = pprofDisabled;
        }

        @Override
        public final Builder pprofDisabled(Boolean pprofDisabled) {
            this.pprofDisabled = pprofDisabled;
            return this;
        }

        public final Long getQueryInitialMemoryBytes() {
            return this.queryInitialMemoryBytes;
        }

        public final void setQueryInitialMemoryBytes(Long queryInitialMemoryBytes) {
            this.queryInitialMemoryBytes = queryInitialMemoryBytes;
        }

        @Override
        public final Builder queryInitialMemoryBytes(Long queryInitialMemoryBytes) {
            this.queryInitialMemoryBytes = queryInitialMemoryBytes;
            return this;
        }

        public final Long getQueryMaxMemoryBytes() {
            return this.queryMaxMemoryBytes;
        }

        public final void setQueryMaxMemoryBytes(Long queryMaxMemoryBytes) {
            this.queryMaxMemoryBytes = queryMaxMemoryBytes;
        }

        @Override
        public final Builder queryMaxMemoryBytes(Long queryMaxMemoryBytes) {
            this.queryMaxMemoryBytes = queryMaxMemoryBytes;
            return this;
        }

        public final Long getQueryMemoryBytes() {
            return this.queryMemoryBytes;
        }

        public final void setQueryMemoryBytes(Long queryMemoryBytes) {
            this.queryMemoryBytes = queryMemoryBytes;
        }

        @Override
        public final Builder queryMemoryBytes(Long queryMemoryBytes) {
            this.queryMemoryBytes = queryMemoryBytes;
            return this;
        }

        public final Integer getSessionLength() {
            return this.sessionLength;
        }

        public final void setSessionLength(Integer sessionLength) {
            this.sessionLength = sessionLength;
        }

        @Override
        public final Builder sessionLength(Integer sessionLength) {
            this.sessionLength = sessionLength;
            return this;
        }

        public final Boolean getSessionRenewDisabled() {
            return this.sessionRenewDisabled;
        }

        public final void setSessionRenewDisabled(Boolean sessionRenewDisabled) {
            this.sessionRenewDisabled = sessionRenewDisabled;
        }

        @Override
        public final Builder sessionRenewDisabled(Boolean sessionRenewDisabled) {
            this.sessionRenewDisabled = sessionRenewDisabled;
            return this;
        }

        public final Long getStorageCacheMaxMemorySize() {
            return this.storageCacheMaxMemorySize;
        }

        public final void setStorageCacheMaxMemorySize(Long storageCacheMaxMemorySize) {
            this.storageCacheMaxMemorySize = storageCacheMaxMemorySize;
        }

        @Override
        public final Builder storageCacheMaxMemorySize(Long storageCacheMaxMemorySize) {
            this.storageCacheMaxMemorySize = storageCacheMaxMemorySize;
            return this;
        }

        public final Long getStorageCacheSnapshotMemorySize() {
            return this.storageCacheSnapshotMemorySize;
        }

        public final void setStorageCacheSnapshotMemorySize(Long storageCacheSnapshotMemorySize) {
            this.storageCacheSnapshotMemorySize = storageCacheSnapshotMemorySize;
        }

        @Override
        public final Builder storageCacheSnapshotMemorySize(Long storageCacheSnapshotMemorySize) {
            this.storageCacheSnapshotMemorySize = storageCacheSnapshotMemorySize;
            return this;
        }

        public final Duration.Builder getStorageCacheSnapshotWriteColdDuration() {
            return this.storageCacheSnapshotWriteColdDuration != null ? this.storageCacheSnapshotWriteColdDuration.toBuilder() : null;
        }

        public final void setStorageCacheSnapshotWriteColdDuration(Duration.BuilderImpl storageCacheSnapshotWriteColdDuration) {
            this.storageCacheSnapshotWriteColdDuration = storageCacheSnapshotWriteColdDuration != null ? storageCacheSnapshotWriteColdDuration.build() : null;
        }

        @Override
        public final Builder storageCacheSnapshotWriteColdDuration(Duration storageCacheSnapshotWriteColdDuration) {
            this.storageCacheSnapshotWriteColdDuration = storageCacheSnapshotWriteColdDuration;
            return this;
        }

        public final Duration.Builder getStorageCompactFullWriteColdDuration() {
            return this.storageCompactFullWriteColdDuration != null ? this.storageCompactFullWriteColdDuration.toBuilder() : null;
        }

        public final void setStorageCompactFullWriteColdDuration(Duration.BuilderImpl storageCompactFullWriteColdDuration) {
            this.storageCompactFullWriteColdDuration = storageCompactFullWriteColdDuration != null ? storageCompactFullWriteColdDuration.build() : null;
        }

        @Override
        public final Builder storageCompactFullWriteColdDuration(Duration storageCompactFullWriteColdDuration) {
            this.storageCompactFullWriteColdDuration = storageCompactFullWriteColdDuration;
            return this;
        }

        public final Long getStorageCompactThroughputBurst() {
            return this.storageCompactThroughputBurst;
        }

        public final void setStorageCompactThroughputBurst(Long storageCompactThroughputBurst) {
            this.storageCompactThroughputBurst = storageCompactThroughputBurst;
        }

        @Override
        public final Builder storageCompactThroughputBurst(Long storageCompactThroughputBurst) {
            this.storageCompactThroughputBurst = storageCompactThroughputBurst;
            return this;
        }

        public final Integer getStorageMaxConcurrentCompactions() {
            return this.storageMaxConcurrentCompactions;
        }

        public final void setStorageMaxConcurrentCompactions(Integer storageMaxConcurrentCompactions) {
            this.storageMaxConcurrentCompactions = storageMaxConcurrentCompactions;
        }

        @Override
        public final Builder storageMaxConcurrentCompactions(Integer storageMaxConcurrentCompactions) {
            this.storageMaxConcurrentCompactions = storageMaxConcurrentCompactions;
            return this;
        }

        public final Long getStorageMaxIndexLogFileSize() {
            return this.storageMaxIndexLogFileSize;
        }

        public final void setStorageMaxIndexLogFileSize(Long storageMaxIndexLogFileSize) {
            this.storageMaxIndexLogFileSize = storageMaxIndexLogFileSize;
        }

        @Override
        public final Builder storageMaxIndexLogFileSize(Long storageMaxIndexLogFileSize) {
            this.storageMaxIndexLogFileSize = storageMaxIndexLogFileSize;
            return this;
        }

        public final Boolean getStorageNoValidateFieldSize() {
            return this.storageNoValidateFieldSize;
        }

        public final void setStorageNoValidateFieldSize(Boolean storageNoValidateFieldSize) {
            this.storageNoValidateFieldSize = storageNoValidateFieldSize;
        }

        @Override
        public final Builder storageNoValidateFieldSize(Boolean storageNoValidateFieldSize) {
            this.storageNoValidateFieldSize = storageNoValidateFieldSize;
            return this;
        }

        public final Duration.Builder getStorageRetentionCheckInterval() {
            return this.storageRetentionCheckInterval != null ? this.storageRetentionCheckInterval.toBuilder() : null;
        }

        public final void setStorageRetentionCheckInterval(Duration.BuilderImpl storageRetentionCheckInterval) {
            this.storageRetentionCheckInterval = storageRetentionCheckInterval != null ? storageRetentionCheckInterval.build() : null;
        }

        @Override
        public final Builder storageRetentionCheckInterval(Duration storageRetentionCheckInterval) {
            this.storageRetentionCheckInterval = storageRetentionCheckInterval;
            return this;
        }

        public final Integer getStorageSeriesFileMaxConcurrentSnapshotCompactions() {
            return this.storageSeriesFileMaxConcurrentSnapshotCompactions;
        }

        public final void setStorageSeriesFileMaxConcurrentSnapshotCompactions(Integer storageSeriesFileMaxConcurrentSnapshotCompactions) {
            this.storageSeriesFileMaxConcurrentSnapshotCompactions = storageSeriesFileMaxConcurrentSnapshotCompactions;
        }

        @Override
        public final Builder storageSeriesFileMaxConcurrentSnapshotCompactions(Integer storageSeriesFileMaxConcurrentSnapshotCompactions) {
            this.storageSeriesFileMaxConcurrentSnapshotCompactions = storageSeriesFileMaxConcurrentSnapshotCompactions;
            return this;
        }

        public final Long getStorageSeriesIdSetCacheSize() {
            return this.storageSeriesIdSetCacheSize;
        }

        public final void setStorageSeriesIdSetCacheSize(Long storageSeriesIdSetCacheSize) {
            this.storageSeriesIdSetCacheSize = storageSeriesIdSetCacheSize;
        }

        @Override
        public final Builder storageSeriesIdSetCacheSize(Long storageSeriesIdSetCacheSize) {
            this.storageSeriesIdSetCacheSize = storageSeriesIdSetCacheSize;
            return this;
        }

        public final Integer getStorageWalMaxConcurrentWrites() {
            return this.storageWalMaxConcurrentWrites;
        }

        public final void setStorageWalMaxConcurrentWrites(Integer storageWalMaxConcurrentWrites) {
            this.storageWalMaxConcurrentWrites = storageWalMaxConcurrentWrites;
        }

        @Override
        public final Builder storageWalMaxConcurrentWrites(Integer storageWalMaxConcurrentWrites) {
            this.storageWalMaxConcurrentWrites = storageWalMaxConcurrentWrites;
            return this;
        }

        public final Duration.Builder getStorageWalMaxWriteDelay() {
            return this.storageWalMaxWriteDelay != null ? this.storageWalMaxWriteDelay.toBuilder() : null;
        }

        public final void setStorageWalMaxWriteDelay(Duration.BuilderImpl storageWalMaxWriteDelay) {
            this.storageWalMaxWriteDelay = storageWalMaxWriteDelay != null ? storageWalMaxWriteDelay.build() : null;
        }

        @Override
        public final Builder storageWalMaxWriteDelay(Duration storageWalMaxWriteDelay) {
            this.storageWalMaxWriteDelay = storageWalMaxWriteDelay;
            return this;
        }

        public final Boolean getUiDisabled() {
            return this.uiDisabled;
        }

        public final void setUiDisabled(Boolean uiDisabled) {
            this.uiDisabled = uiDisabled;
        }

        @Override
        public final Builder uiDisabled(Boolean uiDisabled) {
            this.uiDisabled = uiDisabled;
            return this;
        }

        public InfluxDBv2Parameters build() {
            return new InfluxDBv2Parameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InfluxDBv2Parameters> {
        public Builder fluxLogEnabled(Boolean var1);

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder noTasks(Boolean var1);

        public Builder queryConcurrency(Integer var1);

        public Builder queryQueueSize(Integer var1);

        public Builder tracingType(String var1);

        public Builder tracingType(TracingType var1);

        public Builder metricsDisabled(Boolean var1);

        public Builder httpIdleTimeout(Duration var1);

        default public Builder httpIdleTimeout(Consumer<Duration.Builder> httpIdleTimeout) {
            return this.httpIdleTimeout((Duration)((Duration.Builder)Duration.builder().applyMutation(httpIdleTimeout)).build());
        }

        public Builder httpReadHeaderTimeout(Duration var1);

        default public Builder httpReadHeaderTimeout(Consumer<Duration.Builder> httpReadHeaderTimeout) {
            return this.httpReadHeaderTimeout((Duration)((Duration.Builder)Duration.builder().applyMutation(httpReadHeaderTimeout)).build());
        }

        public Builder httpReadTimeout(Duration var1);

        default public Builder httpReadTimeout(Consumer<Duration.Builder> httpReadTimeout) {
            return this.httpReadTimeout((Duration)((Duration.Builder)Duration.builder().applyMutation(httpReadTimeout)).build());
        }

        public Builder httpWriteTimeout(Duration var1);

        default public Builder httpWriteTimeout(Consumer<Duration.Builder> httpWriteTimeout) {
            return this.httpWriteTimeout((Duration)((Duration.Builder)Duration.builder().applyMutation(httpWriteTimeout)).build());
        }

        public Builder influxqlMaxSelectBuckets(Long var1);

        public Builder influxqlMaxSelectPoint(Long var1);

        public Builder influxqlMaxSelectSeries(Long var1);

        public Builder pprofDisabled(Boolean var1);

        public Builder queryInitialMemoryBytes(Long var1);

        public Builder queryMaxMemoryBytes(Long var1);

        public Builder queryMemoryBytes(Long var1);

        public Builder sessionLength(Integer var1);

        public Builder sessionRenewDisabled(Boolean var1);

        public Builder storageCacheMaxMemorySize(Long var1);

        public Builder storageCacheSnapshotMemorySize(Long var1);

        public Builder storageCacheSnapshotWriteColdDuration(Duration var1);

        default public Builder storageCacheSnapshotWriteColdDuration(Consumer<Duration.Builder> storageCacheSnapshotWriteColdDuration) {
            return this.storageCacheSnapshotWriteColdDuration((Duration)((Duration.Builder)Duration.builder().applyMutation(storageCacheSnapshotWriteColdDuration)).build());
        }

        public Builder storageCompactFullWriteColdDuration(Duration var1);

        default public Builder storageCompactFullWriteColdDuration(Consumer<Duration.Builder> storageCompactFullWriteColdDuration) {
            return this.storageCompactFullWriteColdDuration((Duration)((Duration.Builder)Duration.builder().applyMutation(storageCompactFullWriteColdDuration)).build());
        }

        public Builder storageCompactThroughputBurst(Long var1);

        public Builder storageMaxConcurrentCompactions(Integer var1);

        public Builder storageMaxIndexLogFileSize(Long var1);

        public Builder storageNoValidateFieldSize(Boolean var1);

        public Builder storageRetentionCheckInterval(Duration var1);

        default public Builder storageRetentionCheckInterval(Consumer<Duration.Builder> storageRetentionCheckInterval) {
            return this.storageRetentionCheckInterval((Duration)((Duration.Builder)Duration.builder().applyMutation(storageRetentionCheckInterval)).build());
        }

        public Builder storageSeriesFileMaxConcurrentSnapshotCompactions(Integer var1);

        public Builder storageSeriesIdSetCacheSize(Long var1);

        public Builder storageWalMaxConcurrentWrites(Integer var1);

        public Builder storageWalMaxWriteDelay(Duration var1);

        default public Builder storageWalMaxWriteDelay(Consumer<Duration.Builder> storageWalMaxWriteDelay) {
            return this.storageWalMaxWriteDelay((Duration)((Duration.Builder)Duration.builder().applyMutation(storageWalMaxWriteDelay)).build());
        }

        public Builder uiDisabled(Boolean var1);
    }
}

