/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbInstanceType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbStorageType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DeploymentType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.LogDeliveryConfiguration;
import software.amazon.awssdk.services.timestreaminfluxdb.model.NetworkType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.RequestTagMapCopier;
import software.amazon.awssdk.services.timestreaminfluxdb.model.TimestreamInfluxDbRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.services.timestreaminfluxdb.model.VpcSubnetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDbInstanceRequest
extends TimestreamInfluxDbRequest
implements ToCopyableBuilder<Builder, CreateDbInstanceRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::name)).setter(CreateDbInstanceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::username)).setter(CreateDbInstanceRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("password").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::password)).setter(CreateDbInstanceRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("password").build()}).build();
    private static final SdkField<String> ORGANIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("organization").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::organization)).setter(CreateDbInstanceRequest.setter(Builder::organization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organization").build()}).build();
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucket").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::bucket)).setter(CreateDbInstanceRequest.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()}).build();
    private static final SdkField<String> DB_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbInstanceType").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::dbInstanceTypeAsString)).setter(CreateDbInstanceRequest.setter(Builder::dbInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbInstanceType").build()}).build();
    private static final SdkField<List<String>> VPC_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcSubnetIds").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::vpcSubnetIds)).setter(CreateDbInstanceRequest.setter(Builder::vpcSubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcSecurityGroupIds").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::vpcSecurityGroupIds)).setter(CreateDbInstanceRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publiclyAccessible").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::publiclyAccessible)).setter(CreateDbInstanceRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build()}).build();
    private static final SdkField<String> DB_STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbStorageType").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::dbStorageTypeAsString)).setter(CreateDbInstanceRequest.setter(Builder::dbStorageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbStorageType").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("allocatedStorage").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::allocatedStorage)).setter(CreateDbInstanceRequest.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocatedStorage").build()}).build();
    private static final SdkField<String> DB_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbParameterGroupIdentifier").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::dbParameterGroupIdentifier)).setter(CreateDbInstanceRequest.setter(Builder::dbParameterGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbParameterGroupIdentifier").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentType").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::deploymentTypeAsString)).setter(CreateDbInstanceRequest.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()}).build();
    private static final SdkField<LogDeliveryConfiguration> LOG_DELIVERY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logDeliveryConfiguration").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::logDeliveryConfiguration)).setter(CreateDbInstanceRequest.setter(Builder::logDeliveryConfiguration)).constructor(LogDeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDeliveryConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::tags)).setter(CreateDbInstanceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::port)).setter(CreateDbInstanceRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkType").getter(CreateDbInstanceRequest.getter(CreateDbInstanceRequest::networkTypeAsString)).setter(CreateDbInstanceRequest.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, USERNAME_FIELD, PASSWORD_FIELD, ORGANIZATION_FIELD, BUCKET_FIELD, DB_INSTANCE_TYPE_FIELD, VPC_SUBNET_IDS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, PUBLICLY_ACCESSIBLE_FIELD, DB_STORAGE_TYPE_FIELD, ALLOCATED_STORAGE_FIELD, DB_PARAMETER_GROUP_IDENTIFIER_FIELD, DEPLOYMENT_TYPE_FIELD, LOG_DELIVERY_CONFIGURATION_FIELD, TAGS_FIELD, PORT_FIELD, NETWORK_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDbInstanceRequest.memberNameToFieldInitializer();
    private final String name;
    private final String username;
    private final String password;
    private final String organization;
    private final String bucket;
    private final String dbInstanceType;
    private final List<String> vpcSubnetIds;
    private final List<String> vpcSecurityGroupIds;
    private final Boolean publiclyAccessible;
    private final String dbStorageType;
    private final Integer allocatedStorage;
    private final String dbParameterGroupIdentifier;
    private final String deploymentType;
    private final LogDeliveryConfiguration logDeliveryConfiguration;
    private final Map<String, String> tags;
    private final Integer port;
    private final String networkType;

    private CreateDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.username = builder.username;
        this.password = builder.password;
        this.organization = builder.organization;
        this.bucket = builder.bucket;
        this.dbInstanceType = builder.dbInstanceType;
        this.vpcSubnetIds = builder.vpcSubnetIds;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.dbStorageType = builder.dbStorageType;
        this.allocatedStorage = builder.allocatedStorage;
        this.dbParameterGroupIdentifier = builder.dbParameterGroupIdentifier;
        this.deploymentType = builder.deploymentType;
        this.logDeliveryConfiguration = builder.logDeliveryConfiguration;
        this.tags = builder.tags;
        this.port = builder.port;
        this.networkType = builder.networkType;
    }

    public final String name() {
        return this.name;
    }

    public final String username() {
        return this.username;
    }

    public final String password() {
        return this.password;
    }

    public final String organization() {
        return this.organization;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final DbInstanceType dbInstanceType() {
        return DbInstanceType.fromValue(this.dbInstanceType);
    }

    public final String dbInstanceTypeAsString() {
        return this.dbInstanceType;
    }

    public final boolean hasVpcSubnetIds() {
        return this.vpcSubnetIds != null && !(this.vpcSubnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSubnetIds() {
        return this.vpcSubnetIds;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final DbStorageType dbStorageType() {
        return DbStorageType.fromValue(this.dbStorageType);
    }

    public final String dbStorageTypeAsString() {
        return this.dbStorageType;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final String dbParameterGroupIdentifier() {
        return this.dbParameterGroupIdentifier;
    }

    public final DeploymentType deploymentType() {
        return DeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final LogDeliveryConfiguration logDeliveryConfiguration() {
        return this.logDeliveryConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Integer port() {
        return this.port;
    }

    public final NetworkType networkType() {
        return NetworkType.fromValue(this.networkType);
    }

    public final String networkTypeAsString() {
        return this.networkType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.organization());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSubnetIds() ? this.vpcSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbStorageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbInstanceRequest)) {
            return false;
        }
        CreateDbInstanceRequest other = (CreateDbInstanceRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.organization(), other.organization()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.dbInstanceTypeAsString(), other.dbInstanceTypeAsString()) && this.hasVpcSubnetIds() == other.hasVpcSubnetIds() && Objects.equals(this.vpcSubnetIds(), other.vpcSubnetIds()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.dbStorageTypeAsString(), other.dbStorageTypeAsString()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.dbParameterGroupIdentifier(), other.dbParameterGroupIdentifier()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.logDeliveryConfiguration(), other.logDeliveryConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.networkTypeAsString(), other.networkTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDbInstanceRequest").add("Name", (Object)this.name()).add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("Organization", (Object)this.organization()).add("Bucket", (Object)this.bucket()).add("DbInstanceType", (Object)this.dbInstanceTypeAsString()).add("VpcSubnetIds", this.hasVpcSubnetIds() ? this.vpcSubnetIds() : null).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("DbStorageType", (Object)this.dbStorageTypeAsString()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("DbParameterGroupIdentifier", (Object)this.dbParameterGroupIdentifier()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("LogDeliveryConfiguration", (Object)this.logDeliveryConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).add("Port", (Object)this.port()).add("NetworkType", (Object)this.networkTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "organization": {
                return Optional.ofNullable(clazz.cast(this.organization()));
            }
            case "bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "dbInstanceType": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceTypeAsString()));
            }
            case "vpcSubnetIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSubnetIds()));
            }
            case "vpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "publiclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "dbStorageType": {
                return Optional.ofNullable(clazz.cast(this.dbStorageTypeAsString()));
            }
            case "allocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "dbParameterGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupIdentifier()));
            }
            case "deploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "logDeliveryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logDeliveryConfiguration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "networkType": {
                return Optional.ofNullable(clazz.cast(this.networkTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("username", USERNAME_FIELD);
        map.put("password", PASSWORD_FIELD);
        map.put("organization", ORGANIZATION_FIELD);
        map.put("bucket", BUCKET_FIELD);
        map.put("dbInstanceType", DB_INSTANCE_TYPE_FIELD);
        map.put("vpcSubnetIds", VPC_SUBNET_IDS_FIELD);
        map.put("vpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("publiclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("dbStorageType", DB_STORAGE_TYPE_FIELD);
        map.put("allocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("dbParameterGroupIdentifier", DB_PARAMETER_GROUP_IDENTIFIER_FIELD);
        map.put("deploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("logDeliveryConfiguration", LOG_DELIVERY_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("port", PORT_FIELD);
        map.put("networkType", NETWORK_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDbInstanceRequest, T> g) {
        return obj -> g.apply((CreateDbInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamInfluxDbRequest.BuilderImpl
    implements Builder {
        private String name;
        private String username;
        private String password;
        private String organization;
        private String bucket;
        private String dbInstanceType;
        private List<String> vpcSubnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean publiclyAccessible;
        private String dbStorageType;
        private Integer allocatedStorage;
        private String dbParameterGroupIdentifier;
        private String deploymentType;
        private LogDeliveryConfiguration logDeliveryConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Integer port;
        private String networkType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbInstanceRequest model) {
            super(model);
            this.name(model.name);
            this.username(model.username);
            this.password(model.password);
            this.organization(model.organization);
            this.bucket(model.bucket);
            this.dbInstanceType(model.dbInstanceType);
            this.vpcSubnetIds(model.vpcSubnetIds);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.publiclyAccessible(model.publiclyAccessible);
            this.dbStorageType(model.dbStorageType);
            this.allocatedStorage(model.allocatedStorage);
            this.dbParameterGroupIdentifier(model.dbParameterGroupIdentifier);
            this.deploymentType(model.deploymentType);
            this.logDeliveryConfiguration(model.logDeliveryConfiguration);
            this.tags(model.tags);
            this.port(model.port);
            this.networkType(model.networkType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getOrganization() {
            return this.organization;
        }

        public final void setOrganization(String organization) {
            this.organization = organization;
        }

        @Override
        public final Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getDbInstanceType() {
            return this.dbInstanceType;
        }

        public final void setDbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
        }

        @Override
        public final Builder dbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
            return this;
        }

        @Override
        public final Builder dbInstanceType(DbInstanceType dbInstanceType) {
            this.dbInstanceType(dbInstanceType == null ? null : dbInstanceType.toString());
            return this;
        }

        public final Collection<String> getVpcSubnetIds() {
            if (this.vpcSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSubnetIds;
        }

        public final void setVpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = VpcSubnetIdListCopier.copy(vpcSubnetIds);
        }

        @Override
        public final Builder vpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = VpcSubnetIdListCopier.copy(vpcSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSubnetIds(String ... vpcSubnetIds) {
            this.vpcSubnetIds(Arrays.asList(vpcSubnetIds));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getDbStorageType() {
            return this.dbStorageType;
        }

        public final void setDbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
        }

        @Override
        public final Builder dbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
            return this;
        }

        @Override
        public final Builder dbStorageType(DbStorageType dbStorageType) {
            this.dbStorageType(dbStorageType == null ? null : dbStorageType.toString());
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getDbParameterGroupIdentifier() {
            return this.dbParameterGroupIdentifier;
        }

        public final void setDbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
        }

        @Override
        public final Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final LogDeliveryConfiguration.Builder getLogDeliveryConfiguration() {
            return this.logDeliveryConfiguration != null ? this.logDeliveryConfiguration.toBuilder() : null;
        }

        public final void setLogDeliveryConfiguration(LogDeliveryConfiguration.BuilderImpl logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration != null ? logDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbInstanceRequest build() {
            return new CreateDbInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TimestreamInfluxDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDbInstanceRequest> {
        public Builder name(String var1);

        public Builder username(String var1);

        public Builder password(String var1);

        public Builder organization(String var1);

        public Builder bucket(String var1);

        public Builder dbInstanceType(String var1);

        public Builder dbInstanceType(DbInstanceType var1);

        public Builder vpcSubnetIds(Collection<String> var1);

        public Builder vpcSubnetIds(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder dbStorageType(String var1);

        public Builder dbStorageType(DbStorageType var1);

        public Builder allocatedStorage(Integer var1);

        public Builder dbParameterGroupIdentifier(String var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(DeploymentType var1);

        public Builder logDeliveryConfiguration(LogDeliveryConfiguration var1);

        default public Builder logDeliveryConfiguration(Consumer<LogDeliveryConfiguration.Builder> logDeliveryConfiguration) {
            return this.logDeliveryConfiguration((LogDeliveryConfiguration)((LogDeliveryConfiguration.Builder)LogDeliveryConfiguration.builder().applyMutation(logDeliveryConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder port(Integer var1);

        public Builder networkType(String var1);

        public Builder networkType(NetworkType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

