/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDbClusterResponse extends TimestreamInfluxDbResponse implements
        ToCopyableBuilder<CreateDbClusterResponse.Builder, CreateDbClusterResponse> {
    private static final SdkField<String> DB_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbClusterId").getter(getter(CreateDbClusterResponse::dbClusterId)).setter(setter(Builder::dbClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbClusterId").build()).build();

    private static final SdkField<String> DB_CLUSTER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbClusterStatus").getter(getter(CreateDbClusterResponse::dbClusterStatusAsString))
            .setter(setter(Builder::dbClusterStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbClusterStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_ID_FIELD,
            DB_CLUSTER_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbClusterId;

    private final String dbClusterStatus;

    private CreateDbClusterResponse(BuilderImpl builder) {
        super(builder);
        this.dbClusterId = builder.dbClusterId;
        this.dbClusterStatus = builder.dbClusterStatus;
    }

    /**
     * <p>
     * A service-generated unique identifier.
     * </p>
     * 
     * @return A service-generated unique identifier.
     */
    public final String dbClusterId() {
        return dbClusterId;
    }

    /**
     * <p>
     * The status of the DB cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbClusterStatus}
     * will return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dbClusterStatusAsString}.
     * </p>
     * 
     * @return The status of the DB cluster.
     * @see ClusterStatus
     */
    public final ClusterStatus dbClusterStatus() {
        return ClusterStatus.fromValue(dbClusterStatus);
    }

    /**
     * <p>
     * The status of the DB cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbClusterStatus}
     * will return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dbClusterStatusAsString}.
     * </p>
     * 
     * @return The status of the DB cluster.
     * @see ClusterStatus
     */
    public final String dbClusterStatusAsString() {
        return dbClusterStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbClusterResponse)) {
            return false;
        }
        CreateDbClusterResponse other = (CreateDbClusterResponse) obj;
        return Objects.equals(dbClusterId(), other.dbClusterId())
                && Objects.equals(dbClusterStatusAsString(), other.dbClusterStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDbClusterResponse").add("DbClusterId", dbClusterId())
                .add("DbClusterStatus", dbClusterStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dbClusterId":
            return Optional.ofNullable(clazz.cast(dbClusterId()));
        case "dbClusterStatus":
            return Optional.ofNullable(clazz.cast(dbClusterStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dbClusterId", DB_CLUSTER_ID_FIELD);
        map.put("dbClusterStatus", DB_CLUSTER_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDbClusterResponse, T> g) {
        return obj -> g.apply((CreateDbClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TimestreamInfluxDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDbClusterResponse> {
        /**
         * <p>
         * A service-generated unique identifier.
         * </p>
         * 
         * @param dbClusterId
         *        A service-generated unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterId(String dbClusterId);

        /**
         * <p>
         * The status of the DB cluster.
         * </p>
         * 
         * @param dbClusterStatus
         *        The status of the DB cluster.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder dbClusterStatus(String dbClusterStatus);

        /**
         * <p>
         * The status of the DB cluster.
         * </p>
         * 
         * @param dbClusterStatus
         *        The status of the DB cluster.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder dbClusterStatus(ClusterStatus dbClusterStatus);
    }

    static final class BuilderImpl extends TimestreamInfluxDbResponse.BuilderImpl implements Builder {
        private String dbClusterId;

        private String dbClusterStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbClusterResponse model) {
            super(model);
            dbClusterId(model.dbClusterId);
            dbClusterStatus(model.dbClusterStatus);
        }

        public final String getDbClusterId() {
            return dbClusterId;
        }

        public final void setDbClusterId(String dbClusterId) {
            this.dbClusterId = dbClusterId;
        }

        @Override
        public final Builder dbClusterId(String dbClusterId) {
            this.dbClusterId = dbClusterId;
            return this;
        }

        public final String getDbClusterStatus() {
            return dbClusterStatus;
        }

        public final void setDbClusterStatus(String dbClusterStatus) {
            this.dbClusterStatus = dbClusterStatus;
        }

        @Override
        public final Builder dbClusterStatus(String dbClusterStatus) {
            this.dbClusterStatus = dbClusterStatus;
            return this;
        }

        @Override
        public final Builder dbClusterStatus(ClusterStatus dbClusterStatus) {
            this.dbClusterStatus(dbClusterStatus == null ? null : dbClusterStatus.toString());
            return this;
        }

        @Override
        public CreateDbClusterResponse build() {
            return new CreateDbClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
