/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of a DB instance belonging to a DB cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DbInstanceForClusterSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DbInstanceForClusterSummary.Builder, DbInstanceForClusterSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DbInstanceForClusterSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DbInstanceForClusterSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DbInstanceForClusterSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DbInstanceForClusterSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(DbInstanceForClusterSummary::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(DbInstanceForClusterSummary::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkType").getter(getter(DbInstanceForClusterSummary::networkTypeAsString))
            .setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkType").build()).build();

    private static final SdkField<String> DB_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbInstanceType").getter(getter(DbInstanceForClusterSummary::dbInstanceTypeAsString))
            .setter(setter(Builder::dbInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbInstanceType").build()).build();

    private static final SdkField<String> DB_STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbStorageType").getter(getter(DbInstanceForClusterSummary::dbStorageTypeAsString))
            .setter(setter(Builder::dbStorageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbStorageType").build()).build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("allocatedStorage").getter(getter(DbInstanceForClusterSummary::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocatedStorage").build()).build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentType").getter(getter(DbInstanceForClusterSummary::deploymentTypeAsString))
            .setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()).build();

    private static final SdkField<String> INSTANCE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceMode").getter(getter(DbInstanceForClusterSummary::instanceModeAsString))
            .setter(setter(Builder::instanceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ARN_FIELD, STATUS_FIELD, ENDPOINT_FIELD, PORT_FIELD, NETWORK_TYPE_FIELD, DB_INSTANCE_TYPE_FIELD,
            DB_STORAGE_TYPE_FIELD, ALLOCATED_STORAGE_FIELD, DEPLOYMENT_TYPE_FIELD, INSTANCE_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String arn;

    private final String status;

    private final String endpoint;

    private final Integer port;

    private final String networkType;

    private final String dbInstanceType;

    private final String dbStorageType;

    private final Integer allocatedStorage;

    private final String deploymentType;

    private final String instanceMode;

    private DbInstanceForClusterSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.status = builder.status;
        this.endpoint = builder.endpoint;
        this.port = builder.port;
        this.networkType = builder.networkType;
        this.dbInstanceType = builder.dbInstanceType;
        this.dbStorageType = builder.dbStorageType;
        this.allocatedStorage = builder.allocatedStorage;
        this.deploymentType = builder.deploymentType;
        this.instanceMode = builder.instanceMode;
    }

    /**
     * <p>
     * The service-generated unique identifier of the DB instance.
     * </p>
     * 
     * @return The service-generated unique identifier of the DB instance.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A service-generated name for the DB instance based on the customer-supplied name for the DB cluster.
     * </p>
     * 
     * @return A service-generated name for the DB instance based on the customer-supplied name for the DB cluster.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the DB instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the DB instance.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the DB instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the DB instance.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the DB instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the DB instance.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
     * </p>
     * 
     * @return The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The port number on which InfluxDB accepts connections.
     * </p>
     * 
     * @return The port number on which InfluxDB accepts connections.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * Specifies whether the network type of the Timestream for InfluxDB instance is IPv4, which can communicate over
     * IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link NetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the network type of the Timestream for InfluxDB instance is IPv4, which can communicate
     *         over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
     * @see NetworkType
     */
    public final NetworkType networkType() {
        return NetworkType.fromValue(networkType);
    }

    /**
     * <p>
     * Specifies whether the network type of the Timestream for InfluxDB instance is IPv4, which can communicate over
     * IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link NetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the network type of the Timestream for InfluxDB instance is IPv4, which can communicate
     *         over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
     * @see NetworkType
     */
    public final String networkTypeAsString() {
        return networkType;
    }

    /**
     * <p>
     * The Timestream for InfluxDB instance type to run InfluxDB on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbInstanceType}
     * will return {@link DbInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dbInstanceTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB instance type to run InfluxDB on.
     * @see DbInstanceType
     */
    public final DbInstanceType dbInstanceType() {
        return DbInstanceType.fromValue(dbInstanceType);
    }

    /**
     * <p>
     * The Timestream for InfluxDB instance type to run InfluxDB on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbInstanceType}
     * will return {@link DbInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dbInstanceTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB instance type to run InfluxDB on.
     * @see DbInstanceType
     */
    public final String dbInstanceTypeAsString() {
        return dbInstanceType;
    }

    /**
     * <p>
     * The storage type for your DB instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbStorageType}
     * will return {@link DbStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dbStorageTypeAsString}.
     * </p>
     * 
     * @return The storage type for your DB instance.
     * @see DbStorageType
     */
    public final DbStorageType dbStorageType() {
        return DbStorageType.fromValue(dbStorageType);
    }

    /**
     * <p>
     * The storage type for your DB instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbStorageType}
     * will return {@link DbStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dbStorageTypeAsString}.
     * </p>
     * 
     * @return The storage type for your DB instance.
     * @see DbStorageType
     */
    public final String dbStorageTypeAsString() {
        return dbStorageType;
    }

    /**
     * <p>
     * The amount of storage allocated for your DB storage type in GiB (gibibytes).
     * </p>
     * 
     * @return The amount of storage allocated for your DB storage type in GiB (gibibytes).
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * Specifies the deployment type if applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies the deployment type if applicable.
     * @see DeploymentType
     */
    public final DeploymentType deploymentType() {
        return DeploymentType.fromValue(deploymentType);
    }

    /**
     * <p>
     * Specifies the deployment type if applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies the deployment type if applicable.
     * @see DeploymentType
     */
    public final String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * <p>
     * Specifies the DB instance's role in the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceMode} will
     * return {@link InstanceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceModeAsString}.
     * </p>
     * 
     * @return Specifies the DB instance's role in the cluster.
     * @see InstanceMode
     */
    public final InstanceMode instanceMode() {
        return InstanceMode.fromValue(instanceMode);
    }

    /**
     * <p>
     * Specifies the DB instance's role in the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceMode} will
     * return {@link InstanceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceModeAsString}.
     * </p>
     * 
     * @return Specifies the DB instance's role in the cluster.
     * @see InstanceMode
     */
    public final String instanceModeAsString() {
        return instanceMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(networkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dbStorageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DbInstanceForClusterSummary)) {
            return false;
        }
        DbInstanceForClusterSummary other = (DbInstanceForClusterSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(port(), other.port()) && Objects.equals(networkTypeAsString(), other.networkTypeAsString())
                && Objects.equals(dbInstanceTypeAsString(), other.dbInstanceTypeAsString())
                && Objects.equals(dbStorageTypeAsString(), other.dbStorageTypeAsString())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(instanceModeAsString(), other.instanceModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DbInstanceForClusterSummary").add("Id", id()).add("Name", name()).add("Arn", arn())
                .add("Status", statusAsString()).add("Endpoint", endpoint()).add("Port", port())
                .add("NetworkType", networkTypeAsString()).add("DbInstanceType", dbInstanceTypeAsString())
                .add("DbStorageType", dbStorageTypeAsString()).add("AllocatedStorage", allocatedStorage())
                .add("DeploymentType", deploymentTypeAsString()).add("InstanceMode", instanceModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "networkType":
            return Optional.ofNullable(clazz.cast(networkTypeAsString()));
        case "dbInstanceType":
            return Optional.ofNullable(clazz.cast(dbInstanceTypeAsString()));
        case "dbStorageType":
            return Optional.ofNullable(clazz.cast(dbStorageTypeAsString()));
        case "allocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "deploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "instanceMode":
            return Optional.ofNullable(clazz.cast(instanceModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("port", PORT_FIELD);
        map.put("networkType", NETWORK_TYPE_FIELD);
        map.put("dbInstanceType", DB_INSTANCE_TYPE_FIELD);
        map.put("dbStorageType", DB_STORAGE_TYPE_FIELD);
        map.put("allocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("deploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("instanceMode", INSTANCE_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DbInstanceForClusterSummary, T> g) {
        return obj -> g.apply((DbInstanceForClusterSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DbInstanceForClusterSummary> {
        /**
         * <p>
         * The service-generated unique identifier of the DB instance.
         * </p>
         * 
         * @param id
         *        The service-generated unique identifier of the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A service-generated name for the DB instance based on the customer-supplied name for the DB cluster.
         * </p>
         * 
         * @param name
         *        A service-generated name for the DB instance based on the customer-supplied name for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the DB instance.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the DB instance.
         * </p>
         * 
         * @param status
         *        The status of the DB instance.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the DB instance.
         * </p>
         * 
         * @param status
         *        The status of the DB instance.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
         * </p>
         * 
         * @param endpoint
         *        The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The port number on which InfluxDB accepts connections.
         * </p>
         * 
         * @param port
         *        The port number on which InfluxDB accepts connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Specifies whether the network type of the Timestream for InfluxDB instance is IPv4, which can communicate
         * over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
         * </p>
         * 
         * @param networkType
         *        Specifies whether the network type of the Timestream for InfluxDB instance is IPv4, which can
         *        communicate over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
         * @see NetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkType
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * Specifies whether the network type of the Timestream for InfluxDB instance is IPv4, which can communicate
         * over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
         * </p>
         * 
         * @param networkType
         *        Specifies whether the network type of the Timestream for InfluxDB instance is IPv4, which can
         *        communicate over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
         * @see NetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkType
         */
        Builder networkType(NetworkType networkType);

        /**
         * <p>
         * The Timestream for InfluxDB instance type to run InfluxDB on.
         * </p>
         * 
         * @param dbInstanceType
         *        The Timestream for InfluxDB instance type to run InfluxDB on.
         * @see DbInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbInstanceType
         */
        Builder dbInstanceType(String dbInstanceType);

        /**
         * <p>
         * The Timestream for InfluxDB instance type to run InfluxDB on.
         * </p>
         * 
         * @param dbInstanceType
         *        The Timestream for InfluxDB instance type to run InfluxDB on.
         * @see DbInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbInstanceType
         */
        Builder dbInstanceType(DbInstanceType dbInstanceType);

        /**
         * <p>
         * The storage type for your DB instance.
         * </p>
         * 
         * @param dbStorageType
         *        The storage type for your DB instance.
         * @see DbStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbStorageType
         */
        Builder dbStorageType(String dbStorageType);

        /**
         * <p>
         * The storage type for your DB instance.
         * </p>
         * 
         * @param dbStorageType
         *        The storage type for your DB instance.
         * @see DbStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbStorageType
         */
        Builder dbStorageType(DbStorageType dbStorageType);

        /**
         * <p>
         * The amount of storage allocated for your DB storage type in GiB (gibibytes).
         * </p>
         * 
         * @param allocatedStorage
         *        The amount of storage allocated for your DB storage type in GiB (gibibytes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * Specifies the deployment type if applicable.
         * </p>
         * 
         * @param deploymentType
         *        Specifies the deployment type if applicable.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * Specifies the deployment type if applicable.
         * </p>
         * 
         * @param deploymentType
         *        Specifies the deployment type if applicable.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(DeploymentType deploymentType);

        /**
         * <p>
         * Specifies the DB instance's role in the cluster.
         * </p>
         * 
         * @param instanceMode
         *        Specifies the DB instance's role in the cluster.
         * @see InstanceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMode
         */
        Builder instanceMode(String instanceMode);

        /**
         * <p>
         * Specifies the DB instance's role in the cluster.
         * </p>
         * 
         * @param instanceMode
         *        Specifies the DB instance's role in the cluster.
         * @see InstanceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMode
         */
        Builder instanceMode(InstanceMode instanceMode);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String arn;

        private String status;

        private String endpoint;

        private Integer port;

        private String networkType;

        private String dbInstanceType;

        private String dbStorageType;

        private Integer allocatedStorage;

        private String deploymentType;

        private String instanceMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DbInstanceForClusterSummary model) {
            id(model.id);
            name(model.name);
            arn(model.arn);
            status(model.status);
            endpoint(model.endpoint);
            port(model.port);
            networkType(model.networkType);
            dbInstanceType(model.dbInstanceType);
            dbStorageType(model.dbStorageType);
            allocatedStorage(model.allocatedStorage);
            deploymentType(model.deploymentType);
            instanceMode(model.instanceMode);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final String getDbInstanceType() {
            return dbInstanceType;
        }

        public final void setDbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
        }

        @Override
        public final Builder dbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
            return this;
        }

        @Override
        public final Builder dbInstanceType(DbInstanceType dbInstanceType) {
            this.dbInstanceType(dbInstanceType == null ? null : dbInstanceType.toString());
            return this;
        }

        public final String getDbStorageType() {
            return dbStorageType;
        }

        public final void setDbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
        }

        @Override
        public final Builder dbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
            return this;
        }

        @Override
        public final Builder dbStorageType(DbStorageType dbStorageType) {
            this.dbStorageType(dbStorageType == null ? null : dbStorageType.toString());
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final String getInstanceMode() {
            return instanceMode;
        }

        public final void setInstanceMode(String instanceMode) {
            this.instanceMode = instanceMode;
        }

        @Override
        public final Builder instanceMode(String instanceMode) {
            this.instanceMode = instanceMode;
            return this;
        }

        @Override
        public final Builder instanceMode(InstanceMode instanceMode) {
            this.instanceMode(instanceMode == null ? null : instanceMode.toString());
            return this;
        }

        @Override
        public DbInstanceForClusterSummary build() {
            return new DbInstanceForClusterSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
