/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDbClusterResponse extends TimestreamInfluxDbResponse implements
        ToCopyableBuilder<GetDbClusterResponse.Builder, GetDbClusterResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetDbClusterResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetDbClusterResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetDbClusterResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetDbClusterResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(GetDbClusterResponse::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<String> READER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("readerEndpoint").getter(getter(GetDbClusterResponse::readerEndpoint))
            .setter(setter(Builder::readerEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readerEndpoint").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(GetDbClusterResponse::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentType").getter(getter(GetDbClusterResponse::deploymentTypeAsString))
            .setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()).build();

    private static final SdkField<String> DB_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbInstanceType").getter(getter(GetDbClusterResponse::dbInstanceTypeAsString))
            .setter(setter(Builder::dbInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbInstanceType").build()).build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkType").getter(getter(GetDbClusterResponse::networkTypeAsString))
            .setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkType").build()).build();

    private static final SdkField<String> DB_STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbStorageType").getter(getter(GetDbClusterResponse::dbStorageTypeAsString))
            .setter(setter(Builder::dbStorageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbStorageType").build()).build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("allocatedStorage").getter(getter(GetDbClusterResponse::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocatedStorage").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publiclyAccessible").getter(getter(GetDbClusterResponse::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build())
            .build();

    private static final SdkField<String> DB_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("dbParameterGroupIdentifier")
            .getter(getter(GetDbClusterResponse::dbParameterGroupIdentifier))
            .setter(setter(Builder::dbParameterGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbParameterGroupIdentifier").build())
            .build();

    private static final SdkField<LogDeliveryConfiguration> LOG_DELIVERY_CONFIGURATION_FIELD = SdkField
            .<LogDeliveryConfiguration> builder(MarshallingType.SDK_POJO).memberName("logDeliveryConfiguration")
            .getter(getter(GetDbClusterResponse::logDeliveryConfiguration)).setter(setter(Builder::logDeliveryConfiguration))
            .constructor(LogDeliveryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDeliveryConfiguration").build())
            .build();

    private static final SdkField<String> INFLUX_AUTH_PARAMETERS_SECRET_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("influxAuthParametersSecretArn")
            .getter(getter(GetDbClusterResponse::influxAuthParametersSecretArn))
            .setter(setter(Builder::influxAuthParametersSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("influxAuthParametersSecretArn")
                    .build()).build();

    private static final SdkField<List<String>> VPC_SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpcSubnetIds")
            .getter(getter(GetDbClusterResponse::vpcSubnetIds))
            .setter(setter(Builder::vpcSubnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpcSecurityGroupIds")
            .getter(getter(GetDbClusterResponse::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FAILOVER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failoverMode").getter(getter(GetDbClusterResponse::failoverModeAsString))
            .setter(setter(Builder::failoverMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failoverMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ARN_FIELD, STATUS_FIELD, ENDPOINT_FIELD, READER_ENDPOINT_FIELD, PORT_FIELD, DEPLOYMENT_TYPE_FIELD,
            DB_INSTANCE_TYPE_FIELD, NETWORK_TYPE_FIELD, DB_STORAGE_TYPE_FIELD, ALLOCATED_STORAGE_FIELD,
            PUBLICLY_ACCESSIBLE_FIELD, DB_PARAMETER_GROUP_IDENTIFIER_FIELD, LOG_DELIVERY_CONFIGURATION_FIELD,
            INFLUX_AUTH_PARAMETERS_SECRET_ARN_FIELD, VPC_SUBNET_IDS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, FAILOVER_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final String arn;

    private final String status;

    private final String endpoint;

    private final String readerEndpoint;

    private final Integer port;

    private final String deploymentType;

    private final String dbInstanceType;

    private final String networkType;

    private final String dbStorageType;

    private final Integer allocatedStorage;

    private final Boolean publiclyAccessible;

    private final String dbParameterGroupIdentifier;

    private final LogDeliveryConfiguration logDeliveryConfiguration;

    private final String influxAuthParametersSecretArn;

    private final List<String> vpcSubnetIds;

    private final List<String> vpcSecurityGroupIds;

    private final String failoverMode;

    private GetDbClusterResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.status = builder.status;
        this.endpoint = builder.endpoint;
        this.readerEndpoint = builder.readerEndpoint;
        this.port = builder.port;
        this.deploymentType = builder.deploymentType;
        this.dbInstanceType = builder.dbInstanceType;
        this.networkType = builder.networkType;
        this.dbStorageType = builder.dbStorageType;
        this.allocatedStorage = builder.allocatedStorage;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.dbParameterGroupIdentifier = builder.dbParameterGroupIdentifier;
        this.logDeliveryConfiguration = builder.logDeliveryConfiguration;
        this.influxAuthParametersSecretArn = builder.influxAuthParametersSecretArn;
        this.vpcSubnetIds = builder.vpcSubnetIds;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.failoverMode = builder.failoverMode;
    }

    /**
     * <p>
     * Service-generated unique identifier of the DB cluster to retrieve.
     * </p>
     * 
     * @return Service-generated unique identifier of the DB cluster to retrieve.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Customer-supplied name of the Timestream for InfluxDB cluster.
     * </p>
     * 
     * @return Customer-supplied name of the Timestream for InfluxDB cluster.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the DB cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the DB cluster.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the DB cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the DB cluster.
     * @see ClusterStatus
     */
    public final ClusterStatus status() {
        return ClusterStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the DB cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the DB cluster.
     * @see ClusterStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The endpoint used to connect to the Timestream for InfluxDB cluster for write and read operations.
     * </p>
     * 
     * @return The endpoint used to connect to the Timestream for InfluxDB cluster for write and read operations.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The endpoint used to connect to the Timestream for InfluxDB cluster for read-only operations.
     * </p>
     * 
     * @return The endpoint used to connect to the Timestream for InfluxDB cluster for read-only operations.
     */
    public final String readerEndpoint() {
        return readerEndpoint;
    }

    /**
     * <p>
     * The port number on which InfluxDB accepts connections.
     * </p>
     * 
     * @return The port number on which InfluxDB accepts connections.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * Deployment type of the DB cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link ClusterDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Deployment type of the DB cluster.
     * @see ClusterDeploymentType
     */
    public final ClusterDeploymentType deploymentType() {
        return ClusterDeploymentType.fromValue(deploymentType);
    }

    /**
     * <p>
     * Deployment type of the DB cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link ClusterDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Deployment type of the DB cluster.
     * @see ClusterDeploymentType
     */
    public final String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * <p>
     * The Timestream for InfluxDB instance type that InfluxDB runs on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbInstanceType}
     * will return {@link DbInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dbInstanceTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB instance type that InfluxDB runs on.
     * @see DbInstanceType
     */
    public final DbInstanceType dbInstanceType() {
        return DbInstanceType.fromValue(dbInstanceType);
    }

    /**
     * <p>
     * The Timestream for InfluxDB instance type that InfluxDB runs on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbInstanceType}
     * will return {@link DbInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dbInstanceTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB instance type that InfluxDB runs on.
     * @see DbInstanceType
     */
    public final String dbInstanceTypeAsString() {
        return dbInstanceType;
    }

    /**
     * <p>
     * Specifies whether the network type of the Timestream for InfluxDB cluster is IPv4, which can communicate over
     * IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link NetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the network type of the Timestream for InfluxDB cluster is IPv4, which can communicate
     *         over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
     * @see NetworkType
     */
    public final NetworkType networkType() {
        return NetworkType.fromValue(networkType);
    }

    /**
     * <p>
     * Specifies whether the network type of the Timestream for InfluxDB cluster is IPv4, which can communicate over
     * IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link NetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the network type of the Timestream for InfluxDB cluster is IPv4, which can communicate
     *         over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
     * @see NetworkType
     */
    public final String networkTypeAsString() {
        return networkType;
    }

    /**
     * <p>
     * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbStorageType}
     * will return {@link DbStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dbStorageTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
     * @see DbStorageType
     */
    public final DbStorageType dbStorageType() {
        return DbStorageType.fromValue(dbStorageType);
    }

    /**
     * <p>
     * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbStorageType}
     * will return {@link DbStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dbStorageTypeAsString}.
     * </p>
     * 
     * @return The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
     * @see DbStorageType
     */
    public final String dbStorageTypeAsString() {
        return dbStorageType;
    }

    /**
     * <p>
     * The amount of storage allocated for your DB storage type (in gibibytes).
     * </p>
     * 
     * @return The amount of storage allocated for your DB storage type (in gibibytes).
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * Indicates if the DB cluster has a public IP to facilitate access from outside the VPC.
     * </p>
     * 
     * @return Indicates if the DB cluster has a public IP to facilitate access from outside the VPC.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * The ID of the DB parameter group assigned to your DB cluster.
     * </p>
     * 
     * @return The ID of the DB parameter group assigned to your DB cluster.
     */
    public final String dbParameterGroupIdentifier() {
        return dbParameterGroupIdentifier;
    }

    /**
     * <p>
     * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
     * </p>
     * 
     * @return Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
     */
    public final LogDeliveryConfiguration logDeliveryConfiguration() {
        return logDeliveryConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Secrets Manager secret containing the initial InfluxDB authorization
     * parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization values:
     * organization, bucket, username, and password.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Secrets Manager secret containing the initial InfluxDB
     *         authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB
     *         authorization values: organization, bucket, username, and password.
     */
    public final String influxAuthParametersSecretArn() {
        return influxAuthParametersSecretArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSubnetIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSubnetIds() {
        return vpcSubnetIds != null && !(vpcSubnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC subnet IDs associated with the DB cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSubnetIds} method.
     * </p>
     * 
     * @return A list of VPC subnet IDs associated with the DB cluster.
     */
    public final List<String> vpcSubnetIds() {
        return vpcSubnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC security group IDs associated with the DB cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of VPC security group IDs associated with the DB cluster.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The configured failover mode for the DB cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failoverMode} will
     * return {@link FailoverMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failoverModeAsString}.
     * </p>
     * 
     * @return The configured failover mode for the DB cluster.
     * @see FailoverMode
     */
    public final FailoverMode failoverMode() {
        return FailoverMode.fromValue(failoverMode);
    }

    /**
     * <p>
     * The configured failover mode for the DB cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failoverMode} will
     * return {@link FailoverMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failoverModeAsString}.
     * </p>
     * 
     * @return The configured failover mode for the DB cluster.
     * @see FailoverMode
     */
    public final String failoverModeAsString() {
        return failoverMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(readerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(networkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dbStorageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(logDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(influxAuthParametersSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSubnetIds() ? vpcSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(failoverModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDbClusterResponse)) {
            return false;
        }
        GetDbClusterResponse other = (GetDbClusterResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(readerEndpoint(), other.readerEndpoint()) && Objects.equals(port(), other.port())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(dbInstanceTypeAsString(), other.dbInstanceTypeAsString())
                && Objects.equals(networkTypeAsString(), other.networkTypeAsString())
                && Objects.equals(dbStorageTypeAsString(), other.dbStorageTypeAsString())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(dbParameterGroupIdentifier(), other.dbParameterGroupIdentifier())
                && Objects.equals(logDeliveryConfiguration(), other.logDeliveryConfiguration())
                && Objects.equals(influxAuthParametersSecretArn(), other.influxAuthParametersSecretArn())
                && hasVpcSubnetIds() == other.hasVpcSubnetIds() && Objects.equals(vpcSubnetIds(), other.vpcSubnetIds())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(failoverModeAsString(), other.failoverModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDbClusterResponse").add("Id", id()).add("Name", name()).add("Arn", arn())
                .add("Status", statusAsString()).add("Endpoint", endpoint()).add("ReaderEndpoint", readerEndpoint())
                .add("Port", port()).add("DeploymentType", deploymentTypeAsString())
                .add("DbInstanceType", dbInstanceTypeAsString()).add("NetworkType", networkTypeAsString())
                .add("DbStorageType", dbStorageTypeAsString()).add("AllocatedStorage", allocatedStorage())
                .add("PubliclyAccessible", publiclyAccessible()).add("DbParameterGroupIdentifier", dbParameterGroupIdentifier())
                .add("LogDeliveryConfiguration", logDeliveryConfiguration())
                .add("InfluxAuthParametersSecretArn", influxAuthParametersSecretArn())
                .add("VpcSubnetIds", hasVpcSubnetIds() ? vpcSubnetIds() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("FailoverMode", failoverModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "readerEndpoint":
            return Optional.ofNullable(clazz.cast(readerEndpoint()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "deploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "dbInstanceType":
            return Optional.ofNullable(clazz.cast(dbInstanceTypeAsString()));
        case "networkType":
            return Optional.ofNullable(clazz.cast(networkTypeAsString()));
        case "dbStorageType":
            return Optional.ofNullable(clazz.cast(dbStorageTypeAsString()));
        case "allocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "publiclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "dbParameterGroupIdentifier":
            return Optional.ofNullable(clazz.cast(dbParameterGroupIdentifier()));
        case "logDeliveryConfiguration":
            return Optional.ofNullable(clazz.cast(logDeliveryConfiguration()));
        case "influxAuthParametersSecretArn":
            return Optional.ofNullable(clazz.cast(influxAuthParametersSecretArn()));
        case "vpcSubnetIds":
            return Optional.ofNullable(clazz.cast(vpcSubnetIds()));
        case "vpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "failoverMode":
            return Optional.ofNullable(clazz.cast(failoverModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("readerEndpoint", READER_ENDPOINT_FIELD);
        map.put("port", PORT_FIELD);
        map.put("deploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("dbInstanceType", DB_INSTANCE_TYPE_FIELD);
        map.put("networkType", NETWORK_TYPE_FIELD);
        map.put("dbStorageType", DB_STORAGE_TYPE_FIELD);
        map.put("allocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("publiclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("dbParameterGroupIdentifier", DB_PARAMETER_GROUP_IDENTIFIER_FIELD);
        map.put("logDeliveryConfiguration", LOG_DELIVERY_CONFIGURATION_FIELD);
        map.put("influxAuthParametersSecretArn", INFLUX_AUTH_PARAMETERS_SECRET_ARN_FIELD);
        map.put("vpcSubnetIds", VPC_SUBNET_IDS_FIELD);
        map.put("vpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("failoverMode", FAILOVER_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDbClusterResponse, T> g) {
        return obj -> g.apply((GetDbClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TimestreamInfluxDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDbClusterResponse> {
        /**
         * <p>
         * Service-generated unique identifier of the DB cluster to retrieve.
         * </p>
         * 
         * @param id
         *        Service-generated unique identifier of the DB cluster to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Customer-supplied name of the Timestream for InfluxDB cluster.
         * </p>
         * 
         * @param name
         *        Customer-supplied name of the Timestream for InfluxDB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the DB cluster.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the DB cluster.
         * </p>
         * 
         * @param status
         *        The status of the DB cluster.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the DB cluster.
         * </p>
         * 
         * @param status
         *        The status of the DB cluster.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder status(ClusterStatus status);

        /**
         * <p>
         * The endpoint used to connect to the Timestream for InfluxDB cluster for write and read operations.
         * </p>
         * 
         * @param endpoint
         *        The endpoint used to connect to the Timestream for InfluxDB cluster for write and read operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The endpoint used to connect to the Timestream for InfluxDB cluster for read-only operations.
         * </p>
         * 
         * @param readerEndpoint
         *        The endpoint used to connect to the Timestream for InfluxDB cluster for read-only operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readerEndpoint(String readerEndpoint);

        /**
         * <p>
         * The port number on which InfluxDB accepts connections.
         * </p>
         * 
         * @param port
         *        The port number on which InfluxDB accepts connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Deployment type of the DB cluster.
         * </p>
         * 
         * @param deploymentType
         *        Deployment type of the DB cluster.
         * @see ClusterDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterDeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * Deployment type of the DB cluster.
         * </p>
         * 
         * @param deploymentType
         *        Deployment type of the DB cluster.
         * @see ClusterDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterDeploymentType
         */
        Builder deploymentType(ClusterDeploymentType deploymentType);

        /**
         * <p>
         * The Timestream for InfluxDB instance type that InfluxDB runs on.
         * </p>
         * 
         * @param dbInstanceType
         *        The Timestream for InfluxDB instance type that InfluxDB runs on.
         * @see DbInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbInstanceType
         */
        Builder dbInstanceType(String dbInstanceType);

        /**
         * <p>
         * The Timestream for InfluxDB instance type that InfluxDB runs on.
         * </p>
         * 
         * @param dbInstanceType
         *        The Timestream for InfluxDB instance type that InfluxDB runs on.
         * @see DbInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbInstanceType
         */
        Builder dbInstanceType(DbInstanceType dbInstanceType);

        /**
         * <p>
         * Specifies whether the network type of the Timestream for InfluxDB cluster is IPv4, which can communicate over
         * IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
         * </p>
         * 
         * @param networkType
         *        Specifies whether the network type of the Timestream for InfluxDB cluster is IPv4, which can
         *        communicate over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
         * @see NetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkType
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * Specifies whether the network type of the Timestream for InfluxDB cluster is IPv4, which can communicate over
         * IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
         * </p>
         * 
         * @param networkType
         *        Specifies whether the network type of the Timestream for InfluxDB cluster is IPv4, which can
         *        communicate over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
         * @see NetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkType
         */
        Builder networkType(NetworkType networkType);

        /**
         * <p>
         * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
         * </p>
         * 
         * @param dbStorageType
         *        The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
         * @see DbStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbStorageType
         */
        Builder dbStorageType(String dbStorageType);

        /**
         * <p>
         * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
         * </p>
         * 
         * @param dbStorageType
         *        The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
         * @see DbStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbStorageType
         */
        Builder dbStorageType(DbStorageType dbStorageType);

        /**
         * <p>
         * The amount of storage allocated for your DB storage type (in gibibytes).
         * </p>
         * 
         * @param allocatedStorage
         *        The amount of storage allocated for your DB storage type (in gibibytes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * Indicates if the DB cluster has a public IP to facilitate access from outside the VPC.
         * </p>
         * 
         * @param publiclyAccessible
         *        Indicates if the DB cluster has a public IP to facilitate access from outside the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The ID of the DB parameter group assigned to your DB cluster.
         * </p>
         * 
         * @param dbParameterGroupIdentifier
         *        The ID of the DB parameter group assigned to your DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier);

        /**
         * <p>
         * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
         * </p>
         * 
         * @param logDeliveryConfiguration
         *        Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration);

        /**
         * <p>
         * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogDeliveryConfiguration.Builder}
         * avoiding the need to create one manually via {@link LogDeliveryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogDeliveryConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #logDeliveryConfiguration(LogDeliveryConfiguration)}.
         * 
         * @param logDeliveryConfiguration
         *        a consumer that will call methods on {@link LogDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryConfiguration(LogDeliveryConfiguration)
         */
        default Builder logDeliveryConfiguration(Consumer<LogDeliveryConfiguration.Builder> logDeliveryConfiguration) {
            return logDeliveryConfiguration(LogDeliveryConfiguration.builder().applyMutation(logDeliveryConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Secrets Manager secret containing the initial InfluxDB authorization
         * parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization values:
         * organization, bucket, username, and password.
         * </p>
         * 
         * @param influxAuthParametersSecretArn
         *        The Amazon Resource Name (ARN) of the Secrets Manager secret containing the initial InfluxDB
         *        authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB
         *        authorization values: organization, bucket, username, and password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder influxAuthParametersSecretArn(String influxAuthParametersSecretArn);

        /**
         * <p>
         * A list of VPC subnet IDs associated with the DB cluster.
         * </p>
         * 
         * @param vpcSubnetIds
         *        A list of VPC subnet IDs associated with the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSubnetIds(Collection<String> vpcSubnetIds);

        /**
         * <p>
         * A list of VPC subnet IDs associated with the DB cluster.
         * </p>
         * 
         * @param vpcSubnetIds
         *        A list of VPC subnet IDs associated with the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSubnetIds(String... vpcSubnetIds);

        /**
         * <p>
         * A list of VPC security group IDs associated with the DB cluster.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security group IDs associated with the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of VPC security group IDs associated with the DB cluster.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security group IDs associated with the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The configured failover mode for the DB cluster.
         * </p>
         * 
         * @param failoverMode
         *        The configured failover mode for the DB cluster.
         * @see FailoverMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailoverMode
         */
        Builder failoverMode(String failoverMode);

        /**
         * <p>
         * The configured failover mode for the DB cluster.
         * </p>
         * 
         * @param failoverMode
         *        The configured failover mode for the DB cluster.
         * @see FailoverMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailoverMode
         */
        Builder failoverMode(FailoverMode failoverMode);
    }

    static final class BuilderImpl extends TimestreamInfluxDbResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String arn;

        private String status;

        private String endpoint;

        private String readerEndpoint;

        private Integer port;

        private String deploymentType;

        private String dbInstanceType;

        private String networkType;

        private String dbStorageType;

        private Integer allocatedStorage;

        private Boolean publiclyAccessible;

        private String dbParameterGroupIdentifier;

        private LogDeliveryConfiguration logDeliveryConfiguration;

        private String influxAuthParametersSecretArn;

        private List<String> vpcSubnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String failoverMode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDbClusterResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            arn(model.arn);
            status(model.status);
            endpoint(model.endpoint);
            readerEndpoint(model.readerEndpoint);
            port(model.port);
            deploymentType(model.deploymentType);
            dbInstanceType(model.dbInstanceType);
            networkType(model.networkType);
            dbStorageType(model.dbStorageType);
            allocatedStorage(model.allocatedStorage);
            publiclyAccessible(model.publiclyAccessible);
            dbParameterGroupIdentifier(model.dbParameterGroupIdentifier);
            logDeliveryConfiguration(model.logDeliveryConfiguration);
            influxAuthParametersSecretArn(model.influxAuthParametersSecretArn);
            vpcSubnetIds(model.vpcSubnetIds);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            failoverMode(model.failoverMode);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getReaderEndpoint() {
            return readerEndpoint;
        }

        public final void setReaderEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
        }

        @Override
        public final Builder readerEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(ClusterDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final String getDbInstanceType() {
            return dbInstanceType;
        }

        public final void setDbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
        }

        @Override
        public final Builder dbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
            return this;
        }

        @Override
        public final Builder dbInstanceType(DbInstanceType dbInstanceType) {
            this.dbInstanceType(dbInstanceType == null ? null : dbInstanceType.toString());
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final String getDbStorageType() {
            return dbStorageType;
        }

        public final void setDbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
        }

        @Override
        public final Builder dbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
            return this;
        }

        @Override
        public final Builder dbStorageType(DbStorageType dbStorageType) {
            this.dbStorageType(dbStorageType == null ? null : dbStorageType.toString());
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getDbParameterGroupIdentifier() {
            return dbParameterGroupIdentifier;
        }

        public final void setDbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
        }

        @Override
        public final Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
            return this;
        }

        public final LogDeliveryConfiguration.Builder getLogDeliveryConfiguration() {
            return logDeliveryConfiguration != null ? logDeliveryConfiguration.toBuilder() : null;
        }

        public final void setLogDeliveryConfiguration(LogDeliveryConfiguration.BuilderImpl logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration != null ? logDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration;
            return this;
        }

        public final String getInfluxAuthParametersSecretArn() {
            return influxAuthParametersSecretArn;
        }

        public final void setInfluxAuthParametersSecretArn(String influxAuthParametersSecretArn) {
            this.influxAuthParametersSecretArn = influxAuthParametersSecretArn;
        }

        @Override
        public final Builder influxAuthParametersSecretArn(String influxAuthParametersSecretArn) {
            this.influxAuthParametersSecretArn = influxAuthParametersSecretArn;
            return this;
        }

        public final Collection<String> getVpcSubnetIds() {
            if (vpcSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSubnetIds;
        }

        public final void setVpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = VpcSubnetIdListCopier.copy(vpcSubnetIds);
        }

        @Override
        public final Builder vpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = VpcSubnetIdListCopier.copy(vpcSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSubnetIds(String... vpcSubnetIds) {
            vpcSubnetIds(Arrays.asList(vpcSubnetIds));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getFailoverMode() {
            return failoverMode;
        }

        public final void setFailoverMode(String failoverMode) {
            this.failoverMode = failoverMode;
        }

        @Override
        public final Builder failoverMode(String failoverMode) {
            this.failoverMode = failoverMode;
            return this;
        }

        @Override
        public final Builder failoverMode(FailoverMode failoverMode) {
            this.failoverMode(failoverMode == null ? null : failoverMode.toString());
            return this;
        }

        @Override
        public GetDbClusterResponse build() {
            return new GetDbClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
