/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDbParameterGroupResponse extends TimestreamInfluxDbResponse implements
        ToCopyableBuilder<GetDbParameterGroupResponse.Builder, GetDbParameterGroupResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetDbParameterGroupResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetDbParameterGroupResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetDbParameterGroupResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetDbParameterGroupResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Parameters> PARAMETERS_FIELD = SdkField.<Parameters> builder(MarshallingType.SDK_POJO)
            .memberName("parameters").getter(getter(GetDbParameterGroupResponse::parameters)).setter(setter(Builder::parameters))
            .constructor(Parameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ARN_FIELD, DESCRIPTION_FIELD, PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final String arn;

    private final String description;

    private final Parameters parameters;

    private GetDbParameterGroupResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * A service-generated unique identifier.
     * </p>
     * 
     * @return A service-generated unique identifier.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The customer-supplied name that uniquely identifies the DB parameter group when interacting with the Amazon
     * Timestream for InfluxDB API and CLI commands.
     * </p>
     * 
     * @return The customer-supplied name that uniquely identifies the DB parameter group when interacting with the
     *         Amazon Timestream for InfluxDB API and CLI commands.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the DB parameter group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the DB parameter group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A description of the DB parameter group.
     * </p>
     * 
     * @return A description of the DB parameter group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The parameters that comprise the DB parameter group.
     * </p>
     * 
     * @return The parameters that comprise the DB parameter group.
     */
    public final Parameters parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDbParameterGroupResponse)) {
            return false;
        }
        GetDbParameterGroupResponse other = (GetDbParameterGroupResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description()) && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDbParameterGroupResponse").add("Id", id()).add("Name", name()).add("Arn", arn())
                .add("Description", description()).add("Parameters", parameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDbParameterGroupResponse, T> g) {
        return obj -> g.apply((GetDbParameterGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TimestreamInfluxDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDbParameterGroupResponse> {
        /**
         * <p>
         * A service-generated unique identifier.
         * </p>
         * 
         * @param id
         *        A service-generated unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The customer-supplied name that uniquely identifies the DB parameter group when interacting with the Amazon
         * Timestream for InfluxDB API and CLI commands.
         * </p>
         * 
         * @param name
         *        The customer-supplied name that uniquely identifies the DB parameter group when interacting with the
         *        Amazon Timestream for InfluxDB API and CLI commands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the DB parameter group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the DB parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A description of the DB parameter group.
         * </p>
         * 
         * @param description
         *        A description of the DB parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The parameters that comprise the DB parameter group.
         * </p>
         * 
         * @param parameters
         *        The parameters that comprise the DB parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameters parameters);

        /**
         * <p>
         * The parameters that comprise the DB parameter group.
         * </p>
         * This is a convenience method that creates an instance of the {@link Parameters.Builder} avoiding the need to
         * create one manually via {@link Parameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Parameters.Builder#build()} is called immediately and its result
         * is passed to {@link #parameters(Parameters)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link Parameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(Parameters)
         */
        default Builder parameters(Consumer<Parameters.Builder> parameters) {
            return parameters(Parameters.builder().applyMutation(parameters).build());
        }
    }

    static final class BuilderImpl extends TimestreamInfluxDbResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String arn;

        private String description;

        private Parameters parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDbParameterGroupResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            arn(model.arn);
            description(model.description);
            parameters(model.parameters);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Parameters.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        public final void setParameters(Parameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public GetDbParameterGroupResponse build() {
            return new GetDbParameterGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
