/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbInstanceType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbStorageType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DeploymentType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.LogDeliveryConfiguration;
import software.amazon.awssdk.services.timestreaminfluxdb.model.TimestreamInfluxDbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDbInstanceRequest
extends TimestreamInfluxDbRequest
implements ToCopyableBuilder<Builder, UpdateDbInstanceRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(UpdateDbInstanceRequest.getter(UpdateDbInstanceRequest::identifier)).setter(UpdateDbInstanceRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<LogDeliveryConfiguration> LOG_DELIVERY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logDeliveryConfiguration").getter(UpdateDbInstanceRequest.getter(UpdateDbInstanceRequest::logDeliveryConfiguration)).setter(UpdateDbInstanceRequest.setter(Builder::logDeliveryConfiguration)).constructor(LogDeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDeliveryConfiguration").build()}).build();
    private static final SdkField<String> DB_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbParameterGroupIdentifier").getter(UpdateDbInstanceRequest.getter(UpdateDbInstanceRequest::dbParameterGroupIdentifier)).setter(UpdateDbInstanceRequest.setter(Builder::dbParameterGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbParameterGroupIdentifier").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(UpdateDbInstanceRequest.getter(UpdateDbInstanceRequest::port)).setter(UpdateDbInstanceRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> DB_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbInstanceType").getter(UpdateDbInstanceRequest.getter(UpdateDbInstanceRequest::dbInstanceTypeAsString)).setter(UpdateDbInstanceRequest.setter(Builder::dbInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbInstanceType").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentType").getter(UpdateDbInstanceRequest.getter(UpdateDbInstanceRequest::deploymentTypeAsString)).setter(UpdateDbInstanceRequest.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()}).build();
    private static final SdkField<String> DB_STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbStorageType").getter(UpdateDbInstanceRequest.getter(UpdateDbInstanceRequest::dbStorageTypeAsString)).setter(UpdateDbInstanceRequest.setter(Builder::dbStorageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbStorageType").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("allocatedStorage").getter(UpdateDbInstanceRequest.getter(UpdateDbInstanceRequest::allocatedStorage)).setter(UpdateDbInstanceRequest.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocatedStorage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, LOG_DELIVERY_CONFIGURATION_FIELD, DB_PARAMETER_GROUP_IDENTIFIER_FIELD, PORT_FIELD, DB_INSTANCE_TYPE_FIELD, DEPLOYMENT_TYPE_FIELD, DB_STORAGE_TYPE_FIELD, ALLOCATED_STORAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDbInstanceRequest.memberNameToFieldInitializer();
    private final String identifier;
    private final LogDeliveryConfiguration logDeliveryConfiguration;
    private final String dbParameterGroupIdentifier;
    private final Integer port;
    private final String dbInstanceType;
    private final String deploymentType;
    private final String dbStorageType;
    private final Integer allocatedStorage;

    private UpdateDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.logDeliveryConfiguration = builder.logDeliveryConfiguration;
        this.dbParameterGroupIdentifier = builder.dbParameterGroupIdentifier;
        this.port = builder.port;
        this.dbInstanceType = builder.dbInstanceType;
        this.deploymentType = builder.deploymentType;
        this.dbStorageType = builder.dbStorageType;
        this.allocatedStorage = builder.allocatedStorage;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final LogDeliveryConfiguration logDeliveryConfiguration() {
        return this.logDeliveryConfiguration;
    }

    public final String dbParameterGroupIdentifier() {
        return this.dbParameterGroupIdentifier;
    }

    public final Integer port() {
        return this.port;
    }

    public final DbInstanceType dbInstanceType() {
        return DbInstanceType.fromValue(this.dbInstanceType);
    }

    public final String dbInstanceTypeAsString() {
        return this.dbInstanceType;
    }

    public final DeploymentType deploymentType() {
        return DeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final DbStorageType dbStorageType() {
        return DbStorageType.fromValue(this.dbStorageType);
    }

    public final String dbStorageTypeAsString() {
        return this.dbStorageType;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbStorageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDbInstanceRequest)) {
            return false;
        }
        UpdateDbInstanceRequest other = (UpdateDbInstanceRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.logDeliveryConfiguration(), other.logDeliveryConfiguration()) && Objects.equals(this.dbParameterGroupIdentifier(), other.dbParameterGroupIdentifier()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.dbInstanceTypeAsString(), other.dbInstanceTypeAsString()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.dbStorageTypeAsString(), other.dbStorageTypeAsString()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDbInstanceRequest").add("Identifier", (Object)this.identifier()).add("LogDeliveryConfiguration", (Object)this.logDeliveryConfiguration()).add("DbParameterGroupIdentifier", (Object)this.dbParameterGroupIdentifier()).add("Port", (Object)this.port()).add("DbInstanceType", (Object)this.dbInstanceTypeAsString()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("DbStorageType", (Object)this.dbStorageTypeAsString()).add("AllocatedStorage", (Object)this.allocatedStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "logDeliveryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logDeliveryConfiguration()));
            }
            case "dbParameterGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupIdentifier()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "dbInstanceType": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceTypeAsString()));
            }
            case "deploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "dbStorageType": {
                return Optional.ofNullable(clazz.cast(this.dbStorageTypeAsString()));
            }
            case "allocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("logDeliveryConfiguration", LOG_DELIVERY_CONFIGURATION_FIELD);
        map.put("dbParameterGroupIdentifier", DB_PARAMETER_GROUP_IDENTIFIER_FIELD);
        map.put("port", PORT_FIELD);
        map.put("dbInstanceType", DB_INSTANCE_TYPE_FIELD);
        map.put("deploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("dbStorageType", DB_STORAGE_TYPE_FIELD);
        map.put("allocatedStorage", ALLOCATED_STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDbInstanceRequest, T> g) {
        return obj -> g.apply((UpdateDbInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamInfluxDbRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private LogDeliveryConfiguration logDeliveryConfiguration;
        private String dbParameterGroupIdentifier;
        private Integer port;
        private String dbInstanceType;
        private String deploymentType;
        private String dbStorageType;
        private Integer allocatedStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDbInstanceRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.logDeliveryConfiguration(model.logDeliveryConfiguration);
            this.dbParameterGroupIdentifier(model.dbParameterGroupIdentifier);
            this.port(model.port);
            this.dbInstanceType(model.dbInstanceType);
            this.deploymentType(model.deploymentType);
            this.dbStorageType(model.dbStorageType);
            this.allocatedStorage(model.allocatedStorage);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final LogDeliveryConfiguration.Builder getLogDeliveryConfiguration() {
            return this.logDeliveryConfiguration != null ? this.logDeliveryConfiguration.toBuilder() : null;
        }

        public final void setLogDeliveryConfiguration(LogDeliveryConfiguration.BuilderImpl logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration != null ? logDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration;
            return this;
        }

        public final String getDbParameterGroupIdentifier() {
            return this.dbParameterGroupIdentifier;
        }

        public final void setDbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
        }

        @Override
        public final Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDbInstanceType() {
            return this.dbInstanceType;
        }

        public final void setDbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
        }

        @Override
        public final Builder dbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
            return this;
        }

        @Override
        public final Builder dbInstanceType(DbInstanceType dbInstanceType) {
            this.dbInstanceType(dbInstanceType == null ? null : dbInstanceType.toString());
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final String getDbStorageType() {
            return this.dbStorageType;
        }

        public final void setDbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
        }

        @Override
        public final Builder dbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
            return this;
        }

        @Override
        public final Builder dbStorageType(DbStorageType dbStorageType) {
            this.dbStorageType(dbStorageType == null ? null : dbStorageType.toString());
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDbInstanceRequest build() {
            return new UpdateDbInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TimestreamInfluxDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDbInstanceRequest> {
        public Builder identifier(String var1);

        public Builder logDeliveryConfiguration(LogDeliveryConfiguration var1);

        default public Builder logDeliveryConfiguration(Consumer<LogDeliveryConfiguration.Builder> logDeliveryConfiguration) {
            return this.logDeliveryConfiguration((LogDeliveryConfiguration)((LogDeliveryConfiguration.Builder)LogDeliveryConfiguration.builder().applyMutation(logDeliveryConfiguration)).build());
        }

        public Builder dbParameterGroupIdentifier(String var1);

        public Builder port(Integer var1);

        public Builder dbInstanceType(String var1);

        public Builder dbInstanceType(DbInstanceType var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(DeploymentType var1);

        public Builder dbStorageType(String var1);

        public Builder dbStorageType(DbStorageType var1);

        public Builder allocatedStorage(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

