/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.TimestreamInfluxDbClient;
import software.amazon.awssdk.services.timestreaminfluxdb.internal.UserAgentUtils;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbInstanceSummary;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesResponse;

public class ListDbInstancesIterable
implements SdkIterable<ListDbInstancesResponse> {
    private final TimestreamInfluxDbClient client;
    private final ListDbInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDbInstancesIterable(TimestreamInfluxDbClient client, ListDbInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDbInstancesResponseFetcher();
    }

    public Iterator<ListDbInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DbInstanceSummary> items() {
        Function<ListDbInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDbInstancesResponseFetcher
    implements SyncPageFetcher<ListDbInstancesResponse> {
        private ListDbInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListDbInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDbInstancesResponse nextPage(ListDbInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListDbInstancesIterable.this.client.listDbInstances(ListDbInstancesIterable.this.firstRequest);
            }
            return ListDbInstancesIterable.this.client.listDbInstances((ListDbInstancesRequest)((Object)ListDbInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

