/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DataFusionRuntimeType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.Duration;
import software.amazon.awssdk.services.timestreaminfluxdb.model.LogFormats;
import software.amazon.awssdk.services.timestreaminfluxdb.model.PercentOrAbsoluteLong;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InfluxDBv3CoreParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InfluxDBv3CoreParameters> {
    private static final SdkField<Integer> QUERY_FILE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("queryFileLimit").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::queryFileLimit)).setter(InfluxDBv3CoreParameters.setter(Builder::queryFileLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryFileLimit").build()}).build();
    private static final SdkField<Integer> QUERY_LOG_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("queryLogSize").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::queryLogSize)).setter(InfluxDBv3CoreParameters.setter(Builder::queryLogSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLogSize").build()}).build();
    private static final SdkField<String> LOG_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logFilter").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::logFilter)).setter(InfluxDBv3CoreParameters.setter(Builder::logFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logFilter").build()}).build();
    private static final SdkField<String> LOG_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logFormat").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::logFormatAsString)).setter(InfluxDBv3CoreParameters.setter(Builder::logFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logFormat").build()}).build();
    private static final SdkField<Integer> DATA_FUSION_NUM_THREADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dataFusionNumThreads").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::dataFusionNumThreads)).setter(InfluxDBv3CoreParameters.setter(Builder::dataFusionNumThreads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionNumThreads").build()}).build();
    private static final SdkField<String> DATA_FUSION_RUNTIME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataFusionRuntimeType").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::dataFusionRuntimeTypeAsString)).setter(InfluxDBv3CoreParameters.setter(Builder::dataFusionRuntimeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionRuntimeType").build()}).build();
    private static final SdkField<Boolean> DATA_FUSION_RUNTIME_DISABLE_LIFO_SLOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("dataFusionRuntimeDisableLifoSlot").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::dataFusionRuntimeDisableLifoSlot)).setter(InfluxDBv3CoreParameters.setter(Builder::dataFusionRuntimeDisableLifoSlot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionRuntimeDisableLifoSlot").build()}).build();
    private static final SdkField<Integer> DATA_FUSION_RUNTIME_EVENT_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dataFusionRuntimeEventInterval").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::dataFusionRuntimeEventInterval)).setter(InfluxDBv3CoreParameters.setter(Builder::dataFusionRuntimeEventInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionRuntimeEventInterval").build()}).build();
    private static final SdkField<Integer> DATA_FUSION_RUNTIME_GLOBAL_QUEUE_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dataFusionRuntimeGlobalQueueInterval").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::dataFusionRuntimeGlobalQueueInterval)).setter(InfluxDBv3CoreParameters.setter(Builder::dataFusionRuntimeGlobalQueueInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionRuntimeGlobalQueueInterval").build()}).build();
    private static final SdkField<Integer> DATA_FUSION_RUNTIME_MAX_BLOCKING_THREADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dataFusionRuntimeMaxBlockingThreads").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::dataFusionRuntimeMaxBlockingThreads)).setter(InfluxDBv3CoreParameters.setter(Builder::dataFusionRuntimeMaxBlockingThreads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionRuntimeMaxBlockingThreads").build()}).build();
    private static final SdkField<Integer> DATA_FUSION_RUNTIME_MAX_IO_EVENTS_PER_TICK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dataFusionRuntimeMaxIoEventsPerTick").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::dataFusionRuntimeMaxIoEventsPerTick)).setter(InfluxDBv3CoreParameters.setter(Builder::dataFusionRuntimeMaxIoEventsPerTick)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionRuntimeMaxIoEventsPerTick").build()}).build();
    private static final SdkField<Duration> DATA_FUSION_RUNTIME_THREAD_KEEP_ALIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataFusionRuntimeThreadKeepAlive").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::dataFusionRuntimeThreadKeepAlive)).setter(InfluxDBv3CoreParameters.setter(Builder::dataFusionRuntimeThreadKeepAlive)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionRuntimeThreadKeepAlive").build()}).build();
    private static final SdkField<Integer> DATA_FUSION_RUNTIME_THREAD_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dataFusionRuntimeThreadPriority").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::dataFusionRuntimeThreadPriority)).setter(InfluxDBv3CoreParameters.setter(Builder::dataFusionRuntimeThreadPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionRuntimeThreadPriority").build()}).build();
    private static final SdkField<Integer> DATA_FUSION_MAX_PARQUET_FANOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dataFusionMaxParquetFanout").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::dataFusionMaxParquetFanout)).setter(InfluxDBv3CoreParameters.setter(Builder::dataFusionMaxParquetFanout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionMaxParquetFanout").build()}).build();
    private static final SdkField<Boolean> DATA_FUSION_USE_CACHED_PARQUET_LOADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("dataFusionUseCachedParquetLoader").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::dataFusionUseCachedParquetLoader)).setter(InfluxDBv3CoreParameters.setter(Builder::dataFusionUseCachedParquetLoader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionUseCachedParquetLoader").build()}).build();
    private static final SdkField<String> DATA_FUSION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataFusionConfig").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::dataFusionConfig)).setter(InfluxDBv3CoreParameters.setter(Builder::dataFusionConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionConfig").build()}).build();
    private static final SdkField<Long> MAX_HTTP_REQUEST_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("maxHttpRequestSize").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::maxHttpRequestSize)).setter(InfluxDBv3CoreParameters.setter(Builder::maxHttpRequestSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxHttpRequestSize").build()}).build();
    private static final SdkField<PercentOrAbsoluteLong> FORCE_SNAPSHOT_MEM_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("forceSnapshotMemThreshold").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::forceSnapshotMemThreshold)).setter(InfluxDBv3CoreParameters.setter(Builder::forceSnapshotMemThreshold)).constructor(PercentOrAbsoluteLong::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceSnapshotMemThreshold").build()}).build();
    private static final SdkField<Integer> WAL_SNAPSHOT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("walSnapshotSize").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::walSnapshotSize)).setter(InfluxDBv3CoreParameters.setter(Builder::walSnapshotSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("walSnapshotSize").build()}).build();
    private static final SdkField<Integer> WAL_MAX_WRITE_BUFFER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("walMaxWriteBufferSize").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::walMaxWriteBufferSize)).setter(InfluxDBv3CoreParameters.setter(Builder::walMaxWriteBufferSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("walMaxWriteBufferSize").build()}).build();
    private static final SdkField<Integer> SNAPSHOTTED_WAL_FILES_TO_KEEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("snapshottedWalFilesToKeep").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::snapshottedWalFilesToKeep)).setter(InfluxDBv3CoreParameters.setter(Builder::snapshottedWalFilesToKeep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshottedWalFilesToKeep").build()}).build();
    private static final SdkField<Duration> PREEMPTIVE_CACHE_AGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("preemptiveCacheAge").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::preemptiveCacheAge)).setter(InfluxDBv3CoreParameters.setter(Builder::preemptiveCacheAge)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preemptiveCacheAge").build()}).build();
    private static final SdkField<Float> PARQUET_MEM_CACHE_PRUNE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("parquetMemCachePrunePercentage").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::parquetMemCachePrunePercentage)).setter(InfluxDBv3CoreParameters.setter(Builder::parquetMemCachePrunePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetMemCachePrunePercentage").build()}).build();
    private static final SdkField<Duration> PARQUET_MEM_CACHE_PRUNE_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parquetMemCachePruneInterval").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::parquetMemCachePruneInterval)).setter(InfluxDBv3CoreParameters.setter(Builder::parquetMemCachePruneInterval)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetMemCachePruneInterval").build()}).build();
    private static final SdkField<Boolean> DISABLE_PARQUET_MEM_CACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("disableParquetMemCache").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::disableParquetMemCache)).setter(InfluxDBv3CoreParameters.setter(Builder::disableParquetMemCache)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableParquetMemCache").build()}).build();
    private static final SdkField<Duration> PARQUET_MEM_CACHE_QUERY_PATH_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parquetMemCacheQueryPathDuration").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::parquetMemCacheQueryPathDuration)).setter(InfluxDBv3CoreParameters.setter(Builder::parquetMemCacheQueryPathDuration)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetMemCacheQueryPathDuration").build()}).build();
    private static final SdkField<Duration> LAST_CACHE_EVICTION_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lastCacheEvictionInterval").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::lastCacheEvictionInterval)).setter(InfluxDBv3CoreParameters.setter(Builder::lastCacheEvictionInterval)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastCacheEvictionInterval").build()}).build();
    private static final SdkField<Duration> DISTINCT_CACHE_EVICTION_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("distinctCacheEvictionInterval").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::distinctCacheEvictionInterval)).setter(InfluxDBv3CoreParameters.setter(Builder::distinctCacheEvictionInterval)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distinctCacheEvictionInterval").build()}).build();
    private static final SdkField<Duration> GEN1_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("gen1Duration").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::gen1Duration)).setter(InfluxDBv3CoreParameters.setter(Builder::gen1Duration)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gen1Duration").build()}).build();
    private static final SdkField<PercentOrAbsoluteLong> EXEC_MEM_POOL_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("execMemPoolBytes").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::execMemPoolBytes)).setter(InfluxDBv3CoreParameters.setter(Builder::execMemPoolBytes)).constructor(PercentOrAbsoluteLong::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("execMemPoolBytes").build()}).build();
    private static final SdkField<PercentOrAbsoluteLong> PARQUET_MEM_CACHE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parquetMemCacheSize").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::parquetMemCacheSize)).setter(InfluxDBv3CoreParameters.setter(Builder::parquetMemCacheSize)).constructor(PercentOrAbsoluteLong::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetMemCacheSize").build()}).build();
    private static final SdkField<Boolean> WAL_REPLAY_FAIL_ON_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("walReplayFailOnError").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::walReplayFailOnError)).setter(InfluxDBv3CoreParameters.setter(Builder::walReplayFailOnError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("walReplayFailOnError").build()}).build();
    private static final SdkField<Integer> WAL_REPLAY_CONCURRENCY_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("walReplayConcurrencyLimit").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::walReplayConcurrencyLimit)).setter(InfluxDBv3CoreParameters.setter(Builder::walReplayConcurrencyLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("walReplayConcurrencyLimit").build()}).build();
    private static final SdkField<Integer> TABLE_INDEX_CACHE_MAX_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("tableIndexCacheMaxEntries").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::tableIndexCacheMaxEntries)).setter(InfluxDBv3CoreParameters.setter(Builder::tableIndexCacheMaxEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableIndexCacheMaxEntries").build()}).build();
    private static final SdkField<Integer> TABLE_INDEX_CACHE_CONCURRENCY_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("tableIndexCacheConcurrencyLimit").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::tableIndexCacheConcurrencyLimit)).setter(InfluxDBv3CoreParameters.setter(Builder::tableIndexCacheConcurrencyLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableIndexCacheConcurrencyLimit").build()}).build();
    private static final SdkField<Duration> GEN1_LOOKBACK_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("gen1LookbackDuration").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::gen1LookbackDuration)).setter(InfluxDBv3CoreParameters.setter(Builder::gen1LookbackDuration)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gen1LookbackDuration").build()}).build();
    private static final SdkField<Duration> RETENTION_CHECK_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retentionCheckInterval").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::retentionCheckInterval)).setter(InfluxDBv3CoreParameters.setter(Builder::retentionCheckInterval)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionCheckInterval").build()}).build();
    private static final SdkField<Duration> DELETE_GRACE_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deleteGracePeriod").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::deleteGracePeriod)).setter(InfluxDBv3CoreParameters.setter(Builder::deleteGracePeriod)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteGracePeriod").build()}).build();
    private static final SdkField<Duration> HARD_DELETE_DEFAULT_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hardDeleteDefaultDuration").getter(InfluxDBv3CoreParameters.getter(InfluxDBv3CoreParameters::hardDeleteDefaultDuration)).setter(InfluxDBv3CoreParameters.setter(Builder::hardDeleteDefaultDuration)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hardDeleteDefaultDuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_FILE_LIMIT_FIELD, QUERY_LOG_SIZE_FIELD, LOG_FILTER_FIELD, LOG_FORMAT_FIELD, DATA_FUSION_NUM_THREADS_FIELD, DATA_FUSION_RUNTIME_TYPE_FIELD, DATA_FUSION_RUNTIME_DISABLE_LIFO_SLOT_FIELD, DATA_FUSION_RUNTIME_EVENT_INTERVAL_FIELD, DATA_FUSION_RUNTIME_GLOBAL_QUEUE_INTERVAL_FIELD, DATA_FUSION_RUNTIME_MAX_BLOCKING_THREADS_FIELD, DATA_FUSION_RUNTIME_MAX_IO_EVENTS_PER_TICK_FIELD, DATA_FUSION_RUNTIME_THREAD_KEEP_ALIVE_FIELD, DATA_FUSION_RUNTIME_THREAD_PRIORITY_FIELD, DATA_FUSION_MAX_PARQUET_FANOUT_FIELD, DATA_FUSION_USE_CACHED_PARQUET_LOADER_FIELD, DATA_FUSION_CONFIG_FIELD, MAX_HTTP_REQUEST_SIZE_FIELD, FORCE_SNAPSHOT_MEM_THRESHOLD_FIELD, WAL_SNAPSHOT_SIZE_FIELD, WAL_MAX_WRITE_BUFFER_SIZE_FIELD, SNAPSHOTTED_WAL_FILES_TO_KEEP_FIELD, PREEMPTIVE_CACHE_AGE_FIELD, PARQUET_MEM_CACHE_PRUNE_PERCENTAGE_FIELD, PARQUET_MEM_CACHE_PRUNE_INTERVAL_FIELD, DISABLE_PARQUET_MEM_CACHE_FIELD, PARQUET_MEM_CACHE_QUERY_PATH_DURATION_FIELD, LAST_CACHE_EVICTION_INTERVAL_FIELD, DISTINCT_CACHE_EVICTION_INTERVAL_FIELD, GEN1_DURATION_FIELD, EXEC_MEM_POOL_BYTES_FIELD, PARQUET_MEM_CACHE_SIZE_FIELD, WAL_REPLAY_FAIL_ON_ERROR_FIELD, WAL_REPLAY_CONCURRENCY_LIMIT_FIELD, TABLE_INDEX_CACHE_MAX_ENTRIES_FIELD, TABLE_INDEX_CACHE_CONCURRENCY_LIMIT_FIELD, GEN1_LOOKBACK_DURATION_FIELD, RETENTION_CHECK_INTERVAL_FIELD, DELETE_GRACE_PERIOD_FIELD, HARD_DELETE_DEFAULT_DURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InfluxDBv3CoreParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer queryFileLimit;
    private final Integer queryLogSize;
    private final String logFilter;
    private final String logFormat;
    private final Integer dataFusionNumThreads;
    private final String dataFusionRuntimeType;
    private final Boolean dataFusionRuntimeDisableLifoSlot;
    private final Integer dataFusionRuntimeEventInterval;
    private final Integer dataFusionRuntimeGlobalQueueInterval;
    private final Integer dataFusionRuntimeMaxBlockingThreads;
    private final Integer dataFusionRuntimeMaxIoEventsPerTick;
    private final Duration dataFusionRuntimeThreadKeepAlive;
    private final Integer dataFusionRuntimeThreadPriority;
    private final Integer dataFusionMaxParquetFanout;
    private final Boolean dataFusionUseCachedParquetLoader;
    private final String dataFusionConfig;
    private final Long maxHttpRequestSize;
    private final PercentOrAbsoluteLong forceSnapshotMemThreshold;
    private final Integer walSnapshotSize;
    private final Integer walMaxWriteBufferSize;
    private final Integer snapshottedWalFilesToKeep;
    private final Duration preemptiveCacheAge;
    private final Float parquetMemCachePrunePercentage;
    private final Duration parquetMemCachePruneInterval;
    private final Boolean disableParquetMemCache;
    private final Duration parquetMemCacheQueryPathDuration;
    private final Duration lastCacheEvictionInterval;
    private final Duration distinctCacheEvictionInterval;
    private final Duration gen1Duration;
    private final PercentOrAbsoluteLong execMemPoolBytes;
    private final PercentOrAbsoluteLong parquetMemCacheSize;
    private final Boolean walReplayFailOnError;
    private final Integer walReplayConcurrencyLimit;
    private final Integer tableIndexCacheMaxEntries;
    private final Integer tableIndexCacheConcurrencyLimit;
    private final Duration gen1LookbackDuration;
    private final Duration retentionCheckInterval;
    private final Duration deleteGracePeriod;
    private final Duration hardDeleteDefaultDuration;

    private InfluxDBv3CoreParameters(BuilderImpl builder) {
        this.queryFileLimit = builder.queryFileLimit;
        this.queryLogSize = builder.queryLogSize;
        this.logFilter = builder.logFilter;
        this.logFormat = builder.logFormat;
        this.dataFusionNumThreads = builder.dataFusionNumThreads;
        this.dataFusionRuntimeType = builder.dataFusionRuntimeType;
        this.dataFusionRuntimeDisableLifoSlot = builder.dataFusionRuntimeDisableLifoSlot;
        this.dataFusionRuntimeEventInterval = builder.dataFusionRuntimeEventInterval;
        this.dataFusionRuntimeGlobalQueueInterval = builder.dataFusionRuntimeGlobalQueueInterval;
        this.dataFusionRuntimeMaxBlockingThreads = builder.dataFusionRuntimeMaxBlockingThreads;
        this.dataFusionRuntimeMaxIoEventsPerTick = builder.dataFusionRuntimeMaxIoEventsPerTick;
        this.dataFusionRuntimeThreadKeepAlive = builder.dataFusionRuntimeThreadKeepAlive;
        this.dataFusionRuntimeThreadPriority = builder.dataFusionRuntimeThreadPriority;
        this.dataFusionMaxParquetFanout = builder.dataFusionMaxParquetFanout;
        this.dataFusionUseCachedParquetLoader = builder.dataFusionUseCachedParquetLoader;
        this.dataFusionConfig = builder.dataFusionConfig;
        this.maxHttpRequestSize = builder.maxHttpRequestSize;
        this.forceSnapshotMemThreshold = builder.forceSnapshotMemThreshold;
        this.walSnapshotSize = builder.walSnapshotSize;
        this.walMaxWriteBufferSize = builder.walMaxWriteBufferSize;
        this.snapshottedWalFilesToKeep = builder.snapshottedWalFilesToKeep;
        this.preemptiveCacheAge = builder.preemptiveCacheAge;
        this.parquetMemCachePrunePercentage = builder.parquetMemCachePrunePercentage;
        this.parquetMemCachePruneInterval = builder.parquetMemCachePruneInterval;
        this.disableParquetMemCache = builder.disableParquetMemCache;
        this.parquetMemCacheQueryPathDuration = builder.parquetMemCacheQueryPathDuration;
        this.lastCacheEvictionInterval = builder.lastCacheEvictionInterval;
        this.distinctCacheEvictionInterval = builder.distinctCacheEvictionInterval;
        this.gen1Duration = builder.gen1Duration;
        this.execMemPoolBytes = builder.execMemPoolBytes;
        this.parquetMemCacheSize = builder.parquetMemCacheSize;
        this.walReplayFailOnError = builder.walReplayFailOnError;
        this.walReplayConcurrencyLimit = builder.walReplayConcurrencyLimit;
        this.tableIndexCacheMaxEntries = builder.tableIndexCacheMaxEntries;
        this.tableIndexCacheConcurrencyLimit = builder.tableIndexCacheConcurrencyLimit;
        this.gen1LookbackDuration = builder.gen1LookbackDuration;
        this.retentionCheckInterval = builder.retentionCheckInterval;
        this.deleteGracePeriod = builder.deleteGracePeriod;
        this.hardDeleteDefaultDuration = builder.hardDeleteDefaultDuration;
    }

    public final Integer queryFileLimit() {
        return this.queryFileLimit;
    }

    public final Integer queryLogSize() {
        return this.queryLogSize;
    }

    public final String logFilter() {
        return this.logFilter;
    }

    public final LogFormats logFormat() {
        return LogFormats.fromValue(this.logFormat);
    }

    public final String logFormatAsString() {
        return this.logFormat;
    }

    public final Integer dataFusionNumThreads() {
        return this.dataFusionNumThreads;
    }

    public final DataFusionRuntimeType dataFusionRuntimeType() {
        return DataFusionRuntimeType.fromValue(this.dataFusionRuntimeType);
    }

    public final String dataFusionRuntimeTypeAsString() {
        return this.dataFusionRuntimeType;
    }

    public final Boolean dataFusionRuntimeDisableLifoSlot() {
        return this.dataFusionRuntimeDisableLifoSlot;
    }

    public final Integer dataFusionRuntimeEventInterval() {
        return this.dataFusionRuntimeEventInterval;
    }

    public final Integer dataFusionRuntimeGlobalQueueInterval() {
        return this.dataFusionRuntimeGlobalQueueInterval;
    }

    public final Integer dataFusionRuntimeMaxBlockingThreads() {
        return this.dataFusionRuntimeMaxBlockingThreads;
    }

    public final Integer dataFusionRuntimeMaxIoEventsPerTick() {
        return this.dataFusionRuntimeMaxIoEventsPerTick;
    }

    public final Duration dataFusionRuntimeThreadKeepAlive() {
        return this.dataFusionRuntimeThreadKeepAlive;
    }

    public final Integer dataFusionRuntimeThreadPriority() {
        return this.dataFusionRuntimeThreadPriority;
    }

    public final Integer dataFusionMaxParquetFanout() {
        return this.dataFusionMaxParquetFanout;
    }

    public final Boolean dataFusionUseCachedParquetLoader() {
        return this.dataFusionUseCachedParquetLoader;
    }

    public final String dataFusionConfig() {
        return this.dataFusionConfig;
    }

    public final Long maxHttpRequestSize() {
        return this.maxHttpRequestSize;
    }

    public final PercentOrAbsoluteLong forceSnapshotMemThreshold() {
        return this.forceSnapshotMemThreshold;
    }

    public final Integer walSnapshotSize() {
        return this.walSnapshotSize;
    }

    public final Integer walMaxWriteBufferSize() {
        return this.walMaxWriteBufferSize;
    }

    public final Integer snapshottedWalFilesToKeep() {
        return this.snapshottedWalFilesToKeep;
    }

    public final Duration preemptiveCacheAge() {
        return this.preemptiveCacheAge;
    }

    public final Float parquetMemCachePrunePercentage() {
        return this.parquetMemCachePrunePercentage;
    }

    public final Duration parquetMemCachePruneInterval() {
        return this.parquetMemCachePruneInterval;
    }

    public final Boolean disableParquetMemCache() {
        return this.disableParquetMemCache;
    }

    public final Duration parquetMemCacheQueryPathDuration() {
        return this.parquetMemCacheQueryPathDuration;
    }

    public final Duration lastCacheEvictionInterval() {
        return this.lastCacheEvictionInterval;
    }

    public final Duration distinctCacheEvictionInterval() {
        return this.distinctCacheEvictionInterval;
    }

    public final Duration gen1Duration() {
        return this.gen1Duration;
    }

    public final PercentOrAbsoluteLong execMemPoolBytes() {
        return this.execMemPoolBytes;
    }

    public final PercentOrAbsoluteLong parquetMemCacheSize() {
        return this.parquetMemCacheSize;
    }

    public final Boolean walReplayFailOnError() {
        return this.walReplayFailOnError;
    }

    public final Integer walReplayConcurrencyLimit() {
        return this.walReplayConcurrencyLimit;
    }

    public final Integer tableIndexCacheMaxEntries() {
        return this.tableIndexCacheMaxEntries;
    }

    public final Integer tableIndexCacheConcurrencyLimit() {
        return this.tableIndexCacheConcurrencyLimit;
    }

    public final Duration gen1LookbackDuration() {
        return this.gen1LookbackDuration;
    }

    public final Duration retentionCheckInterval() {
        return this.retentionCheckInterval;
    }

    public final Duration deleteGracePeriod() {
        return this.deleteGracePeriod;
    }

    public final Duration hardDeleteDefaultDuration() {
        return this.hardDeleteDefaultDuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryFileLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryLogSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFusionNumThreads());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFusionRuntimeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFusionRuntimeDisableLifoSlot());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFusionRuntimeEventInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFusionRuntimeGlobalQueueInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFusionRuntimeMaxBlockingThreads());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFusionRuntimeMaxIoEventsPerTick());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFusionRuntimeThreadKeepAlive());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFusionRuntimeThreadPriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFusionMaxParquetFanout());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFusionUseCachedParquetLoader());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFusionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxHttpRequestSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceSnapshotMemThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.walSnapshotSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.walMaxWriteBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshottedWalFilesToKeep());
        hashCode = 31 * hashCode + Objects.hashCode(this.preemptiveCacheAge());
        hashCode = 31 * hashCode + Objects.hashCode(this.parquetMemCachePrunePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.parquetMemCachePruneInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableParquetMemCache());
        hashCode = 31 * hashCode + Objects.hashCode(this.parquetMemCacheQueryPathDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastCacheEvictionInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.distinctCacheEvictionInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.gen1Duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.execMemPoolBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.parquetMemCacheSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.walReplayFailOnError());
        hashCode = 31 * hashCode + Objects.hashCode(this.walReplayConcurrencyLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableIndexCacheMaxEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableIndexCacheConcurrencyLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.gen1LookbackDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionCheckInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hardDeleteDefaultDuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InfluxDBv3CoreParameters)) {
            return false;
        }
        InfluxDBv3CoreParameters other = (InfluxDBv3CoreParameters)obj;
        return Objects.equals(this.queryFileLimit(), other.queryFileLimit()) && Objects.equals(this.queryLogSize(), other.queryLogSize()) && Objects.equals(this.logFilter(), other.logFilter()) && Objects.equals(this.logFormatAsString(), other.logFormatAsString()) && Objects.equals(this.dataFusionNumThreads(), other.dataFusionNumThreads()) && Objects.equals(this.dataFusionRuntimeTypeAsString(), other.dataFusionRuntimeTypeAsString()) && Objects.equals(this.dataFusionRuntimeDisableLifoSlot(), other.dataFusionRuntimeDisableLifoSlot()) && Objects.equals(this.dataFusionRuntimeEventInterval(), other.dataFusionRuntimeEventInterval()) && Objects.equals(this.dataFusionRuntimeGlobalQueueInterval(), other.dataFusionRuntimeGlobalQueueInterval()) && Objects.equals(this.dataFusionRuntimeMaxBlockingThreads(), other.dataFusionRuntimeMaxBlockingThreads()) && Objects.equals(this.dataFusionRuntimeMaxIoEventsPerTick(), other.dataFusionRuntimeMaxIoEventsPerTick()) && Objects.equals(this.dataFusionRuntimeThreadKeepAlive(), other.dataFusionRuntimeThreadKeepAlive()) && Objects.equals(this.dataFusionRuntimeThreadPriority(), other.dataFusionRuntimeThreadPriority()) && Objects.equals(this.dataFusionMaxParquetFanout(), other.dataFusionMaxParquetFanout()) && Objects.equals(this.dataFusionUseCachedParquetLoader(), other.dataFusionUseCachedParquetLoader()) && Objects.equals(this.dataFusionConfig(), other.dataFusionConfig()) && Objects.equals(this.maxHttpRequestSize(), other.maxHttpRequestSize()) && Objects.equals(this.forceSnapshotMemThreshold(), other.forceSnapshotMemThreshold()) && Objects.equals(this.walSnapshotSize(), other.walSnapshotSize()) && Objects.equals(this.walMaxWriteBufferSize(), other.walMaxWriteBufferSize()) && Objects.equals(this.snapshottedWalFilesToKeep(), other.snapshottedWalFilesToKeep()) && Objects.equals(this.preemptiveCacheAge(), other.preemptiveCacheAge()) && Objects.equals(this.parquetMemCachePrunePercentage(), other.parquetMemCachePrunePercentage()) && Objects.equals(this.parquetMemCachePruneInterval(), other.parquetMemCachePruneInterval()) && Objects.equals(this.disableParquetMemCache(), other.disableParquetMemCache()) && Objects.equals(this.parquetMemCacheQueryPathDuration(), other.parquetMemCacheQueryPathDuration()) && Objects.equals(this.lastCacheEvictionInterval(), other.lastCacheEvictionInterval()) && Objects.equals(this.distinctCacheEvictionInterval(), other.distinctCacheEvictionInterval()) && Objects.equals(this.gen1Duration(), other.gen1Duration()) && Objects.equals(this.execMemPoolBytes(), other.execMemPoolBytes()) && Objects.equals(this.parquetMemCacheSize(), other.parquetMemCacheSize()) && Objects.equals(this.walReplayFailOnError(), other.walReplayFailOnError()) && Objects.equals(this.walReplayConcurrencyLimit(), other.walReplayConcurrencyLimit()) && Objects.equals(this.tableIndexCacheMaxEntries(), other.tableIndexCacheMaxEntries()) && Objects.equals(this.tableIndexCacheConcurrencyLimit(), other.tableIndexCacheConcurrencyLimit()) && Objects.equals(this.gen1LookbackDuration(), other.gen1LookbackDuration()) && Objects.equals(this.retentionCheckInterval(), other.retentionCheckInterval()) && Objects.equals(this.deleteGracePeriod(), other.deleteGracePeriod()) && Objects.equals(this.hardDeleteDefaultDuration(), other.hardDeleteDefaultDuration());
    }

    public final String toString() {
        return ToString.builder((String)"InfluxDBv3CoreParameters").add("QueryFileLimit", (Object)this.queryFileLimit()).add("QueryLogSize", (Object)this.queryLogSize()).add("LogFilter", (Object)this.logFilter()).add("LogFormat", (Object)this.logFormatAsString()).add("DataFusionNumThreads", (Object)this.dataFusionNumThreads()).add("DataFusionRuntimeType", (Object)this.dataFusionRuntimeTypeAsString()).add("DataFusionRuntimeDisableLifoSlot", (Object)this.dataFusionRuntimeDisableLifoSlot()).add("DataFusionRuntimeEventInterval", (Object)this.dataFusionRuntimeEventInterval()).add("DataFusionRuntimeGlobalQueueInterval", (Object)this.dataFusionRuntimeGlobalQueueInterval()).add("DataFusionRuntimeMaxBlockingThreads", (Object)this.dataFusionRuntimeMaxBlockingThreads()).add("DataFusionRuntimeMaxIoEventsPerTick", (Object)this.dataFusionRuntimeMaxIoEventsPerTick()).add("DataFusionRuntimeThreadKeepAlive", (Object)this.dataFusionRuntimeThreadKeepAlive()).add("DataFusionRuntimeThreadPriority", (Object)this.dataFusionRuntimeThreadPriority()).add("DataFusionMaxParquetFanout", (Object)this.dataFusionMaxParquetFanout()).add("DataFusionUseCachedParquetLoader", (Object)this.dataFusionUseCachedParquetLoader()).add("DataFusionConfig", (Object)this.dataFusionConfig()).add("MaxHttpRequestSize", (Object)this.maxHttpRequestSize()).add("ForceSnapshotMemThreshold", (Object)this.forceSnapshotMemThreshold()).add("WalSnapshotSize", (Object)this.walSnapshotSize()).add("WalMaxWriteBufferSize", (Object)this.walMaxWriteBufferSize()).add("SnapshottedWalFilesToKeep", (Object)this.snapshottedWalFilesToKeep()).add("PreemptiveCacheAge", (Object)this.preemptiveCacheAge()).add("ParquetMemCachePrunePercentage", (Object)this.parquetMemCachePrunePercentage()).add("ParquetMemCachePruneInterval", (Object)this.parquetMemCachePruneInterval()).add("DisableParquetMemCache", (Object)this.disableParquetMemCache()).add("ParquetMemCacheQueryPathDuration", (Object)this.parquetMemCacheQueryPathDuration()).add("LastCacheEvictionInterval", (Object)this.lastCacheEvictionInterval()).add("DistinctCacheEvictionInterval", (Object)this.distinctCacheEvictionInterval()).add("Gen1Duration", (Object)this.gen1Duration()).add("ExecMemPoolBytes", (Object)this.execMemPoolBytes()).add("ParquetMemCacheSize", (Object)this.parquetMemCacheSize()).add("WalReplayFailOnError", (Object)this.walReplayFailOnError()).add("WalReplayConcurrencyLimit", (Object)this.walReplayConcurrencyLimit()).add("TableIndexCacheMaxEntries", (Object)this.tableIndexCacheMaxEntries()).add("TableIndexCacheConcurrencyLimit", (Object)this.tableIndexCacheConcurrencyLimit()).add("Gen1LookbackDuration", (Object)this.gen1LookbackDuration()).add("RetentionCheckInterval", (Object)this.retentionCheckInterval()).add("DeleteGracePeriod", (Object)this.deleteGracePeriod()).add("HardDeleteDefaultDuration", (Object)this.hardDeleteDefaultDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queryFileLimit": {
                return Optional.ofNullable(clazz.cast(this.queryFileLimit()));
            }
            case "queryLogSize": {
                return Optional.ofNullable(clazz.cast(this.queryLogSize()));
            }
            case "logFilter": {
                return Optional.ofNullable(clazz.cast(this.logFilter()));
            }
            case "logFormat": {
                return Optional.ofNullable(clazz.cast(this.logFormatAsString()));
            }
            case "dataFusionNumThreads": {
                return Optional.ofNullable(clazz.cast(this.dataFusionNumThreads()));
            }
            case "dataFusionRuntimeType": {
                return Optional.ofNullable(clazz.cast(this.dataFusionRuntimeTypeAsString()));
            }
            case "dataFusionRuntimeDisableLifoSlot": {
                return Optional.ofNullable(clazz.cast(this.dataFusionRuntimeDisableLifoSlot()));
            }
            case "dataFusionRuntimeEventInterval": {
                return Optional.ofNullable(clazz.cast(this.dataFusionRuntimeEventInterval()));
            }
            case "dataFusionRuntimeGlobalQueueInterval": {
                return Optional.ofNullable(clazz.cast(this.dataFusionRuntimeGlobalQueueInterval()));
            }
            case "dataFusionRuntimeMaxBlockingThreads": {
                return Optional.ofNullable(clazz.cast(this.dataFusionRuntimeMaxBlockingThreads()));
            }
            case "dataFusionRuntimeMaxIoEventsPerTick": {
                return Optional.ofNullable(clazz.cast(this.dataFusionRuntimeMaxIoEventsPerTick()));
            }
            case "dataFusionRuntimeThreadKeepAlive": {
                return Optional.ofNullable(clazz.cast(this.dataFusionRuntimeThreadKeepAlive()));
            }
            case "dataFusionRuntimeThreadPriority": {
                return Optional.ofNullable(clazz.cast(this.dataFusionRuntimeThreadPriority()));
            }
            case "dataFusionMaxParquetFanout": {
                return Optional.ofNullable(clazz.cast(this.dataFusionMaxParquetFanout()));
            }
            case "dataFusionUseCachedParquetLoader": {
                return Optional.ofNullable(clazz.cast(this.dataFusionUseCachedParquetLoader()));
            }
            case "dataFusionConfig": {
                return Optional.ofNullable(clazz.cast(this.dataFusionConfig()));
            }
            case "maxHttpRequestSize": {
                return Optional.ofNullable(clazz.cast(this.maxHttpRequestSize()));
            }
            case "forceSnapshotMemThreshold": {
                return Optional.ofNullable(clazz.cast(this.forceSnapshotMemThreshold()));
            }
            case "walSnapshotSize": {
                return Optional.ofNullable(clazz.cast(this.walSnapshotSize()));
            }
            case "walMaxWriteBufferSize": {
                return Optional.ofNullable(clazz.cast(this.walMaxWriteBufferSize()));
            }
            case "snapshottedWalFilesToKeep": {
                return Optional.ofNullable(clazz.cast(this.snapshottedWalFilesToKeep()));
            }
            case "preemptiveCacheAge": {
                return Optional.ofNullable(clazz.cast(this.preemptiveCacheAge()));
            }
            case "parquetMemCachePrunePercentage": {
                return Optional.ofNullable(clazz.cast(this.parquetMemCachePrunePercentage()));
            }
            case "parquetMemCachePruneInterval": {
                return Optional.ofNullable(clazz.cast(this.parquetMemCachePruneInterval()));
            }
            case "disableParquetMemCache": {
                return Optional.ofNullable(clazz.cast(this.disableParquetMemCache()));
            }
            case "parquetMemCacheQueryPathDuration": {
                return Optional.ofNullable(clazz.cast(this.parquetMemCacheQueryPathDuration()));
            }
            case "lastCacheEvictionInterval": {
                return Optional.ofNullable(clazz.cast(this.lastCacheEvictionInterval()));
            }
            case "distinctCacheEvictionInterval": {
                return Optional.ofNullable(clazz.cast(this.distinctCacheEvictionInterval()));
            }
            case "gen1Duration": {
                return Optional.ofNullable(clazz.cast(this.gen1Duration()));
            }
            case "execMemPoolBytes": {
                return Optional.ofNullable(clazz.cast(this.execMemPoolBytes()));
            }
            case "parquetMemCacheSize": {
                return Optional.ofNullable(clazz.cast(this.parquetMemCacheSize()));
            }
            case "walReplayFailOnError": {
                return Optional.ofNullable(clazz.cast(this.walReplayFailOnError()));
            }
            case "walReplayConcurrencyLimit": {
                return Optional.ofNullable(clazz.cast(this.walReplayConcurrencyLimit()));
            }
            case "tableIndexCacheMaxEntries": {
                return Optional.ofNullable(clazz.cast(this.tableIndexCacheMaxEntries()));
            }
            case "tableIndexCacheConcurrencyLimit": {
                return Optional.ofNullable(clazz.cast(this.tableIndexCacheConcurrencyLimit()));
            }
            case "gen1LookbackDuration": {
                return Optional.ofNullable(clazz.cast(this.gen1LookbackDuration()));
            }
            case "retentionCheckInterval": {
                return Optional.ofNullable(clazz.cast(this.retentionCheckInterval()));
            }
            case "deleteGracePeriod": {
                return Optional.ofNullable(clazz.cast(this.deleteGracePeriod()));
            }
            case "hardDeleteDefaultDuration": {
                return Optional.ofNullable(clazz.cast(this.hardDeleteDefaultDuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("queryFileLimit", QUERY_FILE_LIMIT_FIELD);
        map.put("queryLogSize", QUERY_LOG_SIZE_FIELD);
        map.put("logFilter", LOG_FILTER_FIELD);
        map.put("logFormat", LOG_FORMAT_FIELD);
        map.put("dataFusionNumThreads", DATA_FUSION_NUM_THREADS_FIELD);
        map.put("dataFusionRuntimeType", DATA_FUSION_RUNTIME_TYPE_FIELD);
        map.put("dataFusionRuntimeDisableLifoSlot", DATA_FUSION_RUNTIME_DISABLE_LIFO_SLOT_FIELD);
        map.put("dataFusionRuntimeEventInterval", DATA_FUSION_RUNTIME_EVENT_INTERVAL_FIELD);
        map.put("dataFusionRuntimeGlobalQueueInterval", DATA_FUSION_RUNTIME_GLOBAL_QUEUE_INTERVAL_FIELD);
        map.put("dataFusionRuntimeMaxBlockingThreads", DATA_FUSION_RUNTIME_MAX_BLOCKING_THREADS_FIELD);
        map.put("dataFusionRuntimeMaxIoEventsPerTick", DATA_FUSION_RUNTIME_MAX_IO_EVENTS_PER_TICK_FIELD);
        map.put("dataFusionRuntimeThreadKeepAlive", DATA_FUSION_RUNTIME_THREAD_KEEP_ALIVE_FIELD);
        map.put("dataFusionRuntimeThreadPriority", DATA_FUSION_RUNTIME_THREAD_PRIORITY_FIELD);
        map.put("dataFusionMaxParquetFanout", DATA_FUSION_MAX_PARQUET_FANOUT_FIELD);
        map.put("dataFusionUseCachedParquetLoader", DATA_FUSION_USE_CACHED_PARQUET_LOADER_FIELD);
        map.put("dataFusionConfig", DATA_FUSION_CONFIG_FIELD);
        map.put("maxHttpRequestSize", MAX_HTTP_REQUEST_SIZE_FIELD);
        map.put("forceSnapshotMemThreshold", FORCE_SNAPSHOT_MEM_THRESHOLD_FIELD);
        map.put("walSnapshotSize", WAL_SNAPSHOT_SIZE_FIELD);
        map.put("walMaxWriteBufferSize", WAL_MAX_WRITE_BUFFER_SIZE_FIELD);
        map.put("snapshottedWalFilesToKeep", SNAPSHOTTED_WAL_FILES_TO_KEEP_FIELD);
        map.put("preemptiveCacheAge", PREEMPTIVE_CACHE_AGE_FIELD);
        map.put("parquetMemCachePrunePercentage", PARQUET_MEM_CACHE_PRUNE_PERCENTAGE_FIELD);
        map.put("parquetMemCachePruneInterval", PARQUET_MEM_CACHE_PRUNE_INTERVAL_FIELD);
        map.put("disableParquetMemCache", DISABLE_PARQUET_MEM_CACHE_FIELD);
        map.put("parquetMemCacheQueryPathDuration", PARQUET_MEM_CACHE_QUERY_PATH_DURATION_FIELD);
        map.put("lastCacheEvictionInterval", LAST_CACHE_EVICTION_INTERVAL_FIELD);
        map.put("distinctCacheEvictionInterval", DISTINCT_CACHE_EVICTION_INTERVAL_FIELD);
        map.put("gen1Duration", GEN1_DURATION_FIELD);
        map.put("execMemPoolBytes", EXEC_MEM_POOL_BYTES_FIELD);
        map.put("parquetMemCacheSize", PARQUET_MEM_CACHE_SIZE_FIELD);
        map.put("walReplayFailOnError", WAL_REPLAY_FAIL_ON_ERROR_FIELD);
        map.put("walReplayConcurrencyLimit", WAL_REPLAY_CONCURRENCY_LIMIT_FIELD);
        map.put("tableIndexCacheMaxEntries", TABLE_INDEX_CACHE_MAX_ENTRIES_FIELD);
        map.put("tableIndexCacheConcurrencyLimit", TABLE_INDEX_CACHE_CONCURRENCY_LIMIT_FIELD);
        map.put("gen1LookbackDuration", GEN1_LOOKBACK_DURATION_FIELD);
        map.put("retentionCheckInterval", RETENTION_CHECK_INTERVAL_FIELD);
        map.put("deleteGracePeriod", DELETE_GRACE_PERIOD_FIELD);
        map.put("hardDeleteDefaultDuration", HARD_DELETE_DEFAULT_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InfluxDBv3CoreParameters, T> g) {
        return obj -> g.apply((InfluxDBv3CoreParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer queryFileLimit;
        private Integer queryLogSize;
        private String logFilter;
        private String logFormat;
        private Integer dataFusionNumThreads;
        private String dataFusionRuntimeType;
        private Boolean dataFusionRuntimeDisableLifoSlot;
        private Integer dataFusionRuntimeEventInterval;
        private Integer dataFusionRuntimeGlobalQueueInterval;
        private Integer dataFusionRuntimeMaxBlockingThreads;
        private Integer dataFusionRuntimeMaxIoEventsPerTick;
        private Duration dataFusionRuntimeThreadKeepAlive;
        private Integer dataFusionRuntimeThreadPriority;
        private Integer dataFusionMaxParquetFanout;
        private Boolean dataFusionUseCachedParquetLoader;
        private String dataFusionConfig;
        private Long maxHttpRequestSize;
        private PercentOrAbsoluteLong forceSnapshotMemThreshold;
        private Integer walSnapshotSize;
        private Integer walMaxWriteBufferSize;
        private Integer snapshottedWalFilesToKeep;
        private Duration preemptiveCacheAge;
        private Float parquetMemCachePrunePercentage;
        private Duration parquetMemCachePruneInterval;
        private Boolean disableParquetMemCache;
        private Duration parquetMemCacheQueryPathDuration;
        private Duration lastCacheEvictionInterval;
        private Duration distinctCacheEvictionInterval;
        private Duration gen1Duration;
        private PercentOrAbsoluteLong execMemPoolBytes;
        private PercentOrAbsoluteLong parquetMemCacheSize;
        private Boolean walReplayFailOnError;
        private Integer walReplayConcurrencyLimit;
        private Integer tableIndexCacheMaxEntries;
        private Integer tableIndexCacheConcurrencyLimit;
        private Duration gen1LookbackDuration;
        private Duration retentionCheckInterval;
        private Duration deleteGracePeriod;
        private Duration hardDeleteDefaultDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(InfluxDBv3CoreParameters model) {
            this.queryFileLimit(model.queryFileLimit);
            this.queryLogSize(model.queryLogSize);
            this.logFilter(model.logFilter);
            this.logFormat(model.logFormat);
            this.dataFusionNumThreads(model.dataFusionNumThreads);
            this.dataFusionRuntimeType(model.dataFusionRuntimeType);
            this.dataFusionRuntimeDisableLifoSlot(model.dataFusionRuntimeDisableLifoSlot);
            this.dataFusionRuntimeEventInterval(model.dataFusionRuntimeEventInterval);
            this.dataFusionRuntimeGlobalQueueInterval(model.dataFusionRuntimeGlobalQueueInterval);
            this.dataFusionRuntimeMaxBlockingThreads(model.dataFusionRuntimeMaxBlockingThreads);
            this.dataFusionRuntimeMaxIoEventsPerTick(model.dataFusionRuntimeMaxIoEventsPerTick);
            this.dataFusionRuntimeThreadKeepAlive(model.dataFusionRuntimeThreadKeepAlive);
            this.dataFusionRuntimeThreadPriority(model.dataFusionRuntimeThreadPriority);
            this.dataFusionMaxParquetFanout(model.dataFusionMaxParquetFanout);
            this.dataFusionUseCachedParquetLoader(model.dataFusionUseCachedParquetLoader);
            this.dataFusionConfig(model.dataFusionConfig);
            this.maxHttpRequestSize(model.maxHttpRequestSize);
            this.forceSnapshotMemThreshold(model.forceSnapshotMemThreshold);
            this.walSnapshotSize(model.walSnapshotSize);
            this.walMaxWriteBufferSize(model.walMaxWriteBufferSize);
            this.snapshottedWalFilesToKeep(model.snapshottedWalFilesToKeep);
            this.preemptiveCacheAge(model.preemptiveCacheAge);
            this.parquetMemCachePrunePercentage(model.parquetMemCachePrunePercentage);
            this.parquetMemCachePruneInterval(model.parquetMemCachePruneInterval);
            this.disableParquetMemCache(model.disableParquetMemCache);
            this.parquetMemCacheQueryPathDuration(model.parquetMemCacheQueryPathDuration);
            this.lastCacheEvictionInterval(model.lastCacheEvictionInterval);
            this.distinctCacheEvictionInterval(model.distinctCacheEvictionInterval);
            this.gen1Duration(model.gen1Duration);
            this.execMemPoolBytes(model.execMemPoolBytes);
            this.parquetMemCacheSize(model.parquetMemCacheSize);
            this.walReplayFailOnError(model.walReplayFailOnError);
            this.walReplayConcurrencyLimit(model.walReplayConcurrencyLimit);
            this.tableIndexCacheMaxEntries(model.tableIndexCacheMaxEntries);
            this.tableIndexCacheConcurrencyLimit(model.tableIndexCacheConcurrencyLimit);
            this.gen1LookbackDuration(model.gen1LookbackDuration);
            this.retentionCheckInterval(model.retentionCheckInterval);
            this.deleteGracePeriod(model.deleteGracePeriod);
            this.hardDeleteDefaultDuration(model.hardDeleteDefaultDuration);
        }

        public final Integer getQueryFileLimit() {
            return this.queryFileLimit;
        }

        public final void setQueryFileLimit(Integer queryFileLimit) {
            this.queryFileLimit = queryFileLimit;
        }

        @Override
        public final Builder queryFileLimit(Integer queryFileLimit) {
            this.queryFileLimit = queryFileLimit;
            return this;
        }

        public final Integer getQueryLogSize() {
            return this.queryLogSize;
        }

        public final void setQueryLogSize(Integer queryLogSize) {
            this.queryLogSize = queryLogSize;
        }

        @Override
        public final Builder queryLogSize(Integer queryLogSize) {
            this.queryLogSize = queryLogSize;
            return this;
        }

        public final String getLogFilter() {
            return this.logFilter;
        }

        public final void setLogFilter(String logFilter) {
            this.logFilter = logFilter;
        }

        @Override
        public final Builder logFilter(String logFilter) {
            this.logFilter = logFilter;
            return this;
        }

        public final String getLogFormat() {
            return this.logFormat;
        }

        public final void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }

        @Override
        public final Builder logFormat(String logFormat) {
            this.logFormat = logFormat;
            return this;
        }

        @Override
        public final Builder logFormat(LogFormats logFormat) {
            this.logFormat(logFormat == null ? null : logFormat.toString());
            return this;
        }

        public final Integer getDataFusionNumThreads() {
            return this.dataFusionNumThreads;
        }

        public final void setDataFusionNumThreads(Integer dataFusionNumThreads) {
            this.dataFusionNumThreads = dataFusionNumThreads;
        }

        @Override
        public final Builder dataFusionNumThreads(Integer dataFusionNumThreads) {
            this.dataFusionNumThreads = dataFusionNumThreads;
            return this;
        }

        public final String getDataFusionRuntimeType() {
            return this.dataFusionRuntimeType;
        }

        public final void setDataFusionRuntimeType(String dataFusionRuntimeType) {
            this.dataFusionRuntimeType = dataFusionRuntimeType;
        }

        @Override
        public final Builder dataFusionRuntimeType(String dataFusionRuntimeType) {
            this.dataFusionRuntimeType = dataFusionRuntimeType;
            return this;
        }

        @Override
        public final Builder dataFusionRuntimeType(DataFusionRuntimeType dataFusionRuntimeType) {
            this.dataFusionRuntimeType(dataFusionRuntimeType == null ? null : dataFusionRuntimeType.toString());
            return this;
        }

        public final Boolean getDataFusionRuntimeDisableLifoSlot() {
            return this.dataFusionRuntimeDisableLifoSlot;
        }

        public final void setDataFusionRuntimeDisableLifoSlot(Boolean dataFusionRuntimeDisableLifoSlot) {
            this.dataFusionRuntimeDisableLifoSlot = dataFusionRuntimeDisableLifoSlot;
        }

        @Override
        public final Builder dataFusionRuntimeDisableLifoSlot(Boolean dataFusionRuntimeDisableLifoSlot) {
            this.dataFusionRuntimeDisableLifoSlot = dataFusionRuntimeDisableLifoSlot;
            return this;
        }

        public final Integer getDataFusionRuntimeEventInterval() {
            return this.dataFusionRuntimeEventInterval;
        }

        public final void setDataFusionRuntimeEventInterval(Integer dataFusionRuntimeEventInterval) {
            this.dataFusionRuntimeEventInterval = dataFusionRuntimeEventInterval;
        }

        @Override
        public final Builder dataFusionRuntimeEventInterval(Integer dataFusionRuntimeEventInterval) {
            this.dataFusionRuntimeEventInterval = dataFusionRuntimeEventInterval;
            return this;
        }

        public final Integer getDataFusionRuntimeGlobalQueueInterval() {
            return this.dataFusionRuntimeGlobalQueueInterval;
        }

        public final void setDataFusionRuntimeGlobalQueueInterval(Integer dataFusionRuntimeGlobalQueueInterval) {
            this.dataFusionRuntimeGlobalQueueInterval = dataFusionRuntimeGlobalQueueInterval;
        }

        @Override
        public final Builder dataFusionRuntimeGlobalQueueInterval(Integer dataFusionRuntimeGlobalQueueInterval) {
            this.dataFusionRuntimeGlobalQueueInterval = dataFusionRuntimeGlobalQueueInterval;
            return this;
        }

        public final Integer getDataFusionRuntimeMaxBlockingThreads() {
            return this.dataFusionRuntimeMaxBlockingThreads;
        }

        public final void setDataFusionRuntimeMaxBlockingThreads(Integer dataFusionRuntimeMaxBlockingThreads) {
            this.dataFusionRuntimeMaxBlockingThreads = dataFusionRuntimeMaxBlockingThreads;
        }

        @Override
        public final Builder dataFusionRuntimeMaxBlockingThreads(Integer dataFusionRuntimeMaxBlockingThreads) {
            this.dataFusionRuntimeMaxBlockingThreads = dataFusionRuntimeMaxBlockingThreads;
            return this;
        }

        public final Integer getDataFusionRuntimeMaxIoEventsPerTick() {
            return this.dataFusionRuntimeMaxIoEventsPerTick;
        }

        public final void setDataFusionRuntimeMaxIoEventsPerTick(Integer dataFusionRuntimeMaxIoEventsPerTick) {
            this.dataFusionRuntimeMaxIoEventsPerTick = dataFusionRuntimeMaxIoEventsPerTick;
        }

        @Override
        public final Builder dataFusionRuntimeMaxIoEventsPerTick(Integer dataFusionRuntimeMaxIoEventsPerTick) {
            this.dataFusionRuntimeMaxIoEventsPerTick = dataFusionRuntimeMaxIoEventsPerTick;
            return this;
        }

        public final Duration.Builder getDataFusionRuntimeThreadKeepAlive() {
            return this.dataFusionRuntimeThreadKeepAlive != null ? this.dataFusionRuntimeThreadKeepAlive.toBuilder() : null;
        }

        public final void setDataFusionRuntimeThreadKeepAlive(Duration.BuilderImpl dataFusionRuntimeThreadKeepAlive) {
            this.dataFusionRuntimeThreadKeepAlive = dataFusionRuntimeThreadKeepAlive != null ? dataFusionRuntimeThreadKeepAlive.build() : null;
        }

        @Override
        public final Builder dataFusionRuntimeThreadKeepAlive(Duration dataFusionRuntimeThreadKeepAlive) {
            this.dataFusionRuntimeThreadKeepAlive = dataFusionRuntimeThreadKeepAlive;
            return this;
        }

        public final Integer getDataFusionRuntimeThreadPriority() {
            return this.dataFusionRuntimeThreadPriority;
        }

        public final void setDataFusionRuntimeThreadPriority(Integer dataFusionRuntimeThreadPriority) {
            this.dataFusionRuntimeThreadPriority = dataFusionRuntimeThreadPriority;
        }

        @Override
        public final Builder dataFusionRuntimeThreadPriority(Integer dataFusionRuntimeThreadPriority) {
            this.dataFusionRuntimeThreadPriority = dataFusionRuntimeThreadPriority;
            return this;
        }

        public final Integer getDataFusionMaxParquetFanout() {
            return this.dataFusionMaxParquetFanout;
        }

        public final void setDataFusionMaxParquetFanout(Integer dataFusionMaxParquetFanout) {
            this.dataFusionMaxParquetFanout = dataFusionMaxParquetFanout;
        }

        @Override
        public final Builder dataFusionMaxParquetFanout(Integer dataFusionMaxParquetFanout) {
            this.dataFusionMaxParquetFanout = dataFusionMaxParquetFanout;
            return this;
        }

        public final Boolean getDataFusionUseCachedParquetLoader() {
            return this.dataFusionUseCachedParquetLoader;
        }

        public final void setDataFusionUseCachedParquetLoader(Boolean dataFusionUseCachedParquetLoader) {
            this.dataFusionUseCachedParquetLoader = dataFusionUseCachedParquetLoader;
        }

        @Override
        public final Builder dataFusionUseCachedParquetLoader(Boolean dataFusionUseCachedParquetLoader) {
            this.dataFusionUseCachedParquetLoader = dataFusionUseCachedParquetLoader;
            return this;
        }

        public final String getDataFusionConfig() {
            return this.dataFusionConfig;
        }

        public final void setDataFusionConfig(String dataFusionConfig) {
            this.dataFusionConfig = dataFusionConfig;
        }

        @Override
        public final Builder dataFusionConfig(String dataFusionConfig) {
            this.dataFusionConfig = dataFusionConfig;
            return this;
        }

        public final Long getMaxHttpRequestSize() {
            return this.maxHttpRequestSize;
        }

        public final void setMaxHttpRequestSize(Long maxHttpRequestSize) {
            this.maxHttpRequestSize = maxHttpRequestSize;
        }

        @Override
        public final Builder maxHttpRequestSize(Long maxHttpRequestSize) {
            this.maxHttpRequestSize = maxHttpRequestSize;
            return this;
        }

        public final PercentOrAbsoluteLong.Builder getForceSnapshotMemThreshold() {
            return this.forceSnapshotMemThreshold != null ? this.forceSnapshotMemThreshold.toBuilder() : null;
        }

        public final void setForceSnapshotMemThreshold(PercentOrAbsoluteLong.BuilderImpl forceSnapshotMemThreshold) {
            this.forceSnapshotMemThreshold = forceSnapshotMemThreshold != null ? forceSnapshotMemThreshold.build() : null;
        }

        @Override
        public final Builder forceSnapshotMemThreshold(PercentOrAbsoluteLong forceSnapshotMemThreshold) {
            this.forceSnapshotMemThreshold = forceSnapshotMemThreshold;
            return this;
        }

        public final Integer getWalSnapshotSize() {
            return this.walSnapshotSize;
        }

        public final void setWalSnapshotSize(Integer walSnapshotSize) {
            this.walSnapshotSize = walSnapshotSize;
        }

        @Override
        public final Builder walSnapshotSize(Integer walSnapshotSize) {
            this.walSnapshotSize = walSnapshotSize;
            return this;
        }

        public final Integer getWalMaxWriteBufferSize() {
            return this.walMaxWriteBufferSize;
        }

        public final void setWalMaxWriteBufferSize(Integer walMaxWriteBufferSize) {
            this.walMaxWriteBufferSize = walMaxWriteBufferSize;
        }

        @Override
        public final Builder walMaxWriteBufferSize(Integer walMaxWriteBufferSize) {
            this.walMaxWriteBufferSize = walMaxWriteBufferSize;
            return this;
        }

        public final Integer getSnapshottedWalFilesToKeep() {
            return this.snapshottedWalFilesToKeep;
        }

        public final void setSnapshottedWalFilesToKeep(Integer snapshottedWalFilesToKeep) {
            this.snapshottedWalFilesToKeep = snapshottedWalFilesToKeep;
        }

        @Override
        public final Builder snapshottedWalFilesToKeep(Integer snapshottedWalFilesToKeep) {
            this.snapshottedWalFilesToKeep = snapshottedWalFilesToKeep;
            return this;
        }

        public final Duration.Builder getPreemptiveCacheAge() {
            return this.preemptiveCacheAge != null ? this.preemptiveCacheAge.toBuilder() : null;
        }

        public final void setPreemptiveCacheAge(Duration.BuilderImpl preemptiveCacheAge) {
            this.preemptiveCacheAge = preemptiveCacheAge != null ? preemptiveCacheAge.build() : null;
        }

        @Override
        public final Builder preemptiveCacheAge(Duration preemptiveCacheAge) {
            this.preemptiveCacheAge = preemptiveCacheAge;
            return this;
        }

        public final Float getParquetMemCachePrunePercentage() {
            return this.parquetMemCachePrunePercentage;
        }

        public final void setParquetMemCachePrunePercentage(Float parquetMemCachePrunePercentage) {
            this.parquetMemCachePrunePercentage = parquetMemCachePrunePercentage;
        }

        @Override
        public final Builder parquetMemCachePrunePercentage(Float parquetMemCachePrunePercentage) {
            this.parquetMemCachePrunePercentage = parquetMemCachePrunePercentage;
            return this;
        }

        public final Duration.Builder getParquetMemCachePruneInterval() {
            return this.parquetMemCachePruneInterval != null ? this.parquetMemCachePruneInterval.toBuilder() : null;
        }

        public final void setParquetMemCachePruneInterval(Duration.BuilderImpl parquetMemCachePruneInterval) {
            this.parquetMemCachePruneInterval = parquetMemCachePruneInterval != null ? parquetMemCachePruneInterval.build() : null;
        }

        @Override
        public final Builder parquetMemCachePruneInterval(Duration parquetMemCachePruneInterval) {
            this.parquetMemCachePruneInterval = parquetMemCachePruneInterval;
            return this;
        }

        public final Boolean getDisableParquetMemCache() {
            return this.disableParquetMemCache;
        }

        public final void setDisableParquetMemCache(Boolean disableParquetMemCache) {
            this.disableParquetMemCache = disableParquetMemCache;
        }

        @Override
        public final Builder disableParquetMemCache(Boolean disableParquetMemCache) {
            this.disableParquetMemCache = disableParquetMemCache;
            return this;
        }

        public final Duration.Builder getParquetMemCacheQueryPathDuration() {
            return this.parquetMemCacheQueryPathDuration != null ? this.parquetMemCacheQueryPathDuration.toBuilder() : null;
        }

        public final void setParquetMemCacheQueryPathDuration(Duration.BuilderImpl parquetMemCacheQueryPathDuration) {
            this.parquetMemCacheQueryPathDuration = parquetMemCacheQueryPathDuration != null ? parquetMemCacheQueryPathDuration.build() : null;
        }

        @Override
        public final Builder parquetMemCacheQueryPathDuration(Duration parquetMemCacheQueryPathDuration) {
            this.parquetMemCacheQueryPathDuration = parquetMemCacheQueryPathDuration;
            return this;
        }

        public final Duration.Builder getLastCacheEvictionInterval() {
            return this.lastCacheEvictionInterval != null ? this.lastCacheEvictionInterval.toBuilder() : null;
        }

        public final void setLastCacheEvictionInterval(Duration.BuilderImpl lastCacheEvictionInterval) {
            this.lastCacheEvictionInterval = lastCacheEvictionInterval != null ? lastCacheEvictionInterval.build() : null;
        }

        @Override
        public final Builder lastCacheEvictionInterval(Duration lastCacheEvictionInterval) {
            this.lastCacheEvictionInterval = lastCacheEvictionInterval;
            return this;
        }

        public final Duration.Builder getDistinctCacheEvictionInterval() {
            return this.distinctCacheEvictionInterval != null ? this.distinctCacheEvictionInterval.toBuilder() : null;
        }

        public final void setDistinctCacheEvictionInterval(Duration.BuilderImpl distinctCacheEvictionInterval) {
            this.distinctCacheEvictionInterval = distinctCacheEvictionInterval != null ? distinctCacheEvictionInterval.build() : null;
        }

        @Override
        public final Builder distinctCacheEvictionInterval(Duration distinctCacheEvictionInterval) {
            this.distinctCacheEvictionInterval = distinctCacheEvictionInterval;
            return this;
        }

        public final Duration.Builder getGen1Duration() {
            return this.gen1Duration != null ? this.gen1Duration.toBuilder() : null;
        }

        public final void setGen1Duration(Duration.BuilderImpl gen1Duration) {
            this.gen1Duration = gen1Duration != null ? gen1Duration.build() : null;
        }

        @Override
        public final Builder gen1Duration(Duration gen1Duration) {
            this.gen1Duration = gen1Duration;
            return this;
        }

        public final PercentOrAbsoluteLong.Builder getExecMemPoolBytes() {
            return this.execMemPoolBytes != null ? this.execMemPoolBytes.toBuilder() : null;
        }

        public final void setExecMemPoolBytes(PercentOrAbsoluteLong.BuilderImpl execMemPoolBytes) {
            this.execMemPoolBytes = execMemPoolBytes != null ? execMemPoolBytes.build() : null;
        }

        @Override
        public final Builder execMemPoolBytes(PercentOrAbsoluteLong execMemPoolBytes) {
            this.execMemPoolBytes = execMemPoolBytes;
            return this;
        }

        public final PercentOrAbsoluteLong.Builder getParquetMemCacheSize() {
            return this.parquetMemCacheSize != null ? this.parquetMemCacheSize.toBuilder() : null;
        }

        public final void setParquetMemCacheSize(PercentOrAbsoluteLong.BuilderImpl parquetMemCacheSize) {
            this.parquetMemCacheSize = parquetMemCacheSize != null ? parquetMemCacheSize.build() : null;
        }

        @Override
        public final Builder parquetMemCacheSize(PercentOrAbsoluteLong parquetMemCacheSize) {
            this.parquetMemCacheSize = parquetMemCacheSize;
            return this;
        }

        public final Boolean getWalReplayFailOnError() {
            return this.walReplayFailOnError;
        }

        public final void setWalReplayFailOnError(Boolean walReplayFailOnError) {
            this.walReplayFailOnError = walReplayFailOnError;
        }

        @Override
        public final Builder walReplayFailOnError(Boolean walReplayFailOnError) {
            this.walReplayFailOnError = walReplayFailOnError;
            return this;
        }

        public final Integer getWalReplayConcurrencyLimit() {
            return this.walReplayConcurrencyLimit;
        }

        public final void setWalReplayConcurrencyLimit(Integer walReplayConcurrencyLimit) {
            this.walReplayConcurrencyLimit = walReplayConcurrencyLimit;
        }

        @Override
        public final Builder walReplayConcurrencyLimit(Integer walReplayConcurrencyLimit) {
            this.walReplayConcurrencyLimit = walReplayConcurrencyLimit;
            return this;
        }

        public final Integer getTableIndexCacheMaxEntries() {
            return this.tableIndexCacheMaxEntries;
        }

        public final void setTableIndexCacheMaxEntries(Integer tableIndexCacheMaxEntries) {
            this.tableIndexCacheMaxEntries = tableIndexCacheMaxEntries;
        }

        @Override
        public final Builder tableIndexCacheMaxEntries(Integer tableIndexCacheMaxEntries) {
            this.tableIndexCacheMaxEntries = tableIndexCacheMaxEntries;
            return this;
        }

        public final Integer getTableIndexCacheConcurrencyLimit() {
            return this.tableIndexCacheConcurrencyLimit;
        }

        public final void setTableIndexCacheConcurrencyLimit(Integer tableIndexCacheConcurrencyLimit) {
            this.tableIndexCacheConcurrencyLimit = tableIndexCacheConcurrencyLimit;
        }

        @Override
        public final Builder tableIndexCacheConcurrencyLimit(Integer tableIndexCacheConcurrencyLimit) {
            this.tableIndexCacheConcurrencyLimit = tableIndexCacheConcurrencyLimit;
            return this;
        }

        public final Duration.Builder getGen1LookbackDuration() {
            return this.gen1LookbackDuration != null ? this.gen1LookbackDuration.toBuilder() : null;
        }

        public final void setGen1LookbackDuration(Duration.BuilderImpl gen1LookbackDuration) {
            this.gen1LookbackDuration = gen1LookbackDuration != null ? gen1LookbackDuration.build() : null;
        }

        @Override
        public final Builder gen1LookbackDuration(Duration gen1LookbackDuration) {
            this.gen1LookbackDuration = gen1LookbackDuration;
            return this;
        }

        public final Duration.Builder getRetentionCheckInterval() {
            return this.retentionCheckInterval != null ? this.retentionCheckInterval.toBuilder() : null;
        }

        public final void setRetentionCheckInterval(Duration.BuilderImpl retentionCheckInterval) {
            this.retentionCheckInterval = retentionCheckInterval != null ? retentionCheckInterval.build() : null;
        }

        @Override
        public final Builder retentionCheckInterval(Duration retentionCheckInterval) {
            this.retentionCheckInterval = retentionCheckInterval;
            return this;
        }

        public final Duration.Builder getDeleteGracePeriod() {
            return this.deleteGracePeriod != null ? this.deleteGracePeriod.toBuilder() : null;
        }

        public final void setDeleteGracePeriod(Duration.BuilderImpl deleteGracePeriod) {
            this.deleteGracePeriod = deleteGracePeriod != null ? deleteGracePeriod.build() : null;
        }

        @Override
        public final Builder deleteGracePeriod(Duration deleteGracePeriod) {
            this.deleteGracePeriod = deleteGracePeriod;
            return this;
        }

        public final Duration.Builder getHardDeleteDefaultDuration() {
            return this.hardDeleteDefaultDuration != null ? this.hardDeleteDefaultDuration.toBuilder() : null;
        }

        public final void setHardDeleteDefaultDuration(Duration.BuilderImpl hardDeleteDefaultDuration) {
            this.hardDeleteDefaultDuration = hardDeleteDefaultDuration != null ? hardDeleteDefaultDuration.build() : null;
        }

        @Override
        public final Builder hardDeleteDefaultDuration(Duration hardDeleteDefaultDuration) {
            this.hardDeleteDefaultDuration = hardDeleteDefaultDuration;
            return this;
        }

        public InfluxDBv3CoreParameters build() {
            return new InfluxDBv3CoreParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InfluxDBv3CoreParameters> {
        public Builder queryFileLimit(Integer var1);

        public Builder queryLogSize(Integer var1);

        public Builder logFilter(String var1);

        public Builder logFormat(String var1);

        public Builder logFormat(LogFormats var1);

        public Builder dataFusionNumThreads(Integer var1);

        public Builder dataFusionRuntimeType(String var1);

        public Builder dataFusionRuntimeType(DataFusionRuntimeType var1);

        public Builder dataFusionRuntimeDisableLifoSlot(Boolean var1);

        public Builder dataFusionRuntimeEventInterval(Integer var1);

        public Builder dataFusionRuntimeGlobalQueueInterval(Integer var1);

        public Builder dataFusionRuntimeMaxBlockingThreads(Integer var1);

        public Builder dataFusionRuntimeMaxIoEventsPerTick(Integer var1);

        public Builder dataFusionRuntimeThreadKeepAlive(Duration var1);

        default public Builder dataFusionRuntimeThreadKeepAlive(Consumer<Duration.Builder> dataFusionRuntimeThreadKeepAlive) {
            return this.dataFusionRuntimeThreadKeepAlive((Duration)((Duration.Builder)Duration.builder().applyMutation(dataFusionRuntimeThreadKeepAlive)).build());
        }

        public Builder dataFusionRuntimeThreadPriority(Integer var1);

        public Builder dataFusionMaxParquetFanout(Integer var1);

        public Builder dataFusionUseCachedParquetLoader(Boolean var1);

        public Builder dataFusionConfig(String var1);

        public Builder maxHttpRequestSize(Long var1);

        public Builder forceSnapshotMemThreshold(PercentOrAbsoluteLong var1);

        default public Builder forceSnapshotMemThreshold(Consumer<PercentOrAbsoluteLong.Builder> forceSnapshotMemThreshold) {
            return this.forceSnapshotMemThreshold((PercentOrAbsoluteLong)((PercentOrAbsoluteLong.Builder)PercentOrAbsoluteLong.builder().applyMutation(forceSnapshotMemThreshold)).build());
        }

        public Builder walSnapshotSize(Integer var1);

        public Builder walMaxWriteBufferSize(Integer var1);

        public Builder snapshottedWalFilesToKeep(Integer var1);

        public Builder preemptiveCacheAge(Duration var1);

        default public Builder preemptiveCacheAge(Consumer<Duration.Builder> preemptiveCacheAge) {
            return this.preemptiveCacheAge((Duration)((Duration.Builder)Duration.builder().applyMutation(preemptiveCacheAge)).build());
        }

        public Builder parquetMemCachePrunePercentage(Float var1);

        public Builder parquetMemCachePruneInterval(Duration var1);

        default public Builder parquetMemCachePruneInterval(Consumer<Duration.Builder> parquetMemCachePruneInterval) {
            return this.parquetMemCachePruneInterval((Duration)((Duration.Builder)Duration.builder().applyMutation(parquetMemCachePruneInterval)).build());
        }

        public Builder disableParquetMemCache(Boolean var1);

        public Builder parquetMemCacheQueryPathDuration(Duration var1);

        default public Builder parquetMemCacheQueryPathDuration(Consumer<Duration.Builder> parquetMemCacheQueryPathDuration) {
            return this.parquetMemCacheQueryPathDuration((Duration)((Duration.Builder)Duration.builder().applyMutation(parquetMemCacheQueryPathDuration)).build());
        }

        public Builder lastCacheEvictionInterval(Duration var1);

        default public Builder lastCacheEvictionInterval(Consumer<Duration.Builder> lastCacheEvictionInterval) {
            return this.lastCacheEvictionInterval((Duration)((Duration.Builder)Duration.builder().applyMutation(lastCacheEvictionInterval)).build());
        }

        public Builder distinctCacheEvictionInterval(Duration var1);

        default public Builder distinctCacheEvictionInterval(Consumer<Duration.Builder> distinctCacheEvictionInterval) {
            return this.distinctCacheEvictionInterval((Duration)((Duration.Builder)Duration.builder().applyMutation(distinctCacheEvictionInterval)).build());
        }

        public Builder gen1Duration(Duration var1);

        default public Builder gen1Duration(Consumer<Duration.Builder> gen1Duration) {
            return this.gen1Duration((Duration)((Duration.Builder)Duration.builder().applyMutation(gen1Duration)).build());
        }

        public Builder execMemPoolBytes(PercentOrAbsoluteLong var1);

        default public Builder execMemPoolBytes(Consumer<PercentOrAbsoluteLong.Builder> execMemPoolBytes) {
            return this.execMemPoolBytes((PercentOrAbsoluteLong)((PercentOrAbsoluteLong.Builder)PercentOrAbsoluteLong.builder().applyMutation(execMemPoolBytes)).build());
        }

        public Builder parquetMemCacheSize(PercentOrAbsoluteLong var1);

        default public Builder parquetMemCacheSize(Consumer<PercentOrAbsoluteLong.Builder> parquetMemCacheSize) {
            return this.parquetMemCacheSize((PercentOrAbsoluteLong)((PercentOrAbsoluteLong.Builder)PercentOrAbsoluteLong.builder().applyMutation(parquetMemCacheSize)).build());
        }

        public Builder walReplayFailOnError(Boolean var1);

        public Builder walReplayConcurrencyLimit(Integer var1);

        public Builder tableIndexCacheMaxEntries(Integer var1);

        public Builder tableIndexCacheConcurrencyLimit(Integer var1);

        public Builder gen1LookbackDuration(Duration var1);

        default public Builder gen1LookbackDuration(Consumer<Duration.Builder> gen1LookbackDuration) {
            return this.gen1LookbackDuration((Duration)((Duration.Builder)Duration.builder().applyMutation(gen1LookbackDuration)).build());
        }

        public Builder retentionCheckInterval(Duration var1);

        default public Builder retentionCheckInterval(Consumer<Duration.Builder> retentionCheckInterval) {
            return this.retentionCheckInterval((Duration)((Duration.Builder)Duration.builder().applyMutation(retentionCheckInterval)).build());
        }

        public Builder deleteGracePeriod(Duration var1);

        default public Builder deleteGracePeriod(Consumer<Duration.Builder> deleteGracePeriod) {
            return this.deleteGracePeriod((Duration)((Duration.Builder)Duration.builder().applyMutation(deleteGracePeriod)).build());
        }

        public Builder hardDeleteDefaultDuration(Duration var1);

        default public Builder hardDeleteDefaultDuration(Consumer<Duration.Builder> hardDeleteDefaultDuration) {
            return this.hardDeleteDefaultDuration((Duration)((Duration.Builder)Duration.builder().applyMutation(hardDeleteDefaultDuration)).build());
        }
    }
}

