/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.timestreaminfluxdb.model.InfluxDBv2Parameters;
import software.amazon.awssdk.services.timestreaminfluxdb.model.InfluxDBv3CoreParameters;
import software.amazon.awssdk.services.timestreaminfluxdb.model.InfluxDBv3EnterpriseParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Parameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Parameters> {
    private static final SdkField<InfluxDBv2Parameters> INFLUX_DB_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InfluxDBv2").getter(Parameters.getter(Parameters::influxDBv2)).setter(Parameters.setter(Builder::influxDBv2)).constructor(InfluxDBv2Parameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfluxDBv2").build()}).build();
    private static final SdkField<InfluxDBv3CoreParameters> INFLUX_DB_V3_CORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InfluxDBv3Core").getter(Parameters.getter(Parameters::influxDBv3Core)).setter(Parameters.setter(Builder::influxDBv3Core)).constructor(InfluxDBv3CoreParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfluxDBv3Core").build()}).build();
    private static final SdkField<InfluxDBv3EnterpriseParameters> INFLUX_DB_V3_ENTERPRISE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InfluxDBv3Enterprise").getter(Parameters.getter(Parameters::influxDBv3Enterprise)).setter(Parameters.setter(Builder::influxDBv3Enterprise)).constructor(InfluxDBv3EnterpriseParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfluxDBv3Enterprise").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFLUX_DB_V2_FIELD, INFLUX_DB_V3_CORE_FIELD, INFLUX_DB_V3_ENTERPRISE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Parameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InfluxDBv2Parameters influxDBv2;
    private final InfluxDBv3CoreParameters influxDBv3Core;
    private final InfluxDBv3EnterpriseParameters influxDBv3Enterprise;
    private final Type type;

    private Parameters(BuilderImpl builder) {
        this.influxDBv2 = builder.influxDBv2;
        this.influxDBv3Core = builder.influxDBv3Core;
        this.influxDBv3Enterprise = builder.influxDBv3Enterprise;
        this.type = builder.type;
    }

    public final InfluxDBv2Parameters influxDBv2() {
        return this.influxDBv2;
    }

    public final InfluxDBv3CoreParameters influxDBv3Core() {
        return this.influxDBv3Core;
    }

    public final InfluxDBv3EnterpriseParameters influxDBv3Enterprise() {
        return this.influxDBv3Enterprise;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.influxDBv2());
        hashCode = 31 * hashCode + Objects.hashCode(this.influxDBv3Core());
        hashCode = 31 * hashCode + Objects.hashCode(this.influxDBv3Enterprise());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameters)) {
            return false;
        }
        Parameters other = (Parameters)obj;
        return Objects.equals(this.influxDBv2(), other.influxDBv2()) && Objects.equals(this.influxDBv3Core(), other.influxDBv3Core()) && Objects.equals(this.influxDBv3Enterprise(), other.influxDBv3Enterprise());
    }

    public final String toString() {
        return ToString.builder((String)"Parameters").add("InfluxDBv2", (Object)this.influxDBv2()).add("InfluxDBv3Core", (Object)this.influxDBv3Core()).add("InfluxDBv3Enterprise", (Object)this.influxDBv3Enterprise()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InfluxDBv2": {
                return Optional.ofNullable(clazz.cast(this.influxDBv2()));
            }
            case "InfluxDBv3Core": {
                return Optional.ofNullable(clazz.cast(this.influxDBv3Core()));
            }
            case "InfluxDBv3Enterprise": {
                return Optional.ofNullable(clazz.cast(this.influxDBv3Enterprise()));
            }
        }
        return Optional.empty();
    }

    public static Parameters fromInfluxDBv2(InfluxDBv2Parameters influxDBv2) {
        return (Parameters)Parameters.builder().influxDBv2(influxDBv2).build();
    }

    public static Parameters fromInfluxDBv2(Consumer<InfluxDBv2Parameters.Builder> influxDBv2) {
        InfluxDBv2Parameters.Builder builder = InfluxDBv2Parameters.builder();
        influxDBv2.accept(builder);
        return Parameters.fromInfluxDBv2((InfluxDBv2Parameters)builder.build());
    }

    public static Parameters fromInfluxDBv3Core(InfluxDBv3CoreParameters influxDBv3Core) {
        return (Parameters)Parameters.builder().influxDBv3Core(influxDBv3Core).build();
    }

    public static Parameters fromInfluxDBv3Core(Consumer<InfluxDBv3CoreParameters.Builder> influxDBv3Core) {
        InfluxDBv3CoreParameters.Builder builder = InfluxDBv3CoreParameters.builder();
        influxDBv3Core.accept(builder);
        return Parameters.fromInfluxDBv3Core((InfluxDBv3CoreParameters)builder.build());
    }

    public static Parameters fromInfluxDBv3Enterprise(InfluxDBv3EnterpriseParameters influxDBv3Enterprise) {
        return (Parameters)Parameters.builder().influxDBv3Enterprise(influxDBv3Enterprise).build();
    }

    public static Parameters fromInfluxDBv3Enterprise(Consumer<InfluxDBv3EnterpriseParameters.Builder> influxDBv3Enterprise) {
        InfluxDBv3EnterpriseParameters.Builder builder = InfluxDBv3EnterpriseParameters.builder();
        influxDBv3Enterprise.accept(builder);
        return Parameters.fromInfluxDBv3Enterprise((InfluxDBv3EnterpriseParameters)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InfluxDBv2", INFLUX_DB_V2_FIELD);
        map.put("InfluxDBv3Core", INFLUX_DB_V3_CORE_FIELD);
        map.put("InfluxDBv3Enterprise", INFLUX_DB_V3_ENTERPRISE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Parameters, T> g) {
        return obj -> g.apply((Parameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INFLUX_DB_V2,
        INFLUX_DB_V3_CORE,
        INFLUX_DB_V3_ENTERPRISE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private InfluxDBv2Parameters influxDBv2;
        private InfluxDBv3CoreParameters influxDBv3Core;
        private InfluxDBv3EnterpriseParameters influxDBv3Enterprise;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Parameters model) {
            this.influxDBv2(model.influxDBv2);
            this.influxDBv3Core(model.influxDBv3Core);
            this.influxDBv3Enterprise(model.influxDBv3Enterprise);
        }

        public final InfluxDBv2Parameters.Builder getInfluxDBv2() {
            return this.influxDBv2 != null ? this.influxDBv2.toBuilder() : null;
        }

        public final void setInfluxDBv2(InfluxDBv2Parameters.BuilderImpl influxDBv2) {
            InfluxDBv2Parameters oldValue = this.influxDBv2;
            this.influxDBv2 = influxDBv2 != null ? influxDBv2.build() : null;
            this.handleUnionValueChange(Type.INFLUX_DB_V2, oldValue, this.influxDBv2);
        }

        @Override
        public final Builder influxDBv2(InfluxDBv2Parameters influxDBv2) {
            InfluxDBv2Parameters oldValue = this.influxDBv2;
            this.influxDBv2 = influxDBv2;
            this.handleUnionValueChange(Type.INFLUX_DB_V2, oldValue, this.influxDBv2);
            return this;
        }

        public final InfluxDBv3CoreParameters.Builder getInfluxDBv3Core() {
            return this.influxDBv3Core != null ? this.influxDBv3Core.toBuilder() : null;
        }

        public final void setInfluxDBv3Core(InfluxDBv3CoreParameters.BuilderImpl influxDBv3Core) {
            InfluxDBv3CoreParameters oldValue = this.influxDBv3Core;
            this.influxDBv3Core = influxDBv3Core != null ? influxDBv3Core.build() : null;
            this.handleUnionValueChange(Type.INFLUX_DB_V3_CORE, oldValue, this.influxDBv3Core);
        }

        @Override
        public final Builder influxDBv3Core(InfluxDBv3CoreParameters influxDBv3Core) {
            InfluxDBv3CoreParameters oldValue = this.influxDBv3Core;
            this.influxDBv3Core = influxDBv3Core;
            this.handleUnionValueChange(Type.INFLUX_DB_V3_CORE, oldValue, this.influxDBv3Core);
            return this;
        }

        public final InfluxDBv3EnterpriseParameters.Builder getInfluxDBv3Enterprise() {
            return this.influxDBv3Enterprise != null ? this.influxDBv3Enterprise.toBuilder() : null;
        }

        public final void setInfluxDBv3Enterprise(InfluxDBv3EnterpriseParameters.BuilderImpl influxDBv3Enterprise) {
            InfluxDBv3EnterpriseParameters oldValue = this.influxDBv3Enterprise;
            this.influxDBv3Enterprise = influxDBv3Enterprise != null ? influxDBv3Enterprise.build() : null;
            this.handleUnionValueChange(Type.INFLUX_DB_V3_ENTERPRISE, oldValue, this.influxDBv3Enterprise);
        }

        @Override
        public final Builder influxDBv3Enterprise(InfluxDBv3EnterpriseParameters influxDBv3Enterprise) {
            InfluxDBv3EnterpriseParameters oldValue = this.influxDBv3Enterprise;
            this.influxDBv3Enterprise = influxDBv3Enterprise;
            this.handleUnionValueChange(Type.INFLUX_DB_V3_ENTERPRISE, oldValue, this.influxDBv3Enterprise);
            return this;
        }

        public Parameters build() {
            return new Parameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Parameters> {
        public Builder influxDBv2(InfluxDBv2Parameters var1);

        default public Builder influxDBv2(Consumer<InfluxDBv2Parameters.Builder> influxDBv2) {
            return this.influxDBv2((InfluxDBv2Parameters)((InfluxDBv2Parameters.Builder)InfluxDBv2Parameters.builder().applyMutation(influxDBv2)).build());
        }

        public Builder influxDBv3Core(InfluxDBv3CoreParameters var1);

        default public Builder influxDBv3Core(Consumer<InfluxDBv3CoreParameters.Builder> influxDBv3Core) {
            return this.influxDBv3Core((InfluxDBv3CoreParameters)((InfluxDBv3CoreParameters.Builder)InfluxDBv3CoreParameters.builder().applyMutation(influxDBv3Core)).build());
        }

        public Builder influxDBv3Enterprise(InfluxDBv3EnterpriseParameters var1);

        default public Builder influxDBv3Enterprise(Consumer<InfluxDBv3EnterpriseParameters.Builder> influxDBv3Enterprise) {
            return this.influxDBv3Enterprise((InfluxDBv3EnterpriseParameters)((InfluxDBv3EnterpriseParameters.Builder)InfluxDBv3EnterpriseParameters.builder().applyMutation(influxDBv3Enterprise)).build());
        }
    }
}

