/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PercentOrAbsoluteLong
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PercentOrAbsoluteLong> {
    private static final SdkField<String> PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("percent").getter(PercentOrAbsoluteLong.getter(PercentOrAbsoluteLong::percent)).setter(PercentOrAbsoluteLong.setter(Builder::percent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percent").build()}).build();
    private static final SdkField<Long> ABSOLUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("absolute").getter(PercentOrAbsoluteLong.getter(PercentOrAbsoluteLong::absolute)).setter(PercentOrAbsoluteLong.setter(Builder::absolute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("absolute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENT_FIELD, ABSOLUTE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PercentOrAbsoluteLong.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String percent;
    private final Long absolute;
    private final Type type;

    private PercentOrAbsoluteLong(BuilderImpl builder) {
        this.percent = builder.percent;
        this.absolute = builder.absolute;
        this.type = builder.type;
    }

    public final String percent() {
        return this.percent;
    }

    public final Long absolute() {
        return this.absolute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.percent());
        hashCode = 31 * hashCode + Objects.hashCode(this.absolute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PercentOrAbsoluteLong)) {
            return false;
        }
        PercentOrAbsoluteLong other = (PercentOrAbsoluteLong)obj;
        return Objects.equals(this.percent(), other.percent()) && Objects.equals(this.absolute(), other.absolute());
    }

    public final String toString() {
        return ToString.builder((String)"PercentOrAbsoluteLong").add("Percent", (Object)this.percent()).add("Absolute", (Object)this.absolute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "percent": {
                return Optional.ofNullable(clazz.cast(this.percent()));
            }
            case "absolute": {
                return Optional.ofNullable(clazz.cast(this.absolute()));
            }
        }
        return Optional.empty();
    }

    public static PercentOrAbsoluteLong fromPercent(String percent) {
        return (PercentOrAbsoluteLong)PercentOrAbsoluteLong.builder().percent(percent).build();
    }

    public static PercentOrAbsoluteLong fromAbsolute(Long absolute) {
        return (PercentOrAbsoluteLong)PercentOrAbsoluteLong.builder().absolute(absolute).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("percent", PERCENT_FIELD);
        map.put("absolute", ABSOLUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PercentOrAbsoluteLong, T> g) {
        return obj -> g.apply((PercentOrAbsoluteLong)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PERCENT,
        ABSOLUTE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String percent;
        private Long absolute;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PercentOrAbsoluteLong model) {
            this.percent(model.percent);
            this.absolute(model.absolute);
        }

        public final String getPercent() {
            return this.percent;
        }

        public final void setPercent(String percent) {
            String oldValue = this.percent;
            this.percent = percent;
            this.handleUnionValueChange(Type.PERCENT, oldValue, this.percent);
        }

        @Override
        public final Builder percent(String percent) {
            String oldValue = this.percent;
            this.percent = percent;
            this.handleUnionValueChange(Type.PERCENT, oldValue, this.percent);
            return this;
        }

        public final Long getAbsolute() {
            return this.absolute;
        }

        public final void setAbsolute(Long absolute) {
            Long oldValue = this.absolute;
            this.absolute = absolute;
            this.handleUnionValueChange(Type.ABSOLUTE, oldValue, this.absolute);
        }

        @Override
        public final Builder absolute(Long absolute) {
            Long oldValue = this.absolute;
            this.absolute = absolute;
            this.handleUnionValueChange(Type.ABSOLUTE, oldValue, this.absolute);
            return this;
        }

        public PercentOrAbsoluteLong build() {
            return new PercentOrAbsoluteLong(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PercentOrAbsoluteLong> {
        public Builder percent(String var1);

        public Builder absolute(Long var1);
    }
}

