/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.timestreaminfluxdb.model.AccessDeniedException;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ConflictException;
import software.amazon.awssdk.services.timestreaminfluxdb.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.CreateDbParameterGroupRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.CreateDbParameterGroupResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.GetDbClusterRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.GetDbClusterResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.GetDbInstanceRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.GetDbInstanceResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.GetDbParameterGroupRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.GetDbParameterGroupResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.InternalServerException;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbClustersRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbClustersResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesForClusterRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesForClusterResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbParameterGroupsRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbParameterGroupsResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.timestreaminfluxdb.model.TagResourceRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.TagResourceResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ThrottlingException;
import software.amazon.awssdk.services.timestreaminfluxdb.model.TimestreamInfluxDbException;
import software.amazon.awssdk.services.timestreaminfluxdb.model.UntagResourceRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.UntagResourceResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.UpdateDbClusterRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.UpdateDbClusterResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.UpdateDbInstanceRequest;
import software.amazon.awssdk.services.timestreaminfluxdb.model.UpdateDbInstanceResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.ValidationException;
import software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbClustersIterable;
import software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbInstancesForClusterIterable;
import software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbInstancesIterable;
import software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbParameterGroupsIterable;

/**
 * Service client for accessing Timestream InfluxDB. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Timestream for InfluxDB is a managed time-series database engine that makes it easy for application developers
 * and DevOps teams to run InfluxDB databases on Amazon Web Services for near real-time time-series applications using
 * open-source APIs. With Amazon Timestream for InfluxDB, it is easy to set up, operate, and scale time-series workloads
 * that can answer queries with single-digit millisecond query response time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface TimestreamInfluxDbClient extends AwsClient {
    String SERVICE_NAME = "timestream-influxdb";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "timestream-influxdb";

    /**
     * <p>
     * Creates a new Timestream for InfluxDB cluster.
     * </p>
     *
     * @param createDbClusterRequest
     * @return Result of the CreateDbCluster operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeds the service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request conflicts with an existing resource in Timestream for InfluxDB.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.CreateDbCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/CreateDbCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDbClusterResponse createDbCluster(CreateDbClusterRequest createDbClusterRequest)
            throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Timestream for InfluxDB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDbClusterRequest#builder()}
     * </p>
     *
     * @param createDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.CreateDbClusterRequest.Builder} to create
     *        a request.
     * @return Result of the CreateDbCluster operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeds the service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request conflicts with an existing resource in Timestream for InfluxDB.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.CreateDbCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/CreateDbCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDbClusterResponse createDbCluster(Consumer<CreateDbClusterRequest.Builder> createDbClusterRequest)
            throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            TimestreamInfluxDbException {
        return createDbCluster(CreateDbClusterRequest.builder().applyMutation(createDbClusterRequest).build());
    }

    /**
     * <p>
     * Creates a new Timestream for InfluxDB DB instance.
     * </p>
     *
     * @param createDbInstanceRequest
     * @return Result of the CreateDbInstance operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeds the service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request conflicts with an existing resource in Timestream for InfluxDB.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.CreateDbInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/CreateDbInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDbInstanceResponse createDbInstance(CreateDbInstanceRequest createDbInstanceRequest)
            throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Timestream for InfluxDB DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDbInstanceRequest#builder()}
     * </p>
     *
     * @param createDbInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.CreateDbInstanceRequest.Builder} to create
     *        a request.
     * @return Result of the CreateDbInstance operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeds the service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request conflicts with an existing resource in Timestream for InfluxDB.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.CreateDbInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/CreateDbInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDbInstanceResponse createDbInstance(Consumer<CreateDbInstanceRequest.Builder> createDbInstanceRequest)
            throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            TimestreamInfluxDbException {
        return createDbInstance(CreateDbInstanceRequest.builder().applyMutation(createDbInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a new Timestream for InfluxDB DB parameter group to associate with DB instances.
     * </p>
     *
     * @param createDbParameterGroupRequest
     * @return Result of the CreateDbParameterGroup operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeds the service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request conflicts with an existing resource in Timestream for InfluxDB.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.CreateDbParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/CreateDbParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDbParameterGroupResponse createDbParameterGroup(CreateDbParameterGroupRequest createDbParameterGroupRequest)
            throws ServiceQuotaExceededException, ValidationException, AccessDeniedException, InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Timestream for InfluxDB DB parameter group to associate with DB instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param createDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.CreateDbParameterGroupRequest.Builder} to
     *        create a request.
     * @return Result of the CreateDbParameterGroup operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeds the service quota.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request conflicts with an existing resource in Timestream for InfluxDB.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.CreateDbParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/CreateDbParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDbParameterGroupResponse createDbParameterGroup(
            Consumer<CreateDbParameterGroupRequest.Builder> createDbParameterGroupRequest) throws ServiceQuotaExceededException,
            ValidationException, AccessDeniedException, InternalServerException, ConflictException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return createDbParameterGroup(CreateDbParameterGroupRequest.builder().applyMutation(createDbParameterGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a Timestream for InfluxDB cluster.
     * </p>
     *
     * @param deleteDbClusterRequest
     * @return Result of the DeleteDbCluster operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request conflicts with an existing resource in Timestream for InfluxDB.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.DeleteDbCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/DeleteDbCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDbClusterResponse deleteDbCluster(DeleteDbClusterRequest deleteDbClusterRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Timestream for InfluxDB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDbClusterRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.DeleteDbClusterRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteDbCluster operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request conflicts with an existing resource in Timestream for InfluxDB.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.DeleteDbCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/DeleteDbCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDbClusterResponse deleteDbCluster(Consumer<DeleteDbClusterRequest.Builder> deleteDbClusterRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return deleteDbCluster(DeleteDbClusterRequest.builder().applyMutation(deleteDbClusterRequest).build());
    }

    /**
     * <p>
     * Deletes a Timestream for InfluxDB DB instance.
     * </p>
     *
     * @param deleteDbInstanceRequest
     * @return Result of the DeleteDbInstance operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request conflicts with an existing resource in Timestream for InfluxDB.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.DeleteDbInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/DeleteDbInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDbInstanceResponse deleteDbInstance(DeleteDbInstanceRequest deleteDbInstanceRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Timestream for InfluxDB DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDbInstanceRequest#builder()}
     * </p>
     *
     * @param deleteDbInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.DeleteDbInstanceRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteDbInstance operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request conflicts with an existing resource in Timestream for InfluxDB.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.DeleteDbInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/DeleteDbInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDbInstanceResponse deleteDbInstance(Consumer<DeleteDbInstanceRequest.Builder> deleteDbInstanceRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return deleteDbInstance(DeleteDbInstanceRequest.builder().applyMutation(deleteDbInstanceRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a Timestream for InfluxDB cluster.
     * </p>
     *
     * @param getDbClusterRequest
     * @return Result of the GetDbCluster operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.GetDbCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/GetDbCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDbClusterResponse getDbCluster(GetDbClusterRequest getDbClusterRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a Timestream for InfluxDB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDbClusterRequest.Builder} avoiding the need to
     * create one manually via {@link GetDbClusterRequest#builder()}
     * </p>
     *
     * @param getDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.GetDbClusterRequest.Builder} to create a
     *        request.
     * @return Result of the GetDbCluster operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.GetDbCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/GetDbCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDbClusterResponse getDbCluster(Consumer<GetDbClusterRequest.Builder> getDbClusterRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return getDbCluster(GetDbClusterRequest.builder().applyMutation(getDbClusterRequest).build());
    }

    /**
     * <p>
     * Returns a Timestream for InfluxDB DB instance.
     * </p>
     *
     * @param getDbInstanceRequest
     * @return Result of the GetDbInstance operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.GetDbInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/GetDbInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDbInstanceResponse getDbInstance(GetDbInstanceRequest getDbInstanceRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a Timestream for InfluxDB DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDbInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDbInstanceRequest#builder()}
     * </p>
     *
     * @param getDbInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.GetDbInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the GetDbInstance operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.GetDbInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/GetDbInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDbInstanceResponse getDbInstance(Consumer<GetDbInstanceRequest.Builder> getDbInstanceRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return getDbInstance(GetDbInstanceRequest.builder().applyMutation(getDbInstanceRequest).build());
    }

    /**
     * <p>
     * Returns a Timestream for InfluxDB DB parameter group.
     * </p>
     *
     * @param getDbParameterGroupRequest
     * @return Result of the GetDbParameterGroup operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.GetDbParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/GetDbParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDbParameterGroupResponse getDbParameterGroup(GetDbParameterGroupRequest getDbParameterGroupRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a Timestream for InfluxDB DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link GetDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param getDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.GetDbParameterGroupRequest.Builder} to
     *        create a request.
     * @return Result of the GetDbParameterGroup operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.GetDbParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/GetDbParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDbParameterGroupResponse getDbParameterGroup(
            Consumer<GetDbParameterGroupRequest.Builder> getDbParameterGroupRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, TimestreamInfluxDbException {
        return getDbParameterGroup(GetDbParameterGroupRequest.builder().applyMutation(getDbParameterGroupRequest).build());
    }

    /**
     * <p>
     * Returns a list of Timestream for InfluxDB DB clusters.
     * </p>
     *
     * @param listDbClustersRequest
     * @return Result of the ListDbClusters operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbClustersResponse listDbClusters(ListDbClustersRequest listDbClustersRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Timestream for InfluxDB DB clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListDbClustersRequest#builder()}
     * </p>
     *
     * @param listDbClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbClustersRequest.Builder} to create a
     *        request.
     * @return Result of the ListDbClusters operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbClustersResponse listDbClusters(Consumer<ListDbClustersRequest.Builder> listDbClustersRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return listDbClusters(ListDbClustersRequest.builder().applyMutation(listDbClustersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDbClusters(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbClustersIterable responses = client.listDbClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbClustersIterable responses = client
     *             .listDbClustersPaginator(request);
     *     for (software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbClustersIterable responses = client.listDbClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbClusters(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbClustersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDbClustersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbClustersIterable listDbClustersPaginator(ListDbClustersRequest listDbClustersRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return new ListDbClustersIterable(this, listDbClustersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDbClusters(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbClustersIterable responses = client.listDbClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbClustersIterable responses = client
     *             .listDbClustersPaginator(request);
     *     for (software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbClustersIterable responses = client.listDbClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbClusters(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbClustersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListDbClustersRequest#builder()}
     * </p>
     *
     * @param listDbClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbClustersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbClustersIterable listDbClustersPaginator(Consumer<ListDbClustersRequest.Builder> listDbClustersRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return listDbClustersPaginator(ListDbClustersRequest.builder().applyMutation(listDbClustersRequest).build());
    }

    /**
     * <p>
     * Returns a list of Timestream for InfluxDB DB instances.
     * </p>
     *
     * @param listDbInstancesRequest
     * @return Result of the ListDbInstances operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbInstancesResponse listDbInstances(ListDbInstancesRequest listDbInstancesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Timestream for InfluxDB DB instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDbInstancesRequest#builder()}
     * </p>
     *
     * @param listDbInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesRequest.Builder} to create
     *        a request.
     * @return Result of the ListDbInstances operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbInstancesResponse listDbInstances(Consumer<ListDbInstancesRequest.Builder> listDbInstancesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return listDbInstances(ListDbInstancesRequest.builder().applyMutation(listDbInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDbInstances(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbInstancesIterable responses = client.listDbInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbInstancesIterable responses = client
     *             .listDbInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbInstancesIterable responses = client.listDbInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbInstances(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDbInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbInstancesIterable listDbInstancesPaginator(ListDbInstancesRequest listDbInstancesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return new ListDbInstancesIterable(this, listDbInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDbInstances(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbInstancesIterable responses = client.listDbInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbInstancesIterable responses = client
     *             .listDbInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbInstancesIterable responses = client.listDbInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbInstances(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDbInstancesRequest#builder()}
     * </p>
     *
     * @param listDbInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbInstancesIterable listDbInstancesPaginator(Consumer<ListDbInstancesRequest.Builder> listDbInstancesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return listDbInstancesPaginator(ListDbInstancesRequest.builder().applyMutation(listDbInstancesRequest).build());
    }

    /**
     * <p>
     * Returns a list of Timestream for InfluxDB clusters.
     * </p>
     *
     * @param listDbInstancesForClusterRequest
     * @return Result of the ListDbInstancesForCluster operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbInstancesForCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbInstancesForCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbInstancesForClusterResponse listDbInstancesForCluster(
            ListDbInstancesForClusterRequest listDbInstancesForClusterRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Timestream for InfluxDB clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbInstancesForClusterRequest.Builder} avoiding
     * the need to create one manually via {@link ListDbInstancesForClusterRequest#builder()}
     * </p>
     *
     * @param listDbInstancesForClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesForClusterRequest.Builder}
     *        to create a request.
     * @return Result of the ListDbInstancesForCluster operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbInstancesForCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbInstancesForCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbInstancesForClusterResponse listDbInstancesForCluster(
            Consumer<ListDbInstancesForClusterRequest.Builder> listDbInstancesForClusterRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, TimestreamInfluxDbException {
        return listDbInstancesForCluster(ListDbInstancesForClusterRequest.builder()
                .applyMutation(listDbInstancesForClusterRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDbInstancesForCluster(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesForClusterRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbInstancesForClusterIterable responses = client.listDbInstancesForClusterPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbInstancesForClusterIterable responses = client
     *             .listDbInstancesForClusterPaginator(request);
     *     for (software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesForClusterResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbInstancesForClusterIterable responses = client.listDbInstancesForClusterPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbInstancesForCluster(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesForClusterRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDbInstancesForClusterRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbInstancesForCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbInstancesForCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbInstancesForClusterIterable listDbInstancesForClusterPaginator(
            ListDbInstancesForClusterRequest listDbInstancesForClusterRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            TimestreamInfluxDbException {
        return new ListDbInstancesForClusterIterable(this, listDbInstancesForClusterRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDbInstancesForCluster(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesForClusterRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbInstancesForClusterIterable responses = client.listDbInstancesForClusterPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbInstancesForClusterIterable responses = client
     *             .listDbInstancesForClusterPaginator(request);
     *     for (software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesForClusterResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbInstancesForClusterIterable responses = client.listDbInstancesForClusterPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbInstancesForCluster(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesForClusterRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbInstancesForClusterRequest.Builder} avoiding
     * the need to create one manually via {@link ListDbInstancesForClusterRequest#builder()}
     * </p>
     *
     * @param listDbInstancesForClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbInstancesForClusterRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbInstancesForCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbInstancesForCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbInstancesForClusterIterable listDbInstancesForClusterPaginator(
            Consumer<ListDbInstancesForClusterRequest.Builder> listDbInstancesForClusterRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, TimestreamInfluxDbException {
        return listDbInstancesForClusterPaginator(ListDbInstancesForClusterRequest.builder()
                .applyMutation(listDbInstancesForClusterRequest).build());
    }

    /**
     * <p>
     * Returns a list of Timestream for InfluxDB DB parameter groups.
     * </p>
     *
     * @param listDbParameterGroupsRequest
     * @return Result of the ListDbParameterGroups operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbParameterGroupsResponse listDbParameterGroups(ListDbParameterGroupsRequest listDbParameterGroupsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Timestream for InfluxDB DB parameter groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbParameterGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDbParameterGroupsRequest#builder()}
     * </p>
     *
     * @param listDbParameterGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbParameterGroupsRequest.Builder} to
     *        create a request.
     * @return Result of the ListDbParameterGroups operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbParameterGroupsResponse listDbParameterGroups(
            Consumer<ListDbParameterGroupsRequest.Builder> listDbParameterGroupsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, TimestreamInfluxDbException {
        return listDbParameterGroups(ListDbParameterGroupsRequest.builder().applyMutation(listDbParameterGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDbParameterGroups(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbParameterGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbParameterGroupsIterable responses = client.listDbParameterGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbParameterGroupsIterable responses = client
     *             .listDbParameterGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbParameterGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbParameterGroupsIterable responses = client.listDbParameterGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbParameterGroups(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDbParameterGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbParameterGroupsIterable listDbParameterGroupsPaginator(ListDbParameterGroupsRequest listDbParameterGroupsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return new ListDbParameterGroupsIterable(this, listDbParameterGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDbParameterGroups(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbParameterGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbParameterGroupsIterable responses = client.listDbParameterGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbParameterGroupsIterable responses = client
     *             .listDbParameterGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbParameterGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.timestreaminfluxdb.paginators.ListDbParameterGroupsIterable responses = client.listDbParameterGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbParameterGroups(software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbParameterGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbParameterGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDbParameterGroupsRequest#builder()}
     * </p>
     *
     * @param listDbParameterGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.ListDbParameterGroupsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListDbParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDbParameterGroupsIterable listDbParameterGroupsPaginator(
            Consumer<ListDbParameterGroupsRequest.Builder> listDbParameterGroupsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, TimestreamInfluxDbException {
        return listDbParameterGroupsPaginator(ListDbParameterGroupsRequest.builder().applyMutation(listDbParameterGroupsRequest)
                .build());
    }

    /**
     * <p>
     * A list of tags applied to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of tags applied to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Tags are composed of a Key/Value pairs. You can use tags to categorize and track your Timestream for InfluxDB
     * resources.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeds the service quota.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags are composed of a Key/Value pairs. You can use tags to categorize and track your Timestream for InfluxDB
     * resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request exceeds the service quota.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            TimestreamInfluxDbException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the tag from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the tag from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a Timestream for InfluxDB cluster.
     * </p>
     *
     * @param updateDbClusterRequest
     * @return Result of the UpdateDbCluster operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request conflicts with an existing resource in Timestream for InfluxDB.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.UpdateDbCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/UpdateDbCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDbClusterResponse updateDbCluster(UpdateDbClusterRequest updateDbClusterRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Timestream for InfluxDB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDbClusterRequest#builder()}
     * </p>
     *
     * @param updateDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.UpdateDbClusterRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateDbCluster operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request conflicts with an existing resource in Timestream for InfluxDB.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.UpdateDbCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/UpdateDbCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDbClusterResponse updateDbCluster(Consumer<UpdateDbClusterRequest.Builder> updateDbClusterRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return updateDbCluster(UpdateDbClusterRequest.builder().applyMutation(updateDbClusterRequest).build());
    }

    /**
     * <p>
     * Updates a Timestream for InfluxDB DB instance.
     * </p>
     *
     * @param updateDbInstanceRequest
     * @return Result of the UpdateDbInstance operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request conflicts with an existing resource in Timestream for InfluxDB.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.UpdateDbInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/UpdateDbInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDbInstanceResponse updateDbInstance(UpdateDbInstanceRequest updateDbInstanceRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Timestream for InfluxDB DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDbInstanceRequest#builder()}
     * </p>
     *
     * @param updateDbInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.timestreaminfluxdb.model.UpdateDbInstanceRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateDbInstance operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Timestream for InfluxDB.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request conflicts with an existing resource in Timestream for InfluxDB.
     * @throws ResourceNotFoundException
     *         The requested resource was not found or does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TimestreamInfluxDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TimestreamInfluxDbClient.UpdateDbInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/UpdateDbInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDbInstanceResponse updateDbInstance(Consumer<UpdateDbInstanceRequest.Builder> updateDbInstanceRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TimestreamInfluxDbException {
        return updateDbInstance(UpdateDbInstanceRequest.builder().applyMutation(updateDbInstanceRequest).build());
    }

    /**
     * Create a {@link TimestreamInfluxDbClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TimestreamInfluxDbClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TimestreamInfluxDbClient}.
     */
    static TimestreamInfluxDbClientBuilder builder() {
        return new DefaultTimestreamInfluxDbClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default TimestreamInfluxDbServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
