/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters that comprise the parameter group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Parameters implements SdkPojo, Serializable, ToCopyableBuilder<Parameters.Builder, Parameters> {
    private static final SdkField<InfluxDBv2Parameters> INFLUX_DB_V2_FIELD = SdkField
            .<InfluxDBv2Parameters> builder(MarshallingType.SDK_POJO).memberName("InfluxDBv2")
            .getter(getter(Parameters::influxDBv2)).setter(setter(Builder::influxDBv2))
            .constructor(InfluxDBv2Parameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfluxDBv2").build()).build();

    private static final SdkField<InfluxDBv3CoreParameters> INFLUX_DB_V3_CORE_FIELD = SdkField
            .<InfluxDBv3CoreParameters> builder(MarshallingType.SDK_POJO).memberName("InfluxDBv3Core")
            .getter(getter(Parameters::influxDBv3Core)).setter(setter(Builder::influxDBv3Core))
            .constructor(InfluxDBv3CoreParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfluxDBv3Core").build()).build();

    private static final SdkField<InfluxDBv3EnterpriseParameters> INFLUX_DB_V3_ENTERPRISE_FIELD = SdkField
            .<InfluxDBv3EnterpriseParameters> builder(MarshallingType.SDK_POJO).memberName("InfluxDBv3Enterprise")
            .getter(getter(Parameters::influxDBv3Enterprise)).setter(setter(Builder::influxDBv3Enterprise))
            .constructor(InfluxDBv3EnterpriseParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfluxDBv3Enterprise").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFLUX_DB_V2_FIELD,
            INFLUX_DB_V3_CORE_FIELD, INFLUX_DB_V3_ENTERPRISE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InfluxDBv2Parameters influxDBv2;

    private final InfluxDBv3CoreParameters influxDBv3Core;

    private final InfluxDBv3EnterpriseParameters influxDBv3Enterprise;

    private final Type type;

    private Parameters(BuilderImpl builder) {
        this.influxDBv2 = builder.influxDBv2;
        this.influxDBv3Core = builder.influxDBv3Core;
        this.influxDBv3Enterprise = builder.influxDBv3Enterprise;
        this.type = builder.type;
    }

    /**
     * <p>
     * All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
     * </p>
     * 
     * @return All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
     */
    public final InfluxDBv2Parameters influxDBv2() {
        return influxDBv2;
    }

    /**
     * <p>
     * All the customer-modifiable InfluxDB v3 Core parameters in Timestream for InfluxDB.
     * </p>
     * 
     * @return All the customer-modifiable InfluxDB v3 Core parameters in Timestream for InfluxDB.
     */
    public final InfluxDBv3CoreParameters influxDBv3Core() {
        return influxDBv3Core;
    }

    /**
     * <p>
     * All the customer-modifiable InfluxDB v3 Enterprise parameters in Timestream for InfluxDB.
     * </p>
     * 
     * @return All the customer-modifiable InfluxDB v3 Enterprise parameters in Timestream for InfluxDB.
     */
    public final InfluxDBv3EnterpriseParameters influxDBv3Enterprise() {
        return influxDBv3Enterprise;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(influxDBv2());
        hashCode = 31 * hashCode + Objects.hashCode(influxDBv3Core());
        hashCode = 31 * hashCode + Objects.hashCode(influxDBv3Enterprise());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameters)) {
            return false;
        }
        Parameters other = (Parameters) obj;
        return Objects.equals(influxDBv2(), other.influxDBv2()) && Objects.equals(influxDBv3Core(), other.influxDBv3Core())
                && Objects.equals(influxDBv3Enterprise(), other.influxDBv3Enterprise());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Parameters").add("InfluxDBv2", influxDBv2()).add("InfluxDBv3Core", influxDBv3Core())
                .add("InfluxDBv3Enterprise", influxDBv3Enterprise()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InfluxDBv2":
            return Optional.ofNullable(clazz.cast(influxDBv2()));
        case "InfluxDBv3Core":
            return Optional.ofNullable(clazz.cast(influxDBv3Core()));
        case "InfluxDBv3Enterprise":
            return Optional.ofNullable(clazz.cast(influxDBv3Enterprise()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #influxDBv2()} initialized to the given value.
     *
     * <p>
     * All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
     * </p>
     * 
     * @param influxDBv2
     *        All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
     */
    public static Parameters fromInfluxDBv2(InfluxDBv2Parameters influxDBv2) {
        return builder().influxDBv2(influxDBv2).build();
    }

    /**
     * Create an instance of this class with {@link #influxDBv2()} initialized to the given value.
     *
     * <p>
     * All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
     * </p>
     * 
     * @param influxDBv2
     *        All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
     */
    public static Parameters fromInfluxDBv2(Consumer<InfluxDBv2Parameters.Builder> influxDBv2) {
        InfluxDBv2Parameters.Builder builder = InfluxDBv2Parameters.builder();
        influxDBv2.accept(builder);
        return fromInfluxDBv2(builder.build());
    }

    /**
     * Create an instance of this class with {@link #influxDBv3Core()} initialized to the given value.
     *
     * <p>
     * All the customer-modifiable InfluxDB v3 Core parameters in Timestream for InfluxDB.
     * </p>
     * 
     * @param influxDBv3Core
     *        All the customer-modifiable InfluxDB v3 Core parameters in Timestream for InfluxDB.
     */
    public static Parameters fromInfluxDBv3Core(InfluxDBv3CoreParameters influxDBv3Core) {
        return builder().influxDBv3Core(influxDBv3Core).build();
    }

    /**
     * Create an instance of this class with {@link #influxDBv3Core()} initialized to the given value.
     *
     * <p>
     * All the customer-modifiable InfluxDB v3 Core parameters in Timestream for InfluxDB.
     * </p>
     * 
     * @param influxDBv3Core
     *        All the customer-modifiable InfluxDB v3 Core parameters in Timestream for InfluxDB.
     */
    public static Parameters fromInfluxDBv3Core(Consumer<InfluxDBv3CoreParameters.Builder> influxDBv3Core) {
        InfluxDBv3CoreParameters.Builder builder = InfluxDBv3CoreParameters.builder();
        influxDBv3Core.accept(builder);
        return fromInfluxDBv3Core(builder.build());
    }

    /**
     * Create an instance of this class with {@link #influxDBv3Enterprise()} initialized to the given value.
     *
     * <p>
     * All the customer-modifiable InfluxDB v3 Enterprise parameters in Timestream for InfluxDB.
     * </p>
     * 
     * @param influxDBv3Enterprise
     *        All the customer-modifiable InfluxDB v3 Enterprise parameters in Timestream for InfluxDB.
     */
    public static Parameters fromInfluxDBv3Enterprise(InfluxDBv3EnterpriseParameters influxDBv3Enterprise) {
        return builder().influxDBv3Enterprise(influxDBv3Enterprise).build();
    }

    /**
     * Create an instance of this class with {@link #influxDBv3Enterprise()} initialized to the given value.
     *
     * <p>
     * All the customer-modifiable InfluxDB v3 Enterprise parameters in Timestream for InfluxDB.
     * </p>
     * 
     * @param influxDBv3Enterprise
     *        All the customer-modifiable InfluxDB v3 Enterprise parameters in Timestream for InfluxDB.
     */
    public static Parameters fromInfluxDBv3Enterprise(Consumer<InfluxDBv3EnterpriseParameters.Builder> influxDBv3Enterprise) {
        InfluxDBv3EnterpriseParameters.Builder builder = InfluxDBv3EnterpriseParameters.builder();
        influxDBv3Enterprise.accept(builder);
        return fromInfluxDBv3Enterprise(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InfluxDBv2", INFLUX_DB_V2_FIELD);
        map.put("InfluxDBv3Core", INFLUX_DB_V3_CORE_FIELD);
        map.put("InfluxDBv3Enterprise", INFLUX_DB_V3_ENTERPRISE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Parameters, T> g) {
        return obj -> g.apply((Parameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Parameters> {
        /**
         * <p>
         * All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
         * </p>
         * 
         * @param influxDBv2
         *        All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder influxDBv2(InfluxDBv2Parameters influxDBv2);

        /**
         * <p>
         * All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
         * </p>
         * This is a convenience method that creates an instance of the {@link InfluxDBv2Parameters.Builder} avoiding
         * the need to create one manually via {@link InfluxDBv2Parameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InfluxDBv2Parameters.Builder#build()} is called immediately and
         * its result is passed to {@link #influxDBv2(InfluxDBv2Parameters)}.
         * 
         * @param influxDBv2
         *        a consumer that will call methods on {@link InfluxDBv2Parameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #influxDBv2(InfluxDBv2Parameters)
         */
        default Builder influxDBv2(Consumer<InfluxDBv2Parameters.Builder> influxDBv2) {
            return influxDBv2(InfluxDBv2Parameters.builder().applyMutation(influxDBv2).build());
        }

        /**
         * <p>
         * All the customer-modifiable InfluxDB v3 Core parameters in Timestream for InfluxDB.
         * </p>
         * 
         * @param influxDBv3Core
         *        All the customer-modifiable InfluxDB v3 Core parameters in Timestream for InfluxDB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder influxDBv3Core(InfluxDBv3CoreParameters influxDBv3Core);

        /**
         * <p>
         * All the customer-modifiable InfluxDB v3 Core parameters in Timestream for InfluxDB.
         * </p>
         * This is a convenience method that creates an instance of the {@link InfluxDBv3CoreParameters.Builder}
         * avoiding the need to create one manually via {@link InfluxDBv3CoreParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InfluxDBv3CoreParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #influxDBv3Core(InfluxDBv3CoreParameters)}.
         * 
         * @param influxDBv3Core
         *        a consumer that will call methods on {@link InfluxDBv3CoreParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #influxDBv3Core(InfluxDBv3CoreParameters)
         */
        default Builder influxDBv3Core(Consumer<InfluxDBv3CoreParameters.Builder> influxDBv3Core) {
            return influxDBv3Core(InfluxDBv3CoreParameters.builder().applyMutation(influxDBv3Core).build());
        }

        /**
         * <p>
         * All the customer-modifiable InfluxDB v3 Enterprise parameters in Timestream for InfluxDB.
         * </p>
         * 
         * @param influxDBv3Enterprise
         *        All the customer-modifiable InfluxDB v3 Enterprise parameters in Timestream for InfluxDB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder influxDBv3Enterprise(InfluxDBv3EnterpriseParameters influxDBv3Enterprise);

        /**
         * <p>
         * All the customer-modifiable InfluxDB v3 Enterprise parameters in Timestream for InfluxDB.
         * </p>
         * This is a convenience method that creates an instance of the {@link InfluxDBv3EnterpriseParameters.Builder}
         * avoiding the need to create one manually via {@link InfluxDBv3EnterpriseParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InfluxDBv3EnterpriseParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #influxDBv3Enterprise(InfluxDBv3EnterpriseParameters)}.
         * 
         * @param influxDBv3Enterprise
         *        a consumer that will call methods on {@link InfluxDBv3EnterpriseParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #influxDBv3Enterprise(InfluxDBv3EnterpriseParameters)
         */
        default Builder influxDBv3Enterprise(Consumer<InfluxDBv3EnterpriseParameters.Builder> influxDBv3Enterprise) {
            return influxDBv3Enterprise(InfluxDBv3EnterpriseParameters.builder().applyMutation(influxDBv3Enterprise).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InfluxDBv2Parameters influxDBv2;

        private InfluxDBv3CoreParameters influxDBv3Core;

        private InfluxDBv3EnterpriseParameters influxDBv3Enterprise;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Parameters model) {
            influxDBv2(model.influxDBv2);
            influxDBv3Core(model.influxDBv3Core);
            influxDBv3Enterprise(model.influxDBv3Enterprise);
        }

        public final InfluxDBv2Parameters.Builder getInfluxDBv2() {
            return influxDBv2 != null ? influxDBv2.toBuilder() : null;
        }

        public final void setInfluxDBv2(InfluxDBv2Parameters.BuilderImpl influxDBv2) {
            Object oldValue = this.influxDBv2;
            this.influxDBv2 = influxDBv2 != null ? influxDBv2.build() : null;
            handleUnionValueChange(Type.INFLUX_DB_V2, oldValue, this.influxDBv2);
        }

        @Override
        public final Builder influxDBv2(InfluxDBv2Parameters influxDBv2) {
            Object oldValue = this.influxDBv2;
            this.influxDBv2 = influxDBv2;
            handleUnionValueChange(Type.INFLUX_DB_V2, oldValue, this.influxDBv2);
            return this;
        }

        public final InfluxDBv3CoreParameters.Builder getInfluxDBv3Core() {
            return influxDBv3Core != null ? influxDBv3Core.toBuilder() : null;
        }

        public final void setInfluxDBv3Core(InfluxDBv3CoreParameters.BuilderImpl influxDBv3Core) {
            Object oldValue = this.influxDBv3Core;
            this.influxDBv3Core = influxDBv3Core != null ? influxDBv3Core.build() : null;
            handleUnionValueChange(Type.INFLUX_DB_V3_CORE, oldValue, this.influxDBv3Core);
        }

        @Override
        public final Builder influxDBv3Core(InfluxDBv3CoreParameters influxDBv3Core) {
            Object oldValue = this.influxDBv3Core;
            this.influxDBv3Core = influxDBv3Core;
            handleUnionValueChange(Type.INFLUX_DB_V3_CORE, oldValue, this.influxDBv3Core);
            return this;
        }

        public final InfluxDBv3EnterpriseParameters.Builder getInfluxDBv3Enterprise() {
            return influxDBv3Enterprise != null ? influxDBv3Enterprise.toBuilder() : null;
        }

        public final void setInfluxDBv3Enterprise(InfluxDBv3EnterpriseParameters.BuilderImpl influxDBv3Enterprise) {
            Object oldValue = this.influxDBv3Enterprise;
            this.influxDBv3Enterprise = influxDBv3Enterprise != null ? influxDBv3Enterprise.build() : null;
            handleUnionValueChange(Type.INFLUX_DB_V3_ENTERPRISE, oldValue, this.influxDBv3Enterprise);
        }

        @Override
        public final Builder influxDBv3Enterprise(InfluxDBv3EnterpriseParameters influxDBv3Enterprise) {
            Object oldValue = this.influxDBv3Enterprise;
            this.influxDBv3Enterprise = influxDBv3Enterprise;
            handleUnionValueChange(Type.INFLUX_DB_V3_ENTERPRISE, oldValue, this.influxDBv3Enterprise);
            return this;
        }

        @Override
        public Parameters build() {
            return new Parameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Parameters#type()
     */
    public enum Type {
        INFLUX_DB_V2,

        INFLUX_DB_V3_CORE,

        INFLUX_DB_V3_ENTERPRISE,

        UNKNOWN_TO_SDK_VERSION
    }
}
