/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Percent or Absolute Long for InfluxDB parameters
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PercentOrAbsoluteLong implements SdkPojo, Serializable,
        ToCopyableBuilder<PercentOrAbsoluteLong.Builder, PercentOrAbsoluteLong> {
    private static final SdkField<String> PERCENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("percent")
            .getter(getter(PercentOrAbsoluteLong::percent)).setter(setter(Builder::percent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percent").build()).build();

    private static final SdkField<Long> ABSOLUTE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("absolute")
            .getter(getter(PercentOrAbsoluteLong::absolute)).setter(setter(Builder::absolute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("absolute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(PERCENT_FIELD, ABSOLUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String percent;

    private final Long absolute;

    private final Type type;

    private PercentOrAbsoluteLong(BuilderImpl builder) {
        this.percent = builder.percent;
        this.absolute = builder.absolute;
        this.type = builder.type;
    }

    /**
     * <p>
     * Percent for InfluxDB parameters.
     * </p>
     * 
     * @return Percent for InfluxDB parameters.
     */
    public final String percent() {
        return percent;
    }

    /**
     * <p>
     * Absolute long for InfluxDB parameters.
     * </p>
     * 
     * @return Absolute long for InfluxDB parameters.
     */
    public final Long absolute() {
        return absolute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(percent());
        hashCode = 31 * hashCode + Objects.hashCode(absolute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PercentOrAbsoluteLong)) {
            return false;
        }
        PercentOrAbsoluteLong other = (PercentOrAbsoluteLong) obj;
        return Objects.equals(percent(), other.percent()) && Objects.equals(absolute(), other.absolute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PercentOrAbsoluteLong").add("Percent", percent()).add("Absolute", absolute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "percent":
            return Optional.ofNullable(clazz.cast(percent()));
        case "absolute":
            return Optional.ofNullable(clazz.cast(absolute()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #percent()} initialized to the given value.
     *
     * <p>
     * Percent for InfluxDB parameters.
     * </p>
     * 
     * @param percent
     *        Percent for InfluxDB parameters.
     */
    public static PercentOrAbsoluteLong fromPercent(String percent) {
        return builder().percent(percent).build();
    }

    /**
     * Create an instance of this class with {@link #absolute()} initialized to the given value.
     *
     * <p>
     * Absolute long for InfluxDB parameters.
     * </p>
     * 
     * @param absolute
     *        Absolute long for InfluxDB parameters.
     */
    public static PercentOrAbsoluteLong fromAbsolute(Long absolute) {
        return builder().absolute(absolute).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("percent", PERCENT_FIELD);
        map.put("absolute", ABSOLUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PercentOrAbsoluteLong, T> g) {
        return obj -> g.apply((PercentOrAbsoluteLong) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PercentOrAbsoluteLong> {
        /**
         * <p>
         * Percent for InfluxDB parameters.
         * </p>
         * 
         * @param percent
         *        Percent for InfluxDB parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percent(String percent);

        /**
         * <p>
         * Absolute long for InfluxDB parameters.
         * </p>
         * 
         * @param absolute
         *        Absolute long for InfluxDB parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder absolute(Long absolute);
    }

    static final class BuilderImpl implements Builder {
        private String percent;

        private Long absolute;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PercentOrAbsoluteLong model) {
            percent(model.percent);
            absolute(model.absolute);
        }

        public final String getPercent() {
            return percent;
        }

        public final void setPercent(String percent) {
            Object oldValue = this.percent;
            this.percent = percent;
            handleUnionValueChange(Type.PERCENT, oldValue, this.percent);
        }

        @Override
        public final Builder percent(String percent) {
            Object oldValue = this.percent;
            this.percent = percent;
            handleUnionValueChange(Type.PERCENT, oldValue, this.percent);
            return this;
        }

        public final Long getAbsolute() {
            return absolute;
        }

        public final void setAbsolute(Long absolute) {
            Object oldValue = this.absolute;
            this.absolute = absolute;
            handleUnionValueChange(Type.ABSOLUTE, oldValue, this.absolute);
        }

        @Override
        public final Builder absolute(Long absolute) {
            Object oldValue = this.absolute;
            this.absolute = absolute;
            handleUnionValueChange(Type.ABSOLUTE, oldValue, this.absolute);
            return this;
        }

        @Override
        public PercentOrAbsoluteLong build() {
            return new PercentOrAbsoluteLong(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PercentOrAbsoluteLong#type()
     */
    public enum Type {
        PERCENT,

        ABSOLUTE,

        UNKNOWN_TO_SDK_VERSION
    }
}
